/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore;

import java.io.IOException;
import java.nio.file.Path;
import org.opensearch.common.StreamContext;
import org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.opensearch.common.blobstore.EncryptedBlobContainer;
import org.opensearch.common.blobstore.stream.read.ReadContext;
import org.opensearch.common.blobstore.stream.write.WriteContext;
import org.opensearch.common.crypto.CryptoHandler;
import org.opensearch.common.io.InputStreamContainer;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

public class AsyncMultiStreamEncryptedBlobContainer<T, U>
extends EncryptedBlobContainer<T, U>
implements AsyncMultiStreamBlobContainer {
    private final AsyncMultiStreamBlobContainer blobContainer;
    private final CryptoHandler<T, U> cryptoHandler;

    public AsyncMultiStreamEncryptedBlobContainer(AsyncMultiStreamBlobContainer blobContainer, CryptoHandler<T, U> cryptoHandler) {
        super(blobContainer, cryptoHandler);
        this.blobContainer = blobContainer;
        this.cryptoHandler = cryptoHandler;
    }

    @Override
    public void asyncBlobUpload(WriteContext writeContext, ActionListener<Void> completionListener) throws IOException {
        EncryptedWriteContext<T, U> encryptedWriteContext = new EncryptedWriteContext<T, U>(writeContext, this.cryptoHandler);
        this.blobContainer.asyncBlobUpload(encryptedWriteContext, completionListener);
    }

    @Override
    public void readBlobAsync(String blobName, ActionListener<ReadContext> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void asyncBlobDownload(String blobName, Path fileLocation, ThreadPool threadPool, ActionListener<String> completionListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remoteIntegrityCheckSupported() {
        return false;
    }

    static class EncryptedStreamContext<T, U>
    extends StreamContext {
        private final CryptoHandler<T, U> cryptoHandler;
        private final T encryptionMetadata;

        public EncryptedStreamContext(StreamContext streamContext, CryptoHandler<T, U> cryptoHandler, T encryptionMetadata) {
            super(streamContext);
            this.cryptoHandler = cryptoHandler;
            this.encryptionMetadata = encryptionMetadata;
        }

        @Override
        public InputStreamContainer provideStream(int partNumber) throws IOException {
            InputStreamContainer inputStreamContainer = super.provideStream(partNumber);
            return this.cryptoHandler.createEncryptingStreamOfPart(this.encryptionMetadata, inputStreamContainer, this.getNumberOfParts(), partNumber);
        }
    }

    static class EncryptedWriteContext<T, U>
    extends WriteContext {
        private final T encryptionMetadata;
        private final CryptoHandler<T, U> cryptoHandler;
        private final long fileSize;

        public EncryptedWriteContext(WriteContext writeContext, CryptoHandler<T, U> cryptoHandler) {
            super(writeContext);
            this.cryptoHandler = cryptoHandler;
            this.encryptionMetadata = this.cryptoHandler.initEncryptionMetadata();
            this.fileSize = this.cryptoHandler.estimateEncryptedLengthOfEntireContent(this.encryptionMetadata, writeContext.getFileSize());
        }

        @Override
        public StreamContext getStreamProvider(long partSize) {
            long adjustedPartSize = this.cryptoHandler.adjustContentSizeForPartialEncryption(this.encryptionMetadata, partSize);
            StreamContext streamContext = super.getStreamProvider(adjustedPartSize);
            return new EncryptedStreamContext<T, U>(streamContext, this.cryptoHandler, this.encryptionMetadata);
        }

        @Override
        public long getFileSize() {
            return this.fileSize;
        }
    }
}

