/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.util.Arrays;

public class RemoteStoreUtils {
    public static final int LONG_MAX_LENGTH = String.valueOf(Long.MAX_VALUE).length();

    public static String invertLong(long num) {
        if (num < 0L) {
            throw new IllegalArgumentException("Negative long values are not allowed");
        }
        String invertedLong = String.valueOf(Long.MAX_VALUE - num);
        char[] characterArray = new char[LONG_MAX_LENGTH - invertedLong.length()];
        Arrays.fill(characterArray, '0');
        return new String(characterArray) + invertedLong;
    }

    public static long invertLong(String str) {
        long num = Long.parseLong(str);
        if (num < 0L) {
            throw new IllegalArgumentException("Strings representing negative long values are not allowed");
        }
        return Long.MAX_VALUE - num;
    }

    public static String getSegmentName(String filename) {
        int endIdx = filename.indexOf(95, 1);
        if (endIdx == -1) {
            endIdx = filename.indexOf(46);
        }
        if (endIdx == -1) {
            throw new IllegalArgumentException("Unable to infer segment name for segment file " + filename);
        }
        return filename.substring(0, endIdx);
    }
}

