/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.index.Index;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.tasks.TaskResultsService;

public class SystemIndices {
    private static final Logger logger = LogManager.getLogger(SystemIndices.class);
    private static final Map<String, Collection<SystemIndexDescriptor>> SERVER_SYSTEM_INDEX_DESCRIPTORS = Collections.singletonMap(TaskResultsService.class.getName(), Collections.singletonList(new SystemIndexDescriptor(".tasks*", "Task Result Index")));
    private final CharacterRunAutomaton runAutomaton;
    private final Collection<SystemIndexDescriptor> systemIndexDescriptors;

    public SystemIndices(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesDescriptors) {
        Map<String, Collection<SystemIndexDescriptor>> descriptorsMap = SystemIndices.buildSystemIndexDescriptorMap(pluginAndModulesDescriptors);
        SystemIndices.checkForOverlappingPatterns(descriptorsMap);
        this.systemIndexDescriptors = Collections.unmodifiableList(descriptorsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        this.runAutomaton = SystemIndices.buildCharacterRunAutomaton(this.systemIndexDescriptors);
    }

    public boolean isSystemIndex(Index index) {
        return this.isSystemIndex(index.getName());
    }

    public boolean isSystemIndex(String indexName) {
        return this.runAutomaton.run(indexName);
    }

    @Nullable
    public SystemIndexDescriptor findMatchingDescriptor(String name) {
        List matchingDescriptors = this.systemIndexDescriptors.stream().filter(descriptor -> descriptor.matchesIndexPattern(name)).collect(Collectors.toList());
        if (matchingDescriptors.isEmpty()) {
            return null;
        }
        if (matchingDescriptors.size() == 1) {
            return (SystemIndexDescriptor)matchingDescriptors.get(0);
        }
        StringBuilder errorMessage = new StringBuilder().append("index name [").append(name).append("] is claimed as a system index by multiple system index patterns: [").append(matchingDescriptors.stream().map(descriptor -> "pattern: [" + descriptor.getIndexPattern() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
        assert (false) : errorMessage.toString();
        throw new IllegalStateException(errorMessage.toString());
    }

    public boolean validateSystemIndex(String index) {
        SystemIndexDescriptor matchingDescriptor;
        if (index.charAt(0) == '.' && (matchingDescriptor = this.findMatchingDescriptor(index)) != null) {
            logger.trace("index [{}] is a system index because it matches index pattern [{}] with description [{}]", (Object)index, (Object)matchingDescriptor.getIndexPattern(), (Object)matchingDescriptor.getDescription());
            return true;
        }
        return false;
    }

    private static CharacterRunAutomaton buildCharacterRunAutomaton(Collection<SystemIndexDescriptor> descriptors) {
        Optional<Automaton> automaton = descriptors.stream().map(descriptor -> Regex.simpleMatchToAutomaton(descriptor.getIndexPattern())).reduce(Operations::union);
        return new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)automaton.orElse(Automata.makeEmpty()), (int)Integer.MAX_VALUE));
    }

    static void checkForOverlappingPatterns(Map<String, Collection<SystemIndexDescriptor>> sourceToDescriptors) {
        List<Tuple> sourceDescriptorPair = sourceToDescriptors.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(descriptor -> new Tuple((Object)((String)entry.getKey()), descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).collect(Collectors.toList());
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndices.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2())).collect(Collectors.toList());
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + descriptorToCheck.v2() + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with other system index descriptors: [" + descriptorsMatchingThisPattern.stream().map(descriptor -> descriptor.v2() + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        Automaton a2Automaton;
        Automaton a1Automaton = Regex.simpleMatchToAutomaton(a1.getIndexPattern());
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1Automaton, (Automaton)(a2Automaton = Regex.simpleMatchToAutomaton(a2.getIndexPattern()))));
    }

    private static Map<String, Collection<SystemIndexDescriptor>> buildSystemIndexDescriptorMap(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesMap) {
        HashMap<String, Collection<SystemIndexDescriptor>> map = new HashMap<String, Collection<SystemIndexDescriptor>>(pluginAndModulesMap.size() + SERVER_SYSTEM_INDEX_DESCRIPTORS.size());
        map.putAll(pluginAndModulesMap);
        SERVER_SYSTEM_INDEX_DESCRIPTORS.forEach((source, descriptors) -> {
            if (map.putIfAbsent((String)source, (Collection<SystemIndexDescriptor>)descriptors) != null) {
                throw new IllegalArgumentException("plugin or module attempted to define the same source [" + source + "] as a built-in system index");
            }
        });
        return Collections.unmodifiableMap(map);
    }
}

