# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
IntPolyh module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_intpolyh.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _IntPolyh
else:
    import _IntPolyh

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IntPolyh.delete_SwigPyIterator

    def value(self):
        return _IntPolyh.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _IntPolyh.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _IntPolyh.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _IntPolyh.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _IntPolyh.SwigPyIterator_equal(self, x)

    def copy(self):
        return _IntPolyh.SwigPyIterator_copy(self)

    def next(self):
        return _IntPolyh.SwigPyIterator_next(self)

    def __next__(self):
        return _IntPolyh.SwigPyIterator___next__(self)

    def previous(self):
        return _IntPolyh.SwigPyIterator_previous(self)

    def advance(self, n):
        return _IntPolyh.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _IntPolyh.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _IntPolyh.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _IntPolyh.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _IntPolyh.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _IntPolyh.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _IntPolyh.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _IntPolyh:
_IntPolyh.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _IntPolyh.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.Bnd
import OCC.Core.BVH

from enum import IntEnum
from OCC.Core.Exception import *



class IntPolyh_ListOfCouples(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _IntPolyh.IntPolyh_ListOfCouples_begin(self)

    def end(self):
        return _IntPolyh.IntPolyh_ListOfCouples_end(self)

    def cbegin(self):
        return _IntPolyh.IntPolyh_ListOfCouples_cbegin(self)

    def cend(self):
        return _IntPolyh.IntPolyh_ListOfCouples_cend(self)

    def __init__(self, *args):
        _IntPolyh.IntPolyh_ListOfCouples_swiginit(self, _IntPolyh.new_IntPolyh_ListOfCouples(*args))

    def Size(self):
        return _IntPolyh.IntPolyh_ListOfCouples_Size(self)

    def Assign(self, theOther):
        return _IntPolyh.IntPolyh_ListOfCouples_Assign(self, theOther)

    def Set(self, theOther):
        return _IntPolyh.IntPolyh_ListOfCouples_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _IntPolyh.IntPolyh_ListOfCouples_Clear(self, theAllocator)

    def First(self):
        return _IntPolyh.IntPolyh_ListOfCouples_First(self)

    def Last(self):
        return _IntPolyh.IntPolyh_ListOfCouples_Last(self)

    def Append(self, *args):
        return _IntPolyh.IntPolyh_ListOfCouples_Append(self, *args)

    def Prepend(self, *args):
        return _IntPolyh.IntPolyh_ListOfCouples_Prepend(self, *args)

    def RemoveFirst(self):
        return _IntPolyh.IntPolyh_ListOfCouples_RemoveFirst(self)

    def Remove(self, theIter):
        return _IntPolyh.IntPolyh_ListOfCouples_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _IntPolyh.IntPolyh_ListOfCouples_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _IntPolyh.IntPolyh_ListOfCouples_InsertAfter(self, *args)

    def Reverse(self):
        return _IntPolyh.IntPolyh_ListOfCouples_Reverse(self)
    __swig_destroy__ = _IntPolyh.delete_IntPolyh_ListOfCouples

    def __len__(self):
        return self.Size()


# Register IntPolyh_ListOfCouples in _IntPolyh:
_IntPolyh.IntPolyh_ListOfCouples_swigregister(IntPolyh_ListOfCouples)
class IntPolyh_SeqOfStartPoints(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_begin(self)

    def end(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_end(self)

    def cbegin(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_cbegin(self)

    def cend(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_cend(self)

    def __init__(self, *args):
        _IntPolyh.IntPolyh_SeqOfStartPoints_swiginit(self, _IntPolyh.new_IntPolyh_SeqOfStartPoints(*args))

    def Size(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Size(self)

    def Length(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Length(self)

    def Lower(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Lower(self)

    def Upper(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Upper(self)

    def IsEmpty(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_IsEmpty(self)

    def Reverse(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Reverse(self)

    def Exchange(self, I, J):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Assign(self, theOther)

    def Set(self, theOther):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Set(self, theOther)

    def Remove(self, *args):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Remove(self, *args)

    def Append(self, *args):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Append(self, *args)

    def Prepend(self, *args):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Split(self, theIndex, theSeq)

    def First(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_First(self)

    def ChangeFirst(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_ChangeFirst(self)

    def Last(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Last(self)

    def ChangeLast(self):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_ChangeLast(self)

    def Value(self, theIndex):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _IntPolyh.IntPolyh_SeqOfStartPoints___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _IntPolyh.IntPolyh_SeqOfStartPoints_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _IntPolyh.delete_IntPolyh_SeqOfStartPoints

    def __len__(self):
        return self.Size()


# Register IntPolyh_SeqOfStartPoints in _IntPolyh:
_IntPolyh.IntPolyh_SeqOfStartPoints_swigregister(IntPolyh_SeqOfStartPoints)
class IntPolyh_Couple(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None
        Constructor.

        Parameters
        ----------
        theTriangle1: int
        theTriangle2: int
        theAngle: float,optional
        	default value is -2.0

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_Couple_swiginit(self, _IntPolyh.new_IntPolyh_Couple(*args))

    def Angle(self, *args):
        r"""
        Returns the angle.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Couple_Angle(self, *args)

    def Dump(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        v: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Couple_Dump(self, *args)

    def FirstValue(self, *args):
        r"""
        Returns the first index.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Couple_FirstValue(self, *args)

    def HashCode(self, *args):
        r"""
        Computes a hash code for this couple, in the range [1, theupperbound] @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theUpperBound: int

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Couple_HashCode(self, *args)

    def __hash__(self):
        return _IntPolyh.IntPolyh_Couple___hash__(self)

    def IsAnalyzed(self, *args):
        r"""
        Returns true if the couple has been analyzed.

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Couple_IsAnalyzed(self, *args)

    def IsEqual(self, *args):
        r"""
        Returns true if the couple is equal to <theother>.

        Parameters
        ----------
        theOther: IntPolyh_Couple

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Couple_IsEqual(self, *args)

    def SecondValue(self, *args):
        r"""
        Returns the second index.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Couple_SecondValue(self, *args)

    def SetAnalyzed(self, *args):
        r"""
        Sets the analyzed flag.

        Parameters
        ----------
        theAnalyzed: bool

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Couple_SetAnalyzed(self, *args)

    def SetAngle(self, *args):
        r"""
        Sets the angle.

        Parameters
        ----------
        theAngle: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Couple_SetAngle(self, *args)

    def SetCoupleValue(self, *args):
        r"""
        Sets the triangles.

        Parameters
        ----------
        theInd1: int
        theInd2: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Couple_SetCoupleValue(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_Couple

# Register IntPolyh_Couple in _IntPolyh:
_IntPolyh.IntPolyh_Couple_swigregister(IntPolyh_Couple)
class IntPolyh_CoupleMapHasher(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def HashCode(*args):
        r"""
        Computes a hash code for the given couple, in the range [1, theupperbound] @param thecouple the couple which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theCouple: IntPolyh_Couple
        theUpperBound: int

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_CoupleMapHasher_HashCode(*args)

    @staticmethod
    def IsEqual(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        theCouple1: IntPolyh_Couple
        theCouple2: IntPolyh_Couple

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_CoupleMapHasher_IsEqual(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _IntPolyh.IntPolyh_CoupleMapHasher_swiginit(self, _IntPolyh.new_IntPolyh_CoupleMapHasher())
    __swig_destroy__ = _IntPolyh.delete_IntPolyh_CoupleMapHasher

# Register IntPolyh_CoupleMapHasher in _IntPolyh:
_IntPolyh.IntPolyh_CoupleMapHasher_swigregister(IntPolyh_CoupleMapHasher)
class IntPolyh_Edge(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None
        Constructor.

        Parameters
        ----------
        thePoint1: int
        thePoint2: int
        theTriangle1: int
        theTriangle2: int

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_Edge_swiginit(self, _IntPolyh.new_IntPolyh_Edge(*args))

    def Dump(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        v: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Edge_Dump(self, *args)

    def FirstPoint(self, *args):
        r"""
        Returns the first point.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Edge_FirstPoint(self, *args)

    def FirstTriangle(self, *args):
        r"""
        Returns the first triangle.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Edge_FirstTriangle(self, *args)

    def SecondPoint(self, *args):
        r"""
        Returns the second point.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Edge_SecondPoint(self, *args)

    def SecondTriangle(self, *args):
        r"""
        Returns the second triangle.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Edge_SecondTriangle(self, *args)

    def SetFirstPoint(self, *args):
        r"""
        Sets the first point.

        Parameters
        ----------
        thePoint: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Edge_SetFirstPoint(self, *args)

    def SetFirstTriangle(self, *args):
        r"""
        Sets the first triangle.

        Parameters
        ----------
        theTriangle: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Edge_SetFirstTriangle(self, *args)

    def SetSecondPoint(self, *args):
        r"""
        Sets the second point.

        Parameters
        ----------
        thePoint: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Edge_SetSecondPoint(self, *args)

    def SetSecondTriangle(self, *args):
        r"""
        Sets the second triangle.

        Parameters
        ----------
        theTriangle: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Edge_SetSecondTriangle(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_Edge

# Register IntPolyh_Edge in _IntPolyh:
_IntPolyh.IntPolyh_Edge_swigregister(IntPolyh_Edge)
class IntPolyh_Intersection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor for intersection of two surfaces with default parameters. performs intersection.

        Parameters
        ----------
        theS1: Adaptor3d_Surface
        theS2: Adaptor3d_Surface

        Returns
        -------
        None
        Constructor for intersection of two surfaces with the given size of the sampling nets: - <thenbsu1> x <thenbsv1> - for the first surface <thes1>; - <thenbsu2> x <thenbsv2> - for the second surface <thes2>. performs intersection.

        Parameters
        ----------
        theS1: Adaptor3d_Surface
        theNbSU1: int
        theNbSV1: int
        theS2: Adaptor3d_Surface
        theNbSU2: int
        theNbSV2: int

        Returns
        -------
        None
        Constructor for intersection of two surfaces with the precomputed sampling. performs intersection.

        Parameters
        ----------
        theS1: Adaptor3d_Surface
        theUPars1: TColStd_Array1OfReal
        theVPars1: TColStd_Array1OfReal
        theS2: Adaptor3d_Surface
        theUPars2: TColStd_Array1OfReal
        theVPars2: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_Intersection_swiginit(self, _IntPolyh.new_IntPolyh_Intersection(*args))

    def GetLinePoint(self, *args):
        r"""
        Gets the parameters of the point in section line.

        Parameters
        ----------
        IndexLine: int
        IndexPoint: int

        Returns
        -------
        x: float
        y: float
        z: float
        u1: float
        v1: float
        u2: float
        v2: float
        incidence: float

        """
        return _IntPolyh.IntPolyh_Intersection_GetLinePoint(self, *args)

    def GetTangentZonePoint(self, *args):
        r"""
        Gets the parameters of the point in tangent zone.

        Parameters
        ----------
        IndexLine: int
        IndexPoint: int

        Returns
        -------
        x: float
        y: float
        z: float
        u1: float
        v1: float
        u2: float
        v2: float

        """
        return _IntPolyh.IntPolyh_Intersection_GetTangentZonePoint(self, *args)

    def IsDone(self, *args):
        r"""
        Returns state of the operation.

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Intersection_IsDone(self, *args)

    def NbPointsInLine(self, *args):
        r"""
        Returns the number of points in the given line.

        Parameters
        ----------
        IndexLine: int

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Intersection_NbPointsInLine(self, *args)

    def NbPointsInTangentZone(self, *args):
        r"""
        Returns number of points in tangent zone.

        Parameters
        ----------
        Standard_Integer: 

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Intersection_NbPointsInTangentZone(self, *args)

    def NbSectionLines(self, *args):
        r"""
        Returns the number of section lines.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Intersection_NbSectionLines(self, *args)

    def NbTangentZones(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Intersection_NbTangentZones(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_Intersection

# Register IntPolyh_Intersection in _IntPolyh:
_IntPolyh.IntPolyh_Intersection_swigregister(IntPolyh_Intersection)
class IntPolyh_Point(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None
        Constructor.

        Parameters
        ----------
        x: float
        y: float
        z: float
        u: float
        v: float

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_Point_swiginit(self, _IntPolyh.new_IntPolyh_Point(*args))

    def Add(self, *args):
        r"""
        Addition.

        Parameters
        ----------
        P1: IntPolyh_Point

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point_Add(self, *args)

    def Cross(self, *args):
        r"""
        Cross.

        Parameters
        ----------
        P1: IntPolyh_Point
        P2: IntPolyh_Point

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_Cross(self, *args)

    def Degenerated(self, *args):
        r"""
        Returns the degenerated flag.

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Point_Degenerated(self, *args)

    def Divide(self, *args):
        r"""
        Division.

        Parameters
        ----------
        rr: float

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point_Divide(self, *args)

    def Dot(self, *args):
        r"""
        Dot.

        Parameters
        ----------
        P2: IntPolyh_Point

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_Dot(self, *args)

    def Dump(self, *args):
        r"""
        Dump.

        Returns
        -------
        None
        Dump.

        Parameters
        ----------
        i: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_Dump(self, *args)

    def Middle(self, *args):
        r"""
        Creates middle point from p1 and p2 and stores it to this.

        Parameters
        ----------
        MySurface: Adaptor3d_Surface
        P1: IntPolyh_Point
        P2: IntPolyh_Point

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_Middle(self, *args)

    def Multiplication(self, *args):
        r"""
        Multiplication.

        Parameters
        ----------
        rr: float

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point_Multiplication(self, *args)

    def PartOfCommon(self, *args):
        r"""
        Returns 0 if the point is not common with the other surface.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Point_PartOfCommon(self, *args)

    def Set(self, *args):
        r"""
        Sets the point.

        Parameters
        ----------
        x: float
        y: float
        z: float
        u: float
        v: float
        II: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_Set(self, *args)

    def SetDegenerated(self, *args):
        r"""
        Sets the degenerated flag.

        Parameters
        ----------
        theFlag: bool

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetDegenerated(self, *args)

    def SetPartOfCommon(self, *args):
        r"""
        Sets the part of common.

        Parameters
        ----------
        ii: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetPartOfCommon(self, *args)

    def SetU(self, *args):
        r"""
        Sets the u coordinate for the 2d point.

        Parameters
        ----------
        u: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetU(self, *args)

    def SetV(self, *args):
        r"""
        Sets the v coordinate for the 2d point.

        Parameters
        ----------
        v: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetV(self, *args)

    def SetX(self, *args):
        r"""
        Sets the x coordinate for the 3d point.

        Parameters
        ----------
        x: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetX(self, *args)

    def SetY(self, *args):
        r"""
        Sets the y coordinate for the 3d point.

        Parameters
        ----------
        y: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetY(self, *args)

    def SetZ(self, *args):
        r"""
        Sets the z coordinate for the 3d point.

        Parameters
        ----------
        z: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Point_SetZ(self, *args)

    def SquareDistance(self, *args):
        r"""
        Square distance to the other point.

        Parameters
        ----------
        P2: IntPolyh_Point

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_SquareDistance(self, *args)

    def SquareModulus(self, *args):
        r"""
        Square modulus.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_SquareModulus(self, *args)

    def Sub(self, *args):
        r"""
        Subtraction.

        Parameters
        ----------
        P1: IntPolyh_Point

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point_Sub(self, *args)

    def U(self, *args):
        r"""
        Returns the u coordinate of the 2d point.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_U(self, *args)

    def V(self, *args):
        r"""
        Returns the v coordinate of the 2d point.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_V(self, *args)

    def X(self, *args):
        r"""
        Returns x coordinate of the 3d point.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_X(self, *args)

    def Y(self, *args):
        r"""
        Returns y coordinate of the 3d point.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_Y(self, *args)

    def Z(self, *args):
        r"""
        Returns the z coordinate of the 3d point.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Point_Z(self, *args)

    def __mul__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        rr: float

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point___mul__(self, *args)

    def __add__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        P1: IntPolyh_Point

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point___add__(self, *args)

    def __sub__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        P1: IntPolyh_Point

        Returns
        -------
        IntPolyh_Point

        """
        return _IntPolyh.IntPolyh_Point___sub__(self, *args)

    def __truediv__(self, *args):
        return _IntPolyh.IntPolyh_Point___truediv__(self, *args)
    __div__ = __truediv__



    __repr__ = _dumps_object

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_Point

# Register IntPolyh_Point in _IntPolyh:
_IntPolyh.IntPolyh_Point_swigregister(IntPolyh_Point)
class IntPolyh_PointNormal(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Point = property(_IntPolyh.IntPolyh_PointNormal_Point_get, _IntPolyh.IntPolyh_PointNormal_Point_set)
    Normal = property(_IntPolyh.IntPolyh_PointNormal_Normal_get, _IntPolyh.IntPolyh_PointNormal_Normal_set)

    __repr__ = _dumps_object


    def __init__(self):
        _IntPolyh.IntPolyh_PointNormal_swiginit(self, _IntPolyh.new_IntPolyh_PointNormal())
    __swig_destroy__ = _IntPolyh.delete_IntPolyh_PointNormal

# Register IntPolyh_PointNormal in _IntPolyh:
_IntPolyh.IntPolyh_PointNormal_swigregister(IntPolyh_PointNormal)
class IntPolyh_SectionLine(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        nn: int

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_SectionLine_swiginit(self, _IntPolyh.new_IntPolyh_SectionLine(*args))

    def ChangeValue(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        nn: int

        Returns
        -------
        IntPolyh_StartPoint

        """
        return _IntPolyh.IntPolyh_SectionLine_ChangeValue(self, *args)

    def Copy(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Other: IntPolyh_SectionLine

        Returns
        -------
        IntPolyh_SectionLine

        """
        return _IntPolyh.IntPolyh_SectionLine_Copy(self, *args)

    def Destroy(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_SectionLine_Destroy(self, *args)

    def Dump(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_SectionLine_Dump(self, *args)

    def GetN(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_SectionLine_GetN(self, *args)

    def IncrementNbStartPoints(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_SectionLine_IncrementNbStartPoints(self, *args)

    def Init(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        nn: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_SectionLine_Init(self, *args)

    def NbStartPoints(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_SectionLine_NbStartPoints(self, *args)

    def Prepend(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        SP: IntPolyh_StartPoint

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_SectionLine_Prepend(self, *args)

    def Value(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        nn: int

        Returns
        -------
        IntPolyh_StartPoint

        """
        return _IntPolyh.IntPolyh_SectionLine_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_SectionLine

# Register IntPolyh_SectionLine in _IntPolyh:
_IntPolyh.IntPolyh_SectionLine_swigregister(IntPolyh_SectionLine)
class IntPolyh_StartPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        xx: float
        yy: float
        zz: float
        uu1: float
        vv1: float
        uu2: float
        vv2: float
        T1: int
        E1: int
        LAM1: float
        T2: int
        E2: int
        LAM2: float
        List: int

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_StartPoint_swiginit(self, _IntPolyh.new_IntPolyh_StartPoint(*args))

    def ChainList(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_StartPoint_ChainList(self, *args)

    def CheckSameSP(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        SP: IntPolyh_StartPoint

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_StartPoint_CheckSameSP(self, *args)

    def Dump(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        i: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_Dump(self, *args)

    def E1(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_StartPoint_E1(self, *args)

    def E2(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_StartPoint_E2(self, *args)

    def GetAngle(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_GetAngle(self, *args)

    def GetEdgePoints(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Triangle: IntPolyh_Triangle

        Returns
        -------
        FirstEdgePoint: int
        SecondEdgePoint: int
        LastPoint: int

        """
        return _IntPolyh.IntPolyh_StartPoint_GetEdgePoints(self, *args)

    def Lambda1(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_Lambda1(self, *args)

    def Lambda2(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_Lambda2(self, *args)

    def SetAngle(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        ang: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetAngle(self, *args)

    def SetChainList(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        ChList: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetChainList(self, *args)

    def SetCoupleValue(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        IT1: int
        IT2: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetCoupleValue(self, *args)

    def SetEdge1(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        IE1: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetEdge1(self, *args)

    def SetEdge2(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        IE2: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetEdge2(self, *args)

    def SetLambda1(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        LAM1: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetLambda1(self, *args)

    def SetLambda2(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        LAM2: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetLambda2(self, *args)

    def SetUV1(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        UU1: float
        VV1: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetUV1(self, *args)

    def SetUV2(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        UU2: float
        VV2: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetUV2(self, *args)

    def SetXYZ(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        XX: float
        YY: float
        ZZ: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_StartPoint_SetXYZ(self, *args)

    def T1(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_StartPoint_T1(self, *args)

    def T2(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_StartPoint_T2(self, *args)

    def U1(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_U1(self, *args)

    def U2(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_U2(self, *args)

    def V1(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_V1(self, *args)

    def V2(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_V2(self, *args)

    def X(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_X(self, *args)

    def Y(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_Y(self, *args)

    def Z(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_StartPoint_Z(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_StartPoint

# Register IntPolyh_StartPoint in _IntPolyh:
_IntPolyh.IntPolyh_StartPoint_swigregister(IntPolyh_StartPoint)
class IntPolyh_Tools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeDeflection(*args):
        r"""
        Computes the deflection tolerance on the surface for the given sampling.

        Parameters
        ----------
        theSurf: Adaptor3d_Surface
        theUPars: TColStd_Array1OfReal
        theVPars: TColStd_Array1OfReal

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Tools_ComputeDeflection(*args)

    @staticmethod
    def FillArrayOfPointNormal(*args):
        r"""
        Fills the array <thepoints> with the points (triangulation nodes) on the surface and normal directions of the surface in these points.

        Parameters
        ----------
        theSurf: Adaptor3d_Surface
        theUPars: TColStd_Array1OfReal
        theVPars: TColStd_Array1OfReal
        thePoints: IntPolyh_ArrayOfPointNormal

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Tools_FillArrayOfPointNormal(*args)

    @staticmethod
    def IsEnlargePossible(*args):
        r"""
        Checks if the surface can be enlarged in u or v direction.

        Parameters
        ----------
        theSurf: Adaptor3d_Surface

        Returns
        -------
        theUEnlarge: bool
        theVEnlarge: bool

        """
        return _IntPolyh.IntPolyh_Tools_IsEnlargePossible(*args)

    @staticmethod
    def MakeSampling(*args):
        r"""
        Makes the sampling of the given surface <thesurf> making the net of <thenbsu> x <thenbsv> sampling points. the flag <theenlargezone> controls the enlargement of the sampling zone on the surface. the parameters of the sampling points are stored into <theupars> and <thevpars> arrays.

        Parameters
        ----------
        theSurf: Adaptor3d_Surface
        theNbSU: int
        theNbSV: int
        theEnlargeZone: bool
        theUPars: TColStd_Array1OfReal
        theVPars: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Tools_MakeSampling(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _IntPolyh.IntPolyh_Tools_swiginit(self, _IntPolyh.new_IntPolyh_Tools())
    __swig_destroy__ = _IntPolyh.delete_IntPolyh_Tools

# Register IntPolyh_Tools in _IntPolyh:
_IntPolyh.IntPolyh_Tools_swigregister(IntPolyh_Tools)
class IntPolyh_Triangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None
        Constructor.

        Parameters
        ----------
        thePoint1: int
        thePoint2: int
        thePoint3: int

        Returns
        -------
        None

        """
        _IntPolyh.IntPolyh_Triangle_swiginit(self, _IntPolyh.new_IntPolyh_Triangle(*args))

    def BoundingBox(self, *args):
        r"""
        Returns the bounding box of the triangle.

        Parameters
        ----------
        thePoints: IntPolyh_ArrayOfPoints

        Returns
        -------
        Bnd_Box

        """
        return _IntPolyh.IntPolyh_Triangle_BoundingBox(self, *args)

    def ComputeDeflection(self, *args):
        r"""
        Computes the deflection for the triangle.

        Parameters
        ----------
        theSurface: Adaptor3d_Surface
        thePoints: IntPolyh_ArrayOfPoints

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Triangle_ComputeDeflection(self, *args)

    def Deflection(self, *args):
        r"""
        Returns the deflection of the triangle.

        Returns
        -------
        float

        """
        return _IntPolyh.IntPolyh_Triangle_Deflection(self, *args)

    def Dump(self, *args):
        r"""
        Dumps the contents of the triangle.

        Parameters
        ----------
        v: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_Dump(self, *args)

    def FirstEdge(self, *args):
        r"""
        Returns the first edge.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_FirstEdge(self, *args)

    def FirstEdgeOrientation(self, *args):
        r"""
        Returns the orientation of the first edge.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_FirstEdgeOrientation(self, *args)

    def FirstPoint(self, *args):
        r"""
        Returns the first point.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_FirstPoint(self, *args)

    def GetEdgeNumber(self, *args):
        r"""
        Gets the edge number by the index.

        Parameters
        ----------
        theEdgeIndex: int

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_GetEdgeNumber(self, *args)

    def GetEdgeOrientation(self, *args):
        r"""
        Gets the edges orientation by the index.

        Parameters
        ----------
        theEdgeIndex: int

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_GetEdgeOrientation(self, *args)

    def GetNextTriangle(self, *args):
        r"""
        Gets the adjacent triangle.

        Parameters
        ----------
        theTriangle: int
        theEdgeNum: int
        TEdges: IntPolyh_ArrayOfEdges

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_GetNextTriangle(self, *args)

    def HasIntersection(self, *args):
        r"""
        Returns true if the triangle has interfered the other triangle.

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Triangle_HasIntersection(self, *args)

    def IsDegenerated(self, *args):
        r"""
        Returns the degenerated flag.

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Triangle_IsDegenerated(self, *args)

    def IsIntersectionPossible(self, *args):
        r"""
        Returns possibility of the intersection.

        Returns
        -------
        bool

        """
        return _IntPolyh.IntPolyh_Triangle_IsIntersectionPossible(self, *args)

    def LinkEdges2Triangle(self, *args):
        r"""
        Links edges to triangle.

        Parameters
        ----------
        TEdges: IntPolyh_ArrayOfEdges
        theEdge1: int
        theEdge2: int
        theEdge3: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_LinkEdges2Triangle(self, *args)

    def MiddleRefinement(self, *args):
        r"""
        Splits the triangle on two to decrease its deflection.

        Parameters
        ----------
        theTriangleNumber: int
        theSurface: Adaptor3d_Surface
        TPoints: IntPolyh_ArrayOfPoints
        TTriangles: IntPolyh_ArrayOfTriangles
        TEdges: IntPolyh_ArrayOfEdges

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_MiddleRefinement(self, *args)

    def MultipleMiddleRefinement(self, *args):
        r"""
        Splits the current triangle and new triangles until the refinement criterion is not achieved.

        Parameters
        ----------
        theRefineCriterion: float
        theBox: Bnd_Box
        theTriangleNumber: int
        theSurface: Adaptor3d_Surface
        TPoints: IntPolyh_ArrayOfPoints
        TTriangles: IntPolyh_ArrayOfTriangles
        TEdges: IntPolyh_ArrayOfEdges

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_MultipleMiddleRefinement(self, *args)

    def SecondEdge(self, *args):
        r"""
        Returns the second edge.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_SecondEdge(self, *args)

    def SecondEdgeOrientation(self, *args):
        r"""
        Returns the orientation of the second edge.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_SecondEdgeOrientation(self, *args)

    def SecondPoint(self, *args):
        r"""
        Returns the second point.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_SecondPoint(self, *args)

    def SetDeflection(self, *args):
        r"""
        Sets the deflection.

        Parameters
        ----------
        theDeflection: float

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetDeflection(self, *args)

    def SetDegenerated(self, *args):
        r"""
        Sets the degenerated flag.

        Parameters
        ----------
        theDegFlag: bool

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetDegenerated(self, *args)

    def SetEdge(self, *args):
        r"""
        Sets the edge by the index.

        Parameters
        ----------
        theEdgeIndex: int
        theEdgeNumber: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetEdge(self, *args)

    def SetEdgeAndOrientation(self, *args):
        r"""
        Sets the appropriate edge and orientation for the triangle.

        Parameters
        ----------
        theEdge: IntPolyh_Edge
        theEdgeIndex: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetEdgeAndOrientation(self, *args)

    def SetEdgeOrientation(self, *args):
        r"""
        Sets the edges orientation by the index.

        Parameters
        ----------
        theEdgeIndex: int
        theEdgeOrientation: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetEdgeOrientation(self, *args)

    def SetFirstEdge(self, *args):
        r"""
        Sets the first edge.

        Parameters
        ----------
        theEdge: int
        theEdgeOrientation: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetFirstEdge(self, *args)

    def SetFirstPoint(self, *args):
        r"""
        Sets the first point.

        Parameters
        ----------
        thePoint: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetFirstPoint(self, *args)

    def SetIntersection(self, *args):
        r"""
        Sets the flag of intersection.

        Parameters
        ----------
        theInt: bool

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetIntersection(self, *args)

    def SetIntersectionPossible(self, *args):
        r"""
        Sets the flag of possibility of intersection.

        Parameters
        ----------
        theIP: bool

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetIntersectionPossible(self, *args)

    def SetSecondEdge(self, *args):
        r"""
        Sets the second edge.

        Parameters
        ----------
        theEdge: int
        theEdgeOrientation: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetSecondEdge(self, *args)

    def SetSecondPoint(self, *args):
        r"""
        Sets the second point.

        Parameters
        ----------
        thePoint: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetSecondPoint(self, *args)

    def SetThirdEdge(self, *args):
        r"""
        Sets the third edge.

        Parameters
        ----------
        theEdge: int
        theEdgeOrientation: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetThirdEdge(self, *args)

    def SetThirdPoint(self, *args):
        r"""
        Sets the third point.

        Parameters
        ----------
        thePoint: int

        Returns
        -------
        None

        """
        return _IntPolyh.IntPolyh_Triangle_SetThirdPoint(self, *args)

    def ThirdEdge(self, *args):
        r"""
        Returns the third edge.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_ThirdEdge(self, *args)

    def ThirdEdgeOrientation(self, *args):
        r"""
        Returns the orientation of the third edge.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_ThirdEdgeOrientation(self, *args)

    def ThirdPoint(self, *args):
        r"""
        Returns the third point.

        Returns
        -------
        int

        """
        return _IntPolyh.IntPolyh_Triangle_ThirdPoint(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def GetNextChainTriangle(self):
    	pass

    __swig_destroy__ = _IntPolyh.delete_IntPolyh_Triangle

# Register IntPolyh_Triangle in _IntPolyh:
_IntPolyh.IntPolyh_Triangle_swigregister(IntPolyh_Triangle)

@classnotwrapped
class IntPolyh_Array:
	pass

@classnotwrapped
class IntPolyh_MaillageAffinage:
	pass





