from datetime import datetime
from typing import Any, Dict, NamedTuple, List, Union

from github.GitCommit import GitCommit
from github.GithubObject import CompletableGithubObject, _NotSetType
from github.PaginatedList import PaginatedList
from github.PullRequest import PullRequest
from github.Repository import Repository
from github.WorkflowJob import WorkflowJob

class TimingData(NamedTuple):
    billable: Dict[str, Dict[str, int]]
    run_duration_ms: int

class WorkflowRun(CompletableGithubObject):
    def __repr__(self) -> str: ...
    def _initAttributes(self) -> None: ...
    def _useAttributes(self, attributes: Dict[str, Any]) -> None: ...
    @property
    def id(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def head_branch(self) -> str: ...
    @property
    def head_sha(self) -> str: ...
    @property
    def path(self) -> str: ...
    @property
    def display_title(self) -> str: ...
    @property
    def run_number(self) -> int: ...
    @property
    def run_attempt(self) -> int: ...
    @property
    def run_started_at(self) -> str: ...
    @property
    def event(self) -> str: ...
    @property
    def status(self) -> str: ...
    @property
    def conclusion(self) -> str: ...
    @property
    def workflow_id(self) -> int: ...
    @property
    def url(self) -> str: ...
    @property
    def html_url(self) -> str: ...
    @property
    def pull_requests(self) -> List[PullRequest]: ...
    @property
    def created_at(self) -> datetime: ...
    @property
    def updated_at(self) -> datetime: ...
    @property
    def jobs_url(self) -> str: ...
    @property
    def logs_url(self) -> str: ...
    @property
    def check_suite_url(self) -> str: ...
    @property
    def artifacts_url(self) -> str: ...
    @property
    def cancel_url(self) -> str: ...
    @property
    def rerun_url(self) -> str: ...
    @property
    def workflow_url(self) -> str: ...
    @property
    def head_commit(self) -> GitCommit: ...
    @property
    def repository(self) -> Repository: ...
    @property
    def head_repository(self) -> Repository: ...
    def cancel(self) -> bool: ...
    def jobs(
        self, _filter: Union[str, _NotSetType] = ...
    ) -> PaginatedList[WorkflowJob]: ...
    def rerun(self) -> bool: ...
    def timing(self) -> TimingData: ...
