/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer.its.etsi102941;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.oer.its.etsi102941.CtlDelete;
import org.bouncycastle.oer.its.etsi102941.CtlEntry;

public class CtlCommand
extends ASN1Object
implements ASN1Choice {
    private final int choice;
    private final ASN1Encodable ctlCommand;
    public static final int add = 0;
    public static final int delete = 1;

    public CtlCommand(int n, ASN1Encodable aSN1Encodable) {
        this.choice = n;
        this.ctlCommand = aSN1Encodable;
    }

    private CtlCommand(ASN1TaggedObject aSN1TaggedObject) {
        this.choice = aSN1TaggedObject.getTagNo();
        switch (this.choice) {
            case 0: {
                this.ctlCommand = CtlEntry.getInstance(aSN1TaggedObject.getObject());
                return;
            }
            case 1: {
                this.ctlCommand = CtlDelete.getInstance(aSN1TaggedObject.getObject());
                return;
            }
        }
        throw new IllegalArgumentException("invalid choice value " + this.choice);
    }

    public static CtlCommand getInstance(Object object) {
        if (object instanceof CtlCommand) {
            return (CtlCommand)((Object)object);
        }
        if (object != null) {
            return new CtlCommand(ASN1TaggedObject.getInstance((Object)object));
        }
        return null;
    }

    public static CtlCommand add(CtlEntry ctlEntry) {
        return new CtlCommand(0, (ASN1Encodable)ctlEntry);
    }

    public static CtlCommand delete(CtlDelete ctlDelete) {
        return new CtlCommand(1, (ASN1Encodable)ctlDelete);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getCtlCommand() {
        return this.ctlCommand;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.ctlCommand);
    }
}

