import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { collectBody, decorateServiceException as __decorateServiceException, expectNonNull as __expectNonNull, expectString as __expectString, extendedEncodeURIComponent as __extendedEncodeURIComponent, getArrayIfSingleItem as __getArrayIfSingleItem, getValueFromTextNode as __getValueFromTextNode, parseBoolean as __parseBoolean, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, strictParseInt32 as __strictParseInt32, withBaseException, } from "@smithy/smithy-client";
import { XMLParser } from "fast-xml-parser";
import { v4 as generateIdempotencyToken } from "uuid";
import { CloudFormationServiceException as __BaseException } from "../models/CloudFormationServiceException";
import { AlreadyExistsException, CFNRegistryException, ChangeSetNotFoundException, CreatedButModifiedException, InsufficientCapabilitiesException, InvalidChangeSetStatusException, InvalidOperationException, InvalidStateTransitionException, LimitExceededException, NameAlreadyExistsException, OperationIdAlreadyExistsException, OperationInProgressException, OperationNotFoundException, OperationStatusCheckFailedException, StackInstanceNotFoundException, StackNotFoundException, StackSetNotEmptyException, StackSetNotFoundException, StaleRequestException, TokenAlreadyExistsException, TypeConfigurationNotFoundException, TypeNotFoundException, } from "../models/models_0";
export const se_ActivateOrganizationsAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ActivateOrganizationsAccessInput(input, context),
        Action: "ActivateOrganizationsAccess",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ActivateTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ActivateTypeInput(input, context),
        Action: "ActivateType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchDescribeTypeConfigurationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_BatchDescribeTypeConfigurationsInput(input, context),
        Action: "BatchDescribeTypeConfigurations",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelUpdateStackCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelUpdateStackInput(input, context),
        Action: "CancelUpdateStack",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ContinueUpdateRollbackCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ContinueUpdateRollbackInput(input, context),
        Action: "ContinueUpdateRollback",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateChangeSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateChangeSetInput(input, context),
        Action: "CreateChangeSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateStackCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateStackInput(input, context),
        Action: "CreateStack",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateStackInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateStackInstancesInput(input, context),
        Action: "CreateStackInstances",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateStackSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateStackSetInput(input, context),
        Action: "CreateStackSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeactivateOrganizationsAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeactivateOrganizationsAccessInput(input, context),
        Action: "DeactivateOrganizationsAccess",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeactivateTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeactivateTypeInput(input, context),
        Action: "DeactivateType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteChangeSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteChangeSetInput(input, context),
        Action: "DeleteChangeSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteStackCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteStackInput(input, context),
        Action: "DeleteStack",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteStackInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteStackInstancesInput(input, context),
        Action: "DeleteStackInstances",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteStackSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteStackSetInput(input, context),
        Action: "DeleteStackSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeregisterTypeInput(input, context),
        Action: "DeregisterType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAccountLimitsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAccountLimitsInput(input, context),
        Action: "DescribeAccountLimits",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeChangeSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeChangeSetInput(input, context),
        Action: "DescribeChangeSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeChangeSetHooksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeChangeSetHooksInput(input, context),
        Action: "DescribeChangeSetHooks",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeOrganizationsAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeOrganizationsAccessInput(input, context),
        Action: "DescribeOrganizationsAccess",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePublisherCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribePublisherInput(input, context),
        Action: "DescribePublisher",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackDriftDetectionStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackDriftDetectionStatusInput(input, context),
        Action: "DescribeStackDriftDetectionStatus",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackEventsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackEventsInput(input, context),
        Action: "DescribeStackEvents",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackInstanceInput(input, context),
        Action: "DescribeStackInstance",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackResourceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackResourceInput(input, context),
        Action: "DescribeStackResource",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackResourceDriftsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackResourceDriftsInput(input, context),
        Action: "DescribeStackResourceDrifts",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackResourcesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackResourcesInput(input, context),
        Action: "DescribeStackResources",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStacksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStacksInput(input, context),
        Action: "DescribeStacks",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackSetInput(input, context),
        Action: "DescribeStackSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStackSetOperationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStackSetOperationInput(input, context),
        Action: "DescribeStackSetOperation",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTypeInput(input, context),
        Action: "DescribeType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTypeRegistrationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTypeRegistrationInput(input, context),
        Action: "DescribeTypeRegistration",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetectStackDriftCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetectStackDriftInput(input, context),
        Action: "DetectStackDrift",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetectStackResourceDriftCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetectStackResourceDriftInput(input, context),
        Action: "DetectStackResourceDrift",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetectStackSetDriftCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetectStackSetDriftInput(input, context),
        Action: "DetectStackSetDrift",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EstimateTemplateCostCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EstimateTemplateCostInput(input, context),
        Action: "EstimateTemplateCost",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ExecuteChangeSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ExecuteChangeSetInput(input, context),
        Action: "ExecuteChangeSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetStackPolicyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetStackPolicyInput(input, context),
        Action: "GetStackPolicy",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTemplateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTemplateInput(input, context),
        Action: "GetTemplate",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTemplateSummaryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTemplateSummaryInput(input, context),
        Action: "GetTemplateSummary",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportStacksToStackSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportStacksToStackSetInput(input, context),
        Action: "ImportStacksToStackSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListChangeSetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListChangeSetsInput(input, context),
        Action: "ListChangeSets",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListExportsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListExportsInput(input, context),
        Action: "ListExports",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListImportsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListImportsInput(input, context),
        Action: "ListImports",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStackInstanceResourceDriftsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStackInstanceResourceDriftsInput(input, context),
        Action: "ListStackInstanceResourceDrifts",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStackInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStackInstancesInput(input, context),
        Action: "ListStackInstances",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStackResourcesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStackResourcesInput(input, context),
        Action: "ListStackResources",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStacksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStacksInput(input, context),
        Action: "ListStacks",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStackSetOperationResultsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStackSetOperationResultsInput(input, context),
        Action: "ListStackSetOperationResults",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStackSetOperationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStackSetOperationsInput(input, context),
        Action: "ListStackSetOperations",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStackSetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListStackSetsInput(input, context),
        Action: "ListStackSets",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTypeRegistrationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListTypeRegistrationsInput(input, context),
        Action: "ListTypeRegistrations",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTypesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListTypesInput(input, context),
        Action: "ListTypes",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTypeVersionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListTypeVersionsInput(input, context),
        Action: "ListTypeVersions",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PublishTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PublishTypeInput(input, context),
        Action: "PublishType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RecordHandlerProgressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RecordHandlerProgressInput(input, context),
        Action: "RecordHandlerProgress",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterPublisherCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterPublisherInput(input, context),
        Action: "RegisterPublisher",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterTypeInput(input, context),
        Action: "RegisterType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RollbackStackCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RollbackStackInput(input, context),
        Action: "RollbackStack",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SetStackPolicyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SetStackPolicyInput(input, context),
        Action: "SetStackPolicy",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SetTypeConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SetTypeConfigurationInput(input, context),
        Action: "SetTypeConfiguration",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SetTypeDefaultVersionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SetTypeDefaultVersionInput(input, context),
        Action: "SetTypeDefaultVersion",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SignalResourceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SignalResourceInput(input, context),
        Action: "SignalResource",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopStackSetOperationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StopStackSetOperationInput(input, context),
        Action: "StopStackSetOperation",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TestTypeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_TestTypeInput(input, context),
        Action: "TestType",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateStackCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UpdateStackInput(input, context),
        Action: "UpdateStack",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateStackInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UpdateStackInstancesInput(input, context),
        Action: "UpdateStackInstances",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateStackSetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UpdateStackSetInput(input, context),
        Action: "UpdateStackSet",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateTerminationProtectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UpdateTerminationProtectionInput(input, context),
        Action: "UpdateTerminationProtection",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ValidateTemplateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ValidateTemplateInput(input, context),
        Action: "ValidateTemplate",
        Version: "2010-05-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_ActivateOrganizationsAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ActivateOrganizationsAccessCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ActivateOrganizationsAccessOutput(data.ActivateOrganizationsAccessResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ActivateOrganizationsAccessCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ActivateTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ActivateTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ActivateTypeOutput(data.ActivateTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ActivateTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_BatchDescribeTypeConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchDescribeTypeConfigurationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchDescribeTypeConfigurationsOutput(data.BatchDescribeTypeConfigurationsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchDescribeTypeConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeConfigurationNotFoundException":
        case "com.amazonaws.cloudformation#TypeConfigurationNotFoundException":
            throw await de_TypeConfigurationNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_CancelUpdateStackCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CancelUpdateStackCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_CancelUpdateStackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ContinueUpdateRollbackCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ContinueUpdateRollbackCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ContinueUpdateRollbackOutput(data.ContinueUpdateRollbackResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ContinueUpdateRollbackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_CreateChangeSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateChangeSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateChangeSetOutput(data.CreateChangeSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateChangeSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AlreadyExistsException":
        case "com.amazonaws.cloudformation#AlreadyExistsException":
            throw await de_AlreadyExistsExceptionRes(parsedOutput, context);
        case "InsufficientCapabilitiesException":
        case "com.amazonaws.cloudformation#InsufficientCapabilitiesException":
            throw await de_InsufficientCapabilitiesExceptionRes(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudformation#LimitExceededException":
            throw await de_LimitExceededExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_CreateStackCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateStackCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateStackOutput(data.CreateStackResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateStackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AlreadyExistsException":
        case "com.amazonaws.cloudformation#AlreadyExistsException":
            throw await de_AlreadyExistsExceptionRes(parsedOutput, context);
        case "InsufficientCapabilitiesException":
        case "com.amazonaws.cloudformation#InsufficientCapabilitiesException":
            throw await de_InsufficientCapabilitiesExceptionRes(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudformation#LimitExceededException":
            throw await de_LimitExceededExceptionRes(parsedOutput, context);
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_CreateStackInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateStackInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateStackInstancesOutput(data.CreateStackInstancesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateStackInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudformation#LimitExceededException":
            throw await de_LimitExceededExceptionRes(parsedOutput, context);
        case "OperationIdAlreadyExistsException":
        case "com.amazonaws.cloudformation#OperationIdAlreadyExistsException":
            throw await de_OperationIdAlreadyExistsExceptionRes(parsedOutput, context);
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        case "StaleRequestException":
        case "com.amazonaws.cloudformation#StaleRequestException":
            throw await de_StaleRequestExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_CreateStackSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateStackSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateStackSetOutput(data.CreateStackSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateStackSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CreatedButModifiedException":
        case "com.amazonaws.cloudformation#CreatedButModifiedException":
            throw await de_CreatedButModifiedExceptionRes(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudformation#LimitExceededException":
            throw await de_LimitExceededExceptionRes(parsedOutput, context);
        case "NameAlreadyExistsException":
        case "com.amazonaws.cloudformation#NameAlreadyExistsException":
            throw await de_NameAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeactivateOrganizationsAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeactivateOrganizationsAccessCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeactivateOrganizationsAccessOutput(data.DeactivateOrganizationsAccessResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeactivateOrganizationsAccessCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeactivateTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeactivateTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeactivateTypeOutput(data.DeactivateTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeactivateTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeleteChangeSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteChangeSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteChangeSetOutput(data.DeleteChangeSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeleteChangeSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidChangeSetStatus":
        case "com.amazonaws.cloudformation#InvalidChangeSetStatusException":
            throw await de_InvalidChangeSetStatusExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeleteStackCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteStackCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_DeleteStackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeleteStackInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteStackInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteStackInstancesOutput(data.DeleteStackInstancesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeleteStackInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationIdAlreadyExistsException":
        case "com.amazonaws.cloudformation#OperationIdAlreadyExistsException":
            throw await de_OperationIdAlreadyExistsExceptionRes(parsedOutput, context);
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        case "StaleRequestException":
        case "com.amazonaws.cloudformation#StaleRequestException":
            throw await de_StaleRequestExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeleteStackSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteStackSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteStackSetOutput(data.DeleteStackSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeleteStackSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackSetNotEmptyException":
        case "com.amazonaws.cloudformation#StackSetNotEmptyException":
            throw await de_StackSetNotEmptyExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DeregisterTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeregisterTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeregisterTypeOutput(data.DeregisterTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeregisterTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeAccountLimitsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeAccountLimitsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAccountLimitsOutput(data.DescribeAccountLimitsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeAccountLimitsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeChangeSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeChangeSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeChangeSetOutput(data.DescribeChangeSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeChangeSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ChangeSetNotFound":
        case "com.amazonaws.cloudformation#ChangeSetNotFoundException":
            throw await de_ChangeSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeChangeSetHooksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeChangeSetHooksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeChangeSetHooksOutput(data.DescribeChangeSetHooksResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeChangeSetHooksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ChangeSetNotFound":
        case "com.amazonaws.cloudformation#ChangeSetNotFoundException":
            throw await de_ChangeSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeOrganizationsAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeOrganizationsAccessCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeOrganizationsAccessOutput(data.DescribeOrganizationsAccessResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeOrganizationsAccessCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribePublisherCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribePublisherCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePublisherOutput(data.DescribePublisherResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribePublisherCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeStackDriftDetectionStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackDriftDetectionStatusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackDriftDetectionStatusOutput(data.DescribeStackDriftDetectionStatusResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackDriftDetectionStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeStackEventsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackEventsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackEventsOutput(data.DescribeStackEventsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackEventsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeStackInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackInstanceOutput(data.DescribeStackInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "StackInstanceNotFoundException":
        case "com.amazonaws.cloudformation#StackInstanceNotFoundException":
            throw await de_StackInstanceNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeStackResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackResourceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackResourceOutput(data.DescribeStackResourceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeStackResourceDriftsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackResourceDriftsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackResourceDriftsOutput(data.DescribeStackResourceDriftsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackResourceDriftsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeStackResourcesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackResourcesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackResourcesOutput(data.DescribeStackResourcesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackResourcesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeStacksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStacksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStacksOutput(data.DescribeStacksResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStacksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DescribeStackSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackSetOutput(data.DescribeStackSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeStackSetOperationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeStackSetOperationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStackSetOperationOutput(data.DescribeStackSetOperationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeStackSetOperationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTypeOutput(data.DescribeTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DescribeTypeRegistrationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DescribeTypeRegistrationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTypeRegistrationOutput(data.DescribeTypeRegistrationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DescribeTypeRegistrationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_DetectStackDriftCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DetectStackDriftCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DetectStackDriftOutput(data.DetectStackDriftResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DetectStackDriftCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DetectStackResourceDriftCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DetectStackResourceDriftCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DetectStackResourceDriftOutput(data.DetectStackResourceDriftResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DetectStackResourceDriftCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_DetectStackSetDriftCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DetectStackSetDriftCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DetectStackSetDriftOutput(data.DetectStackSetDriftResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DetectStackSetDriftCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_EstimateTemplateCostCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_EstimateTemplateCostCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EstimateTemplateCostOutput(data.EstimateTemplateCostResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_EstimateTemplateCostCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ExecuteChangeSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ExecuteChangeSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExecuteChangeSetOutput(data.ExecuteChangeSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ExecuteChangeSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ChangeSetNotFound":
        case "com.amazonaws.cloudformation#ChangeSetNotFoundException":
            throw await de_ChangeSetNotFoundExceptionRes(parsedOutput, context);
        case "InsufficientCapabilitiesException":
        case "com.amazonaws.cloudformation#InsufficientCapabilitiesException":
            throw await de_InsufficientCapabilitiesExceptionRes(parsedOutput, context);
        case "InvalidChangeSetStatus":
        case "com.amazonaws.cloudformation#InvalidChangeSetStatusException":
            throw await de_InvalidChangeSetStatusExceptionRes(parsedOutput, context);
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_GetStackPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetStackPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetStackPolicyOutput(data.GetStackPolicyResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetStackPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_GetTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetTemplateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTemplateOutput(data.GetTemplateResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetTemplateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ChangeSetNotFound":
        case "com.amazonaws.cloudformation#ChangeSetNotFoundException":
            throw await de_ChangeSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_GetTemplateSummaryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetTemplateSummaryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTemplateSummaryOutput(data.GetTemplateSummaryResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetTemplateSummaryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ImportStacksToStackSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ImportStacksToStackSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportStacksToStackSetOutput(data.ImportStacksToStackSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ImportStacksToStackSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.cloudformation#LimitExceededException":
            throw await de_LimitExceededExceptionRes(parsedOutput, context);
        case "OperationIdAlreadyExistsException":
        case "com.amazonaws.cloudformation#OperationIdAlreadyExistsException":
            throw await de_OperationIdAlreadyExistsExceptionRes(parsedOutput, context);
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackNotFoundException":
        case "com.amazonaws.cloudformation#StackNotFoundException":
            throw await de_StackNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        case "StaleRequestException":
        case "com.amazonaws.cloudformation#StaleRequestException":
            throw await de_StaleRequestExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListChangeSetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListChangeSetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListChangeSetsOutput(data.ListChangeSetsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListChangeSetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ListExportsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListExportsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListExportsOutput(data.ListExportsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListExportsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ListImportsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListImportsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListImportsOutput(data.ListImportsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListImportsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ListStackInstanceResourceDriftsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStackInstanceResourceDriftsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStackInstanceResourceDriftsOutput(data.ListStackInstanceResourceDriftsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStackInstanceResourceDriftsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        case "StackInstanceNotFoundException":
        case "com.amazonaws.cloudformation#StackInstanceNotFoundException":
            throw await de_StackInstanceNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListStackInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStackInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStackInstancesOutput(data.ListStackInstancesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStackInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListStackResourcesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStackResourcesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStackResourcesOutput(data.ListStackResourcesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStackResourcesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ListStacksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStacksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStacksOutput(data.ListStacksResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStacksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ListStackSetOperationResultsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStackSetOperationResultsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStackSetOperationResultsOutput(data.ListStackSetOperationResultsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStackSetOperationResultsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListStackSetOperationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStackSetOperationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStackSetOperationsOutput(data.ListStackSetOperationsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStackSetOperationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListStackSetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListStackSetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStackSetsOutput(data.ListStackSetsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListStackSetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ListTypeRegistrationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListTypeRegistrationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListTypeRegistrationsOutput(data.ListTypeRegistrationsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListTypeRegistrationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListTypesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListTypesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListTypesOutput(data.ListTypesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListTypesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_ListTypeVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListTypeVersionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListTypeVersionsOutput(data.ListTypeVersionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListTypeVersionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_PublishTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_PublishTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PublishTypeOutput(data.PublishTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_PublishTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_RecordHandlerProgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RecordHandlerProgressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RecordHandlerProgressOutput(data.RecordHandlerProgressResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_RecordHandlerProgressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ConditionalCheckFailed":
        case "com.amazonaws.cloudformation#OperationStatusCheckFailedException":
            throw await de_OperationStatusCheckFailedExceptionRes(parsedOutput, context);
        case "InvalidStateTransition":
        case "com.amazonaws.cloudformation#InvalidStateTransitionException":
            throw await de_InvalidStateTransitionExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_RegisterPublisherCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RegisterPublisherCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterPublisherOutput(data.RegisterPublisherResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_RegisterPublisherCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_RegisterTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RegisterTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterTypeOutput(data.RegisterTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_RegisterTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_RollbackStackCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RollbackStackCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RollbackStackOutput(data.RollbackStackResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_RollbackStackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_SetStackPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SetStackPolicyCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_SetStackPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_SetTypeConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SetTypeConfigurationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SetTypeConfigurationOutput(data.SetTypeConfigurationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_SetTypeConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_SetTypeDefaultVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SetTypeDefaultVersionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SetTypeDefaultVersionOutput(data.SetTypeDefaultVersionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_SetTypeDefaultVersionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_SignalResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SignalResourceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_SignalResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_StopStackSetOperationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_StopStackSetOperationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopStackSetOperationOutput(data.StopStackSetOperationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_StopStackSetOperationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationNotFoundException":
        case "com.amazonaws.cloudformation#OperationNotFoundException":
            throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_TestTypeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_TestTypeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_TestTypeOutput(data.TestTypeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_TestTypeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "CFNRegistryException":
        case "com.amazonaws.cloudformation#CFNRegistryException":
            throw await de_CFNRegistryExceptionRes(parsedOutput, context);
        case "TypeNotFoundException":
        case "com.amazonaws.cloudformation#TypeNotFoundException":
            throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_UpdateStackCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UpdateStackCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateStackOutput(data.UpdateStackResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_UpdateStackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InsufficientCapabilitiesException":
        case "com.amazonaws.cloudformation#InsufficientCapabilitiesException":
            throw await de_InsufficientCapabilitiesExceptionRes(parsedOutput, context);
        case "TokenAlreadyExistsException":
        case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
            throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_UpdateStackInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UpdateStackInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateStackInstancesOutput(data.UpdateStackInstancesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_UpdateStackInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationIdAlreadyExistsException":
        case "com.amazonaws.cloudformation#OperationIdAlreadyExistsException":
            throw await de_OperationIdAlreadyExistsExceptionRes(parsedOutput, context);
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackInstanceNotFoundException":
        case "com.amazonaws.cloudformation#StackInstanceNotFoundException":
            throw await de_StackInstanceNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        case "StaleRequestException":
        case "com.amazonaws.cloudformation#StaleRequestException":
            throw await de_StaleRequestExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_UpdateStackSetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UpdateStackSetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateStackSetOutput(data.UpdateStackSetResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_UpdateStackSetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidOperationException":
        case "com.amazonaws.cloudformation#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        case "OperationIdAlreadyExistsException":
        case "com.amazonaws.cloudformation#OperationIdAlreadyExistsException":
            throw await de_OperationIdAlreadyExistsExceptionRes(parsedOutput, context);
        case "OperationInProgressException":
        case "com.amazonaws.cloudformation#OperationInProgressException":
            throw await de_OperationInProgressExceptionRes(parsedOutput, context);
        case "StackInstanceNotFoundException":
        case "com.amazonaws.cloudformation#StackInstanceNotFoundException":
            throw await de_StackInstanceNotFoundExceptionRes(parsedOutput, context);
        case "StackSetNotFoundException":
        case "com.amazonaws.cloudformation#StackSetNotFoundException":
            throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
        case "StaleRequestException":
        case "com.amazonaws.cloudformation#StaleRequestException":
            throw await de_StaleRequestExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
export const de_UpdateTerminationProtectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UpdateTerminationProtectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateTerminationProtectionOutput(data.UpdateTerminationProtectionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_UpdateTerminationProtectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
export const de_ValidateTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ValidateTemplateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ValidateTemplateOutput(data.ValidateTemplateResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ValidateTemplateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode,
    });
};
const de_AlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_AlreadyExistsException(body.Error, context);
    const exception = new AlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CFNRegistryExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CFNRegistryException(body.Error, context);
    const exception = new CFNRegistryException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ChangeSetNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ChangeSetNotFoundException(body.Error, context);
    const exception = new ChangeSetNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CreatedButModifiedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CreatedButModifiedException(body.Error, context);
    const exception = new CreatedButModifiedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InsufficientCapabilitiesExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InsufficientCapabilitiesException(body.Error, context);
    const exception = new InsufficientCapabilitiesException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidChangeSetStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidChangeSetStatusException(body.Error, context);
    const exception = new InvalidChangeSetStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOperationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidOperationException(body.Error, context);
    const exception = new InvalidOperationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidStateTransitionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidStateTransitionException(body.Error, context);
    const exception = new InvalidStateTransitionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_LimitExceededException(body.Error, context);
    const exception = new LimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_NameAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_NameAlreadyExistsException(body.Error, context);
    const exception = new NameAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OperationIdAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OperationIdAlreadyExistsException(body.Error, context);
    const exception = new OperationIdAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OperationInProgressExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OperationInProgressException(body.Error, context);
    const exception = new OperationInProgressException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OperationNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OperationNotFoundException(body.Error, context);
    const exception = new OperationNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OperationStatusCheckFailedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OperationStatusCheckFailedException(body.Error, context);
    const exception = new OperationStatusCheckFailedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StackInstanceNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StackInstanceNotFoundException(body.Error, context);
    const exception = new StackInstanceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StackNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StackNotFoundException(body.Error, context);
    const exception = new StackNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StackSetNotEmptyExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StackSetNotEmptyException(body.Error, context);
    const exception = new StackSetNotEmptyException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StackSetNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StackSetNotFoundException(body.Error, context);
    const exception = new StackSetNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StaleRequestExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StaleRequestException(body.Error, context);
    const exception = new StaleRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TokenAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_TokenAlreadyExistsException(body.Error, context);
    const exception = new TokenAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TypeConfigurationNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_TypeConfigurationNotFoundException(body.Error, context);
    const exception = new TypeConfigurationNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TypeNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_TypeNotFoundException(body.Error, context);
    const exception = new TypeNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const se_AccountList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ActivateOrganizationsAccessInput = (input, context) => {
    const entries = {};
    return entries;
};
const se_ActivateTypeInput = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.PublicTypeArn != null) {
        entries["PublicTypeArn"] = input.PublicTypeArn;
    }
    if (input.PublisherId != null) {
        entries["PublisherId"] = input.PublisherId;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.TypeNameAlias != null) {
        entries["TypeNameAlias"] = input.TypeNameAlias;
    }
    if (input.AutoUpdate != null) {
        entries["AutoUpdate"] = input.AutoUpdate;
    }
    if (input.LoggingConfig != null) {
        const memberEntries = se_LoggingConfig(input.LoggingConfig, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LoggingConfig.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ExecutionRoleArn != null) {
        entries["ExecutionRoleArn"] = input.ExecutionRoleArn;
    }
    if (input.VersionBump != null) {
        entries["VersionBump"] = input.VersionBump;
    }
    if (input.MajorVersion != null) {
        entries["MajorVersion"] = input.MajorVersion;
    }
    return entries;
};
const se_AutoDeployment = (input, context) => {
    const entries = {};
    if (input.Enabled != null) {
        entries["Enabled"] = input.Enabled;
    }
    if (input.RetainStacksOnAccountRemoval != null) {
        entries["RetainStacksOnAccountRemoval"] = input.RetainStacksOnAccountRemoval;
    }
    return entries;
};
const se_BatchDescribeTypeConfigurationsInput = (input, context) => {
    const entries = {};
    if (input.TypeConfigurationIdentifiers != null) {
        const memberEntries = se_TypeConfigurationIdentifiers(input.TypeConfigurationIdentifiers, context);
        if (input.TypeConfigurationIdentifiers?.length === 0) {
            entries.TypeConfigurationIdentifiers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TypeConfigurationIdentifiers.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CancelUpdateStackInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    return entries;
};
const se_Capabilities = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ContinueUpdateRollbackInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.RoleARN != null) {
        entries["RoleARN"] = input.RoleARN;
    }
    if (input.ResourcesToSkip != null) {
        const memberEntries = se_ResourcesToSkip(input.ResourcesToSkip, context);
        if (input.ResourcesToSkip?.length === 0) {
            entries.ResourcesToSkip = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourcesToSkip.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    return entries;
};
const se_CreateChangeSetInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.UsePreviousTemplate != null) {
        entries["UsePreviousTemplate"] = input.UsePreviousTemplate;
    }
    if (input.Parameters != null) {
        const memberEntries = se_Parameters(input.Parameters, context);
        if (input.Parameters?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Capabilities != null) {
        const memberEntries = se_Capabilities(input.Capabilities, context);
        if (input.Capabilities?.length === 0) {
            entries.Capabilities = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Capabilities.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ResourceTypes != null) {
        const memberEntries = se_ResourceTypes(input.ResourceTypes, context);
        if (input.ResourceTypes?.length === 0) {
            entries.ResourceTypes = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceTypes.${key}`;
            entries[loc] = value;
        });
    }
    if (input.RoleARN != null) {
        entries["RoleARN"] = input.RoleARN;
    }
    if (input.RollbackConfiguration != null) {
        const memberEntries = se_RollbackConfiguration(input.RollbackConfiguration, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RollbackConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input.NotificationARNs != null) {
        const memberEntries = se_NotificationARNs(input.NotificationARNs, context);
        if (input.NotificationARNs?.length === 0) {
            entries.NotificationARNs = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NotificationARNs.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Tags != null) {
        const memberEntries = se_Tags(input.Tags, context);
        if (input.Tags?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ChangeSetName != null) {
        entries["ChangeSetName"] = input.ChangeSetName;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.ChangeSetType != null) {
        entries["ChangeSetType"] = input.ChangeSetType;
    }
    if (input.ResourcesToImport != null) {
        const memberEntries = se_ResourcesToImport(input.ResourcesToImport, context);
        if (input.ResourcesToImport?.length === 0) {
            entries.ResourcesToImport = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourcesToImport.${key}`;
            entries[loc] = value;
        });
    }
    if (input.IncludeNestedStacks != null) {
        entries["IncludeNestedStacks"] = input.IncludeNestedStacks;
    }
    if (input.OnStackFailure != null) {
        entries["OnStackFailure"] = input.OnStackFailure;
    }
    return entries;
};
const se_CreateStackInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.Parameters != null) {
        const memberEntries = se_Parameters(input.Parameters, context);
        if (input.Parameters?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DisableRollback != null) {
        entries["DisableRollback"] = input.DisableRollback;
    }
    if (input.RollbackConfiguration != null) {
        const memberEntries = se_RollbackConfiguration(input.RollbackConfiguration, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RollbackConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TimeoutInMinutes != null) {
        entries["TimeoutInMinutes"] = input.TimeoutInMinutes;
    }
    if (input.NotificationARNs != null) {
        const memberEntries = se_NotificationARNs(input.NotificationARNs, context);
        if (input.NotificationARNs?.length === 0) {
            entries.NotificationARNs = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NotificationARNs.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Capabilities != null) {
        const memberEntries = se_Capabilities(input.Capabilities, context);
        if (input.Capabilities?.length === 0) {
            entries.Capabilities = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Capabilities.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ResourceTypes != null) {
        const memberEntries = se_ResourceTypes(input.ResourceTypes, context);
        if (input.ResourceTypes?.length === 0) {
            entries.ResourceTypes = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceTypes.${key}`;
            entries[loc] = value;
        });
    }
    if (input.RoleARN != null) {
        entries["RoleARN"] = input.RoleARN;
    }
    if (input.OnFailure != null) {
        entries["OnFailure"] = input.OnFailure;
    }
    if (input.StackPolicyBody != null) {
        entries["StackPolicyBody"] = input.StackPolicyBody;
    }
    if (input.StackPolicyURL != null) {
        entries["StackPolicyURL"] = input.StackPolicyURL;
    }
    if (input.Tags != null) {
        const memberEntries = se_Tags(input.Tags, context);
        if (input.Tags?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    if (input.EnableTerminationProtection != null) {
        entries["EnableTerminationProtection"] = input.EnableTerminationProtection;
    }
    if (input.RetainExceptOnCreate != null) {
        entries["RetainExceptOnCreate"] = input.RetainExceptOnCreate;
    }
    return entries;
};
const se_CreateStackInstancesInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.Accounts != null) {
        const memberEntries = se_AccountList(input.Accounts, context);
        if (input.Accounts?.length === 0) {
            entries.Accounts = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Accounts.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DeploymentTargets != null) {
        const memberEntries = se_DeploymentTargets(input.DeploymentTargets, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeploymentTargets.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Regions != null) {
        const memberEntries = se_RegionList(input.Regions, context);
        if (input.Regions?.length === 0) {
            entries.Regions = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Regions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ParameterOverrides != null) {
        const memberEntries = se_Parameters(input.ParameterOverrides, context);
        if (input.ParameterOverrides?.length === 0) {
            entries.ParameterOverrides = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ParameterOverrides.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationPreferences != null) {
        const memberEntries = se_StackSetOperationPreferences(input.OperationPreferences, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperationPreferences.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationId === undefined) {
        input.OperationId = generateIdempotencyToken();
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_CreateStackSetInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.StackId != null) {
        entries["StackId"] = input.StackId;
    }
    if (input.Parameters != null) {
        const memberEntries = se_Parameters(input.Parameters, context);
        if (input.Parameters?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Capabilities != null) {
        const memberEntries = se_Capabilities(input.Capabilities, context);
        if (input.Capabilities?.length === 0) {
            entries.Capabilities = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Capabilities.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Tags != null) {
        const memberEntries = se_Tags(input.Tags, context);
        if (input.Tags?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input.AdministrationRoleARN != null) {
        entries["AdministrationRoleARN"] = input.AdministrationRoleARN;
    }
    if (input.ExecutionRoleName != null) {
        entries["ExecutionRoleName"] = input.ExecutionRoleName;
    }
    if (input.PermissionModel != null) {
        entries["PermissionModel"] = input.PermissionModel;
    }
    if (input.AutoDeployment != null) {
        const memberEntries = se_AutoDeployment(input.AutoDeployment, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AutoDeployment.${key}`;
            entries[loc] = value;
        });
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    if (input.ClientRequestToken === undefined) {
        input.ClientRequestToken = generateIdempotencyToken();
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    if (input.ManagedExecution != null) {
        const memberEntries = se_ManagedExecution(input.ManagedExecution, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ManagedExecution.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeactivateOrganizationsAccessInput = (input, context) => {
    const entries = {};
    return entries;
};
const se_DeactivateTypeInput = (input, context) => {
    const entries = {};
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    return entries;
};
const se_DeleteChangeSetInput = (input, context) => {
    const entries = {};
    if (input.ChangeSetName != null) {
        entries["ChangeSetName"] = input.ChangeSetName;
    }
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    return entries;
};
const se_DeleteStackInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.RetainResources != null) {
        const memberEntries = se_RetainResources(input.RetainResources, context);
        if (input.RetainResources?.length === 0) {
            entries.RetainResources = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RetainResources.${key}`;
            entries[loc] = value;
        });
    }
    if (input.RoleARN != null) {
        entries["RoleARN"] = input.RoleARN;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    return entries;
};
const se_DeleteStackInstancesInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.Accounts != null) {
        const memberEntries = se_AccountList(input.Accounts, context);
        if (input.Accounts?.length === 0) {
            entries.Accounts = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Accounts.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DeploymentTargets != null) {
        const memberEntries = se_DeploymentTargets(input.DeploymentTargets, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeploymentTargets.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Regions != null) {
        const memberEntries = se_RegionList(input.Regions, context);
        if (input.Regions?.length === 0) {
            entries.Regions = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Regions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationPreferences != null) {
        const memberEntries = se_StackSetOperationPreferences(input.OperationPreferences, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperationPreferences.${key}`;
            entries[loc] = value;
        });
    }
    if (input.RetainStacks != null) {
        entries["RetainStacks"] = input.RetainStacks;
    }
    if (input.OperationId === undefined) {
        input.OperationId = generateIdempotencyToken();
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_DeleteStackSetInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_DeploymentTargets = (input, context) => {
    const entries = {};
    if (input.Accounts != null) {
        const memberEntries = se_AccountList(input.Accounts, context);
        if (input.Accounts?.length === 0) {
            entries.Accounts = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Accounts.${key}`;
            entries[loc] = value;
        });
    }
    if (input.AccountsUrl != null) {
        entries["AccountsUrl"] = input.AccountsUrl;
    }
    if (input.OrganizationalUnitIds != null) {
        const memberEntries = se_OrganizationalUnitIdList(input.OrganizationalUnitIds, context);
        if (input.OrganizationalUnitIds?.length === 0) {
            entries.OrganizationalUnitIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OrganizationalUnitIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input.AccountFilterType != null) {
        entries["AccountFilterType"] = input.AccountFilterType;
    }
    return entries;
};
const se_DeregisterTypeInput = (input, context) => {
    const entries = {};
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.VersionId != null) {
        entries["VersionId"] = input.VersionId;
    }
    return entries;
};
const se_DescribeAccountLimitsInput = (input, context) => {
    const entries = {};
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_DescribeChangeSetHooksInput = (input, context) => {
    const entries = {};
    if (input.ChangeSetName != null) {
        entries["ChangeSetName"] = input.ChangeSetName;
    }
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.LogicalResourceId != null) {
        entries["LogicalResourceId"] = input.LogicalResourceId;
    }
    return entries;
};
const se_DescribeChangeSetInput = (input, context) => {
    const entries = {};
    if (input.ChangeSetName != null) {
        entries["ChangeSetName"] = input.ChangeSetName;
    }
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_DescribeOrganizationsAccessInput = (input, context) => {
    const entries = {};
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_DescribePublisherInput = (input, context) => {
    const entries = {};
    if (input.PublisherId != null) {
        entries["PublisherId"] = input.PublisherId;
    }
    return entries;
};
const se_DescribeStackDriftDetectionStatusInput = (input, context) => {
    const entries = {};
    if (input.StackDriftDetectionId != null) {
        entries["StackDriftDetectionId"] = input.StackDriftDetectionId;
    }
    return entries;
};
const se_DescribeStackEventsInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_DescribeStackInstanceInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.StackInstanceAccount != null) {
        entries["StackInstanceAccount"] = input.StackInstanceAccount;
    }
    if (input.StackInstanceRegion != null) {
        entries["StackInstanceRegion"] = input.StackInstanceRegion;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_DescribeStackResourceDriftsInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.StackResourceDriftStatusFilters != null) {
        const memberEntries = se_StackResourceDriftStatusFilters(input.StackResourceDriftStatusFilters, context);
        if (input.StackResourceDriftStatusFilters?.length === 0) {
            entries.StackResourceDriftStatusFilters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `StackResourceDriftStatusFilters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    return entries;
};
const se_DescribeStackResourceInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.LogicalResourceId != null) {
        entries["LogicalResourceId"] = input.LogicalResourceId;
    }
    return entries;
};
const se_DescribeStackResourcesInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.LogicalResourceId != null) {
        entries["LogicalResourceId"] = input.LogicalResourceId;
    }
    if (input.PhysicalResourceId != null) {
        entries["PhysicalResourceId"] = input.PhysicalResourceId;
    }
    return entries;
};
const se_DescribeStackSetInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_DescribeStackSetOperationInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_DescribeStacksInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_DescribeTypeInput = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.VersionId != null) {
        entries["VersionId"] = input.VersionId;
    }
    if (input.PublisherId != null) {
        entries["PublisherId"] = input.PublisherId;
    }
    if (input.PublicVersionNumber != null) {
        entries["PublicVersionNumber"] = input.PublicVersionNumber;
    }
    return entries;
};
const se_DescribeTypeRegistrationInput = (input, context) => {
    const entries = {};
    if (input.RegistrationToken != null) {
        entries["RegistrationToken"] = input.RegistrationToken;
    }
    return entries;
};
const se_DetectStackDriftInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.LogicalResourceIds != null) {
        const memberEntries = se_LogicalResourceIds(input.LogicalResourceIds, context);
        if (input.LogicalResourceIds?.length === 0) {
            entries.LogicalResourceIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LogicalResourceIds.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DetectStackResourceDriftInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.LogicalResourceId != null) {
        entries["LogicalResourceId"] = input.LogicalResourceId;
    }
    return entries;
};
const se_DetectStackSetDriftInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.OperationPreferences != null) {
        const memberEntries = se_StackSetOperationPreferences(input.OperationPreferences, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperationPreferences.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationId === undefined) {
        input.OperationId = generateIdempotencyToken();
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_EstimateTemplateCostInput = (input, context) => {
    const entries = {};
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.Parameters != null) {
        const memberEntries = se_Parameters(input.Parameters, context);
        if (input.Parameters?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ExecuteChangeSetInput = (input, context) => {
    const entries = {};
    if (input.ChangeSetName != null) {
        entries["ChangeSetName"] = input.ChangeSetName;
    }
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    if (input.DisableRollback != null) {
        entries["DisableRollback"] = input.DisableRollback;
    }
    if (input.RetainExceptOnCreate != null) {
        entries["RetainExceptOnCreate"] = input.RetainExceptOnCreate;
    }
    return entries;
};
const se_GetStackPolicyInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    return entries;
};
const se_GetTemplateInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.ChangeSetName != null) {
        entries["ChangeSetName"] = input.ChangeSetName;
    }
    if (input.TemplateStage != null) {
        entries["TemplateStage"] = input.TemplateStage;
    }
    return entries;
};
const se_GetTemplateSummaryInput = (input, context) => {
    const entries = {};
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    if (input.TemplateSummaryConfig != null) {
        const memberEntries = se_TemplateSummaryConfig(input.TemplateSummaryConfig, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TemplateSummaryConfig.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ImportStacksToStackSetInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.StackIds != null) {
        const memberEntries = se_StackIdList(input.StackIds, context);
        if (input.StackIds?.length === 0) {
            entries.StackIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `StackIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input.StackIdsUrl != null) {
        entries["StackIdsUrl"] = input.StackIdsUrl;
    }
    if (input.OrganizationalUnitIds != null) {
        const memberEntries = se_OrganizationalUnitIdList(input.OrganizationalUnitIds, context);
        if (input.OrganizationalUnitIds?.length === 0) {
            entries.OrganizationalUnitIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OrganizationalUnitIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationPreferences != null) {
        const memberEntries = se_StackSetOperationPreferences(input.OperationPreferences, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperationPreferences.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationId === undefined) {
        input.OperationId = generateIdempotencyToken();
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_ListChangeSetsInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_ListExportsInput = (input, context) => {
    const entries = {};
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_ListImportsInput = (input, context) => {
    const entries = {};
    if (input.ExportName != null) {
        entries["ExportName"] = input.ExportName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_ListStackInstanceResourceDriftsInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.StackInstanceResourceDriftStatuses != null) {
        const memberEntries = se_StackResourceDriftStatusFilters(input.StackInstanceResourceDriftStatuses, context);
        if (input.StackInstanceResourceDriftStatuses?.length === 0) {
            entries.StackInstanceResourceDriftStatuses = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `StackInstanceResourceDriftStatuses.${key}`;
            entries[loc] = value;
        });
    }
    if (input.StackInstanceAccount != null) {
        entries["StackInstanceAccount"] = input.StackInstanceAccount;
    }
    if (input.StackInstanceRegion != null) {
        entries["StackInstanceRegion"] = input.StackInstanceRegion;
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_ListStackInstancesInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.Filters != null) {
        const memberEntries = se_StackInstanceFilters(input.Filters, context);
        if (input.Filters?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.StackInstanceAccount != null) {
        entries["StackInstanceAccount"] = input.StackInstanceAccount;
    }
    if (input.StackInstanceRegion != null) {
        entries["StackInstanceRegion"] = input.StackInstanceRegion;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_ListStackResourcesInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_ListStackSetOperationResultsInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    if (input.Filters != null) {
        const memberEntries = se_OperationResultFilters(input.Filters, context);
        if (input.Filters?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ListStackSetOperationsInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_ListStackSetsInput = (input, context) => {
    const entries = {};
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.Status != null) {
        entries["Status"] = input.Status;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_ListStacksInput = (input, context) => {
    const entries = {};
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.StackStatusFilter != null) {
        const memberEntries = se_StackStatusFilter(input.StackStatusFilter, context);
        if (input.StackStatusFilter?.length === 0) {
            entries.StackStatusFilter = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `StackStatusFilter.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ListTypeRegistrationsInput = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.TypeArn != null) {
        entries["TypeArn"] = input.TypeArn;
    }
    if (input.RegistrationStatusFilter != null) {
        entries["RegistrationStatusFilter"] = input.RegistrationStatusFilter;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_ListTypesInput = (input, context) => {
    const entries = {};
    if (input.Visibility != null) {
        entries["Visibility"] = input.Visibility;
    }
    if (input.ProvisioningType != null) {
        entries["ProvisioningType"] = input.ProvisioningType;
    }
    if (input.DeprecatedStatus != null) {
        entries["DeprecatedStatus"] = input.DeprecatedStatus;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.Filters != null) {
        const memberEntries = se_TypeFilters(input.Filters, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    return entries;
};
const se_ListTypeVersionsInput = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.MaxResults != null) {
        entries["MaxResults"] = input.MaxResults;
    }
    if (input.NextToken != null) {
        entries["NextToken"] = input.NextToken;
    }
    if (input.DeprecatedStatus != null) {
        entries["DeprecatedStatus"] = input.DeprecatedStatus;
    }
    if (input.PublisherId != null) {
        entries["PublisherId"] = input.PublisherId;
    }
    return entries;
};
const se_LoggingConfig = (input, context) => {
    const entries = {};
    if (input.LogRoleArn != null) {
        entries["LogRoleArn"] = input.LogRoleArn;
    }
    if (input.LogGroupName != null) {
        entries["LogGroupName"] = input.LogGroupName;
    }
    return entries;
};
const se_LogicalResourceIds = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ManagedExecution = (input, context) => {
    const entries = {};
    if (input.Active != null) {
        entries["Active"] = input.Active;
    }
    return entries;
};
const se_NotificationARNs = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_OperationResultFilter = (input, context) => {
    const entries = {};
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.Values != null) {
        entries["Values"] = input.Values;
    }
    return entries;
};
const se_OperationResultFilters = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_OperationResultFilter(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_OrganizationalUnitIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_Parameter = (input, context) => {
    const entries = {};
    if (input.ParameterKey != null) {
        entries["ParameterKey"] = input.ParameterKey;
    }
    if (input.ParameterValue != null) {
        entries["ParameterValue"] = input.ParameterValue;
    }
    if (input.UsePreviousValue != null) {
        entries["UsePreviousValue"] = input.UsePreviousValue;
    }
    if (input.ResolvedValue != null) {
        entries["ResolvedValue"] = input.ResolvedValue;
    }
    return entries;
};
const se_Parameters = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_Parameter(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_PublishTypeInput = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.PublicVersionNumber != null) {
        entries["PublicVersionNumber"] = input.PublicVersionNumber;
    }
    return entries;
};
const se_RecordHandlerProgressInput = (input, context) => {
    const entries = {};
    if (input.BearerToken != null) {
        entries["BearerToken"] = input.BearerToken;
    }
    if (input.OperationStatus != null) {
        entries["OperationStatus"] = input.OperationStatus;
    }
    if (input.CurrentOperationStatus != null) {
        entries["CurrentOperationStatus"] = input.CurrentOperationStatus;
    }
    if (input.StatusMessage != null) {
        entries["StatusMessage"] = input.StatusMessage;
    }
    if (input.ErrorCode != null) {
        entries["ErrorCode"] = input.ErrorCode;
    }
    if (input.ResourceModel != null) {
        entries["ResourceModel"] = input.ResourceModel;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    return entries;
};
const se_RegionList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_RegisterPublisherInput = (input, context) => {
    const entries = {};
    if (input.AcceptTermsAndConditions != null) {
        entries["AcceptTermsAndConditions"] = input.AcceptTermsAndConditions;
    }
    if (input.ConnectionArn != null) {
        entries["ConnectionArn"] = input.ConnectionArn;
    }
    return entries;
};
const se_RegisterTypeInput = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.SchemaHandlerPackage != null) {
        entries["SchemaHandlerPackage"] = input.SchemaHandlerPackage;
    }
    if (input.LoggingConfig != null) {
        const memberEntries = se_LoggingConfig(input.LoggingConfig, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LoggingConfig.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ExecutionRoleArn != null) {
        entries["ExecutionRoleArn"] = input.ExecutionRoleArn;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    return entries;
};
const se_ResourceIdentifierProperties = (input, context) => {
    const entries = {};
    let counter = 1;
    Object.keys(input)
        .filter((key) => input[key] != null)
        .forEach((key) => {
        entries[`entry.${counter}.key`] = key;
        entries[`entry.${counter}.value`] = input[key];
        counter++;
    });
    return entries;
};
const se_ResourcesToImport = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ResourceToImport(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ResourcesToSkip = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ResourceToImport = (input, context) => {
    const entries = {};
    if (input.ResourceType != null) {
        entries["ResourceType"] = input.ResourceType;
    }
    if (input.LogicalResourceId != null) {
        entries["LogicalResourceId"] = input.LogicalResourceId;
    }
    if (input.ResourceIdentifier != null) {
        const memberEntries = se_ResourceIdentifierProperties(input.ResourceIdentifier, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceIdentifier.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ResourceTypes = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_RetainResources = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_RollbackConfiguration = (input, context) => {
    const entries = {};
    if (input.RollbackTriggers != null) {
        const memberEntries = se_RollbackTriggers(input.RollbackTriggers, context);
        if (input.RollbackTriggers?.length === 0) {
            entries.RollbackTriggers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RollbackTriggers.${key}`;
            entries[loc] = value;
        });
    }
    if (input.MonitoringTimeInMinutes != null) {
        entries["MonitoringTimeInMinutes"] = input.MonitoringTimeInMinutes;
    }
    return entries;
};
const se_RollbackStackInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.RoleARN != null) {
        entries["RoleARN"] = input.RoleARN;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    if (input.RetainExceptOnCreate != null) {
        entries["RetainExceptOnCreate"] = input.RetainExceptOnCreate;
    }
    return entries;
};
const se_RollbackTrigger = (input, context) => {
    const entries = {};
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    return entries;
};
const se_RollbackTriggers = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_RollbackTrigger(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_SetStackPolicyInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.StackPolicyBody != null) {
        entries["StackPolicyBody"] = input.StackPolicyBody;
    }
    if (input.StackPolicyURL != null) {
        entries["StackPolicyURL"] = input.StackPolicyURL;
    }
    return entries;
};
const se_SetTypeConfigurationInput = (input, context) => {
    const entries = {};
    if (input.TypeArn != null) {
        entries["TypeArn"] = input.TypeArn;
    }
    if (input.Configuration != null) {
        entries["Configuration"] = input.Configuration;
    }
    if (input.ConfigurationAlias != null) {
        entries["ConfigurationAlias"] = input.ConfigurationAlias;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    return entries;
};
const se_SetTypeDefaultVersionInput = (input, context) => {
    const entries = {};
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.VersionId != null) {
        entries["VersionId"] = input.VersionId;
    }
    return entries;
};
const se_SignalResourceInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.LogicalResourceId != null) {
        entries["LogicalResourceId"] = input.LogicalResourceId;
    }
    if (input.UniqueId != null) {
        entries["UniqueId"] = input.UniqueId;
    }
    if (input.Status != null) {
        entries["Status"] = input.Status;
    }
    return entries;
};
const se_StackIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_StackInstanceFilter = (input, context) => {
    const entries = {};
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.Values != null) {
        entries["Values"] = input.Values;
    }
    return entries;
};
const se_StackInstanceFilters = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_StackInstanceFilter(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_StackResourceDriftStatusFilters = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_StackSetOperationPreferences = (input, context) => {
    const entries = {};
    if (input.RegionConcurrencyType != null) {
        entries["RegionConcurrencyType"] = input.RegionConcurrencyType;
    }
    if (input.RegionOrder != null) {
        const memberEntries = se_RegionList(input.RegionOrder, context);
        if (input.RegionOrder?.length === 0) {
            entries.RegionOrder = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RegionOrder.${key}`;
            entries[loc] = value;
        });
    }
    if (input.FailureToleranceCount != null) {
        entries["FailureToleranceCount"] = input.FailureToleranceCount;
    }
    if (input.FailureTolerancePercentage != null) {
        entries["FailureTolerancePercentage"] = input.FailureTolerancePercentage;
    }
    if (input.MaxConcurrentCount != null) {
        entries["MaxConcurrentCount"] = input.MaxConcurrentCount;
    }
    if (input.MaxConcurrentPercentage != null) {
        entries["MaxConcurrentPercentage"] = input.MaxConcurrentPercentage;
    }
    return entries;
};
const se_StackStatusFilter = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_StopStackSetOperationInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_Tag = (input, context) => {
    const entries = {};
    if (input.Key != null) {
        entries["Key"] = input.Key;
    }
    if (input.Value != null) {
        entries["Value"] = input.Value;
    }
    return entries;
};
const se_Tags = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_Tag(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_TemplateSummaryConfig = (input, context) => {
    const entries = {};
    if (input.TreatUnrecognizedResourceTypesAsWarnings != null) {
        entries["TreatUnrecognizedResourceTypesAsWarnings"] = input.TreatUnrecognizedResourceTypesAsWarnings;
    }
    return entries;
};
const se_TestTypeInput = (input, context) => {
    const entries = {};
    if (input.Arn != null) {
        entries["Arn"] = input.Arn;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    if (input.VersionId != null) {
        entries["VersionId"] = input.VersionId;
    }
    if (input.LogDeliveryBucket != null) {
        entries["LogDeliveryBucket"] = input.LogDeliveryBucket;
    }
    return entries;
};
const se_TypeConfigurationIdentifier = (input, context) => {
    const entries = {};
    if (input.TypeArn != null) {
        entries["TypeArn"] = input.TypeArn;
    }
    if (input.TypeConfigurationAlias != null) {
        entries["TypeConfigurationAlias"] = input.TypeConfigurationAlias;
    }
    if (input.TypeConfigurationArn != null) {
        entries["TypeConfigurationArn"] = input.TypeConfigurationArn;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TypeName != null) {
        entries["TypeName"] = input.TypeName;
    }
    return entries;
};
const se_TypeConfigurationIdentifiers = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_TypeConfigurationIdentifier(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_TypeFilters = (input, context) => {
    const entries = {};
    if (input.Category != null) {
        entries["Category"] = input.Category;
    }
    if (input.PublisherId != null) {
        entries["PublisherId"] = input.PublisherId;
    }
    if (input.TypeNamePrefix != null) {
        entries["TypeNamePrefix"] = input.TypeNamePrefix;
    }
    return entries;
};
const se_UpdateStackInput = (input, context) => {
    const entries = {};
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.UsePreviousTemplate != null) {
        entries["UsePreviousTemplate"] = input.UsePreviousTemplate;
    }
    if (input.StackPolicyDuringUpdateBody != null) {
        entries["StackPolicyDuringUpdateBody"] = input.StackPolicyDuringUpdateBody;
    }
    if (input.StackPolicyDuringUpdateURL != null) {
        entries["StackPolicyDuringUpdateURL"] = input.StackPolicyDuringUpdateURL;
    }
    if (input.Parameters != null) {
        const memberEntries = se_Parameters(input.Parameters, context);
        if (input.Parameters?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Capabilities != null) {
        const memberEntries = se_Capabilities(input.Capabilities, context);
        if (input.Capabilities?.length === 0) {
            entries.Capabilities = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Capabilities.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ResourceTypes != null) {
        const memberEntries = se_ResourceTypes(input.ResourceTypes, context);
        if (input.ResourceTypes?.length === 0) {
            entries.ResourceTypes = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceTypes.${key}`;
            entries[loc] = value;
        });
    }
    if (input.RoleARN != null) {
        entries["RoleARN"] = input.RoleARN;
    }
    if (input.RollbackConfiguration != null) {
        const memberEntries = se_RollbackConfiguration(input.RollbackConfiguration, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RollbackConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input.StackPolicyBody != null) {
        entries["StackPolicyBody"] = input.StackPolicyBody;
    }
    if (input.StackPolicyURL != null) {
        entries["StackPolicyURL"] = input.StackPolicyURL;
    }
    if (input.NotificationARNs != null) {
        const memberEntries = se_NotificationARNs(input.NotificationARNs, context);
        if (input.NotificationARNs?.length === 0) {
            entries.NotificationARNs = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NotificationARNs.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Tags != null) {
        const memberEntries = se_Tags(input.Tags, context);
        if (input.Tags?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DisableRollback != null) {
        entries["DisableRollback"] = input.DisableRollback;
    }
    if (input.ClientRequestToken != null) {
        entries["ClientRequestToken"] = input.ClientRequestToken;
    }
    if (input.RetainExceptOnCreate != null) {
        entries["RetainExceptOnCreate"] = input.RetainExceptOnCreate;
    }
    return entries;
};
const se_UpdateStackInstancesInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.Accounts != null) {
        const memberEntries = se_AccountList(input.Accounts, context);
        if (input.Accounts?.length === 0) {
            entries.Accounts = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Accounts.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DeploymentTargets != null) {
        const memberEntries = se_DeploymentTargets(input.DeploymentTargets, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeploymentTargets.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Regions != null) {
        const memberEntries = se_RegionList(input.Regions, context);
        if (input.Regions?.length === 0) {
            entries.Regions = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Regions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ParameterOverrides != null) {
        const memberEntries = se_Parameters(input.ParameterOverrides, context);
        if (input.ParameterOverrides?.length === 0) {
            entries.ParameterOverrides = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ParameterOverrides.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationPreferences != null) {
        const memberEntries = se_StackSetOperationPreferences(input.OperationPreferences, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperationPreferences.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationId === undefined) {
        input.OperationId = generateIdempotencyToken();
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    return entries;
};
const se_UpdateStackSetInput = (input, context) => {
    const entries = {};
    if (input.StackSetName != null) {
        entries["StackSetName"] = input.StackSetName;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    if (input.UsePreviousTemplate != null) {
        entries["UsePreviousTemplate"] = input.UsePreviousTemplate;
    }
    if (input.Parameters != null) {
        const memberEntries = se_Parameters(input.Parameters, context);
        if (input.Parameters?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Capabilities != null) {
        const memberEntries = se_Capabilities(input.Capabilities, context);
        if (input.Capabilities?.length === 0) {
            entries.Capabilities = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Capabilities.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Tags != null) {
        const memberEntries = se_Tags(input.Tags, context);
        if (input.Tags?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationPreferences != null) {
        const memberEntries = se_StackSetOperationPreferences(input.OperationPreferences, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperationPreferences.${key}`;
            entries[loc] = value;
        });
    }
    if (input.AdministrationRoleARN != null) {
        entries["AdministrationRoleARN"] = input.AdministrationRoleARN;
    }
    if (input.ExecutionRoleName != null) {
        entries["ExecutionRoleName"] = input.ExecutionRoleName;
    }
    if (input.DeploymentTargets != null) {
        const memberEntries = se_DeploymentTargets(input.DeploymentTargets, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeploymentTargets.${key}`;
            entries[loc] = value;
        });
    }
    if (input.PermissionModel != null) {
        entries["PermissionModel"] = input.PermissionModel;
    }
    if (input.AutoDeployment != null) {
        const memberEntries = se_AutoDeployment(input.AutoDeployment, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AutoDeployment.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OperationId === undefined) {
        input.OperationId = generateIdempotencyToken();
    }
    if (input.OperationId != null) {
        entries["OperationId"] = input.OperationId;
    }
    if (input.Accounts != null) {
        const memberEntries = se_AccountList(input.Accounts, context);
        if (input.Accounts?.length === 0) {
            entries.Accounts = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Accounts.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Regions != null) {
        const memberEntries = se_RegionList(input.Regions, context);
        if (input.Regions?.length === 0) {
            entries.Regions = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Regions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.CallAs != null) {
        entries["CallAs"] = input.CallAs;
    }
    if (input.ManagedExecution != null) {
        const memberEntries = se_ManagedExecution(input.ManagedExecution, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ManagedExecution.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_UpdateTerminationProtectionInput = (input, context) => {
    const entries = {};
    if (input.EnableTerminationProtection != null) {
        entries["EnableTerminationProtection"] = input.EnableTerminationProtection;
    }
    if (input.StackName != null) {
        entries["StackName"] = input.StackName;
    }
    return entries;
};
const se_ValidateTemplateInput = (input, context) => {
    const entries = {};
    if (input.TemplateBody != null) {
        entries["TemplateBody"] = input.TemplateBody;
    }
    if (input.TemplateURL != null) {
        entries["TemplateURL"] = input.TemplateURL;
    }
    return entries;
};
const de_AccountGateResult = (output, context) => {
    const contents = {};
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    return contents;
};
const de_AccountLimit = (output, context) => {
    const contents = {};
    if (output["Name"] !== undefined) {
        contents.Name = __expectString(output["Name"]);
    }
    if (output["Value"] !== undefined) {
        contents.Value = __strictParseInt32(output["Value"]);
    }
    return contents;
};
const de_AccountLimitList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AccountLimit(entry, context);
    });
};
const de_AccountList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ActivateOrganizationsAccessOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_ActivateTypeOutput = (output, context) => {
    const contents = {};
    if (output["Arn"] !== undefined) {
        contents.Arn = __expectString(output["Arn"]);
    }
    return contents;
};
const de_AllowedValues = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AlreadyExistsException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_AutoDeployment = (output, context) => {
    const contents = {};
    if (output["Enabled"] !== undefined) {
        contents.Enabled = __parseBoolean(output["Enabled"]);
    }
    if (output["RetainStacksOnAccountRemoval"] !== undefined) {
        contents.RetainStacksOnAccountRemoval = __parseBoolean(output["RetainStacksOnAccountRemoval"]);
    }
    return contents;
};
const de_BatchDescribeTypeConfigurationsError = (output, context) => {
    const contents = {};
    if (output["ErrorCode"] !== undefined) {
        contents.ErrorCode = __expectString(output["ErrorCode"]);
    }
    if (output["ErrorMessage"] !== undefined) {
        contents.ErrorMessage = __expectString(output["ErrorMessage"]);
    }
    if (output["TypeConfigurationIdentifier"] !== undefined) {
        contents.TypeConfigurationIdentifier = de_TypeConfigurationIdentifier(output["TypeConfigurationIdentifier"], context);
    }
    return contents;
};
const de_BatchDescribeTypeConfigurationsErrors = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_BatchDescribeTypeConfigurationsError(entry, context);
    });
};
const de_BatchDescribeTypeConfigurationsOutput = (output, context) => {
    const contents = {};
    if (output.Errors === "") {
        contents.Errors = [];
    }
    else if (output["Errors"] !== undefined && output["Errors"]["member"] !== undefined) {
        contents.Errors = de_BatchDescribeTypeConfigurationsErrors(__getArrayIfSingleItem(output["Errors"]["member"]), context);
    }
    if (output.UnprocessedTypeConfigurations === "") {
        contents.UnprocessedTypeConfigurations = [];
    }
    else if (output["UnprocessedTypeConfigurations"] !== undefined &&
        output["UnprocessedTypeConfigurations"]["member"] !== undefined) {
        contents.UnprocessedTypeConfigurations = de_UnprocessedTypeConfigurations(__getArrayIfSingleItem(output["UnprocessedTypeConfigurations"]["member"]), context);
    }
    if (output.TypeConfigurations === "") {
        contents.TypeConfigurations = [];
    }
    else if (output["TypeConfigurations"] !== undefined && output["TypeConfigurations"]["member"] !== undefined) {
        contents.TypeConfigurations = de_TypeConfigurationDetailsList(__getArrayIfSingleItem(output["TypeConfigurations"]["member"]), context);
    }
    return contents;
};
const de_Capabilities = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_CFNRegistryException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_Change = (output, context) => {
    const contents = {};
    if (output["Type"] !== undefined) {
        contents.Type = __expectString(output["Type"]);
    }
    if (output["HookInvocationCount"] !== undefined) {
        contents.HookInvocationCount = __strictParseInt32(output["HookInvocationCount"]);
    }
    if (output["ResourceChange"] !== undefined) {
        contents.ResourceChange = de_ResourceChange(output["ResourceChange"], context);
    }
    return contents;
};
const de_Changes = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Change(entry, context);
    });
};
const de_ChangeSetHook = (output, context) => {
    const contents = {};
    if (output["InvocationPoint"] !== undefined) {
        contents.InvocationPoint = __expectString(output["InvocationPoint"]);
    }
    if (output["FailureMode"] !== undefined) {
        contents.FailureMode = __expectString(output["FailureMode"]);
    }
    if (output["TypeName"] !== undefined) {
        contents.TypeName = __expectString(output["TypeName"]);
    }
    if (output["TypeVersionId"] !== undefined) {
        contents.TypeVersionId = __expectString(output["TypeVersionId"]);
    }
    if (output["TypeConfigurationVersionId"] !== undefined) {
        contents.TypeConfigurationVersionId = __expectString(output["TypeConfigurationVersionId"]);
    }
    if (output["TargetDetails"] !== undefined) {
        contents.TargetDetails = de_ChangeSetHookTargetDetails(output["TargetDetails"], context);
    }
    return contents;
};
const de_ChangeSetHookResourceTargetDetails = (output, context) => {
    const contents = {};
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["ResourceAction"] !== undefined) {
        contents.ResourceAction = __expectString(output["ResourceAction"]);
    }
    return contents;
};
const de_ChangeSetHooks = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ChangeSetHook(entry, context);
    });
};
const de_ChangeSetHookTargetDetails = (output, context) => {
    const contents = {};
    if (output["TargetType"] !== undefined) {
        contents.TargetType = __expectString(output["TargetType"]);
    }
    if (output["ResourceTargetDetails"] !== undefined) {
        contents.ResourceTargetDetails = de_ChangeSetHookResourceTargetDetails(output["ResourceTargetDetails"], context);
    }
    return contents;
};
const de_ChangeSetNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_ChangeSetSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ChangeSetSummary(entry, context);
    });
};
const de_ChangeSetSummary = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["ChangeSetId"] !== undefined) {
        contents.ChangeSetId = __expectString(output["ChangeSetId"]);
    }
    if (output["ChangeSetName"] !== undefined) {
        contents.ChangeSetName = __expectString(output["ChangeSetName"]);
    }
    if (output["ExecutionStatus"] !== undefined) {
        contents.ExecutionStatus = __expectString(output["ExecutionStatus"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output["CreationTime"] !== undefined) {
        contents.CreationTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["CreationTime"]));
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["IncludeNestedStacks"] !== undefined) {
        contents.IncludeNestedStacks = __parseBoolean(output["IncludeNestedStacks"]);
    }
    if (output["ParentChangeSetId"] !== undefined) {
        contents.ParentChangeSetId = __expectString(output["ParentChangeSetId"]);
    }
    if (output["RootChangeSetId"] !== undefined) {
        contents.RootChangeSetId = __expectString(output["RootChangeSetId"]);
    }
    return contents;
};
const de_ContinueUpdateRollbackOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_CreateChangeSetOutput = (output, context) => {
    const contents = {};
    if (output["Id"] !== undefined) {
        contents.Id = __expectString(output["Id"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    return contents;
};
const de_CreatedButModifiedException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_CreateStackInstancesOutput = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    return contents;
};
const de_CreateStackOutput = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    return contents;
};
const de_CreateStackSetOutput = (output, context) => {
    const contents = {};
    if (output["StackSetId"] !== undefined) {
        contents.StackSetId = __expectString(output["StackSetId"]);
    }
    return contents;
};
const de_DeactivateOrganizationsAccessOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_DeactivateTypeOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_DeleteChangeSetOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_DeleteStackInstancesOutput = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    return contents;
};
const de_DeleteStackSetOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_DeploymentTargets = (output, context) => {
    const contents = {};
    if (output.Accounts === "") {
        contents.Accounts = [];
    }
    else if (output["Accounts"] !== undefined && output["Accounts"]["member"] !== undefined) {
        contents.Accounts = de_AccountList(__getArrayIfSingleItem(output["Accounts"]["member"]), context);
    }
    if (output["AccountsUrl"] !== undefined) {
        contents.AccountsUrl = __expectString(output["AccountsUrl"]);
    }
    if (output.OrganizationalUnitIds === "") {
        contents.OrganizationalUnitIds = [];
    }
    else if (output["OrganizationalUnitIds"] !== undefined && output["OrganizationalUnitIds"]["member"] !== undefined) {
        contents.OrganizationalUnitIds = de_OrganizationalUnitIdList(__getArrayIfSingleItem(output["OrganizationalUnitIds"]["member"]), context);
    }
    if (output["AccountFilterType"] !== undefined) {
        contents.AccountFilterType = __expectString(output["AccountFilterType"]);
    }
    return contents;
};
const de_DeregisterTypeOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_DescribeAccountLimitsOutput = (output, context) => {
    const contents = {};
    if (output.AccountLimits === "") {
        contents.AccountLimits = [];
    }
    else if (output["AccountLimits"] !== undefined && output["AccountLimits"]["member"] !== undefined) {
        contents.AccountLimits = de_AccountLimitList(__getArrayIfSingleItem(output["AccountLimits"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_DescribeChangeSetHooksOutput = (output, context) => {
    const contents = {};
    if (output["ChangeSetId"] !== undefined) {
        contents.ChangeSetId = __expectString(output["ChangeSetId"]);
    }
    if (output["ChangeSetName"] !== undefined) {
        contents.ChangeSetName = __expectString(output["ChangeSetName"]);
    }
    if (output.Hooks === "") {
        contents.Hooks = [];
    }
    else if (output["Hooks"] !== undefined && output["Hooks"]["member"] !== undefined) {
        contents.Hooks = de_ChangeSetHooks(__getArrayIfSingleItem(output["Hooks"]["member"]), context);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    return contents;
};
const de_DescribeChangeSetOutput = (output, context) => {
    const contents = {};
    if (output["ChangeSetName"] !== undefined) {
        contents.ChangeSetName = __expectString(output["ChangeSetName"]);
    }
    if (output["ChangeSetId"] !== undefined) {
        contents.ChangeSetId = __expectString(output["ChangeSetId"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output.Parameters === "") {
        contents.Parameters = [];
    }
    else if (output["Parameters"] !== undefined && output["Parameters"]["member"] !== undefined) {
        contents.Parameters = de_Parameters(__getArrayIfSingleItem(output["Parameters"]["member"]), context);
    }
    if (output["CreationTime"] !== undefined) {
        contents.CreationTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["CreationTime"]));
    }
    if (output["ExecutionStatus"] !== undefined) {
        contents.ExecutionStatus = __expectString(output["ExecutionStatus"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output.NotificationARNs === "") {
        contents.NotificationARNs = [];
    }
    else if (output["NotificationARNs"] !== undefined && output["NotificationARNs"]["member"] !== undefined) {
        contents.NotificationARNs = de_NotificationARNs(__getArrayIfSingleItem(output["NotificationARNs"]["member"]), context);
    }
    if (output["RollbackConfiguration"] !== undefined) {
        contents.RollbackConfiguration = de_RollbackConfiguration(output["RollbackConfiguration"], context);
    }
    if (output.Capabilities === "") {
        contents.Capabilities = [];
    }
    else if (output["Capabilities"] !== undefined && output["Capabilities"]["member"] !== undefined) {
        contents.Capabilities = de_Capabilities(__getArrayIfSingleItem(output["Capabilities"]["member"]), context);
    }
    if (output.Tags === "") {
        contents.Tags = [];
    }
    else if (output["Tags"] !== undefined && output["Tags"]["member"] !== undefined) {
        contents.Tags = de_Tags(__getArrayIfSingleItem(output["Tags"]["member"]), context);
    }
    if (output.Changes === "") {
        contents.Changes = [];
    }
    else if (output["Changes"] !== undefined && output["Changes"]["member"] !== undefined) {
        contents.Changes = de_Changes(__getArrayIfSingleItem(output["Changes"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    if (output["IncludeNestedStacks"] !== undefined) {
        contents.IncludeNestedStacks = __parseBoolean(output["IncludeNestedStacks"]);
    }
    if (output["ParentChangeSetId"] !== undefined) {
        contents.ParentChangeSetId = __expectString(output["ParentChangeSetId"]);
    }
    if (output["RootChangeSetId"] !== undefined) {
        contents.RootChangeSetId = __expectString(output["RootChangeSetId"]);
    }
    if (output["OnStackFailure"] !== undefined) {
        contents.OnStackFailure = __expectString(output["OnStackFailure"]);
    }
    return contents;
};
const de_DescribeOrganizationsAccessOutput = (output, context) => {
    const contents = {};
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    return contents;
};
const de_DescribePublisherOutput = (output, context) => {
    const contents = {};
    if (output["PublisherId"] !== undefined) {
        contents.PublisherId = __expectString(output["PublisherId"]);
    }
    if (output["PublisherStatus"] !== undefined) {
        contents.PublisherStatus = __expectString(output["PublisherStatus"]);
    }
    if (output["IdentityProvider"] !== undefined) {
        contents.IdentityProvider = __expectString(output["IdentityProvider"]);
    }
    if (output["PublisherProfile"] !== undefined) {
        contents.PublisherProfile = __expectString(output["PublisherProfile"]);
    }
    return contents;
};
const de_DescribeStackDriftDetectionStatusOutput = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["StackDriftDetectionId"] !== undefined) {
        contents.StackDriftDetectionId = __expectString(output["StackDriftDetectionId"]);
    }
    if (output["StackDriftStatus"] !== undefined) {
        contents.StackDriftStatus = __expectString(output["StackDriftStatus"]);
    }
    if (output["DetectionStatus"] !== undefined) {
        contents.DetectionStatus = __expectString(output["DetectionStatus"]);
    }
    if (output["DetectionStatusReason"] !== undefined) {
        contents.DetectionStatusReason = __expectString(output["DetectionStatusReason"]);
    }
    if (output["DriftedStackResourceCount"] !== undefined) {
        contents.DriftedStackResourceCount = __strictParseInt32(output["DriftedStackResourceCount"]);
    }
    if (output["Timestamp"] !== undefined) {
        contents.Timestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["Timestamp"]));
    }
    return contents;
};
const de_DescribeStackEventsOutput = (output, context) => {
    const contents = {};
    if (output.StackEvents === "") {
        contents.StackEvents = [];
    }
    else if (output["StackEvents"] !== undefined && output["StackEvents"]["member"] !== undefined) {
        contents.StackEvents = de_StackEvents(__getArrayIfSingleItem(output["StackEvents"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_DescribeStackInstanceOutput = (output, context) => {
    const contents = {};
    if (output["StackInstance"] !== undefined) {
        contents.StackInstance = de_StackInstance(output["StackInstance"], context);
    }
    return contents;
};
const de_DescribeStackResourceDriftsOutput = (output, context) => {
    const contents = {};
    if (output.StackResourceDrifts === "") {
        contents.StackResourceDrifts = [];
    }
    else if (output["StackResourceDrifts"] !== undefined && output["StackResourceDrifts"]["member"] !== undefined) {
        contents.StackResourceDrifts = de_StackResourceDrifts(__getArrayIfSingleItem(output["StackResourceDrifts"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_DescribeStackResourceOutput = (output, context) => {
    const contents = {};
    if (output["StackResourceDetail"] !== undefined) {
        contents.StackResourceDetail = de_StackResourceDetail(output["StackResourceDetail"], context);
    }
    return contents;
};
const de_DescribeStackResourcesOutput = (output, context) => {
    const contents = {};
    if (output.StackResources === "") {
        contents.StackResources = [];
    }
    else if (output["StackResources"] !== undefined && output["StackResources"]["member"] !== undefined) {
        contents.StackResources = de_StackResources(__getArrayIfSingleItem(output["StackResources"]["member"]), context);
    }
    return contents;
};
const de_DescribeStackSetOperationOutput = (output, context) => {
    const contents = {};
    if (output["StackSetOperation"] !== undefined) {
        contents.StackSetOperation = de_StackSetOperation(output["StackSetOperation"], context);
    }
    return contents;
};
const de_DescribeStackSetOutput = (output, context) => {
    const contents = {};
    if (output["StackSet"] !== undefined) {
        contents.StackSet = de_StackSet(output["StackSet"], context);
    }
    return contents;
};
const de_DescribeStacksOutput = (output, context) => {
    const contents = {};
    if (output.Stacks === "") {
        contents.Stacks = [];
    }
    else if (output["Stacks"] !== undefined && output["Stacks"]["member"] !== undefined) {
        contents.Stacks = de_Stacks(__getArrayIfSingleItem(output["Stacks"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_DescribeTypeOutput = (output, context) => {
    const contents = {};
    if (output["Arn"] !== undefined) {
        contents.Arn = __expectString(output["Arn"]);
    }
    if (output["Type"] !== undefined) {
        contents.Type = __expectString(output["Type"]);
    }
    if (output["TypeName"] !== undefined) {
        contents.TypeName = __expectString(output["TypeName"]);
    }
    if (output["DefaultVersionId"] !== undefined) {
        contents.DefaultVersionId = __expectString(output["DefaultVersionId"]);
    }
    if (output["IsDefaultVersion"] !== undefined) {
        contents.IsDefaultVersion = __parseBoolean(output["IsDefaultVersion"]);
    }
    if (output["TypeTestsStatus"] !== undefined) {
        contents.TypeTestsStatus = __expectString(output["TypeTestsStatus"]);
    }
    if (output["TypeTestsStatusDescription"] !== undefined) {
        contents.TypeTestsStatusDescription = __expectString(output["TypeTestsStatusDescription"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["Schema"] !== undefined) {
        contents.Schema = __expectString(output["Schema"]);
    }
    if (output["ProvisioningType"] !== undefined) {
        contents.ProvisioningType = __expectString(output["ProvisioningType"]);
    }
    if (output["DeprecatedStatus"] !== undefined) {
        contents.DeprecatedStatus = __expectString(output["DeprecatedStatus"]);
    }
    if (output["LoggingConfig"] !== undefined) {
        contents.LoggingConfig = de_LoggingConfig(output["LoggingConfig"], context);
    }
    if (output.RequiredActivatedTypes === "") {
        contents.RequiredActivatedTypes = [];
    }
    else if (output["RequiredActivatedTypes"] !== undefined &&
        output["RequiredActivatedTypes"]["member"] !== undefined) {
        contents.RequiredActivatedTypes = de_RequiredActivatedTypes(__getArrayIfSingleItem(output["RequiredActivatedTypes"]["member"]), context);
    }
    if (output["ExecutionRoleArn"] !== undefined) {
        contents.ExecutionRoleArn = __expectString(output["ExecutionRoleArn"]);
    }
    if (output["Visibility"] !== undefined) {
        contents.Visibility = __expectString(output["Visibility"]);
    }
    if (output["SourceUrl"] !== undefined) {
        contents.SourceUrl = __expectString(output["SourceUrl"]);
    }
    if (output["DocumentationUrl"] !== undefined) {
        contents.DocumentationUrl = __expectString(output["DocumentationUrl"]);
    }
    if (output["LastUpdated"] !== undefined) {
        contents.LastUpdated = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdated"]));
    }
    if (output["TimeCreated"] !== undefined) {
        contents.TimeCreated = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["TimeCreated"]));
    }
    if (output["ConfigurationSchema"] !== undefined) {
        contents.ConfigurationSchema = __expectString(output["ConfigurationSchema"]);
    }
    if (output["PublisherId"] !== undefined) {
        contents.PublisherId = __expectString(output["PublisherId"]);
    }
    if (output["OriginalTypeName"] !== undefined) {
        contents.OriginalTypeName = __expectString(output["OriginalTypeName"]);
    }
    if (output["OriginalTypeArn"] !== undefined) {
        contents.OriginalTypeArn = __expectString(output["OriginalTypeArn"]);
    }
    if (output["PublicVersionNumber"] !== undefined) {
        contents.PublicVersionNumber = __expectString(output["PublicVersionNumber"]);
    }
    if (output["LatestPublicVersion"] !== undefined) {
        contents.LatestPublicVersion = __expectString(output["LatestPublicVersion"]);
    }
    if (output["IsActivated"] !== undefined) {
        contents.IsActivated = __parseBoolean(output["IsActivated"]);
    }
    if (output["AutoUpdate"] !== undefined) {
        contents.AutoUpdate = __parseBoolean(output["AutoUpdate"]);
    }
    return contents;
};
const de_DescribeTypeRegistrationOutput = (output, context) => {
    const contents = {};
    if (output["ProgressStatus"] !== undefined) {
        contents.ProgressStatus = __expectString(output["ProgressStatus"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["TypeArn"] !== undefined) {
        contents.TypeArn = __expectString(output["TypeArn"]);
    }
    if (output["TypeVersionArn"] !== undefined) {
        contents.TypeVersionArn = __expectString(output["TypeVersionArn"]);
    }
    return contents;
};
const de_DetectStackDriftOutput = (output, context) => {
    const contents = {};
    if (output["StackDriftDetectionId"] !== undefined) {
        contents.StackDriftDetectionId = __expectString(output["StackDriftDetectionId"]);
    }
    return contents;
};
const de_DetectStackResourceDriftOutput = (output, context) => {
    const contents = {};
    if (output["StackResourceDrift"] !== undefined) {
        contents.StackResourceDrift = de_StackResourceDrift(output["StackResourceDrift"], context);
    }
    return contents;
};
const de_DetectStackSetDriftOutput = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    return contents;
};
const de_EstimateTemplateCostOutput = (output, context) => {
    const contents = {};
    if (output["Url"] !== undefined) {
        contents.Url = __expectString(output["Url"]);
    }
    return contents;
};
const de_ExecuteChangeSetOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_Export = (output, context) => {
    const contents = {};
    if (output["ExportingStackId"] !== undefined) {
        contents.ExportingStackId = __expectString(output["ExportingStackId"]);
    }
    if (output["Name"] !== undefined) {
        contents.Name = __expectString(output["Name"]);
    }
    if (output["Value"] !== undefined) {
        contents.Value = __expectString(output["Value"]);
    }
    return contents;
};
const de_Exports = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Export(entry, context);
    });
};
const de_GetStackPolicyOutput = (output, context) => {
    const contents = {};
    if (output["StackPolicyBody"] !== undefined) {
        contents.StackPolicyBody = __expectString(output["StackPolicyBody"]);
    }
    return contents;
};
const de_GetTemplateOutput = (output, context) => {
    const contents = {};
    if (output["TemplateBody"] !== undefined) {
        contents.TemplateBody = __expectString(output["TemplateBody"]);
    }
    if (output.StagesAvailable === "") {
        contents.StagesAvailable = [];
    }
    else if (output["StagesAvailable"] !== undefined && output["StagesAvailable"]["member"] !== undefined) {
        contents.StagesAvailable = de_StageList(__getArrayIfSingleItem(output["StagesAvailable"]["member"]), context);
    }
    return contents;
};
const de_GetTemplateSummaryOutput = (output, context) => {
    const contents = {};
    if (output.Parameters === "") {
        contents.Parameters = [];
    }
    else if (output["Parameters"] !== undefined && output["Parameters"]["member"] !== undefined) {
        contents.Parameters = de_ParameterDeclarations(__getArrayIfSingleItem(output["Parameters"]["member"]), context);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output.Capabilities === "") {
        contents.Capabilities = [];
    }
    else if (output["Capabilities"] !== undefined && output["Capabilities"]["member"] !== undefined) {
        contents.Capabilities = de_Capabilities(__getArrayIfSingleItem(output["Capabilities"]["member"]), context);
    }
    if (output["CapabilitiesReason"] !== undefined) {
        contents.CapabilitiesReason = __expectString(output["CapabilitiesReason"]);
    }
    if (output.ResourceTypes === "") {
        contents.ResourceTypes = [];
    }
    else if (output["ResourceTypes"] !== undefined && output["ResourceTypes"]["member"] !== undefined) {
        contents.ResourceTypes = de_ResourceTypes(__getArrayIfSingleItem(output["ResourceTypes"]["member"]), context);
    }
    if (output["Version"] !== undefined) {
        contents.Version = __expectString(output["Version"]);
    }
    if (output["Metadata"] !== undefined) {
        contents.Metadata = __expectString(output["Metadata"]);
    }
    if (output.DeclaredTransforms === "") {
        contents.DeclaredTransforms = [];
    }
    else if (output["DeclaredTransforms"] !== undefined && output["DeclaredTransforms"]["member"] !== undefined) {
        contents.DeclaredTransforms = de_TransformsList(__getArrayIfSingleItem(output["DeclaredTransforms"]["member"]), context);
    }
    if (output.ResourceIdentifierSummaries === "") {
        contents.ResourceIdentifierSummaries = [];
    }
    else if (output["ResourceIdentifierSummaries"] !== undefined &&
        output["ResourceIdentifierSummaries"]["member"] !== undefined) {
        contents.ResourceIdentifierSummaries = de_ResourceIdentifierSummaries(__getArrayIfSingleItem(output["ResourceIdentifierSummaries"]["member"]), context);
    }
    if (output["Warnings"] !== undefined) {
        contents.Warnings = de_Warnings(output["Warnings"], context);
    }
    return contents;
};
const de_Imports = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ImportStacksToStackSetOutput = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    return contents;
};
const de_InsufficientCapabilitiesException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_InvalidChangeSetStatusException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_InvalidOperationException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_InvalidStateTransitionException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_LimitExceededException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_ListChangeSetsOutput = (output, context) => {
    const contents = {};
    if (output.Summaries === "") {
        contents.Summaries = [];
    }
    else if (output["Summaries"] !== undefined && output["Summaries"]["member"] !== undefined) {
        contents.Summaries = de_ChangeSetSummaries(__getArrayIfSingleItem(output["Summaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListExportsOutput = (output, context) => {
    const contents = {};
    if (output.Exports === "") {
        contents.Exports = [];
    }
    else if (output["Exports"] !== undefined && output["Exports"]["member"] !== undefined) {
        contents.Exports = de_Exports(__getArrayIfSingleItem(output["Exports"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListImportsOutput = (output, context) => {
    const contents = {};
    if (output.Imports === "") {
        contents.Imports = [];
    }
    else if (output["Imports"] !== undefined && output["Imports"]["member"] !== undefined) {
        contents.Imports = de_Imports(__getArrayIfSingleItem(output["Imports"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStackInstanceResourceDriftsOutput = (output, context) => {
    const contents = {};
    if (output.Summaries === "") {
        contents.Summaries = [];
    }
    else if (output["Summaries"] !== undefined && output["Summaries"]["member"] !== undefined) {
        contents.Summaries = de_StackInstanceResourceDriftsSummaries(__getArrayIfSingleItem(output["Summaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStackInstancesOutput = (output, context) => {
    const contents = {};
    if (output.Summaries === "") {
        contents.Summaries = [];
    }
    else if (output["Summaries"] !== undefined && output["Summaries"]["member"] !== undefined) {
        contents.Summaries = de_StackInstanceSummaries(__getArrayIfSingleItem(output["Summaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStackResourcesOutput = (output, context) => {
    const contents = {};
    if (output.StackResourceSummaries === "") {
        contents.StackResourceSummaries = [];
    }
    else if (output["StackResourceSummaries"] !== undefined &&
        output["StackResourceSummaries"]["member"] !== undefined) {
        contents.StackResourceSummaries = de_StackResourceSummaries(__getArrayIfSingleItem(output["StackResourceSummaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStackSetOperationResultsOutput = (output, context) => {
    const contents = {};
    if (output.Summaries === "") {
        contents.Summaries = [];
    }
    else if (output["Summaries"] !== undefined && output["Summaries"]["member"] !== undefined) {
        contents.Summaries = de_StackSetOperationResultSummaries(__getArrayIfSingleItem(output["Summaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStackSetOperationsOutput = (output, context) => {
    const contents = {};
    if (output.Summaries === "") {
        contents.Summaries = [];
    }
    else if (output["Summaries"] !== undefined && output["Summaries"]["member"] !== undefined) {
        contents.Summaries = de_StackSetOperationSummaries(__getArrayIfSingleItem(output["Summaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStackSetsOutput = (output, context) => {
    const contents = {};
    if (output.Summaries === "") {
        contents.Summaries = [];
    }
    else if (output["Summaries"] !== undefined && output["Summaries"]["member"] !== undefined) {
        contents.Summaries = de_StackSetSummaries(__getArrayIfSingleItem(output["Summaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListStacksOutput = (output, context) => {
    const contents = {};
    if (output.StackSummaries === "") {
        contents.StackSummaries = [];
    }
    else if (output["StackSummaries"] !== undefined && output["StackSummaries"]["member"] !== undefined) {
        contents.StackSummaries = de_StackSummaries(__getArrayIfSingleItem(output["StackSummaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListTypeRegistrationsOutput = (output, context) => {
    const contents = {};
    if (output.RegistrationTokenList === "") {
        contents.RegistrationTokenList = [];
    }
    else if (output["RegistrationTokenList"] !== undefined && output["RegistrationTokenList"]["member"] !== undefined) {
        contents.RegistrationTokenList = de_RegistrationTokenList(__getArrayIfSingleItem(output["RegistrationTokenList"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListTypesOutput = (output, context) => {
    const contents = {};
    if (output.TypeSummaries === "") {
        contents.TypeSummaries = [];
    }
    else if (output["TypeSummaries"] !== undefined && output["TypeSummaries"]["member"] !== undefined) {
        contents.TypeSummaries = de_TypeSummaries(__getArrayIfSingleItem(output["TypeSummaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_ListTypeVersionsOutput = (output, context) => {
    const contents = {};
    if (output.TypeVersionSummaries === "") {
        contents.TypeVersionSummaries = [];
    }
    else if (output["TypeVersionSummaries"] !== undefined && output["TypeVersionSummaries"]["member"] !== undefined) {
        contents.TypeVersionSummaries = de_TypeVersionSummaries(__getArrayIfSingleItem(output["TypeVersionSummaries"]["member"]), context);
    }
    if (output["NextToken"] !== undefined) {
        contents.NextToken = __expectString(output["NextToken"]);
    }
    return contents;
};
const de_LoggingConfig = (output, context) => {
    const contents = {};
    if (output["LogRoleArn"] !== undefined) {
        contents.LogRoleArn = __expectString(output["LogRoleArn"]);
    }
    if (output["LogGroupName"] !== undefined) {
        contents.LogGroupName = __expectString(output["LogGroupName"]);
    }
    return contents;
};
const de_LogicalResourceIds = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ManagedExecution = (output, context) => {
    const contents = {};
    if (output["Active"] !== undefined) {
        contents.Active = __parseBoolean(output["Active"]);
    }
    return contents;
};
const de_ModuleInfo = (output, context) => {
    const contents = {};
    if (output["TypeHierarchy"] !== undefined) {
        contents.TypeHierarchy = __expectString(output["TypeHierarchy"]);
    }
    if (output["LogicalIdHierarchy"] !== undefined) {
        contents.LogicalIdHierarchy = __expectString(output["LogicalIdHierarchy"]);
    }
    return contents;
};
const de_NameAlreadyExistsException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_NotificationARNs = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_OperationIdAlreadyExistsException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_OperationInProgressException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_OperationNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_OperationStatusCheckFailedException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_OrganizationalUnitIdList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_Output = (output, context) => {
    const contents = {};
    if (output["OutputKey"] !== undefined) {
        contents.OutputKey = __expectString(output["OutputKey"]);
    }
    if (output["OutputValue"] !== undefined) {
        contents.OutputValue = __expectString(output["OutputValue"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["ExportName"] !== undefined) {
        contents.ExportName = __expectString(output["ExportName"]);
    }
    return contents;
};
const de_Outputs = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Output(entry, context);
    });
};
const de_Parameter = (output, context) => {
    const contents = {};
    if (output["ParameterKey"] !== undefined) {
        contents.ParameterKey = __expectString(output["ParameterKey"]);
    }
    if (output["ParameterValue"] !== undefined) {
        contents.ParameterValue = __expectString(output["ParameterValue"]);
    }
    if (output["UsePreviousValue"] !== undefined) {
        contents.UsePreviousValue = __parseBoolean(output["UsePreviousValue"]);
    }
    if (output["ResolvedValue"] !== undefined) {
        contents.ResolvedValue = __expectString(output["ResolvedValue"]);
    }
    return contents;
};
const de_ParameterConstraints = (output, context) => {
    const contents = {};
    if (output.AllowedValues === "") {
        contents.AllowedValues = [];
    }
    else if (output["AllowedValues"] !== undefined && output["AllowedValues"]["member"] !== undefined) {
        contents.AllowedValues = de_AllowedValues(__getArrayIfSingleItem(output["AllowedValues"]["member"]), context);
    }
    return contents;
};
const de_ParameterDeclaration = (output, context) => {
    const contents = {};
    if (output["ParameterKey"] !== undefined) {
        contents.ParameterKey = __expectString(output["ParameterKey"]);
    }
    if (output["DefaultValue"] !== undefined) {
        contents.DefaultValue = __expectString(output["DefaultValue"]);
    }
    if (output["ParameterType"] !== undefined) {
        contents.ParameterType = __expectString(output["ParameterType"]);
    }
    if (output["NoEcho"] !== undefined) {
        contents.NoEcho = __parseBoolean(output["NoEcho"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["ParameterConstraints"] !== undefined) {
        contents.ParameterConstraints = de_ParameterConstraints(output["ParameterConstraints"], context);
    }
    return contents;
};
const de_ParameterDeclarations = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ParameterDeclaration(entry, context);
    });
};
const de_Parameters = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Parameter(entry, context);
    });
};
const de_PhysicalResourceIdContext = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PhysicalResourceIdContextKeyValuePair(entry, context);
    });
};
const de_PhysicalResourceIdContextKeyValuePair = (output, context) => {
    const contents = {};
    if (output["Key"] !== undefined) {
        contents.Key = __expectString(output["Key"]);
    }
    if (output["Value"] !== undefined) {
        contents.Value = __expectString(output["Value"]);
    }
    return contents;
};
const de_PropertyDifference = (output, context) => {
    const contents = {};
    if (output["PropertyPath"] !== undefined) {
        contents.PropertyPath = __expectString(output["PropertyPath"]);
    }
    if (output["ExpectedValue"] !== undefined) {
        contents.ExpectedValue = __expectString(output["ExpectedValue"]);
    }
    if (output["ActualValue"] !== undefined) {
        contents.ActualValue = __expectString(output["ActualValue"]);
    }
    if (output["DifferenceType"] !== undefined) {
        contents.DifferenceType = __expectString(output["DifferenceType"]);
    }
    return contents;
};
const de_PropertyDifferences = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PropertyDifference(entry, context);
    });
};
const de_PublishTypeOutput = (output, context) => {
    const contents = {};
    if (output["PublicTypeArn"] !== undefined) {
        contents.PublicTypeArn = __expectString(output["PublicTypeArn"]);
    }
    return contents;
};
const de_RecordHandlerProgressOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_RegionList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_RegisterPublisherOutput = (output, context) => {
    const contents = {};
    if (output["PublisherId"] !== undefined) {
        contents.PublisherId = __expectString(output["PublisherId"]);
    }
    return contents;
};
const de_RegisterTypeOutput = (output, context) => {
    const contents = {};
    if (output["RegistrationToken"] !== undefined) {
        contents.RegistrationToken = __expectString(output["RegistrationToken"]);
    }
    return contents;
};
const de_RegistrationTokenList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_RequiredActivatedType = (output, context) => {
    const contents = {};
    if (output["TypeNameAlias"] !== undefined) {
        contents.TypeNameAlias = __expectString(output["TypeNameAlias"]);
    }
    if (output["OriginalTypeName"] !== undefined) {
        contents.OriginalTypeName = __expectString(output["OriginalTypeName"]);
    }
    if (output["PublisherId"] !== undefined) {
        contents.PublisherId = __expectString(output["PublisherId"]);
    }
    if (output.SupportedMajorVersions === "") {
        contents.SupportedMajorVersions = [];
    }
    else if (output["SupportedMajorVersions"] !== undefined &&
        output["SupportedMajorVersions"]["member"] !== undefined) {
        contents.SupportedMajorVersions = de_SupportedMajorVersions(__getArrayIfSingleItem(output["SupportedMajorVersions"]["member"]), context);
    }
    return contents;
};
const de_RequiredActivatedTypes = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RequiredActivatedType(entry, context);
    });
};
const de_ResourceChange = (output, context) => {
    const contents = {};
    if (output["Action"] !== undefined) {
        contents.Action = __expectString(output["Action"]);
    }
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["Replacement"] !== undefined) {
        contents.Replacement = __expectString(output["Replacement"]);
    }
    if (output.Scope === "") {
        contents.Scope = [];
    }
    else if (output["Scope"] !== undefined && output["Scope"]["member"] !== undefined) {
        contents.Scope = de_Scope(__getArrayIfSingleItem(output["Scope"]["member"]), context);
    }
    if (output.Details === "") {
        contents.Details = [];
    }
    else if (output["Details"] !== undefined && output["Details"]["member"] !== undefined) {
        contents.Details = de_ResourceChangeDetails(__getArrayIfSingleItem(output["Details"]["member"]), context);
    }
    if (output["ChangeSetId"] !== undefined) {
        contents.ChangeSetId = __expectString(output["ChangeSetId"]);
    }
    if (output["ModuleInfo"] !== undefined) {
        contents.ModuleInfo = de_ModuleInfo(output["ModuleInfo"], context);
    }
    return contents;
};
const de_ResourceChangeDetail = (output, context) => {
    const contents = {};
    if (output["Target"] !== undefined) {
        contents.Target = de_ResourceTargetDefinition(output["Target"], context);
    }
    if (output["Evaluation"] !== undefined) {
        contents.Evaluation = __expectString(output["Evaluation"]);
    }
    if (output["ChangeSource"] !== undefined) {
        contents.ChangeSource = __expectString(output["ChangeSource"]);
    }
    if (output["CausingEntity"] !== undefined) {
        contents.CausingEntity = __expectString(output["CausingEntity"]);
    }
    return contents;
};
const de_ResourceChangeDetails = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ResourceChangeDetail(entry, context);
    });
};
const de_ResourceIdentifiers = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ResourceIdentifierSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ResourceIdentifierSummary(entry, context);
    });
};
const de_ResourceIdentifierSummary = (output, context) => {
    const contents = {};
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output.LogicalResourceIds === "") {
        contents.LogicalResourceIds = [];
    }
    else if (output["LogicalResourceIds"] !== undefined && output["LogicalResourceIds"]["member"] !== undefined) {
        contents.LogicalResourceIds = de_LogicalResourceIds(__getArrayIfSingleItem(output["LogicalResourceIds"]["member"]), context);
    }
    if (output.ResourceIdentifiers === "") {
        contents.ResourceIdentifiers = [];
    }
    else if (output["ResourceIdentifiers"] !== undefined && output["ResourceIdentifiers"]["member"] !== undefined) {
        contents.ResourceIdentifiers = de_ResourceIdentifiers(__getArrayIfSingleItem(output["ResourceIdentifiers"]["member"]), context);
    }
    return contents;
};
const de_ResourceTargetDefinition = (output, context) => {
    const contents = {};
    if (output["Attribute"] !== undefined) {
        contents.Attribute = __expectString(output["Attribute"]);
    }
    if (output["Name"] !== undefined) {
        contents.Name = __expectString(output["Name"]);
    }
    if (output["RequiresRecreation"] !== undefined) {
        contents.RequiresRecreation = __expectString(output["RequiresRecreation"]);
    }
    return contents;
};
const de_ResourceTypes = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_RollbackConfiguration = (output, context) => {
    const contents = {};
    if (output.RollbackTriggers === "") {
        contents.RollbackTriggers = [];
    }
    else if (output["RollbackTriggers"] !== undefined && output["RollbackTriggers"]["member"] !== undefined) {
        contents.RollbackTriggers = de_RollbackTriggers(__getArrayIfSingleItem(output["RollbackTriggers"]["member"]), context);
    }
    if (output["MonitoringTimeInMinutes"] !== undefined) {
        contents.MonitoringTimeInMinutes = __strictParseInt32(output["MonitoringTimeInMinutes"]);
    }
    return contents;
};
const de_RollbackStackOutput = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    return contents;
};
const de_RollbackTrigger = (output, context) => {
    const contents = {};
    if (output["Arn"] !== undefined) {
        contents.Arn = __expectString(output["Arn"]);
    }
    if (output["Type"] !== undefined) {
        contents.Type = __expectString(output["Type"]);
    }
    return contents;
};
const de_RollbackTriggers = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RollbackTrigger(entry, context);
    });
};
const de_Scope = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_SetTypeConfigurationOutput = (output, context) => {
    const contents = {};
    if (output["ConfigurationArn"] !== undefined) {
        contents.ConfigurationArn = __expectString(output["ConfigurationArn"]);
    }
    return contents;
};
const de_SetTypeDefaultVersionOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_Stack = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["ChangeSetId"] !== undefined) {
        contents.ChangeSetId = __expectString(output["ChangeSetId"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output.Parameters === "") {
        contents.Parameters = [];
    }
    else if (output["Parameters"] !== undefined && output["Parameters"]["member"] !== undefined) {
        contents.Parameters = de_Parameters(__getArrayIfSingleItem(output["Parameters"]["member"]), context);
    }
    if (output["CreationTime"] !== undefined) {
        contents.CreationTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["CreationTime"]));
    }
    if (output["DeletionTime"] !== undefined) {
        contents.DeletionTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["DeletionTime"]));
    }
    if (output["LastUpdatedTime"] !== undefined) {
        contents.LastUpdatedTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdatedTime"]));
    }
    if (output["RollbackConfiguration"] !== undefined) {
        contents.RollbackConfiguration = de_RollbackConfiguration(output["RollbackConfiguration"], context);
    }
    if (output["StackStatus"] !== undefined) {
        contents.StackStatus = __expectString(output["StackStatus"]);
    }
    if (output["StackStatusReason"] !== undefined) {
        contents.StackStatusReason = __expectString(output["StackStatusReason"]);
    }
    if (output["DisableRollback"] !== undefined) {
        contents.DisableRollback = __parseBoolean(output["DisableRollback"]);
    }
    if (output.NotificationARNs === "") {
        contents.NotificationARNs = [];
    }
    else if (output["NotificationARNs"] !== undefined && output["NotificationARNs"]["member"] !== undefined) {
        contents.NotificationARNs = de_NotificationARNs(__getArrayIfSingleItem(output["NotificationARNs"]["member"]), context);
    }
    if (output["TimeoutInMinutes"] !== undefined) {
        contents.TimeoutInMinutes = __strictParseInt32(output["TimeoutInMinutes"]);
    }
    if (output.Capabilities === "") {
        contents.Capabilities = [];
    }
    else if (output["Capabilities"] !== undefined && output["Capabilities"]["member"] !== undefined) {
        contents.Capabilities = de_Capabilities(__getArrayIfSingleItem(output["Capabilities"]["member"]), context);
    }
    if (output.Outputs === "") {
        contents.Outputs = [];
    }
    else if (output["Outputs"] !== undefined && output["Outputs"]["member"] !== undefined) {
        contents.Outputs = de_Outputs(__getArrayIfSingleItem(output["Outputs"]["member"]), context);
    }
    if (output["RoleARN"] !== undefined) {
        contents.RoleARN = __expectString(output["RoleARN"]);
    }
    if (output.Tags === "") {
        contents.Tags = [];
    }
    else if (output["Tags"] !== undefined && output["Tags"]["member"] !== undefined) {
        contents.Tags = de_Tags(__getArrayIfSingleItem(output["Tags"]["member"]), context);
    }
    if (output["EnableTerminationProtection"] !== undefined) {
        contents.EnableTerminationProtection = __parseBoolean(output["EnableTerminationProtection"]);
    }
    if (output["ParentId"] !== undefined) {
        contents.ParentId = __expectString(output["ParentId"]);
    }
    if (output["RootId"] !== undefined) {
        contents.RootId = __expectString(output["RootId"]);
    }
    if (output["DriftInformation"] !== undefined) {
        contents.DriftInformation = de_StackDriftInformation(output["DriftInformation"], context);
    }
    if (output["RetainExceptOnCreate"] !== undefined) {
        contents.RetainExceptOnCreate = __parseBoolean(output["RetainExceptOnCreate"]);
    }
    return contents;
};
const de_StackDriftInformation = (output, context) => {
    const contents = {};
    if (output["StackDriftStatus"] !== undefined) {
        contents.StackDriftStatus = __expectString(output["StackDriftStatus"]);
    }
    if (output["LastCheckTimestamp"] !== undefined) {
        contents.LastCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastCheckTimestamp"]));
    }
    return contents;
};
const de_StackDriftInformationSummary = (output, context) => {
    const contents = {};
    if (output["StackDriftStatus"] !== undefined) {
        contents.StackDriftStatus = __expectString(output["StackDriftStatus"]);
    }
    if (output["LastCheckTimestamp"] !== undefined) {
        contents.LastCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastCheckTimestamp"]));
    }
    return contents;
};
const de_StackEvent = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["EventId"] !== undefined) {
        contents.EventId = __expectString(output["EventId"]);
    }
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["Timestamp"] !== undefined) {
        contents.Timestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["Timestamp"]));
    }
    if (output["ResourceStatus"] !== undefined) {
        contents.ResourceStatus = __expectString(output["ResourceStatus"]);
    }
    if (output["ResourceStatusReason"] !== undefined) {
        contents.ResourceStatusReason = __expectString(output["ResourceStatusReason"]);
    }
    if (output["ResourceProperties"] !== undefined) {
        contents.ResourceProperties = __expectString(output["ResourceProperties"]);
    }
    if (output["ClientRequestToken"] !== undefined) {
        contents.ClientRequestToken = __expectString(output["ClientRequestToken"]);
    }
    if (output["HookType"] !== undefined) {
        contents.HookType = __expectString(output["HookType"]);
    }
    if (output["HookStatus"] !== undefined) {
        contents.HookStatus = __expectString(output["HookStatus"]);
    }
    if (output["HookStatusReason"] !== undefined) {
        contents.HookStatusReason = __expectString(output["HookStatusReason"]);
    }
    if (output["HookInvocationPoint"] !== undefined) {
        contents.HookInvocationPoint = __expectString(output["HookInvocationPoint"]);
    }
    if (output["HookFailureMode"] !== undefined) {
        contents.HookFailureMode = __expectString(output["HookFailureMode"]);
    }
    return contents;
};
const de_StackEvents = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackEvent(entry, context);
    });
};
const de_StackInstance = (output, context) => {
    const contents = {};
    if (output["StackSetId"] !== undefined) {
        contents.StackSetId = __expectString(output["StackSetId"]);
    }
    if (output["Region"] !== undefined) {
        contents.Region = __expectString(output["Region"]);
    }
    if (output["Account"] !== undefined) {
        contents.Account = __expectString(output["Account"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output.ParameterOverrides === "") {
        contents.ParameterOverrides = [];
    }
    else if (output["ParameterOverrides"] !== undefined && output["ParameterOverrides"]["member"] !== undefined) {
        contents.ParameterOverrides = de_Parameters(__getArrayIfSingleItem(output["ParameterOverrides"]["member"]), context);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["StackInstanceStatus"] !== undefined) {
        contents.StackInstanceStatus = de_StackInstanceComprehensiveStatus(output["StackInstanceStatus"], context);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output["OrganizationalUnitId"] !== undefined) {
        contents.OrganizationalUnitId = __expectString(output["OrganizationalUnitId"]);
    }
    if (output["DriftStatus"] !== undefined) {
        contents.DriftStatus = __expectString(output["DriftStatus"]);
    }
    if (output["LastDriftCheckTimestamp"] !== undefined) {
        contents.LastDriftCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastDriftCheckTimestamp"]));
    }
    if (output["LastOperationId"] !== undefined) {
        contents.LastOperationId = __expectString(output["LastOperationId"]);
    }
    return contents;
};
const de_StackInstanceComprehensiveStatus = (output, context) => {
    const contents = {};
    if (output["DetailedStatus"] !== undefined) {
        contents.DetailedStatus = __expectString(output["DetailedStatus"]);
    }
    return contents;
};
const de_StackInstanceNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_StackInstanceResourceDriftsSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackInstanceResourceDriftsSummary(entry, context);
    });
};
const de_StackInstanceResourceDriftsSummary = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output.PhysicalResourceIdContext === "") {
        contents.PhysicalResourceIdContext = [];
    }
    else if (output["PhysicalResourceIdContext"] !== undefined &&
        output["PhysicalResourceIdContext"]["member"] !== undefined) {
        contents.PhysicalResourceIdContext = de_PhysicalResourceIdContext(__getArrayIfSingleItem(output["PhysicalResourceIdContext"]["member"]), context);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output.PropertyDifferences === "") {
        contents.PropertyDifferences = [];
    }
    else if (output["PropertyDifferences"] !== undefined && output["PropertyDifferences"]["member"] !== undefined) {
        contents.PropertyDifferences = de_PropertyDifferences(__getArrayIfSingleItem(output["PropertyDifferences"]["member"]), context);
    }
    if (output["StackResourceDriftStatus"] !== undefined) {
        contents.StackResourceDriftStatus = __expectString(output["StackResourceDriftStatus"]);
    }
    if (output["Timestamp"] !== undefined) {
        contents.Timestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["Timestamp"]));
    }
    return contents;
};
const de_StackInstanceSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackInstanceSummary(entry, context);
    });
};
const de_StackInstanceSummary = (output, context) => {
    const contents = {};
    if (output["StackSetId"] !== undefined) {
        contents.StackSetId = __expectString(output["StackSetId"]);
    }
    if (output["Region"] !== undefined) {
        contents.Region = __expectString(output["Region"]);
    }
    if (output["Account"] !== undefined) {
        contents.Account = __expectString(output["Account"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output["StackInstanceStatus"] !== undefined) {
        contents.StackInstanceStatus = de_StackInstanceComprehensiveStatus(output["StackInstanceStatus"], context);
    }
    if (output["OrganizationalUnitId"] !== undefined) {
        contents.OrganizationalUnitId = __expectString(output["OrganizationalUnitId"]);
    }
    if (output["DriftStatus"] !== undefined) {
        contents.DriftStatus = __expectString(output["DriftStatus"]);
    }
    if (output["LastDriftCheckTimestamp"] !== undefined) {
        contents.LastDriftCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastDriftCheckTimestamp"]));
    }
    if (output["LastOperationId"] !== undefined) {
        contents.LastOperationId = __expectString(output["LastOperationId"]);
    }
    return contents;
};
const de_StackNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_StackResource = (output, context) => {
    const contents = {};
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["Timestamp"] !== undefined) {
        contents.Timestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["Timestamp"]));
    }
    if (output["ResourceStatus"] !== undefined) {
        contents.ResourceStatus = __expectString(output["ResourceStatus"]);
    }
    if (output["ResourceStatusReason"] !== undefined) {
        contents.ResourceStatusReason = __expectString(output["ResourceStatusReason"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["DriftInformation"] !== undefined) {
        contents.DriftInformation = de_StackResourceDriftInformation(output["DriftInformation"], context);
    }
    if (output["ModuleInfo"] !== undefined) {
        contents.ModuleInfo = de_ModuleInfo(output["ModuleInfo"], context);
    }
    return contents;
};
const de_StackResourceDetail = (output, context) => {
    const contents = {};
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["LastUpdatedTimestamp"] !== undefined) {
        contents.LastUpdatedTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdatedTimestamp"]));
    }
    if (output["ResourceStatus"] !== undefined) {
        contents.ResourceStatus = __expectString(output["ResourceStatus"]);
    }
    if (output["ResourceStatusReason"] !== undefined) {
        contents.ResourceStatusReason = __expectString(output["ResourceStatusReason"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["Metadata"] !== undefined) {
        contents.Metadata = __expectString(output["Metadata"]);
    }
    if (output["DriftInformation"] !== undefined) {
        contents.DriftInformation = de_StackResourceDriftInformation(output["DriftInformation"], context);
    }
    if (output["ModuleInfo"] !== undefined) {
        contents.ModuleInfo = de_ModuleInfo(output["ModuleInfo"], context);
    }
    return contents;
};
const de_StackResourceDrift = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output.PhysicalResourceIdContext === "") {
        contents.PhysicalResourceIdContext = [];
    }
    else if (output["PhysicalResourceIdContext"] !== undefined &&
        output["PhysicalResourceIdContext"]["member"] !== undefined) {
        contents.PhysicalResourceIdContext = de_PhysicalResourceIdContext(__getArrayIfSingleItem(output["PhysicalResourceIdContext"]["member"]), context);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["ExpectedProperties"] !== undefined) {
        contents.ExpectedProperties = __expectString(output["ExpectedProperties"]);
    }
    if (output["ActualProperties"] !== undefined) {
        contents.ActualProperties = __expectString(output["ActualProperties"]);
    }
    if (output.PropertyDifferences === "") {
        contents.PropertyDifferences = [];
    }
    else if (output["PropertyDifferences"] !== undefined && output["PropertyDifferences"]["member"] !== undefined) {
        contents.PropertyDifferences = de_PropertyDifferences(__getArrayIfSingleItem(output["PropertyDifferences"]["member"]), context);
    }
    if (output["StackResourceDriftStatus"] !== undefined) {
        contents.StackResourceDriftStatus = __expectString(output["StackResourceDriftStatus"]);
    }
    if (output["Timestamp"] !== undefined) {
        contents.Timestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["Timestamp"]));
    }
    if (output["ModuleInfo"] !== undefined) {
        contents.ModuleInfo = de_ModuleInfo(output["ModuleInfo"], context);
    }
    return contents;
};
const de_StackResourceDriftInformation = (output, context) => {
    const contents = {};
    if (output["StackResourceDriftStatus"] !== undefined) {
        contents.StackResourceDriftStatus = __expectString(output["StackResourceDriftStatus"]);
    }
    if (output["LastCheckTimestamp"] !== undefined) {
        contents.LastCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastCheckTimestamp"]));
    }
    return contents;
};
const de_StackResourceDriftInformationSummary = (output, context) => {
    const contents = {};
    if (output["StackResourceDriftStatus"] !== undefined) {
        contents.StackResourceDriftStatus = __expectString(output["StackResourceDriftStatus"]);
    }
    if (output["LastCheckTimestamp"] !== undefined) {
        contents.LastCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastCheckTimestamp"]));
    }
    return contents;
};
const de_StackResourceDrifts = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackResourceDrift(entry, context);
    });
};
const de_StackResources = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackResource(entry, context);
    });
};
const de_StackResourceSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackResourceSummary(entry, context);
    });
};
const de_StackResourceSummary = (output, context) => {
    const contents = {};
    if (output["LogicalResourceId"] !== undefined) {
        contents.LogicalResourceId = __expectString(output["LogicalResourceId"]);
    }
    if (output["PhysicalResourceId"] !== undefined) {
        contents.PhysicalResourceId = __expectString(output["PhysicalResourceId"]);
    }
    if (output["ResourceType"] !== undefined) {
        contents.ResourceType = __expectString(output["ResourceType"]);
    }
    if (output["LastUpdatedTimestamp"] !== undefined) {
        contents.LastUpdatedTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdatedTimestamp"]));
    }
    if (output["ResourceStatus"] !== undefined) {
        contents.ResourceStatus = __expectString(output["ResourceStatus"]);
    }
    if (output["ResourceStatusReason"] !== undefined) {
        contents.ResourceStatusReason = __expectString(output["ResourceStatusReason"]);
    }
    if (output["DriftInformation"] !== undefined) {
        contents.DriftInformation = de_StackResourceDriftInformationSummary(output["DriftInformation"], context);
    }
    if (output["ModuleInfo"] !== undefined) {
        contents.ModuleInfo = de_ModuleInfo(output["ModuleInfo"], context);
    }
    return contents;
};
const de_Stacks = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Stack(entry, context);
    });
};
const de_StackSet = (output, context) => {
    const contents = {};
    if (output["StackSetName"] !== undefined) {
        contents.StackSetName = __expectString(output["StackSetName"]);
    }
    if (output["StackSetId"] !== undefined) {
        contents.StackSetId = __expectString(output["StackSetId"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["TemplateBody"] !== undefined) {
        contents.TemplateBody = __expectString(output["TemplateBody"]);
    }
    if (output.Parameters === "") {
        contents.Parameters = [];
    }
    else if (output["Parameters"] !== undefined && output["Parameters"]["member"] !== undefined) {
        contents.Parameters = de_Parameters(__getArrayIfSingleItem(output["Parameters"]["member"]), context);
    }
    if (output.Capabilities === "") {
        contents.Capabilities = [];
    }
    else if (output["Capabilities"] !== undefined && output["Capabilities"]["member"] !== undefined) {
        contents.Capabilities = de_Capabilities(__getArrayIfSingleItem(output["Capabilities"]["member"]), context);
    }
    if (output.Tags === "") {
        contents.Tags = [];
    }
    else if (output["Tags"] !== undefined && output["Tags"]["member"] !== undefined) {
        contents.Tags = de_Tags(__getArrayIfSingleItem(output["Tags"]["member"]), context);
    }
    if (output["StackSetARN"] !== undefined) {
        contents.StackSetARN = __expectString(output["StackSetARN"]);
    }
    if (output["AdministrationRoleARN"] !== undefined) {
        contents.AdministrationRoleARN = __expectString(output["AdministrationRoleARN"]);
    }
    if (output["ExecutionRoleName"] !== undefined) {
        contents.ExecutionRoleName = __expectString(output["ExecutionRoleName"]);
    }
    if (output["StackSetDriftDetectionDetails"] !== undefined) {
        contents.StackSetDriftDetectionDetails = de_StackSetDriftDetectionDetails(output["StackSetDriftDetectionDetails"], context);
    }
    if (output["AutoDeployment"] !== undefined) {
        contents.AutoDeployment = de_AutoDeployment(output["AutoDeployment"], context);
    }
    if (output["PermissionModel"] !== undefined) {
        contents.PermissionModel = __expectString(output["PermissionModel"]);
    }
    if (output.OrganizationalUnitIds === "") {
        contents.OrganizationalUnitIds = [];
    }
    else if (output["OrganizationalUnitIds"] !== undefined && output["OrganizationalUnitIds"]["member"] !== undefined) {
        contents.OrganizationalUnitIds = de_OrganizationalUnitIdList(__getArrayIfSingleItem(output["OrganizationalUnitIds"]["member"]), context);
    }
    if (output["ManagedExecution"] !== undefined) {
        contents.ManagedExecution = de_ManagedExecution(output["ManagedExecution"], context);
    }
    if (output.Regions === "") {
        contents.Regions = [];
    }
    else if (output["Regions"] !== undefined && output["Regions"]["member"] !== undefined) {
        contents.Regions = de_RegionList(__getArrayIfSingleItem(output["Regions"]["member"]), context);
    }
    return contents;
};
const de_StackSetDriftDetectionDetails = (output, context) => {
    const contents = {};
    if (output["DriftStatus"] !== undefined) {
        contents.DriftStatus = __expectString(output["DriftStatus"]);
    }
    if (output["DriftDetectionStatus"] !== undefined) {
        contents.DriftDetectionStatus = __expectString(output["DriftDetectionStatus"]);
    }
    if (output["LastDriftCheckTimestamp"] !== undefined) {
        contents.LastDriftCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastDriftCheckTimestamp"]));
    }
    if (output["TotalStackInstancesCount"] !== undefined) {
        contents.TotalStackInstancesCount = __strictParseInt32(output["TotalStackInstancesCount"]);
    }
    if (output["DriftedStackInstancesCount"] !== undefined) {
        contents.DriftedStackInstancesCount = __strictParseInt32(output["DriftedStackInstancesCount"]);
    }
    if (output["InSyncStackInstancesCount"] !== undefined) {
        contents.InSyncStackInstancesCount = __strictParseInt32(output["InSyncStackInstancesCount"]);
    }
    if (output["InProgressStackInstancesCount"] !== undefined) {
        contents.InProgressStackInstancesCount = __strictParseInt32(output["InProgressStackInstancesCount"]);
    }
    if (output["FailedStackInstancesCount"] !== undefined) {
        contents.FailedStackInstancesCount = __strictParseInt32(output["FailedStackInstancesCount"]);
    }
    return contents;
};
const de_StackSetNotEmptyException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_StackSetNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_StackSetOperation = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    if (output["StackSetId"] !== undefined) {
        contents.StackSetId = __expectString(output["StackSetId"]);
    }
    if (output["Action"] !== undefined) {
        contents.Action = __expectString(output["Action"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["OperationPreferences"] !== undefined) {
        contents.OperationPreferences = de_StackSetOperationPreferences(output["OperationPreferences"], context);
    }
    if (output["RetainStacks"] !== undefined) {
        contents.RetainStacks = __parseBoolean(output["RetainStacks"]);
    }
    if (output["AdministrationRoleARN"] !== undefined) {
        contents.AdministrationRoleARN = __expectString(output["AdministrationRoleARN"]);
    }
    if (output["ExecutionRoleName"] !== undefined) {
        contents.ExecutionRoleName = __expectString(output["ExecutionRoleName"]);
    }
    if (output["CreationTimestamp"] !== undefined) {
        contents.CreationTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["CreationTimestamp"]));
    }
    if (output["EndTimestamp"] !== undefined) {
        contents.EndTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["EndTimestamp"]));
    }
    if (output["DeploymentTargets"] !== undefined) {
        contents.DeploymentTargets = de_DeploymentTargets(output["DeploymentTargets"], context);
    }
    if (output["StackSetDriftDetectionDetails"] !== undefined) {
        contents.StackSetDriftDetectionDetails = de_StackSetDriftDetectionDetails(output["StackSetDriftDetectionDetails"], context);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output["StatusDetails"] !== undefined) {
        contents.StatusDetails = de_StackSetOperationStatusDetails(output["StatusDetails"], context);
    }
    return contents;
};
const de_StackSetOperationPreferences = (output, context) => {
    const contents = {};
    if (output["RegionConcurrencyType"] !== undefined) {
        contents.RegionConcurrencyType = __expectString(output["RegionConcurrencyType"]);
    }
    if (output.RegionOrder === "") {
        contents.RegionOrder = [];
    }
    else if (output["RegionOrder"] !== undefined && output["RegionOrder"]["member"] !== undefined) {
        contents.RegionOrder = de_RegionList(__getArrayIfSingleItem(output["RegionOrder"]["member"]), context);
    }
    if (output["FailureToleranceCount"] !== undefined) {
        contents.FailureToleranceCount = __strictParseInt32(output["FailureToleranceCount"]);
    }
    if (output["FailureTolerancePercentage"] !== undefined) {
        contents.FailureTolerancePercentage = __strictParseInt32(output["FailureTolerancePercentage"]);
    }
    if (output["MaxConcurrentCount"] !== undefined) {
        contents.MaxConcurrentCount = __strictParseInt32(output["MaxConcurrentCount"]);
    }
    if (output["MaxConcurrentPercentage"] !== undefined) {
        contents.MaxConcurrentPercentage = __strictParseInt32(output["MaxConcurrentPercentage"]);
    }
    return contents;
};
const de_StackSetOperationResultSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackSetOperationResultSummary(entry, context);
    });
};
const de_StackSetOperationResultSummary = (output, context) => {
    const contents = {};
    if (output["Account"] !== undefined) {
        contents.Account = __expectString(output["Account"]);
    }
    if (output["Region"] !== undefined) {
        contents.Region = __expectString(output["Region"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output["AccountGateResult"] !== undefined) {
        contents.AccountGateResult = de_AccountGateResult(output["AccountGateResult"], context);
    }
    if (output["OrganizationalUnitId"] !== undefined) {
        contents.OrganizationalUnitId = __expectString(output["OrganizationalUnitId"]);
    }
    return contents;
};
const de_StackSetOperationStatusDetails = (output, context) => {
    const contents = {};
    if (output["FailedStackInstancesCount"] !== undefined) {
        contents.FailedStackInstancesCount = __strictParseInt32(output["FailedStackInstancesCount"]);
    }
    return contents;
};
const de_StackSetOperationSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackSetOperationSummary(entry, context);
    });
};
const de_StackSetOperationSummary = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    if (output["Action"] !== undefined) {
        contents.Action = __expectString(output["Action"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["CreationTimestamp"] !== undefined) {
        contents.CreationTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["CreationTimestamp"]));
    }
    if (output["EndTimestamp"] !== undefined) {
        contents.EndTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["EndTimestamp"]));
    }
    if (output["StatusReason"] !== undefined) {
        contents.StatusReason = __expectString(output["StatusReason"]);
    }
    if (output["StatusDetails"] !== undefined) {
        contents.StatusDetails = de_StackSetOperationStatusDetails(output["StatusDetails"], context);
    }
    if (output["OperationPreferences"] !== undefined) {
        contents.OperationPreferences = de_StackSetOperationPreferences(output["OperationPreferences"], context);
    }
    return contents;
};
const de_StackSetSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackSetSummary(entry, context);
    });
};
const de_StackSetSummary = (output, context) => {
    const contents = {};
    if (output["StackSetName"] !== undefined) {
        contents.StackSetName = __expectString(output["StackSetName"]);
    }
    if (output["StackSetId"] !== undefined) {
        contents.StackSetId = __expectString(output["StackSetId"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["Status"] !== undefined) {
        contents.Status = __expectString(output["Status"]);
    }
    if (output["AutoDeployment"] !== undefined) {
        contents.AutoDeployment = de_AutoDeployment(output["AutoDeployment"], context);
    }
    if (output["PermissionModel"] !== undefined) {
        contents.PermissionModel = __expectString(output["PermissionModel"]);
    }
    if (output["DriftStatus"] !== undefined) {
        contents.DriftStatus = __expectString(output["DriftStatus"]);
    }
    if (output["LastDriftCheckTimestamp"] !== undefined) {
        contents.LastDriftCheckTimestamp = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastDriftCheckTimestamp"]));
    }
    if (output["ManagedExecution"] !== undefined) {
        contents.ManagedExecution = de_ManagedExecution(output["ManagedExecution"], context);
    }
    return contents;
};
const de_StackSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StackSummary(entry, context);
    });
};
const de_StackSummary = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    if (output["StackName"] !== undefined) {
        contents.StackName = __expectString(output["StackName"]);
    }
    if (output["TemplateDescription"] !== undefined) {
        contents.TemplateDescription = __expectString(output["TemplateDescription"]);
    }
    if (output["CreationTime"] !== undefined) {
        contents.CreationTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["CreationTime"]));
    }
    if (output["LastUpdatedTime"] !== undefined) {
        contents.LastUpdatedTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdatedTime"]));
    }
    if (output["DeletionTime"] !== undefined) {
        contents.DeletionTime = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["DeletionTime"]));
    }
    if (output["StackStatus"] !== undefined) {
        contents.StackStatus = __expectString(output["StackStatus"]);
    }
    if (output["StackStatusReason"] !== undefined) {
        contents.StackStatusReason = __expectString(output["StackStatusReason"]);
    }
    if (output["ParentId"] !== undefined) {
        contents.ParentId = __expectString(output["ParentId"]);
    }
    if (output["RootId"] !== undefined) {
        contents.RootId = __expectString(output["RootId"]);
    }
    if (output["DriftInformation"] !== undefined) {
        contents.DriftInformation = de_StackDriftInformationSummary(output["DriftInformation"], context);
    }
    return contents;
};
const de_StageList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_StaleRequestException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_StopStackSetOperationOutput = (output, context) => {
    const contents = {};
    return contents;
};
const de_SupportedMajorVersions = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __strictParseInt32(entry);
    });
};
const de_Tag = (output, context) => {
    const contents = {};
    if (output["Key"] !== undefined) {
        contents.Key = __expectString(output["Key"]);
    }
    if (output["Value"] !== undefined) {
        contents.Value = __expectString(output["Value"]);
    }
    return contents;
};
const de_Tags = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Tag(entry, context);
    });
};
const de_TemplateParameter = (output, context) => {
    const contents = {};
    if (output["ParameterKey"] !== undefined) {
        contents.ParameterKey = __expectString(output["ParameterKey"]);
    }
    if (output["DefaultValue"] !== undefined) {
        contents.DefaultValue = __expectString(output["DefaultValue"]);
    }
    if (output["NoEcho"] !== undefined) {
        contents.NoEcho = __parseBoolean(output["NoEcho"]);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    return contents;
};
const de_TemplateParameters = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_TemplateParameter(entry, context);
    });
};
const de_TestTypeOutput = (output, context) => {
    const contents = {};
    if (output["TypeVersionArn"] !== undefined) {
        contents.TypeVersionArn = __expectString(output["TypeVersionArn"]);
    }
    return contents;
};
const de_TokenAlreadyExistsException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_TransformsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_TypeConfigurationDetails = (output, context) => {
    const contents = {};
    if (output["Arn"] !== undefined) {
        contents.Arn = __expectString(output["Arn"]);
    }
    if (output["Alias"] !== undefined) {
        contents.Alias = __expectString(output["Alias"]);
    }
    if (output["Configuration"] !== undefined) {
        contents.Configuration = __expectString(output["Configuration"]);
    }
    if (output["LastUpdated"] !== undefined) {
        contents.LastUpdated = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdated"]));
    }
    if (output["TypeArn"] !== undefined) {
        contents.TypeArn = __expectString(output["TypeArn"]);
    }
    if (output["TypeName"] !== undefined) {
        contents.TypeName = __expectString(output["TypeName"]);
    }
    if (output["IsDefaultConfiguration"] !== undefined) {
        contents.IsDefaultConfiguration = __parseBoolean(output["IsDefaultConfiguration"]);
    }
    return contents;
};
const de_TypeConfigurationDetailsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_TypeConfigurationDetails(entry, context);
    });
};
const de_TypeConfigurationIdentifier = (output, context) => {
    const contents = {};
    if (output["TypeArn"] !== undefined) {
        contents.TypeArn = __expectString(output["TypeArn"]);
    }
    if (output["TypeConfigurationAlias"] !== undefined) {
        contents.TypeConfigurationAlias = __expectString(output["TypeConfigurationAlias"]);
    }
    if (output["TypeConfigurationArn"] !== undefined) {
        contents.TypeConfigurationArn = __expectString(output["TypeConfigurationArn"]);
    }
    if (output["Type"] !== undefined) {
        contents.Type = __expectString(output["Type"]);
    }
    if (output["TypeName"] !== undefined) {
        contents.TypeName = __expectString(output["TypeName"]);
    }
    return contents;
};
const de_TypeConfigurationNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_TypeNotFoundException = (output, context) => {
    const contents = {};
    if (output["Message"] !== undefined) {
        contents.Message = __expectString(output["Message"]);
    }
    return contents;
};
const de_TypeSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_TypeSummary(entry, context);
    });
};
const de_TypeSummary = (output, context) => {
    const contents = {};
    if (output["Type"] !== undefined) {
        contents.Type = __expectString(output["Type"]);
    }
    if (output["TypeName"] !== undefined) {
        contents.TypeName = __expectString(output["TypeName"]);
    }
    if (output["DefaultVersionId"] !== undefined) {
        contents.DefaultVersionId = __expectString(output["DefaultVersionId"]);
    }
    if (output["TypeArn"] !== undefined) {
        contents.TypeArn = __expectString(output["TypeArn"]);
    }
    if (output["LastUpdated"] !== undefined) {
        contents.LastUpdated = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["LastUpdated"]));
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["PublisherId"] !== undefined) {
        contents.PublisherId = __expectString(output["PublisherId"]);
    }
    if (output["OriginalTypeName"] !== undefined) {
        contents.OriginalTypeName = __expectString(output["OriginalTypeName"]);
    }
    if (output["PublicVersionNumber"] !== undefined) {
        contents.PublicVersionNumber = __expectString(output["PublicVersionNumber"]);
    }
    if (output["LatestPublicVersion"] !== undefined) {
        contents.LatestPublicVersion = __expectString(output["LatestPublicVersion"]);
    }
    if (output["PublisherIdentity"] !== undefined) {
        contents.PublisherIdentity = __expectString(output["PublisherIdentity"]);
    }
    if (output["PublisherName"] !== undefined) {
        contents.PublisherName = __expectString(output["PublisherName"]);
    }
    if (output["IsActivated"] !== undefined) {
        contents.IsActivated = __parseBoolean(output["IsActivated"]);
    }
    return contents;
};
const de_TypeVersionSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_TypeVersionSummary(entry, context);
    });
};
const de_TypeVersionSummary = (output, context) => {
    const contents = {};
    if (output["Type"] !== undefined) {
        contents.Type = __expectString(output["Type"]);
    }
    if (output["TypeName"] !== undefined) {
        contents.TypeName = __expectString(output["TypeName"]);
    }
    if (output["VersionId"] !== undefined) {
        contents.VersionId = __expectString(output["VersionId"]);
    }
    if (output["IsDefaultVersion"] !== undefined) {
        contents.IsDefaultVersion = __parseBoolean(output["IsDefaultVersion"]);
    }
    if (output["Arn"] !== undefined) {
        contents.Arn = __expectString(output["Arn"]);
    }
    if (output["TimeCreated"] !== undefined) {
        contents.TimeCreated = __expectNonNull(__parseRfc3339DateTimeWithOffset(output["TimeCreated"]));
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output["PublicVersionNumber"] !== undefined) {
        contents.PublicVersionNumber = __expectString(output["PublicVersionNumber"]);
    }
    return contents;
};
const de_UnprocessedTypeConfigurations = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_TypeConfigurationIdentifier(entry, context);
    });
};
const de_UpdateStackInstancesOutput = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    return contents;
};
const de_UpdateStackOutput = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    return contents;
};
const de_UpdateStackSetOutput = (output, context) => {
    const contents = {};
    if (output["OperationId"] !== undefined) {
        contents.OperationId = __expectString(output["OperationId"]);
    }
    return contents;
};
const de_UpdateTerminationProtectionOutput = (output, context) => {
    const contents = {};
    if (output["StackId"] !== undefined) {
        contents.StackId = __expectString(output["StackId"]);
    }
    return contents;
};
const de_ValidateTemplateOutput = (output, context) => {
    const contents = {};
    if (output.Parameters === "") {
        contents.Parameters = [];
    }
    else if (output["Parameters"] !== undefined && output["Parameters"]["member"] !== undefined) {
        contents.Parameters = de_TemplateParameters(__getArrayIfSingleItem(output["Parameters"]["member"]), context);
    }
    if (output["Description"] !== undefined) {
        contents.Description = __expectString(output["Description"]);
    }
    if (output.Capabilities === "") {
        contents.Capabilities = [];
    }
    else if (output["Capabilities"] !== undefined && output["Capabilities"]["member"] !== undefined) {
        contents.Capabilities = de_Capabilities(__getArrayIfSingleItem(output["Capabilities"]["member"]), context);
    }
    if (output["CapabilitiesReason"] !== undefined) {
        contents.CapabilitiesReason = __expectString(output["CapabilitiesReason"]);
    }
    if (output.DeclaredTransforms === "") {
        contents.DeclaredTransforms = [];
    }
    else if (output["DeclaredTransforms"] !== undefined && output["DeclaredTransforms"]["member"] !== undefined) {
        contents.DeclaredTransforms = de_TransformsList(__getArrayIfSingleItem(output["DeclaredTransforms"]["member"]), context);
    }
    return contents;
};
const de_Warnings = (output, context) => {
    const contents = {};
    if (output.UnrecognizedResourceTypes === "") {
        contents.UnrecognizedResourceTypes = [];
    }
    else if (output["UnrecognizedResourceTypes"] !== undefined &&
        output["UnrecognizedResourceTypes"]["member"] !== undefined) {
        contents.UnrecognizedResourceTypes = de_ResourceTypes(__getArrayIfSingleItem(output["UnrecognizedResourceTypes"]["member"]), context);
    }
    return contents;
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = withBaseException(__BaseException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
const SHARED_HEADERS = {
    "content-type": "application/x-www-form-urlencoded",
};
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        const parser = new XMLParser({
            attributeNamePrefix: "",
            htmlEntities: true,
            ignoreAttributes: false,
            ignoreDeclaration: true,
            parseTagValue: false,
            trimValues: false,
            tagValueProcessor: (_, val) => (val.trim() === "" && val.includes("\n") ? "" : undefined),
        });
        parser.addEntity("#xD", "\r");
        parser.addEntity("#10", "\n");
        const parsedObj = parser.parse(encoded);
        const textNodeName = "#text";
        const key = Object.keys(parsedObj)[0];
        const parsedObjToReturn = parsedObj[key];
        if (parsedObjToReturn[textNodeName]) {
            parsedObjToReturn[key] = parsedObjToReturn[textNodeName];
            delete parsedObjToReturn[textNodeName];
        }
        return __getValueFromTextNode(parsedObjToReturn);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    if (value.Error) {
        value.Error.message = value.Error.message ?? value.Error.Message;
    }
    return value;
};
const buildFormUrlencodedString = (formEntries) => Object.entries(formEntries)
    .map(([key, value]) => __extendedEncodeURIComponent(key) + "=" + __extendedEncodeURIComponent(value))
    .join("&");
const loadQueryErrorCode = (output, data) => {
    if (data.Error?.Code !== undefined) {
        return data.Error.Code;
    }
    if (output.statusCode == 404) {
        return "NotFound";
    }
};
