/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Bones {
    private static final String BONES_FILE = "bones.dat";
    private static final String LEVEL = "level";
    private static final String BRANCH = "branch";
    private static final String ITEM = "item";
    private static int depth = -1;
    private static int branch = -1;
    private static Item item;

    public static void leave() {
        depth = Math.max(Dungeon.depth, Statistics.deepestFloor - 5);
        branch = Dungeon.branch;
        if (Dungeon.daily) {
            branch = -1;
            depth = -1;
            return;
        }
        item = Bones.pickItem(Dungeon.hero);
        Bundle bundle = new Bundle();
        bundle.put(LEVEL, depth);
        bundle.put(ITEM, item);
        try {
            FileUtils.bundleToFile(BONES_FILE, bundle);
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException(e);
        }
    }

    private static Item pickItem(Hero hero) {
        Item item = null;
        if (!Dungeon.customSeedText.isEmpty()) {
            if (Dungeon.gold > 100) {
                return new Gold(Random.NormalIntRange(50, Dungeon.gold / 2));
            }
            return new Gold(50);
        }
        if (Random.Int(3) != 0) {
            switch (Random.Int(7)) {
                case 0: {
                    item = hero.belongings.weapon;
                    if (hero.belongings.secondWep == null || item != null && hero.belongings.secondWep.trueLevel() <= item.trueLevel()) break;
                    item = hero.belongings.secondWep;
                    break;
                }
                case 1: {
                    item = hero.belongings.armor;
                    break;
                }
                case 2: {
                    item = hero.belongings.artifact;
                    break;
                }
                case 3: {
                    item = hero.belongings.misc;
                    break;
                }
                case 4: {
                    item = hero.belongings.ring;
                    break;
                }
                case 5: 
                case 6: {
                    item = Dungeon.quickslot.randomNonePlaceholder();
                }
            }
            if (item == null || !item.bones) {
                return Bones.pickItem(hero);
            }
        } else {
            Iterator<Item> iterator = hero.belongings.backpack.iterator();
            ArrayList<Item> items = new ArrayList<Item>();
            while (iterator.hasNext()) {
                Item curItem = iterator.next();
                if (!curItem.bones) continue;
                items.add(curItem);
            }
            if (Random.Int(3) < items.size()) {
                item = (Item)Random.element(items);
                if (item.stackable) {
                    item.quantity(Random.NormalIntRange(1, (item.quantity() + 1) / 2));
                }
            } else {
                item = Dungeon.gold > 100 ? new Gold(Random.NormalIntRange(50, Dungeon.gold / 2)) : new Gold(50);
            }
        }
        return item;
    }

    public static Item get() {
        if (Dungeon.daily) {
            return null;
        }
        if (depth == -1) {
            try {
                Bundle bundle = FileUtils.bundleFromFile(BONES_FILE);
                depth = bundle.getInt(LEVEL);
                branch = bundle.getInt(BRANCH);
                if (depth > 0) {
                    item = (Item)bundle.get(ITEM);
                }
                return Bones.get();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (Bones.lootAtCurLevel()) {
            Bundle emptyBones = new Bundle();
            emptyBones.put(LEVEL, 0);
            try {
                FileUtils.bundleToFile(BONES_FILE, emptyBones);
            }
            catch (IOException e) {
                ShatteredPixelDungeon.reportException(e);
            }
            depth = 0;
            if (Dungeon.challenges != 0 || !Dungeon.customSeedText.isEmpty()) {
                item = new Gold(10);
            }
            if (item == null) {
                item = new Gold(50);
            }
            if (item instanceof Artifact) {
                if (Generator.removeArtifact(((Artifact)item).getClass())) {
                    Artifact artifact = (Artifact)Reflection.newInstance(((Artifact)item).getClass());
                    if (artifact == null) {
                        return new Gold(item.value());
                    }
                    artifact.cursed = true;
                    artifact.cursedKnown = true;
                    return artifact;
                }
                return new Gold(item.value());
            }
            if (item.isUpgradable() && !(item instanceof MissileWeapon)) {
                Bones.item.cursed = true;
                Bones.item.cursedKnown = true;
            }
            if (item.isUpgradable()) {
                if (item.level() > 3) {
                    item.degrade(item.level() - 3);
                }
                Bones.item.levelKnown = item instanceof MissileWeapon;
            }
            item.reset();
            return item;
        }
        return null;
    }

    private static boolean lootAtCurLevel() {
        if (branch == Dungeon.branch) {
            if (branch == 0) {
                return depth == Dungeon.depth;
            }
            if (branch == 1) {
                return depth / 5 == Dungeon.depth / 5;
            }
        }
        return false;
    }
}

