/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.rings;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MonkEnergy;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class RingOfForce
extends Ring {
    public static String AC_ABILITY = "ABILITY";

    public RingOfForce() {
        this.icon = ItemSpriteSheet.Icons.RING_FORCE;
    }

    @Override
    protected Ring.RingBuff buff() {
        return new Force();
    }

    public static int armedDamageBonus(Char ch) {
        return RingOfForce.getBuffedBonus(ch, Force.class);
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            if (hero.buff(BrawlersStance.class) != null && hero.buff(Force.class) == null) {
                hero.buff(BrawlersStance.class).detach();
            }
            return true;
        }
        return false;
    }

    private static float tier(int str) {
        float tier = Math.max(1.0f, (float)(str - 8) / 2.0f);
        if (tier > 5.0f) {
            tier = 5.0f + (tier - 5.0f) / 2.0f;
        }
        return tier;
    }

    public static int damageRoll(Hero hero) {
        if (hero.buff(Force.class) != null && hero.buff(MonkEnergy.MonkAbility.UnarmedAbilityTracker.class) == null) {
            int level = RingOfForce.getBuffedBonus(hero, Force.class);
            float tier = RingOfForce.tier(hero.STR());
            return Random.NormalIntRange(RingOfForce.min(level, tier), RingOfForce.max(level, tier));
        }
        return Random.NormalIntRange(1, Math.max(hero.STR() - 8, 1));
    }

    private static int min(int lvl, float tier) {
        if (lvl <= 0) {
            tier = 1.0f;
        }
        return Math.max(0, Math.round(tier + (float)lvl));
    }

    private static int max(int lvl, float tier) {
        if (lvl <= 0) {
            tier = 1.0f;
        }
        return Math.max(0, Math.round(5.0f * (tier + 1.0f) + (float)lvl * (tier + 1.0f)));
    }

    @Override
    public String statsInfo() {
        float tier = RingOfForce.tier(Dungeon.hero.STR());
        if (this.isIdentified()) {
            int level = this.soloBuffedBonus();
            String info = Messages.get(this, "stats", RingOfForce.min(level, tier), RingOfForce.max(level, tier), level);
            if (this.isEquipped(Dungeon.hero) && this.soloBuffedBonus() != RingOfForce.combinedBuffedBonus(Dungeon.hero, Force.class)) {
                level = RingOfForce.combinedBuffedBonus(Dungeon.hero, Force.class);
                info = info + "\n\n" + Messages.get(this, "combined_stats", RingOfForce.min(level, tier), RingOfForce.max(level, tier), level);
            }
            return info;
        }
        return Messages.get(this, "typical_stats", RingOfForce.min(1, tier), RingOfForce.max(1, tier), 1);
    }

    @Override
    public void activate(Char ch) {
        super.activate(ch);
        if (ch instanceof Hero && ((Hero)ch).heroClass == HeroClass.DUELIST) {
            Buff.affect(ch, MeleeWeapon.Charger.class);
        }
    }

    @Override
    public String defaultAction() {
        if (Dungeon.hero != null && Dungeon.hero.heroClass == HeroClass.DUELIST) {
            return AC_ABILITY;
        }
        return super.defaultAction();
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero) && hero.heroClass == HeroClass.DUELIST) {
            actions.add(AC_ABILITY);
        }
        return actions;
    }

    @Override
    public String actionName(String action, Hero hero) {
        if (action.equals(AC_ABILITY)) {
            return Messages.upperCase(Messages.get(this, "ability_name", new Object[0]));
        }
        return super.actionName(action, hero);
    }

    @Override
    public void execute(Hero hero, String action) {
        if (action.equals(AC_ABILITY)) {
            if (hero.buff(BrawlersStance.class) != null) {
                hero.buff(BrawlersStance.class).detach();
                AttackIndicator.updateState();
            } else if (!this.isEquipped(hero)) {
                GLog.w(Messages.get(MeleeWeapon.class, "ability_need_equip", new Object[0]), new Object[0]);
            } else if ((float)Buff.affect((Char)hero, MeleeWeapon.Charger.class).charges + Buff.affect((Char)hero, MeleeWeapon.Charger.class).partialCharge < BrawlersStance.HIT_CHARGE_USE) {
                GLog.w(Messages.get(MeleeWeapon.class, "ability_no_charge", new Object[0]), new Object[0]);
            } else {
                Buff.affect(hero, BrawlersStance.class);
                AttackIndicator.updateState();
            }
        } else {
            super.execute(hero, action);
        }
    }

    @Override
    public String info() {
        String info = super.info();
        if (Dungeon.hero.heroClass == HeroClass.DUELIST && (this.anonymous || this.isIdentified() || this.isEquipped(Dungeon.hero))) {
            info = info + "\n\n" + Messages.get(this, "ability_desc", new Object[0]);
        }
        return info;
    }

    public static boolean fightingUnarmed(Hero hero) {
        if (hero.belongings.attackingWeapon() == null || hero.buff(MonkEnergy.MonkAbility.UnarmedAbilityTracker.class) != null) {
            return true;
        }
        if (hero.belongings.thrownWeapon != null || hero.belongings.abilityWeapon != null) {
            return false;
        }
        BrawlersStance stance = hero.buff(BrawlersStance.class);
        if (stance != null && stance.hitsLeft() > 0) {
            if (hero.buff(Force.class) == null) {
                stance.detach();
                AttackIndicator.updateState();
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean unarmedGetsWeaponEnchantment(Hero hero) {
        if (hero.belongings.attackingWeapon() == null) {
            return false;
        }
        if (hero.buff(MonkEnergy.MonkAbility.UnarmedAbilityTracker.class) != null) {
            return hero.buff(MonkEnergy.MonkAbility.FlurryEmpowerTracker.class) != null;
        }
        BrawlersStance stance = hero.buff(BrawlersStance.class);
        return stance != null && stance.hitsLeft() > 0;
    }

    public static boolean unarmedGetsWeaponAugment(Hero hero) {
        if (hero.belongings.attackingWeapon() == null || hero.buff(MonkEnergy.MonkAbility.UnarmedAbilityTracker.class) != null) {
            return false;
        }
        BrawlersStance stance = hero.buff(BrawlersStance.class);
        return stance != null && stance.hitsLeft() > 0;
    }

    public static class BrawlersStance
    extends Buff {
        public static float HIT_CHARGE_USE = 0.16666667f;

        public BrawlersStance() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        public int hitsLeft() {
            MeleeWeapon.Charger charger = Buff.affect(this.target, MeleeWeapon.Charger.class);
            float charges = charger.charges;
            return (int)((charges += charger.partialCharge) / HIT_CHARGE_USE);
        }

        @Override
        public int icon() {
            return 65;
        }

        @Override
        public void tintIcon(Image icon) {
            if (this.hitsLeft() == 0) {
                icon.brightness(0.25f);
            } else {
                icon.resetColor();
            }
        }

        @Override
        public float iconFadePercent() {
            float usableCharges = (float)this.hitsLeft() * HIT_CHARGE_USE;
            return 1.0f - usableCharges / (float)Buff.affect(this.target, MeleeWeapon.Charger.class).chargeCap();
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString(this.hitsLeft());
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.hitsLeft());
        }
    }

    public class Force
    extends Ring.RingBuff {
    }
}

