/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RotHeart;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RotLasher;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.IronKey;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class RotGardenRoom
extends SpecialRoom {
    @Override
    public int minWidth() {
        return 10;
    }

    @Override
    public int minHeight() {
        return 10;
    }

    @Override
    public void paint(Level level) {
        int i;
        int i2;
        Room.Door entrance = this.entrance();
        entrance.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey(Dungeon.depth));
        Painter.fill(level, this, 4);
        Painter.set(level, entrance, 10);
        Painter.fill(level, this, 1, 15);
        for (int i22 = 0; i22 < 12; ++i22) {
            Painter.set(level, this.random(1), 4);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            Painter.set(level, this.random(2), 4);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Painter.set(level, this.random(3), 4);
        }
        Painter.drawInside(level, this, entrance, 3, 15);
        boolean[] passable = new boolean[level.length()];
        for (int i3 = 0; i3 < passable.length; ++i3) {
            passable[i3] = level.map[i3] != 4;
        }
        int entryPos = level.pointToCell(this.entrance());
        PathFinder.buildDistanceMap(entryPos, passable);
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (Point point : this.getPoints()) {
            int i4 = level.pointToCell(point);
            if (PathFinder.distance[i4] != Integer.MAX_VALUE) {
                if (PathFinder.distance[i4] < 3) continue;
                candidates.add(i4);
                continue;
            }
            if (level.map[i4] != 15) continue;
            level.map[i4] = 4;
        }
        Random.shuffle(candidates);
        int closestPos = 3;
        while (candidates.size() > 5) {
            for (Integer i5 : candidates.toArray(new Integer[0])) {
                if (candidates.size() <= 5 || PathFinder.distance[i5] != closestPos) continue;
                candidates.remove(i5);
            }
            ++closestPos;
        }
        int n = (Integer)Random.element(candidates);
        RotGardenRoom.placePlant(level, n, new RotHeart());
        boolean[] newPassable = Arrays.copyOf(passable, passable.length);
        int maxLashers = 6;
        for (int i6 = 1; i6 <= maxLashers; ++i6) {
            int pos;
            int tries = 50;
            do {
                pos = level.pointToCell(this.random());
            } while (--tries > 0 && !RotGardenRoom.validPlantPos(passable, newPassable, level, pos, n, entryPos));
            if (tries <= 0) break;
            RotGardenRoom.placePlant(level, pos, new RotLasher());
        }
        boolean openCardinal = false;
        for (i = 1; i < PathFinder.CIRCLE8.length; i += 2) {
            if (level.map[n + PathFinder.CIRCLE8[i]] == 4) continue;
            openCardinal = true;
        }
        if (!openCardinal) {
            for (i = 0; i < PathFinder.CIRCLE8.length; i += 2) {
                if (level.map[n + PathFinder.CIRCLE8[i]] == 4) continue;
                Painter.set(level, n + PathFinder.CIRCLE8[i + 1], 15);
            }
        }
        int safeHeartcells = 0;
        HashSet<Mob> adjacentLashers = new HashSet<Mob>();
        for (int i7 : PathFinder.NEIGHBOURS8) {
            if (level.map[n + i7] == 4) continue;
            boolean foundLasher = false;
            for (int j : PathFinder.NEIGHBOURS8) {
                if (n + i7 + j == n || level.map[n + i7 + j] == 4 || level.findMob(n + i7 + j) == null) continue;
                foundLasher = true;
                adjacentLashers.add(level.findMob(n + i7 + j));
            }
            if (foundLasher) continue;
            ++safeHeartcells;
        }
        if (safeHeartcells < 2 && !adjacentLashers.isEmpty()) {
            Char toRemove = (Char)Random.element(adjacentLashers);
            level.mobs.remove(toRemove);
            Painter.set(level, toRemove.pos, 15);
        }
    }

    private static boolean validPlantPos(boolean[] passable, boolean[] newPassable, Level level, int pos, int heartPos, int entryPos) {
        if (level.map[pos] != 15) {
            return false;
        }
        for (int i : PathFinder.NEIGHBOURS9) {
            if (level.findMob(pos + i) == null) continue;
            return false;
        }
        newPassable[pos] = false;
        for (int i : PathFinder.NEIGHBOURS4) {
            newPassable[pos + i] = false;
        }
        PathFinder.buildDistanceMap(heartPos, newPassable);
        if (PathFinder.distance[entryPos] == Integer.MAX_VALUE) {
            System.arraycopy(passable, 0, newPassable, 0, passable.length);
            return false;
        }
        System.arraycopy(newPassable, 0, passable, 0, passable.length);
        return true;
    }

    private static void placePlant(Level level, int pos, Mob plant) {
        plant.pos = pos;
        level.mobs.add(plant);
        Painter.set(level, pos, 2);
    }
}

