/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.javafx.filterpanel.FXSearchControlFieldMode;
import mediathek.tool.Filter;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmediathek/javafx/filterpanel/FXSearchControl;", "Lorg/controlsfx/control/textfield/CustomTextField;", "()V", "irgendwoTooltip", "Ljavafx/scene/control/Tooltip;", "themaTitelTooltip", "checkPatternValidity", "", "text", "", "setMode", "mode", "Lmediathek/javafx/filterpanel/FXSearchControlFieldMode;", "Companion", "MediathekView"})
public final class FXSearchControl
extends CustomTextField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tooltip themaTitelTooltip = new Tooltip("Thema/Titel durchsuchen");
    @NotNull
    private final Tooltip irgendwoTooltip = new Tooltip("Thema/Titel/Beschreibung durchsuchen");
    @NotNull
    private static final String PROMPT_THEMA_TITEL = "Thema/Titel";
    @NotNull
    private static final String PROMPT_IRGENDWO = "Thema/Titel/Beschreibung";

    public FXSearchControl() {
        GlyphFont fontAwesome = GlyphFontRegistry.font("FontAwesome");
        this.setLeft((Node)fontAwesome.create(FontAwesome.Glyph.SEARCH));
        this.setRight((Node)fontAwesome.create(FontAwesome.Glyph.REMOVE));
        this.setOnKeyPressed(arg_0 -> FXSearchControl._init_$lambda-0(this, arg_0));
        Node rightNode = this.getRight();
        rightNode.setOnMouseClicked(arg_0 -> FXSearchControl._init_$lambda-1(this, arg_0));
        rightNode.setCursor(Cursor.DEFAULT);
        rightNode.setVisible(false);
        StringProperty textProperty = this.textProperty();
        textProperty.addListener((arg_0, arg_1, arg_2) -> FXSearchControl._init_$lambda-2(rightNode, arg_0, arg_1, arg_2));
        this.setPrefWidth(350.0);
        this.setMinWidth(350.0);
        this.setMaxWidth(350.0);
        textProperty.addListener((arg_0, arg_1, arg_2) -> FXSearchControl._init_$lambda-3(this, arg_0, arg_1, arg_2));
    }

    public final void setMode(@NotNull FXSearchControlFieldMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                this.setTooltip(this.themaTitelTooltip);
                this.setPromptText(PROMPT_THEMA_TITEL);
                break;
            }
            case 2: {
                this.setTooltip(this.irgendwoTooltip);
                this.setPromptText(PROMPT_IRGENDWO);
            }
        }
    }

    private final void checkPatternValidity(String text) {
        this.setStyle(Filter.isPattern(text) ? (Filter.makePatternNoCache(text) == null ? "-fx-text-fill: red" : "-fx-text-fill: blue") : (String)null);
    }

    private static final void _init_$lambda-0(FXSearchControl this$0, KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getCode() == KeyCode.ESCAPE) {
            String string = this$0.getText();
            Intrinsics.checkNotNullExpressionValue(string, "text");
            if (((CharSequence)string).length() > 0) {
                this$0.setText("");
            }
            event.consume();
        }
    }

    private static final void _init_$lambda-1(FXSearchControl this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        this$0.setText("");
    }

    private static final void _init_$lambda-2(Node $rightNode, ObservableValue observableValue, String string, String newValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        $rightNode.setVisible(((CharSequence)newValue).length() > 0);
    }

    private static final void _init_$lambda-3(FXSearchControl this$0, ObservableValue observableValue, String string, String newValue) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(newValue, "newValue");
        this$0.checkPatternValidity(newValue);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/javafx/filterpanel/FXSearchControl$Companion;", "", "()V", "PROMPT_IRGENDWO", "", "PROMPT_THEMA_TITEL", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FXSearchControlFieldMode.values().length];
            nArray[FXSearchControlFieldMode.THEMA_TITEL.ordinal()] = 1;
            nArray[FXSearchControlFieldMode.IRGENDWO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

