/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.script;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.query.KNNWeight;
import org.opensearch.knn.plugin.script.KNNScoreScript;
import org.opensearch.knn.plugin.script.KNNScoringSpaceUtil;
import org.opensearch.knn.plugin.script.KNNScoringUtil;
import org.opensearch.script.ScoreScript;
import org.opensearch.search.lookup.SearchLookup;

public interface KNNScoringSpace {
    public ScoreScript getScoreScript(Map<String, Object> var1, String var2, SearchLookup var3, LeafReaderContext var4, IndexSearcher var5) throws IOException;

    public static class InnerProd
    implements KNNScoringSpace {
        float[] processedQuery;
        BiFunction<float[], float[], Float> scoringMethod;

        public InnerProd(Object query, MappedFieldType fieldType) {
            if (!KNNScoringSpaceUtil.isKNNVectorFieldType(fieldType)) {
                throw new IllegalArgumentException("Incompatible field_type for innerproduct space. The field type must be knn_vector.");
            }
            this.processedQuery = KNNScoringSpaceUtil.parseToFloatArray(query, ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getDimension(), ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getVectorDataType());
            this.scoringMethod = (q, v) -> Float.valueOf(KNNWeight.normalizeScore(-KNNScoringUtil.innerProduct(q, v)));
        }

        @Override
        public ScoreScript getScoreScript(Map<String, Object> params, String field, SearchLookup lookup, LeafReaderContext ctx, IndexSearcher searcher) throws IOException {
            return new KNNScoreScript.KNNVectorType(params, this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
        }
    }

    public static class LInf
    implements KNNScoringSpace {
        float[] processedQuery;
        BiFunction<float[], float[], Float> scoringMethod;

        public LInf(Object query, MappedFieldType fieldType) {
            if (!KNNScoringSpaceUtil.isKNNVectorFieldType(fieldType)) {
                throw new IllegalArgumentException("Incompatible field_type for l-inf space. The field type must be knn_vector.");
            }
            this.processedQuery = KNNScoringSpaceUtil.parseToFloatArray(query, ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getDimension(), ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getVectorDataType());
            this.scoringMethod = (q, v) -> Float.valueOf(1.0f / (1.0f + KNNScoringUtil.lInfNorm(q, v)));
        }

        @Override
        public ScoreScript getScoreScript(Map<String, Object> params, String field, SearchLookup lookup, LeafReaderContext ctx, IndexSearcher searcher) throws IOException {
            return new KNNScoreScript.KNNVectorType(params, this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
        }
    }

    public static class L1
    implements KNNScoringSpace {
        float[] processedQuery;
        BiFunction<float[], float[], Float> scoringMethod;

        public L1(Object query, MappedFieldType fieldType) {
            if (!KNNScoringSpaceUtil.isKNNVectorFieldType(fieldType)) {
                throw new IllegalArgumentException("Incompatible field_type for l1 space. The field type must be knn_vector.");
            }
            this.processedQuery = KNNScoringSpaceUtil.parseToFloatArray(query, ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getDimension(), ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getVectorDataType());
            this.scoringMethod = (q, v) -> Float.valueOf(1.0f / (1.0f + KNNScoringUtil.l1Norm(q, v)));
        }

        @Override
        public ScoreScript getScoreScript(Map<String, Object> params, String field, SearchLookup lookup, LeafReaderContext ctx, IndexSearcher searcher) throws IOException {
            return new KNNScoreScript.KNNVectorType(params, this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
        }
    }

    public static class HammingBit
    implements KNNScoringSpace {
        Object processedQuery;
        BiFunction<?, ?, Float> scoringMethod;

        public HammingBit(Object query, MappedFieldType fieldType) {
            if (KNNScoringSpaceUtil.isLongFieldType(fieldType)) {
                this.processedQuery = KNNScoringSpaceUtil.parseToLong(query);
                this.scoringMethod = (q, v) -> Float.valueOf(1.0f / (1.0f + KNNScoringUtil.calculateHammingBit(q, v)));
            } else if (KNNScoringSpaceUtil.isBinaryFieldType(fieldType)) {
                this.processedQuery = KNNScoringSpaceUtil.parseToBigInteger(query);
                this.scoringMethod = (q, v) -> Float.valueOf(1.0f / (1.0f + KNNScoringUtil.calculateHammingBit(q, v)));
            } else {
                throw new IllegalArgumentException("Incompatible field_type for hamming space. The field type must of type long or binary.");
            }
        }

        @Override
        public ScoreScript getScoreScript(Map<String, Object> params, String field, SearchLookup lookup, LeafReaderContext ctx, IndexSearcher searcher) throws IOException {
            if (this.processedQuery instanceof Long) {
                return new KNNScoreScript.LongType(params, (Long)this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
            }
            return new KNNScoreScript.BigIntegerType(params, (BigInteger)this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
        }
    }

    public static class CosineSimilarity
    implements KNNScoringSpace {
        float[] processedQuery;
        BiFunction<float[], float[], Float> scoringMethod;

        public CosineSimilarity(Object query, MappedFieldType fieldType) {
            if (!KNNScoringSpaceUtil.isKNNVectorFieldType(fieldType)) {
                throw new IllegalArgumentException("Incompatible field_type for cosine space. The field type must be knn_vector.");
            }
            this.processedQuery = KNNScoringSpaceUtil.parseToFloatArray(query, ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getDimension(), ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getVectorDataType());
            float qVectorSquaredMagnitude = KNNScoringSpaceUtil.getVectorMagnitudeSquared(this.processedQuery);
            this.scoringMethod = (q, v) -> Float.valueOf(1.0f + KNNScoringUtil.cosinesimilOptimized(q, v, qVectorSquaredMagnitude));
        }

        @Override
        public ScoreScript getScoreScript(Map<String, Object> params, String field, SearchLookup lookup, LeafReaderContext ctx, IndexSearcher searcher) throws IOException {
            return new KNNScoreScript.KNNVectorType(params, this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
        }
    }

    public static class L2
    implements KNNScoringSpace {
        float[] processedQuery;
        BiFunction<float[], float[], Float> scoringMethod;

        public L2(Object query, MappedFieldType fieldType) {
            if (!KNNScoringSpaceUtil.isKNNVectorFieldType(fieldType)) {
                throw new IllegalArgumentException("Incompatible field_type for l2 space. The field type must be knn_vector.");
            }
            this.processedQuery = KNNScoringSpaceUtil.parseToFloatArray(query, ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getDimension(), ((KNNVectorFieldMapper.KNNVectorFieldType)fieldType).getVectorDataType());
            this.scoringMethod = (q, v) -> Float.valueOf(1.0f / (1.0f + KNNScoringUtil.l2Squared(q, v)));
        }

        @Override
        public ScoreScript getScoreScript(Map<String, Object> params, String field, SearchLookup lookup, LeafReaderContext ctx, IndexSearcher searcher) throws IOException {
            return new KNNScoreScript.KNNVectorType(params, this.processedQuery, field, this.scoringMethod, lookup, ctx, searcher);
        }
    }
}

