"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
module.exports = {
  rootDir: "../",
  setupFiles: ["<rootDir>/test/polyfills.ts", "<rootDir>/test/setupTests.ts"],
  setupFilesAfterEnv: ["<rootDir>/test/setup.jest.ts"],
  roots: ["<rootDir>"],
  coverageDirectory: "./coverage",
  moduleNameMapper: {
    "\\.(css|less|scss)$": "<rootDir>/test/mocks/styleMock.ts",
    "^ui/(.*)": "<rootDir>/../../src/ui/public/$1/"
  },
  coverageReporters: ["lcov", "text", "cobertura"],
  testMatch: ["**/*.test.ts", "**/*.test.tsx"],
  collectCoverageFrom: ["!**/*.ts", "**/*.tsx", "!**/*.js", "!**/*.jsx", "!**/models/**", "!**/node_modules/**", "!**/index.ts", "!<rootDir>/index.js", "!<rootDir>/public/app.js", "!<rootDir>/public/temporary/**", "!<rootDir>/babel.config.js", "!<rootDir>/test/**", "!<rootDir>/server/**", "!<rootDir>/coverage/**", "!<rootDir>/scripts/**", "!<rootDir>/build/**", "!**/vendor/**"],
  clearMocks: true,
  testPathIgnorePatterns: ["<rootDir>/build/", "<rootDir>/node_modules/"],
  testEnvironment: 'jsdom'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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