/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.s3.S3AsyncService;
import org.opensearch.repositories.s3.S3ClientSettings;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.S3Service;
import org.opensearch.repositories.s3.async.AsyncExecutorContainer;
import org.opensearch.repositories.s3.async.AsyncTransferEventLoopGroup;
import org.opensearch.repositories.s3.async.AsyncTransferManager;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    private static final String PRIORITY_FUTURE_COMPLETION = "priority_future_completion";
    private static final String PRIORITY_STREAM_READER = "priority_stream_reader";
    private static final String FUTURE_COMPLETION = "future_completion";
    private static final String STREAM_READER = "stream_reader";
    protected final S3Service service;
    private final S3AsyncService s3AsyncService;
    private final Path configPath;
    private AsyncExecutorContainer priorityExecutorBuilder;
    private AsyncExecutorContainer normalExecutorBuilder;

    public S3RepositoryPlugin(Settings settings, Path configPath) {
        this(settings, configPath, new S3Service(configPath), new S3AsyncService(configPath));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList executorBuilders = new ArrayList();
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, PRIORITY_FUTURE_COMPLETION, S3RepositoryPlugin.priorityPoolCount(settings), 10000, PRIORITY_FUTURE_COMPLETION));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, PRIORITY_STREAM_READER, S3RepositoryPlugin.priorityPoolCount(settings), 10000, PRIORITY_STREAM_READER));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, FUTURE_COMPLETION, S3RepositoryPlugin.normalPoolCount(settings), 10000, FUTURE_COMPLETION));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, STREAM_READER, S3RepositoryPlugin.normalPoolCount(settings), 10000, STREAM_READER));
        return executorBuilders;
    }

    S3RepositoryPlugin(Settings settings, Path configPath, S3Service service, S3AsyncService s3AsyncService) {
        this.service = Objects.requireNonNull(service, "S3 service must not be null");
        this.configPath = configPath;
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings, configPath);
        this.s3AsyncService = Objects.requireNonNull(s3AsyncService, "S3AsyncService must not be null");
        this.service.refreshAndClearCache(clientsSettings);
        this.s3AsyncService.refreshAndClearCache(clientsSettings);
    }

    private static int boundedBy(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    private static int allocatedProcessors(Settings settings) {
        return OpenSearchExecutors.allocatedProcessors((Settings)settings);
    }

    private static int priorityPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 1) / 2, 2, 4);
    }

    private static int normalPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 7) / 8, 1, 2);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        int priorityEventLoopThreads = S3RepositoryPlugin.priorityPoolCount(clusterService.getSettings());
        int normalEventLoopThreads = S3RepositoryPlugin.normalPoolCount(clusterService.getSettings());
        this.priorityExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(PRIORITY_FUTURE_COMPLETION), threadPool.executor(PRIORITY_STREAM_READER), new AsyncTransferEventLoopGroup(priorityEventLoopThreads));
        this.normalExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(FUTURE_COMPLETION), threadPool.executor(STREAM_READER), new AsyncTransferEventLoopGroup(normalEventLoopThreads));
        return Collections.emptyList();
    }

    protected S3Repository createRepository(RepositoryMetadata metadata, NamedXContentRegistry registry, ClusterService clusterService, RecoverySettings recoverySettings) {
        AsyncTransferManager asyncUploadUtils = new AsyncTransferManager(((ByteSizeValue)S3Repository.PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING.get(clusterService.getSettings())).getBytes(), this.normalExecutorBuilder.getStreamReader(), this.priorityExecutorBuilder.getStreamReader());
        return new S3Repository(metadata, registry, this.service, clusterService, recoverySettings, asyncUploadUtils, this.priorityExecutorBuilder, this.normalExecutorBuilder, this.s3AsyncService, (Boolean)S3Repository.PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING.get(clusterService.getSettings()));
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry registry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("s3", metadata -> this.createRepository(metadata, registry, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.SESSION_TOKEN_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_TYPE_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING, S3ClientSettings.USE_PATH_STYLE_ACCESS, S3Repository.ACCESS_KEY_SETTING, S3Repository.SECRET_KEY_SETTING, S3ClientSettings.SIGNER_OVERRIDE, S3ClientSettings.REGION, S3ClientSettings.ROLE_ARN_SETTING, S3ClientSettings.IDENTITY_TOKEN_FILE_SETTING, S3ClientSettings.ROLE_SESSION_NAME_SETTING, S3Repository.PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING, S3Repository.PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING);
    }

    public void reload(Settings settings) {
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings, this.configPath);
        this.service.refreshAndClearCache(clientsSettings);
        this.s3AsyncService.refreshAndClearCache(clientsSettings);
    }

    public void close() throws IOException {
        this.service.close();
        this.s3AsyncService.close();
    }
}

