/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.annotation.MLAlgoOutput;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.MLOutputType;
import org.opensearch.ml.common.output.model.ModelTensors;

@MLAlgoOutput(value=MLOutputType.MODEL_TENSOR)
public class ModelTensorOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.MODEL_TENSOR;
    public static final String INFERENCE_RESULT_FIELD = "inference_results";
    private List<ModelTensors> mlModelOutputs;

    public ModelTensorOutput(List<ModelTensors> mlModelOutputs) {
        super(OUTPUT_TYPE);
        this.mlModelOutputs = mlModelOutputs;
    }

    public ModelTensorOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        if (in.readBoolean()) {
            this.mlModelOutputs = new ArrayList<ModelTensors>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.mlModelOutputs.add(new ModelTensors(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.mlModelOutputs != null && this.mlModelOutputs.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.mlModelOutputs.size());
            for (ModelTensors output : this.mlModelOutputs) {
                output.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.mlModelOutputs != null && this.mlModelOutputs.size() > 0) {
            builder.startArray(INFERENCE_RESULT_FIELD);
            for (ModelTensors output : this.mlModelOutputs) {
                output.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    @Generated
    public static ModelTensorOutputBuilder builder() {
        return new ModelTensorOutputBuilder();
    }

    @Generated
    public ModelTensorOutputBuilder toBuilder() {
        return new ModelTensorOutputBuilder().mlModelOutputs(this.mlModelOutputs);
    }

    @Generated
    public List<ModelTensors> getMlModelOutputs() {
        return this.mlModelOutputs;
    }

    @Generated
    public void setMlModelOutputs(List<ModelTensors> mlModelOutputs) {
        this.mlModelOutputs = mlModelOutputs;
    }

    @Generated
    public String toString() {
        return "ModelTensorOutput(mlModelOutputs=" + this.getMlModelOutputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelTensorOutput)) {
            return false;
        }
        ModelTensorOutput other = (ModelTensorOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ModelTensors> this$mlModelOutputs = this.getMlModelOutputs();
        List<ModelTensors> other$mlModelOutputs = other.getMlModelOutputs();
        return !(this$mlModelOutputs == null ? other$mlModelOutputs != null : !((Object)this$mlModelOutputs).equals(other$mlModelOutputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelTensorOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ModelTensors> $mlModelOutputs = this.getMlModelOutputs();
        result = result * 59 + ($mlModelOutputs == null ? 43 : ((Object)$mlModelOutputs).hashCode());
        return result;
    }

    @Generated
    public static class ModelTensorOutputBuilder {
        @Generated
        private List<ModelTensors> mlModelOutputs;

        @Generated
        ModelTensorOutputBuilder() {
        }

        @Generated
        public ModelTensorOutputBuilder mlModelOutputs(List<ModelTensors> mlModelOutputs) {
            this.mlModelOutputs = mlModelOutputs;
            return this;
        }

        @Generated
        public ModelTensorOutput build() {
            return new ModelTensorOutput(this.mlModelOutputs);
        }

        @Generated
        public String toString() {
            return "ModelTensorOutput.ModelTensorOutputBuilder(mlModelOutputs=" + this.mlModelOutputs + ")";
        }
    }
}

