/*
  Simplified BSD License (see LICENSES/BSD-2-Clause.txt or https://opensource.org/licenses/BSD-2-Clause)
  SPDX-FileCopyrightText: Ansible Project
  SPDX-License-Identifier: BSD-2-Clause
*/
export function mergeOpts(options, fallback) {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
    const result = Object.assign({}, fallback, options);
    // In case options.formatXXX is explicitly set to undefined:
    for (const key of Object.keys(fallback)) {
        if (!result[key]) {
            /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
            result[key] = fallback[key];
        }
    }
    return result;
}
//# sourceMappingURL=opts.js.map