/*
 * Decompiled with CFR 0.152.
 */
package naga.eventmachine;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import naga.eventmachine.DelayedEvent;

class DelayedAction
implements Comparable<DelayedAction>,
DelayedEvent {
    private static final AtomicLong s_nextId = new AtomicLong(0L);
    private volatile Runnable m_call;
    private final long m_time;
    private final long m_id;

    public DelayedAction(Runnable runnable, long l) {
        this.m_call = runnable;
        this.m_time = l;
        this.m_id = s_nextId.getAndIncrement();
    }

    @Override
    public void cancel() {
        this.m_call = null;
    }

    void run() {
        Runnable runnable = this.m_call;
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public int compareTo(DelayedAction delayedAction) {
        if (this.m_time < delayedAction.m_time) {
            return -1;
        }
        if (this.m_time > delayedAction.m_time) {
            return 1;
        }
        if (this.m_id < delayedAction.m_id) {
            return -1;
        }
        return this.m_id > delayedAction.m_id ? 1 : 0;
    }

    @Override
    public Runnable getCall() {
        return this.m_call;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    public String toString() {
        return "DelayedAction @ " + new Date(this.m_time) + " [" + (this.m_call == null ? "Cancelled" : this.m_call) + "]";
    }
}

