/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.V3;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class WyckoffFinder {
    private static final Map<String, WyckoffFinder> helpers = new Hashtable<String, WyckoffFinder>();
    private Lst<Object> positions;
    private P3[] centerings;
    private static WyckoffFinder nullHelper;

    public WyckoffFinder() {
    }

    WyckoffFinder getWyckoffFinder(Viewer vwr, String sgname) {
        Lst its;
        Map<String, Object> resource;
        int itno;
        WyckoffFinder helper = helpers.get(sgname);
        if (helper == null && (itno = PT.parseInt(PT.split(sgname, ":")[0])) >= 1 && itno <= 230 && (resource = this.getResource(vwr, "ita_" + itno + ".json")) != null && (its = (Lst)resource.get("its")) != null) {
            int i = its.size();
            while (--i >= 0) {
                Map map = (Map)its.get(i);
                if (!sgname.equals(map.get("itaFull"))) continue;
                helper = new WyckoffFinder(map);
                helpers.put(sgname, helper);
                return helper;
            }
        }
        if (helper == null) {
            if (nullHelper == null) {
                nullHelper = new WyckoffFinder(null);
            }
            helpers.put(sgname, nullHelper);
        }
        return helper;
    }

    private WyckoffFinder(Map<String, Object> map) {
        if (map != null) {
            Map wpos = (Map)map.get("wpos");
            this.positions = (Lst)wpos.get("pos");
            Lst cent = (Lst)wpos.get("cent");
            if (cent != null) {
                this.centerings = new P3[cent.size()];
                int i = cent.size();
                while (--i >= 0) {
                    this.centerings[i] = WyckoffFinder.toPoint((String)cent.get(i));
                }
            }
        }
    }

    String getWyckoffPosition(P3 p) {
        if (this.positions == null) {
            return "?";
        }
        int i = this.positions.size();
        while (--i >= 0) {
            Map map = (Map)this.positions.get(i);
            if (i == 0) {
                return (String)map.get("label");
            }
            Lst coords = (Lst)map.get("coord");
            int n = coords.size();
            for (int c = 0; c < n; ++c) {
                Object coord = coords.get(c);
                if (coord instanceof String) {
                    coord = new WyckoffPos((String)coord);
                    coords.set(c, coord);
                }
                if (!((WyckoffPos)coord).contains(p, this.centerings)) continue;
                return (String)map.get("label");
            }
        }
        return "?";
    }

    private Map<String, Object> getResource(Viewer vwr, String resource) {
        try {
            BufferedReader r = FileManager.getBufferedReaderForResource(vwr, this, "org/jmol/symmetry/", "sg/json/" + resource);
            String[] data = new String[1];
            if (Rdr.readAllAsString(r, Integer.MAX_VALUE, false, data, 0)) {
                return (Map)new JSJSONParser().parse(data[0], true);
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    static P3 toPoint(String xyz) {
        String[] s = PT.split(xyz, ",");
        return P3.new3(PT.parseFloatFraction(s[0]), PT.parseFloatFraction(s[1]), PT.parseFloatFraction(s[2]));
    }

    static class WyckoffPos {
        static final int TYPE_POINT = 1;
        static final int TYPE_LINE = 2;
        static final int TYPE_PLANE = 3;
        private P3 point;
        private V3 line;
        private P4 plane;
        private int type;
        private static V3 vtemp1 = new V3();

        public WyckoffPos(WyckoffPos wp, P3 offset) {
            this.type = wp.type;
            switch (this.type) {
                case 1: 
                case 2: {
                    this.point = P3.newP(wp.point);
                    this.point.add(offset);
                    WyckoffPos.unitize(this.point);
                    this.line = wp.line;
                    break;
                }
                case 3: {
                    this.plane = P4.newPt(wp.plane);
                    this.plane.w -= offset.dot(this.plane);
                }
            }
        }

        private static P3 unitize(P3 p) {
            SimpleUnitCell.unitizeDim(3, p);
            return p;
        }

        public WyckoffPos(String xyz) {
            this.create(xyz);
        }

        private void create(String p) {
            String[] xyz = PT.split(p, ",");
            int nxyz = 0;
            for (int i = 0; i < 3; ++i) {
                if (xyz[i].indexOf(120) >= 0) {
                    nxyz |= 1;
                }
                if (xyz[i].indexOf(121) >= 0) {
                    nxyz |= 2;
                }
                if (xyz[i].indexOf(122) < 0) continue;
                nxyz |= 4;
            }
            switch (nxyz) {
                case 0: {
                    this.type = 1;
                    this.point = WyckoffFinder.toPoint(p);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.type = 2;
                    P3 v1 = WyckoffPos.ptFor(p, 0.0f, 0.0f, 0.0f);
                    P3 v2 = WyckoffPos.ptFor(p, 1.0f, 1.27f, 1.64f);
                    v2.sub2(v2, v1);
                    v2.normalize();
                    this.point = WyckoffPos.unitize(P3.newP(v1));
                    this.line = V3.newV(v2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    this.type = 3;
                    P3 v1 = WyckoffPos.ptFor(p, 0.0f, 0.0f, 0.0f);
                    P3 v2 = WyckoffPos.ptFor(p, 1.23f, 1.47f, 1.86f);
                    P3 v3 = WyckoffPos.ptFor(p, 0.1f, 0.2f, 0.3f);
                    this.plane = Measure.getPlaneThroughPoints(v1, v2, v3, null, null, new P4());
                    break;
                }
            }
        }

        private static P3 ptFor(String p, float x, float y, float z) {
            String[] v = PT.split(p, ",");
            float a = WyckoffPos.decodeXYZ(v[0], x, y, z);
            float b = WyckoffPos.decodeXYZ(v[1], x, y, z);
            float c = WyckoffPos.decodeXYZ(v[2], x, y, z);
            return P3.new3(a, b, c);
        }

        private static float decodeXYZ(String s, float x, float y, float z) {
            s = PT.rep(s, "-", "+-");
            s = PT.rep(s, "x", "*x");
            s = PT.rep(s, "y", "*y");
            s = PT.rep(s, "z", "*z");
            s = PT.rep(s, "-*", "-");
            s = PT.rep(s, "+*", "+");
            float r = 0.0f;
            String[] parts = PT.split(s, "+");
            int p = parts.length;
            while (--p >= 0) {
                s = parts[p];
                if (s.length() == 0) continue;
                if (s.indexOf(46) >= 0) {
                    r += PT.parseFloat(s);
                    continue;
                }
                float v = 0.0f;
                int f2 = 0;
                int i0 = 0;
                float f = 1.0f;
                switch (s.charAt(0)) {
                    case '-': {
                        f = -1.0f;
                    }
                    case '*': {
                        ++i0;
                    }
                }
                int i = s.length();
                block12: while (--i >= i0) {
                    char c = s.charAt(i);
                    switch (c) {
                        case 'x': {
                            v = x;
                            continue block12;
                        }
                        case 'y': {
                            v = y;
                            continue block12;
                        }
                        case 'z': {
                            v = z;
                            continue block12;
                        }
                        case '/': {
                            v = 1.0f / v;
                        }
                        case '*': {
                            f *= v;
                            v = 0.0f;
                            continue block12;
                        }
                    }
                    int u = "0123456789".indexOf(c);
                    if (u < 0) {
                        System.err.println("WH ????");
                    }
                    if (v == 0.0f) {
                        v = u;
                        continue;
                    }
                    f2 = f2 == 0 ? 10 : f2 * 10;
                    v += (float)(f2 * u);
                }
                r += f * v;
            }
            return r;
        }

        boolean contains(P3 p, P3[] centerings) {
            if (this.containsPt(p)) {
                return true;
            }
            P3 pc = new P3();
            if (centerings != null) {
                int i = centerings.length;
                while (--i >= 0) {
                    pc.add2(p, centerings[i]);
                    WyckoffPos.unitize(pc);
                    if (!this.containsPt(pc)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean containsPt(P3 p) {
            float d = 1.0f;
            switch (this.type) {
                case 1: {
                    d = p.distance(this.point);
                    break;
                }
                case 2: {
                    P3 p1 = P3.newP(p);
                    Measure.projectOntoAxis(p1, this.point, this.line, vtemp1);
                    d = p.distance(p1);
                    break;
                }
                case 3: {
                    d = Measure.distanceToPlane(this.plane, p);
                }
            }
            return WyckoffPos.approx(d) == 0.0f;
        }

        private static float approx(float d) {
            return PT.approx(d, 1000.0f);
        }
    }
}

