/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLibUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TlbBase {
    public static final String CR = "\n";
    public static final String CRCR = "\n\n";
    public static final String TAB = "\t";
    public static final String TABTAB = "\t\t";
    protected TypeLibUtil typeLibUtil;
    protected TypeInfoUtil typeInfoUtil;
    protected int index;
    protected StringBuffer templateBuffer;
    protected StringBuffer classBuffer;
    protected String content = "";
    protected String filename = "DefaultFilename";
    protected String name = "DefaultName";
    public static String[] IUNKNOWN_METHODS = new String[]{"QueryInterface", "AddRef", "Release"};
    public static String[] IDISPATCH_METHODS = new String[]{"GetTypeInfoCount", "GetTypeInfo", "GetIDsOfNames", "Invoke"};
    protected String bindingMode = "dispid";

    public TlbBase(int index2, TypeLibUtil typeLibUtil, TypeInfoUtil typeInfoUtil) {
        this(index2, typeLibUtil, typeInfoUtil, "dispid");
    }

    public TlbBase(int index2, TypeLibUtil typeLibUtil, TypeInfoUtil typeInfoUtil, String bindingMode) {
        this.index = index2;
        this.typeLibUtil = typeLibUtil;
        this.typeInfoUtil = typeInfoUtil;
        this.bindingMode = bindingMode;
        String filename = this.getClassTemplate();
        try {
            this.readTemplateFile(filename);
            this.classBuffer = this.templateBuffer;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void logError(String msg2) {
        this.log("ERROR", msg2);
    }

    public void logInfo(String msg2) {
        this.log("INFO", msg2);
    }

    public StringBuffer getClassBuffer() {
        return this.classBuffer;
    }

    public void createContent(String content2) {
        this.replaceVariable("content", content2);
    }

    public void setFilename(String filename) {
        if (!filename.endsWith("java")) {
            filename = filename + ".java";
        }
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    protected void log(String level, String msg2) {
        String _msg = level + " " + this.getTime() + " : " + msg2;
        System.out.println(_msg);
    }

    private String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(new Date());
    }

    protected abstract String getClassTemplate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTemplateFile(String filename) throws IOException {
        this.templateBuffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.templateBuffer.append(line + CR);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected void replaceVariable(String name2, String value2) {
        if (value2 == null) {
            value2 = "";
        }
        Pattern pattern = Pattern.compile("\\$\\{" + name2 + "\\}");
        Matcher matcher = pattern.matcher(this.classBuffer);
        String replacement = value2;
        String result2 = "";
        while (matcher.find()) {
            result2 = matcher.replaceAll(replacement);
        }
        if (result2.length() > 0) {
            this.classBuffer = new StringBuffer(result2);
        }
    }

    protected void createPackageName(String packagename) {
        this.replaceVariable("packagename", packagename);
    }

    protected void createClassName(String name2) {
        this.replaceVariable("classname", name2);
    }

    protected boolean isReservedMethod(String method) {
        int i;
        for (i = 0; i < IUNKNOWN_METHODS.length; ++i) {
            if (!IUNKNOWN_METHODS[i].equalsIgnoreCase(method)) continue;
            return true;
        }
        for (i = 0; i < IDISPATCH_METHODS.length; ++i) {
            if (!IDISPATCH_METHODS[i].equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    protected boolean isVTableMode() {
        return this.bindingMode.equalsIgnoreCase("vtable");
    }

    protected boolean isDispIdMode() {
        return this.bindingMode.equalsIgnoreCase("dispid");
    }
}

