/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.addRemoveModifier;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0000\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0018\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0010\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"0\u0010\u0006\u001a$\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"MODIFIERS_ORDER", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "getMODIFIERS_ORDER", "()Ljava/util/List;", "MODIFIERS_TO_REPLACE", "", "addAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "owner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "annotationEntry", "addModifier", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "modifier", "createModifierList", "text", "", "removeModifier", "sortModifiers", "modifiers", "addModifierList", "newModifierList", "setModifierList", "psi"})
@SourceDebugExtension(value={"SMAP\naddRemoveModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 addRemoveModifier.kt\norg/jetbrains/kotlin/psi/addRemoveModifier/AddRemoveModifierKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,163:1\n1603#2,9:164\n1855#2:173\n1856#2:175\n1612#2:176\n1045#2:179\n1#3:174\n179#4,2:177\n*S KotlinDebug\n*F\n+ 1 addRemoveModifier.kt\norg/jetbrains/kotlin/psi/addRemoveModifier/AddRemoveModifierKt\n*L\n60#1:164,9\n60#1:173\n60#1:175\n60#1:176\n122#1:179\n60#1:174\n87#1:177,2\n*E\n"})
public final class AddRemoveModifierKt {
    @NotNull
    private static final Map<KtModifierKeywordToken, List<KtModifierKeywordToken>> MODIFIERS_TO_REPLACE;
    @NotNull
    private static final List<KtModifierKeywordToken> MODIFIERS_ORDER;

    private static final KtModifierList addModifierList(KtModifierListOwner $this$addModifierList, KtModifierList newModifierList) {
        PsiElement psiElement = $this$addModifierList.getFirstChild();
        Intrinsics.checkNotNull(psiElement);
        PsiElement anchor2 = (PsiElement)SequencesKt.first(SequencesKt.dropWhile(PsiUtilsKt.siblings$default(psiElement, true, false, 2, null), addModifierList.anchor.1.INSTANCE));
        PsiElement psiElement2 = $this$addModifierList.addBefore(newModifierList, anchor2);
        Intrinsics.checkNotNull(psiElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
        return (KtModifierList)psiElement2;
    }

    private static final KtModifierList createModifierList(String text2, KtModifierListOwner owner) {
        Project project = owner.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "owner.project");
        return AddRemoveModifierKt.addModifierList(owner, new KtPsiFactory(project, false, 2, null).createModifierList(text2));
    }

    public static final void setModifierList(@NotNull KtModifierListOwner $this$setModifierList, @NotNull KtModifierList newModifierList) {
        Intrinsics.checkNotNullParameter($this$setModifierList, "<this>");
        Intrinsics.checkNotNullParameter(newModifierList, "newModifierList");
        KtModifierList currentModifierList = $this$setModifierList.getModifierList();
        if (currentModifierList != null) {
            currentModifierList.replace(newModifierList);
        } else {
            AddRemoveModifierKt.addModifierList($this$setModifierList, newModifierList);
        }
    }

    public static final void addModifier(@NotNull KtModifierListOwner owner, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        KtModifierList modifierList2 = owner.getModifierList();
        if (modifierList2 == null) {
            String string2 = modifier.getValue();
            Intrinsics.checkNotNullExpressionValue(string2, "modifier.value");
            AddRemoveModifierKt.createModifierList(string2, owner);
        } else {
            AddRemoveModifierKt.addModifier(modifierList2, modifier);
        }
    }

    @NotNull
    public static final KtAnnotationEntry addAnnotationEntry(@NotNull KtModifierListOwner owner, @NotNull KtAnnotationEntry annotationEntry) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(annotationEntry, "annotationEntry");
        KtModifierList modifierList2 = owner.getModifierList();
        if (modifierList2 == null) {
            String string2 = annotationEntry.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "annotationEntry.text");
            List<KtAnnotationEntry> list2 = AddRemoveModifierKt.createModifierList(string2, owner).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "createModifierList(annot\u2026 owner).annotationEntries");
            KtAnnotationEntry ktAnnotationEntry2 = CollectionsKt.first(list2);
            Intrinsics.checkNotNullExpressionValue(ktAnnotationEntry2, "{\n        createModifier\u2026tionEntries.first()\n    }");
            ktAnnotationEntry = ktAnnotationEntry2;
        } else {
            PsiElement psiElement = modifierList2.addBefore(annotationEntry, modifierList2.getFirstChild());
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        }
        return ktAnnotationEntry;
    }

    /*
     * WARNING - void declaration
     */
    public static final void addModifier(@NotNull KtModifierList modifierList2, @NotNull KtModifierKeywordToken modifier) {
        PsiElement modifierToReplace;
        PsiElement psiElement;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter(modifierList2, "modifierList");
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        if (modifierList2.hasModifier(modifier)) {
            return;
        }
        Project project = modifierList2.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "modifierList.project");
        PsiElement newModifier = new KtPsiFactory(project, false, 2, null).createModifier(modifier);
        List<KtModifierKeywordToken> list2 = MODIFIERS_TO_REPLACE.get(modifier);
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list2;
            boolean $i$f$mapNotNull = false;
            psiElement2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                boolean bl2 = false;
                if (modifierList2.getModifier(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            psiElement = (PsiElement)CollectionsKt.firstOrNull((List)destination$iv$iv);
        } else {
            psiElement = modifierToReplace = null;
        }
        if (Intrinsics.areEqual(modifier, KtTokens.FINAL_KEYWORD) && !modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            if (modifierToReplace != null) {
                modifierToReplace.delete();
                if (modifierList2.getFirstChild() == null) {
                    modifierList2.delete();
                }
            }
            return;
        }
        if (modifierToReplace != null && Intrinsics.areEqual(modifierList2.getFirstChild(), modifierList2.getLastChild())) {
            modifierToReplace.replace(newModifier);
        } else {
            PsiElement psiElement3;
            PsiElement psiElement4 = modifierToReplace;
            if (psiElement4 != null) {
                psiElement4.delete();
            }
            int newModifierOrder = MODIFIERS_ORDER.indexOf(modifier);
            PsiElement lastChild = modifierList2.getLastChild();
            Object object = lastChild;
            if (object != null && (object = PsiUtilsKt.siblings$default((PsiElement)object, false, false, 2, null)) != null) {
                Object v4;
                block16: {
                    Object $this$firstOrNull$iv = object;
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator3 = $this$firstOrNull$iv.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv = iterator3.next();
                        PsiElement p0 = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!AddRemoveModifierKt.addModifier$placeAfter(newModifierOrder, p0)) continue;
                        v4 = element$iv;
                        break block16;
                    }
                    v4 = null;
                }
                psiElement3 = v4;
            } else {
                psiElement3 = null;
            }
            PsiElement it = psiElement3;
            boolean bl = false;
            PsiElement psiElement5 = it;
            PsiElement anchor2 = (psiElement5 != null ? psiElement5.getNextSibling() : null) instanceof PsiWhiteSpace && (it instanceof KtAnnotation || it instanceof KtAnnotationEntry || it instanceof PsiComment) ? it.getNextSibling() : (it == null && modifierList2.getFirstChild() instanceof PsiWhiteSpace ? modifierList2.getFirstChild() : it);
            modifierList2.addAfter(newModifier, anchor2);
            if (Intrinsics.areEqual(anchor2, lastChild)) {
                PsiWhiteSpace whiteSpace;
                psiElement2 = modifierList2.getNextSibling();
                PsiWhiteSpace psiWhiteSpace = whiteSpace = psiElement2 instanceof PsiWhiteSpace ? (PsiWhiteSpace)psiElement2 : null;
                if (whiteSpace != null) {
                    String string2 = whiteSpace.getText();
                    Intrinsics.checkNotNullExpressionValue(string2, "whiteSpace.text");
                    if (StringsKt.contains$default((CharSequence)string2, '\n', false, 2, null)) {
                        modifierList2.addAfter(whiteSpace, anchor2);
                        whiteSpace.delete();
                    }
                }
            }
        }
    }

    public static final void removeModifier(@NotNull KtModifierListOwner owner, @NotNull KtModifierKeywordToken modifier) {
        block3: {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(modifier, "modifier");
            KtModifierList ktModifierList = owner.getModifierList();
            if (ktModifierList == null) break block3;
            KtModifierList it = ktModifierList;
            boolean bl = false;
            PsiElement psiElement = it.getModifier(modifier);
            if (psiElement != null) {
                psiElement.delete();
            }
            if (it.getFirstChild() == null) {
                it.delete();
                return;
            }
            PsiElement lastChild = it.getLastChild();
            if (lastChild instanceof PsiComment) {
                Project project = owner.getProject();
                Intrinsics.checkNotNullExpressionValue(project, "owner.project");
                it.addAfter(new KtPsiFactory(project, false, 2, null).createNewLine(), lastChild);
            }
        }
    }

    @NotNull
    public static final List<KtModifierKeywordToken> sortModifiers(@NotNull List<KtModifierKeywordToken> modifiers) {
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        Iterable $this$sortedBy$iv = modifiers;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                KtModifierKeywordToken it = (KtModifierKeywordToken)a;
                boolean bl = false;
                int index2 = AddRemoveModifierKt.getMODIFIERS_ORDER().indexOf(it);
                int n = index2 == -1 ? Integer.MAX_VALUE : index2;
                it = (KtModifierKeywordToken)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                index2 = AddRemoveModifierKt.getMODIFIERS_ORDER().indexOf(it);
                return ComparisonsKt.compareValues(comparable, index2 == -1 ? Integer.MAX_VALUE : index2);
            }
        });
    }

    @NotNull
    public static final List<KtModifierKeywordToken> getMODIFIERS_ORDER() {
        return MODIFIERS_ORDER;
    }

    private static final boolean addModifier$placeAfter(int newModifierOrder, PsiElement child) {
        if (child instanceof PsiWhiteSpace) {
            return false;
        }
        if (child instanceof KtAnnotation || child instanceof KtAnnotationEntry) {
            return true;
        }
        ASTNode aSTNode = child.getNode();
        Intrinsics.checkNotNull(aSTNode);
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "child.node!!.elementType");
        IElementType elementType = iElementType;
        int order = CollectionsKt.indexOf(MODIFIERS_ORDER, elementType);
        return newModifierOrder > order;
    }

    static {
        Object[] objectArray = new Pair[12];
        objectArray[0] = TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, CollectionsKt.listOf(KtTokens.OPEN_KEYWORD));
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.OPEN_KEYWORD, KtTokens.FINAL_KEYWORD};
        objectArray[1] = TuplesKt.to(KtTokens.ABSTRACT_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.FINAL_KEYWORD, KtTokens.ABSTRACT_KEYWORD};
        objectArray[2] = TuplesKt.to(KtTokens.OPEN_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD};
        objectArray[3] = TuplesKt.to(KtTokens.FINAL_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD};
        objectArray[4] = TuplesKt.to(KtTokens.PUBLIC_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD};
        objectArray[5] = TuplesKt.to(KtTokens.PROTECTED_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.INTERNAL_KEYWORD};
        objectArray[6] = TuplesKt.to(KtTokens.PRIVATE_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD};
        objectArray[7] = TuplesKt.to(KtTokens.INTERNAL_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.IMPL_KEYWORD, KtTokens.ACTUAL_KEYWORD, KtTokens.EXPECT_KEYWORD};
        objectArray[8] = TuplesKt.to(KtTokens.HEADER_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.HEADER_KEYWORD, KtTokens.EXPECT_KEYWORD, KtTokens.ACTUAL_KEYWORD};
        objectArray[9] = TuplesKt.to(KtTokens.IMPL_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.IMPL_KEYWORD, KtTokens.ACTUAL_KEYWORD, KtTokens.HEADER_KEYWORD};
        objectArray[10] = TuplesKt.to(KtTokens.EXPECT_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.HEADER_KEYWORD, KtTokens.EXPECT_KEYWORD, KtTokens.IMPL_KEYWORD};
        objectArray[11] = TuplesKt.to(KtTokens.ACTUAL_KEYWORD, CollectionsKt.listOf(ktModifierKeywordTokenArray));
        MODIFIERS_TO_REPLACE = MapsKt.mapOf(objectArray);
        objectArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD, KtTokens.HEADER_KEYWORD, KtTokens.IMPL_KEYWORD, KtTokens.EXPECT_KEYWORD, KtTokens.ACTUAL_KEYWORD, KtTokens.FINAL_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.ABSTRACT_KEYWORD, KtTokens.SEALED_KEYWORD, KtTokens.CONST_KEYWORD, KtTokens.EXTERNAL_KEYWORD, KtTokens.OVERRIDE_KEYWORD, KtTokens.LATEINIT_KEYWORD, KtTokens.TAILREC_KEYWORD, KtTokens.VARARG_KEYWORD, KtTokens.SUSPEND_KEYWORD, KtTokens.INNER_KEYWORD, KtTokens.ENUM_KEYWORD, KtTokens.ANNOTATION_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.COMPANION_KEYWORD, KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD, KtTokens.INFIX_KEYWORD, KtTokens.OPERATOR_KEYWORD, KtTokens.DATA_KEYWORD};
        MODIFIERS_ORDER = CollectionsKt.listOf(objectArray);
    }
}

