/* hashset.c generated by valac 0.56.3, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 * Copyright (C) 2009-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "gee.h"
#include <glib.h>
#include <glib-object.h>

#define GEE_HASH_SET_MIN_SIZE 11
#define GEE_HASH_SET_MAX_SIZE 13845163

typedef struct _GeeHashSetNode GeeHashSetNode;

#define GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE (gee_functions_hash_data_func_closure_get_type ())
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosure))
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_HASH_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_HASH_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosureClass))

typedef struct _GeeFunctionsHashDataFuncClosure GeeFunctionsHashDataFuncClosure;
typedef struct _GeeFunctionsHashDataFuncClosureClass GeeFunctionsHashDataFuncClosureClass;

#define GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE (gee_functions_equal_data_func_closure_get_type ())
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))

typedef struct _GeeFunctionsEqualDataFuncClosure GeeFunctionsEqualDataFuncClosure;
typedef struct _GeeFunctionsEqualDataFuncClosureClass GeeFunctionsEqualDataFuncClosureClass;
enum  {
	GEE_HASH_SET_0_PROPERTY,
	GEE_HASH_SET_G_TYPE,
	GEE_HASH_SET_G_DUP_FUNC,
	GEE_HASH_SET_G_DESTROY_FUNC,
	GEE_HASH_SET_SIZE_PROPERTY,
	GEE_HASH_SET_READ_ONLY_PROPERTY,
	GEE_HASH_SET_NUM_PROPERTIES
};
static GParamSpec* gee_hash_set_properties[GEE_HASH_SET_NUM_PROPERTIES];
#define _gee_functions_hash_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_hash_data_func_closure_unref (var), NULL)))
#define _gee_functions_equal_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_equal_data_func_closure_unref (var), NULL)))

#define GEE_HASH_SET_TYPE_ITERATOR (gee_hash_set_iterator_get_type ())
#define GEE_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator))
#define GEE_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))
#define GEE_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))

typedef struct _GeeHashSetIterator GeeHashSetIterator;
typedef struct _GeeHashSetIteratorClass GeeHashSetIteratorClass;
#define _gee_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_hash_set_node_free (var), NULL)))
typedef struct _GeeFunctionsHashDataFuncClosurePrivate GeeFunctionsHashDataFuncClosurePrivate;
typedef struct _GeeFunctionsEqualDataFuncClosurePrivate GeeFunctionsEqualDataFuncClosurePrivate;
typedef struct _GeeHashSetIteratorPrivate GeeHashSetIteratorPrivate;
enum  {
	GEE_HASH_SET_ITERATOR_0_PROPERTY,
	GEE_HASH_SET_ITERATOR_G_TYPE,
	GEE_HASH_SET_ITERATOR_G_DUP_FUNC,
	GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC,
	GEE_HASH_SET_ITERATOR_READ_ONLY_PROPERTY,
	GEE_HASH_SET_ITERATOR_VALID_PROPERTY,
	GEE_HASH_SET_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_hash_set_iterator_properties[GEE_HASH_SET_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _array_size;
	gint _nnodes;
	GeeHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	GeeFunctionsHashDataFuncClosure* _hash_func;
	GeeFunctionsEqualDataFuncClosure* _equal_func;
	gint _stamp;
};

struct _GeeHashSetNode {
	gpointer key;
	GeeHashSetNode* next;
	guint key_hash;
};

struct _GeeFunctionsHashDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsHashDataFuncClosurePrivate * priv;
	GeeHashDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsHashDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsHashDataFuncClosure *self);
};

struct _GeeFunctionsEqualDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsEqualDataFuncClosurePrivate * priv;
	GeeEqualDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsEqualDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsEqualDataFuncClosure *self);
};

struct _GeeHashSetIterator {
	GObject parent_instance;
	GeeHashSetIteratorPrivate * priv;
	GeeHashSet* _set;
	gint _index;
	GeeHashSetNode* _node;
	GeeHashSetNode* _next;
	gint _stamp;
};

struct _GeeHashSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

static gint GeeHashSet_private_offset;
static gpointer gee_hash_set_parent_class = NULL;
static gint GeeHashSetIterator_private_offset;
static gpointer gee_hash_set_iterator_parent_class = NULL;
static GeeTraversableIface * gee_hash_set_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_hash_set_iterator_gee_iterator_parent_iface = NULL;

static void gee_hash_set_node_free (GeeHashSetNode * self);
 G_GNUC_INTERNAL gpointer gee_functions_hash_data_func_closure_ref (gpointer instance);
 G_GNUC_INTERNAL void gee_functions_hash_data_func_closure_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_hash_data_func_closure (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
 G_GNUC_INTERNAL void gee_functions_value_set_hash_data_func_closure (GValue* value,
                                                     gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void gee_functions_value_take_hash_data_func_closure (GValue* value,
                                                      gpointer v_object);
 G_GNUC_INTERNAL gpointer gee_functions_value_get_hash_data_func_closure (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gee_functions_hash_data_func_closure_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL gpointer gee_functions_equal_data_func_closure_ref (gpointer instance);
 G_GNUC_INTERNAL void gee_functions_equal_data_func_closure_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_equal_data_func_closure (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags);
 G_GNUC_INTERNAL void gee_functions_value_set_equal_data_func_closure (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void gee_functions_value_take_equal_data_func_closure (GValue* value,
                                                       gpointer v_object);
 G_GNUC_INTERNAL gpointer gee_functions_value_get_equal_data_func_closure (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gee_functions_equal_data_func_closure_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GeeFunctionsHashDataFuncClosure* gee_functions_hash_data_func_closure_new (GType g_type,
                                                                           GBoxedCopyFunc g_dup_func,
                                                                           GDestroyNotify g_destroy_func,
                                                                           GeeHashDataFunc func,
                                                                           gpointer func_target,
                                                                           GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeFunctionsHashDataFuncClosure* gee_functions_hash_data_func_closure_construct (GType object_type,
                                                                                 GType g_type,
                                                                                 GBoxedCopyFunc g_dup_func,
                                                                                 GDestroyNotify g_destroy_func,
                                                                                 GeeHashDataFunc func,
                                                                                 gpointer func_target,
                                                                                 GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_new (GType g_type,
                                                                             GBoxedCopyFunc g_dup_func,
                                                                             GDestroyNotify g_destroy_func,
                                                                             GeeEqualDataFunc func,
                                                                             gpointer func_target,
                                                                             GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_construct (GType object_type,
                                                                                   GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   GeeEqualDataFunc func,
                                                                                   gpointer func_target,
                                                                                   GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeHashSet* gee_hash_set_new_with_closures (GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            GeeFunctionsHashDataFuncClosure* hash_func,
                                            GeeFunctionsEqualDataFuncClosure* equal_func);
 G_GNUC_INTERNAL GeeHashSet* gee_hash_set_construct_with_closures (GType object_type,
                                                  GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  GeeFunctionsHashDataFuncClosure* hash_func,
                                                  GeeFunctionsEqualDataFuncClosure* equal_func);
static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self,
                                           gconstpointer key);
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base,
                                     gconstpointer key);
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base);
static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               GeeHashSet* set);
static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeHashSet* set);
static GType gee_hash_set_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base,
                                gconstpointer key);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k,
                                       guint hash);
static void gee_hash_set_resize (GeeHashSet* self);
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base,
                                   gconstpointer key);
static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self,
                                     gconstpointer key);
static void gee_hash_set_real_clear (GeeAbstractCollection* base);
static gboolean gee_hash_set_real_foreach (GeeAbstractCollection* base,
                                    GeeForallFunc f,
                                    gpointer f_target);
static void gee_hash_set_set_hash_func (GeeHashSet* self,
                                 GeeHashDataFunc value,
                                 gpointer value_target);
static void gee_hash_set_set_equal_func (GeeHashSet* self,
                                  GeeEqualDataFunc value,
                                  gpointer value_target);
static void gee_hash_set_node_instance_init (GeeHashSetNode * self);
static GeeHashSetIterator* gee_hash_set_iterator_new_from_iterator (GType g_type,
                                                             GBoxedCopyFunc g_dup_func,
                                                             GDestroyNotify g_destroy_func,
                                                             GeeHashSetIterator* iter);
static GeeHashSetIterator* gee_hash_set_iterator_construct_from_iterator (GType object_type,
                                                                   GType g_type,
                                                                   GBoxedCopyFunc g_dup_func,
                                                                   GDestroyNotify g_destroy_func,
                                                                   GeeHashSetIterator* iter);
static gboolean gee_hash_set_iterator_real_next (GeeIterator* base);
static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base);
static gpointer gee_hash_set_iterator_real_get (GeeIterator* base);
static void gee_hash_set_iterator_real_remove (GeeIterator* base);
static gboolean gee_hash_set_iterator_real_foreach (GeeTraversable* base,
                                             GeeForallFunc f,
                                             gpointer f_target);
static GeeIterator** gee_hash_set_iterator_real_tee (GeeTraversable* base,
                                              guint forks,
                                              gint* result_length1);
static void gee_hash_set_iterator_finalize (GObject * obj);
static GType gee_hash_set_iterator_get_type_once (void);
static void _vala_gee_hash_set_iterator_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gee_hash_set_iterator_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void gee_hash_set_finalize (GObject * obj);
static GType gee_hash_set_get_type_once (void);
static void _vala_gee_hash_set_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_gee_hash_set_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gee_hash_set_get_instance_private (GeeHashSet* self)
{
	return G_STRUCT_MEMBER_P (self, GeeHashSet_private_offset);
}

/**
 * Constructs a new, empty hash set.
 *
 * If not provided, the functions parameters are requested to the
 * {@link Functions} function factory methods.
 *
 * @param hash_func an optional hash function
 * @param equal_func an optional equality testing function
 */
GeeHashSet*
gee_hash_set_construct (GType object_type,
                        GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func,
                        GeeHashDataFunc hash_func,
                        gpointer hash_func_target,
                        GDestroyNotify hash_func_target_destroy_notify,
                        GeeEqualDataFunc equal_func,
                        gpointer equal_func_target,
                        GDestroyNotify equal_func_target_destroy_notify)
{
	GeeHashSet * self = NULL;
	GeeHashDataFunc _tmp6_;
	gpointer _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	GeeFunctionsHashDataFuncClosure* _tmp7_;
	GeeEqualDataFunc _tmp8_;
	gpointer _tmp8__target;
	GDestroyNotify _tmp8__target_destroy_notify;
	GeeFunctionsEqualDataFuncClosure* _tmp9_;
	GeeHashSetNode** _tmp10_;
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (hash_func == NULL) {
		gpointer _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GeeHashDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_hash_func_for (g_type, &_tmp0_, &_tmp1_);
		(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
		hash_func = NULL;
		hash_func_target = NULL;
		hash_func_target_destroy_notify = NULL;
		hash_func = _tmp2_;
		hash_func_target = _tmp0_;
		hash_func_target_destroy_notify = _tmp1_;
	}
	if (equal_func == NULL) {
		gpointer _tmp3_ = NULL;
		GDestroyNotify _tmp4_ = NULL;
		GeeEqualDataFunc _tmp5_;
		_tmp5_ = gee_functions_get_equal_func_for (g_type, &_tmp3_, &_tmp4_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp5_;
		equal_func_target = _tmp3_;
		equal_func_target_destroy_notify = _tmp4_;
	}
	_tmp6_ = hash_func;
	_tmp6__target = hash_func_target;
	_tmp6__target_destroy_notify = hash_func_target_destroy_notify;
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	_tmp7_ = gee_functions_hash_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify);
	_gee_functions_hash_data_func_closure_unref0 (self->priv->_hash_func);
	self->priv->_hash_func = _tmp7_;
	_tmp8_ = equal_func;
	_tmp8__target = equal_func_target;
	_tmp8__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp9_ = gee_functions_equal_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp9_;
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
	_tmp10_ = g_new0 (GeeHashSetNode*, self->priv->_array_size + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	self->priv->_nodes = _tmp10_;
	self->priv->_nodes_length1 = self->priv->_array_size;
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

GeeHashSet*
gee_hash_set_new (GType g_type,
                  GBoxedCopyFunc g_dup_func,
                  GDestroyNotify g_destroy_func,
                  GeeHashDataFunc hash_func,
                  gpointer hash_func_target,
                  GDestroyNotify hash_func_target_destroy_notify,
                  GeeEqualDataFunc equal_func,
                  gpointer equal_func_target,
                  GDestroyNotify equal_func_target_destroy_notify)
{
	return gee_hash_set_construct (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, hash_func_target, hash_func_target_destroy_notify, equal_func, equal_func_target, equal_func_target_destroy_notify);
}

static gpointer
_gee_functions_hash_data_func_closure_ref0 (gpointer self)
{
	return self ? gee_functions_hash_data_func_closure_ref (self) : NULL;
}

static gpointer
_gee_functions_equal_data_func_closure_ref0 (gpointer self)
{
	return self ? gee_functions_equal_data_func_closure_ref (self) : NULL;
}

 G_GNUC_INTERNAL GeeHashSet*
gee_hash_set_construct_with_closures (GType object_type,
                                      GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      GeeFunctionsHashDataFuncClosure* hash_func,
                                      GeeFunctionsEqualDataFuncClosure* equal_func)
{
	GeeHashSet * self = NULL;
	GeeFunctionsHashDataFuncClosure* _tmp0_;
	GeeFunctionsEqualDataFuncClosure* _tmp1_;
	GeeHashSetNode** _tmp2_;
	g_return_val_if_fail (hash_func != NULL, NULL);
	g_return_val_if_fail (equal_func != NULL, NULL);
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _gee_functions_hash_data_func_closure_ref0 (hash_func);
	_gee_functions_hash_data_func_closure_unref0 (self->priv->_hash_func);
	self->priv->_hash_func = _tmp0_;
	_tmp1_ = _gee_functions_equal_data_func_closure_ref0 (equal_func);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp1_;
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
	_tmp2_ = g_new0 (GeeHashSetNode*, self->priv->_array_size + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	self->priv->_nodes = _tmp2_;
	self->priv->_nodes_length1 = self->priv->_array_size;
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
	_gee_functions_hash_data_func_closure_unref0 (hash_func);
	_gee_functions_equal_data_func_closure_unref0 (equal_func);
	return self;
}

 G_GNUC_INTERNAL GeeHashSet*
gee_hash_set_new_with_closures (GType g_type,
                                GBoxedCopyFunc g_dup_func,
                                GDestroyNotify g_destroy_func,
                                GeeFunctionsHashDataFuncClosure* hash_func,
                                GeeFunctionsEqualDataFuncClosure* equal_func)
{
	return gee_hash_set_construct_with_closures (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
}

static GeeHashSetNode**
gee_hash_set_lookup_node (GeeHashSet* self,
                          gconstpointer key)
{
	guint hash_value = 0U;
	GeeHashDataFunc _tmp0_ = NULL;
	gpointer _tmp0__target = NULL;
	GeeHashDataFunc _tmp1_;
	gpointer _tmp1__target;
	GeeHashSetNode** node = NULL;
	GeeHashSetNode** _tmp2_;
	gint _tmp2__length1;
	GeeHashSetNode** _tmp12_;
	GeeHashSetNode** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_set_get_hash_func (self, &_tmp0__target);
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	hash_value = _tmp1_ (key, _tmp1__target);
	_tmp2_ = self->priv->_nodes;
	_tmp2__length1 = self->priv->_nodes_length1;
	node = &_tmp2_[hash_value % self->priv->_array_size];
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		GeeHashSetNode** _tmp4_;
		GeeHashSetNode** _tmp11_;
		_tmp4_ = node;
		if ((*_tmp4_) != NULL) {
			gboolean _tmp5_ = FALSE;
			GeeHashSetNode** _tmp6_;
			_tmp6_ = node;
			if (hash_value != (*_tmp6_)->key_hash) {
				_tmp5_ = TRUE;
			} else {
				GeeEqualDataFunc _tmp7_ = NULL;
				gpointer _tmp7__target = NULL;
				GeeEqualDataFunc _tmp8_;
				gpointer _tmp8__target;
				GeeHashSetNode** _tmp9_;
				gconstpointer _tmp10_;
				_tmp7_ = gee_hash_set_get_equal_func (self, &_tmp7__target);
				_tmp8_ = _tmp7_;
				_tmp8__target = _tmp7__target;
				_tmp9_ = node;
				_tmp10_ = (*_tmp9_)->key;
				_tmp5_ = !_tmp8_ (_tmp10_, key, _tmp8__target);
			}
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp11_ = node;
		node = &(*_tmp11_)->next;
	}
	_tmp12_ = node;
	result = _tmp12_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_hash_set_real_contains (GeeAbstractCollection* base,
                            gconstpointer key)
{
	GeeHashSet * self;
	GeeHashSetNode** node = NULL;
	GeeHashSetNode** _tmp0_;
	gboolean result;
	self = (GeeHashSet*) base;
	_tmp0_ = gee_hash_set_lookup_node (self, key);
	node = _tmp0_;
	result = (*node) != NULL;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_hash_set_real_iterator (GeeAbstractCollection* base)
{
	GeeHashSet * self;
	GeeHashSetIterator* _tmp0_;
	GeeIterator* result;
	self = (GeeHashSet*) base;
	_tmp0_ = gee_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_hash_set_real_add (GeeAbstractCollection* base,
                       gconstpointer key)
{
	GeeHashSet * self;
	GeeHashSetNode** node = NULL;
	GeeHashSetNode** _tmp0_;
	GeeHashSetNode** _tmp1_;
	gboolean result;
	self = (GeeHashSet*) base;
	_tmp0_ = gee_hash_set_lookup_node (self, key);
	node = _tmp0_;
	_tmp1_ = node;
	if ((*_tmp1_) != NULL) {
		result = FALSE;
		return result;
	} else {
		guint hash_value = 0U;
		GeeHashDataFunc _tmp2_ = NULL;
		gpointer _tmp2__target = NULL;
		GeeHashDataFunc _tmp3_;
		gpointer _tmp3__target;
		GeeHashSetNode** _tmp4_;
		gpointer _tmp5_;
		GeeHashSetNode* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp2_ = gee_hash_set_get_hash_func (self, &_tmp2__target);
		_tmp3_ = _tmp2_;
		_tmp3__target = _tmp2__target;
		hash_value = _tmp3_ (key, _tmp3__target);
		_tmp4_ = node;
		_tmp5_ = ((key != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) key) : ((gpointer) key);
		_tmp6_ = gee_hash_set_node_new (_tmp5_, hash_value);
		*_tmp4_ = _tmp6_;
		_tmp7_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp7_ + 1;
		gee_hash_set_resize (self);
		_tmp8_ = self->priv->_stamp;
		self->priv->_stamp = _tmp8_ + 1;
		result = TRUE;
		return result;
	}
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_hash_set_real_remove (GeeAbstractCollection* base,
                          gconstpointer key)
{
	GeeHashSet * self;
	gboolean b = FALSE;
	gboolean result;
	self = (GeeHashSet*) base;
	b = gee_hash_set_remove_helper (self, key);
	if (b) {
		gee_hash_set_resize (self);
	}
	result = b;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_hash_set_real_clear (GeeAbstractCollection* base)
{
	GeeHashSet * self;
	self = (GeeHashSet*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeHashSetNode* node = NULL;
				GeeHashSetNode** _tmp2_;
				gint _tmp2__length1;
				GeeHashSetNode* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_array_size)) {
					break;
				}
				_tmp2_ = self->priv->_nodes;
				_tmp2__length1 = self->priv->_nodes_length1;
				_tmp3_ = _tmp2_[i];
				_tmp2_[i] = NULL;
				node = _tmp3_;
				while (TRUE) {
					GeeHashSetNode* _tmp4_;
					GeeHashSetNode* next = NULL;
					GeeHashSetNode* _tmp5_;
					GeeHashSetNode* _tmp6_;
					GeeHashSetNode* _tmp7_;
					GeeHashSetNode* _tmp8_;
					_tmp4_ = node;
					if (!(_tmp4_ != NULL)) {
						break;
					}
					_tmp5_ = node;
					_tmp6_ = _tmp5_->next;
					_tmp5_->next = NULL;
					next = _tmp6_;
					_tmp7_ = node;
					((_tmp7_->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_->key = (self->priv->g_destroy_func (_tmp7_->key), NULL));
					_tmp7_->key = NULL;
					_tmp8_ = next;
					next = NULL;
					_gee_hash_set_node_free0 (node);
					node = _tmp8_;
					_gee_hash_set_node_free0 (next);
				}
				_gee_hash_set_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	gee_hash_set_resize (self);
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_hash_set_real_foreach (GeeAbstractCollection* base,
                           GeeForallFunc f,
                           gpointer f_target)
{
	GeeHashSet * self;
	gboolean result;
	self = (GeeHashSet*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_array_size)) {
					break;
				}
				{
					GeeHashSetNode* current = NULL;
					GeeHashSetNode** _tmp2_;
					gint _tmp2__length1;
					GeeHashSetNode* _tmp3_;
					_tmp2_ = self->priv->_nodes;
					_tmp2__length1 = self->priv->_nodes_length1;
					_tmp3_ = _tmp2_[i];
					current = _tmp3_;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							GeeHashSetNode* _tmp7_;
							GeeHashSetNode* _tmp8_;
							gconstpointer _tmp9_;
							gpointer _tmp10_;
							if (!_tmp4_) {
								GeeHashSetNode* _tmp5_;
								GeeHashSetNode* _tmp6_;
								_tmp5_ = current;
								_tmp6_ = _tmp5_->next;
								current = _tmp6_;
							}
							_tmp4_ = FALSE;
							_tmp7_ = current;
							if (!(_tmp7_ != NULL)) {
								break;
							}
							_tmp8_ = current;
							_tmp9_ = _tmp8_->key;
							_tmp10_ = ((_tmp9_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp9_) : ((gpointer) _tmp9_);
							if (!f (_tmp10_, f_target)) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static inline gboolean
gee_hash_set_remove_helper (GeeHashSet* self,
                            gconstpointer key)
{
	GeeHashSetNode** node = NULL;
	GeeHashSetNode** _tmp0_;
	GeeHashSetNode** _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_hash_set_lookup_node (self, key);
	node = _tmp0_;
	_tmp1_ = node;
	if ((*_tmp1_) != NULL) {
		GeeHashSetNode** _tmp2_;
		GeeHashSetNode* next = NULL;
		GeeHashSetNode** _tmp3_;
		GeeHashSetNode* _tmp4_;
		GeeHashSetNode** _tmp5_;
		GeeHashSetNode** _tmp6_;
		GeeHashSetNode** _tmp7_;
		GeeHashSetNode* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp2_ = node;
		_vala_assert ((*_tmp2_) != NULL, "*node != null");
		_tmp3_ = node;
		_tmp4_ = (*_tmp3_)->next;
		(*_tmp3_)->next = NULL;
		next = _tmp4_;
		_tmp5_ = node;
		(((*_tmp5_)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp5_)->key = (self->priv->g_destroy_func ((*_tmp5_)->key), NULL));
		(*_tmp5_)->key = NULL;
		_tmp6_ = node;
		_gee_hash_set_node_free0 (*_tmp6_);
		_tmp7_ = node;
		_tmp8_ = next;
		next = NULL;
		*_tmp7_ = _tmp8_;
		_tmp9_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp9_ - 1;
		_tmp10_ = self->priv->_stamp;
		self->priv->_stamp = _tmp10_ + 1;
		result = TRUE;
		_gee_hash_set_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}

static void
gee_hash_set_resize (GeeHashSet* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_array_size >= (3 * self->priv->_nnodes)) {
		_tmp1_ = self->priv->_array_size >= GEE_HASH_SET_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if ((3 * self->priv->_array_size) <= self->priv->_nnodes) {
			_tmp2_ = self->priv->_array_size < GEE_HASH_SET_MAX_SIZE;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gint new_array_size = 0;
		GeeHashSetNode** new_nodes = NULL;
		GeeHashSetNode** _tmp3_;
		gint new_nodes_length1;
		gint _new_nodes_size_;
		GeeHashSetNode** _tmp19_;
		gint _tmp19__length1;
		new_array_size = (gint) g_spaced_primes_closest ((guint) self->priv->_nnodes);
		new_array_size = CLAMP (new_array_size, GEE_HASH_SET_MIN_SIZE, GEE_HASH_SET_MAX_SIZE);
		_tmp3_ = g_new0 (GeeHashSetNode*, new_array_size + 1);
		new_nodes = _tmp3_;
		new_nodes_length1 = new_array_size;
		_new_nodes_size_ = new_nodes_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					GeeHashSetNode* node = NULL;
					GeeHashSetNode* next = NULL;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					if (!(i < self->priv->_array_size)) {
						break;
					}
					next = NULL;
					{
						GeeHashSetNode** _tmp6_;
						gint _tmp6__length1;
						GeeHashSetNode* _tmp7_;
						gboolean _tmp8_ = FALSE;
						_tmp6_ = self->priv->_nodes;
						_tmp6__length1 = self->priv->_nodes_length1;
						_tmp7_ = _tmp6_[i];
						_tmp6_[i] = NULL;
						_gee_hash_set_node_free0 (node);
						node = _tmp7_;
						_tmp8_ = TRUE;
						while (TRUE) {
							GeeHashSetNode* _tmp10_;
							GeeHashSetNode* _tmp11_;
							GeeHashSetNode* _tmp12_;
							guint hash_val = 0U;
							GeeHashSetNode* _tmp13_;
							GeeHashSetNode* _tmp14_;
							GeeHashSetNode** _tmp15_;
							gint _tmp15__length1;
							GeeHashSetNode* _tmp16_;
							GeeHashSetNode** _tmp17_;
							gint _tmp17__length1;
							GeeHashSetNode* _tmp18_;
							if (!_tmp8_) {
								GeeHashSetNode* _tmp9_;
								_tmp9_ = next;
								next = NULL;
								_gee_hash_set_node_free0 (node);
								node = _tmp9_;
							}
							_tmp8_ = FALSE;
							_tmp10_ = node;
							if (!(_tmp10_ != NULL)) {
								break;
							}
							_tmp11_ = node;
							_tmp12_ = _tmp11_->next;
							_tmp11_->next = NULL;
							_gee_hash_set_node_free0 (next);
							next = _tmp12_;
							_tmp13_ = node;
							hash_val = _tmp13_->key_hash % new_array_size;
							_tmp14_ = node;
							_tmp15_ = new_nodes;
							_tmp15__length1 = new_nodes_length1;
							_tmp16_ = _tmp15_[hash_val];
							_tmp15_[hash_val] = NULL;
							_gee_hash_set_node_free0 (_tmp14_->next);
							_tmp14_->next = _tmp16_;
							_tmp17_ = new_nodes;
							_tmp17__length1 = new_nodes_length1;
							_tmp18_ = node;
							node = NULL;
							_gee_hash_set_node_free0 (_tmp17_[hash_val]);
							_tmp17_[hash_val] = _tmp18_;
						}
					}
					_gee_hash_set_node_free0 (next);
					_gee_hash_set_node_free0 (node);
				}
			}
		}
		_tmp19_ = new_nodes;
		_tmp19__length1 = new_nodes_length1;
		new_nodes = NULL;
		new_nodes_length1 = 0;
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
		self->priv->_nodes = _tmp19_;
		self->priv->_nodes_length1 = _tmp19__length1;
		self->priv->__nodes_size_ = self->priv->_nodes_length1;
		self->priv->_array_size = new_array_size;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	}
}

static gint
gee_hash_set_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GeeHashSet* self;
	self = (GeeHashSet*) base;
	result = self->priv->_nnodes;
	return result;
}

static gboolean
gee_hash_set_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GeeHashSet* self;
	self = (GeeHashSet*) base;
	result = FALSE;
	return result;
}

GeeHashDataFunc
gee_hash_set_get_hash_func (GeeHashSet* self,
                            gpointer* result_target)
{
	GeeHashDataFunc result;
	GeeFunctionsHashDataFuncClosure* _tmp0_;
	GeeHashDataFunc _tmp1_;
	gpointer _tmp1__target;
	GeeHashDataFunc _tmp2_;
	gpointer _tmp2__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hash_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
gee_hash_set_set_hash_func (GeeHashSet* self,
                            GeeHashDataFunc value,
                            gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

GeeEqualDataFunc
gee_hash_set_get_equal_func (GeeHashSet* self,
                             gpointer* result_target)
{
	GeeEqualDataFunc result;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GeeEqualDataFunc _tmp2_;
	gpointer _tmp2__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
gee_hash_set_set_equal_func (GeeHashSet* self,
                             GeeEqualDataFunc value,
                             gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

static GeeHashSetNode*
gee_hash_set_node_new (gpointer k,
                       guint hash)
{
	GeeHashSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (GeeHashSetNode);
	gee_hash_set_node_instance_init (self);
	_tmp0_ = k;
	k = NULL;
	self->key = _tmp0_;
	self->key_hash = hash;
	return self;
}

static void
gee_hash_set_node_instance_init (GeeHashSetNode * self)
{
}

static void
gee_hash_set_node_free (GeeHashSetNode * self)
{
	_gee_hash_set_node_free0 (self->next);
	g_slice_free (GeeHashSetNode, self);
}

static inline gpointer
gee_hash_set_iterator_get_instance_private (GeeHashSetIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeeHashSetIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeHashSetIterator*
gee_hash_set_iterator_construct (GType object_type,
                                 GType g_type,
                                 GBoxedCopyFunc g_dup_func,
                                 GDestroyNotify g_destroy_func,
                                 GeeHashSet* set)
{
	GeeHashSetIterator * self = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeHashSetIterator*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (set);
	_g_object_unref0 (self->_set);
	self->_set = _tmp0_;
	_tmp1_ = self->_set;
	self->_stamp = _tmp1_->priv->_stamp;
	return self;
}

static GeeHashSetIterator*
gee_hash_set_iterator_new (GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           GeeHashSet* set)
{
	return gee_hash_set_iterator_construct (GEE_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}

static GeeHashSetIterator*
gee_hash_set_iterator_construct_from_iterator (GType object_type,
                                               GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               GeeHashSetIterator* iter)
{
	GeeHashSetIterator * self = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSetNode* _tmp2_;
	GeeHashSetNode* _tmp3_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GeeHashSetIterator*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = iter->_set;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->_set);
	self->_set = _tmp1_;
	self->_index = iter->_index;
	_tmp2_ = iter->_node;
	self->_node = _tmp2_;
	_tmp3_ = iter->_next;
	self->_next = _tmp3_;
	return self;
}

static GeeHashSetIterator*
gee_hash_set_iterator_new_from_iterator (GType g_type,
                                         GBoxedCopyFunc g_dup_func,
                                         GDestroyNotify g_destroy_func,
                                         GeeHashSetIterator* iter)
{
	return gee_hash_set_iterator_construct_from_iterator (GEE_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iter);
}

static gboolean
gee_hash_set_iterator_real_next (GeeIterator* base)
{
	GeeHashSetIterator * self;
	GeeHashSet* _tmp0_;
	GeeHashSetNode* _tmp1_;
	GeeHashSetNode* _tmp2_;
	gboolean result;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->_set;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _set._stamp");
	if (!gee_iterator_has_next ((GeeIterator*) self)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->_next;
	self->_node = _tmp1_;
	self->_next = NULL;
	_tmp2_ = self->_node;
	result = _tmp2_ != NULL;
	return result;
}

static gboolean
gee_hash_set_iterator_real_has_next (GeeIterator* base)
{
	GeeHashSetIterator * self;
	GeeHashSet* _tmp0_;
	GeeHashSetNode* _tmp1_;
	GeeHashSetNode* _tmp13_;
	gboolean result;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->_set;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _set._stamp");
	_tmp1_ = self->_next;
	if (_tmp1_ == NULL) {
		GeeHashSetNode* _tmp2_;
		GeeHashSetNode* _tmp3_;
		_tmp2_ = self->_node;
		self->_next = _tmp2_;
		_tmp3_ = self->_next;
		if (_tmp3_ != NULL) {
			GeeHashSetNode* _tmp4_;
			GeeHashSetNode* _tmp5_;
			_tmp4_ = self->_next;
			_tmp5_ = _tmp4_->next;
			self->_next = _tmp5_;
		}
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			GeeHashSetNode* _tmp7_;
			gint _tmp9_;
			GeeHashSet* _tmp10_;
			GeeHashSetNode** _tmp11_;
			gint _tmp11__length1;
			GeeHashSetNode* _tmp12_;
			_tmp7_ = self->_next;
			if (_tmp7_ == NULL) {
				GeeHashSet* _tmp8_;
				_tmp8_ = self->_set;
				_tmp6_ = (self->_index + 1) < _tmp8_->priv->_array_size;
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			_tmp9_ = self->_index;
			self->_index = _tmp9_ + 1;
			_tmp10_ = self->_set;
			_tmp11_ = _tmp10_->priv->_nodes;
			_tmp11__length1 = _tmp10_->priv->_nodes_length1;
			_tmp12_ = _tmp11_[self->_index];
			self->_next = _tmp12_;
		}
	}
	_tmp13_ = self->_next;
	result = _tmp13_ != NULL;
	return result;
}

static gpointer
gee_hash_set_iterator_real_get (GeeIterator* base)
{
	GeeHashSetIterator * self;
	GeeHashSet* _tmp0_;
	GeeHashSetNode* _tmp1_;
	GeeHashSetNode* _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	gpointer result;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->_set;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _set._stamp");
	_tmp1_ = self->_node;
	_vala_assert (_tmp1_ != NULL, "_node != null");
	_tmp2_ = self->_node;
	_tmp3_ = _tmp2_->key;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
gee_hash_set_iterator_real_remove (GeeIterator* base)
{
	GeeHashSetIterator * self;
	GeeHashSet* _tmp0_;
	GeeHashSetNode* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSetNode* _tmp3_;
	gconstpointer _tmp4_;
	GeeHashSet* _tmp5_;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->_set;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _set._stamp");
	_tmp1_ = self->_node;
	_vala_assert (_tmp1_ != NULL, "_node != null");
	gee_iterator_has_next ((GeeIterator*) self);
	_tmp2_ = self->_set;
	_tmp3_ = self->_node;
	_tmp4_ = _tmp3_->key;
	gee_hash_set_remove_helper (_tmp2_, _tmp4_);
	self->_node = NULL;
	_tmp5_ = self->_set;
	self->_stamp = _tmp5_->priv->_stamp;
}

static gboolean
gee_hash_set_iterator_real_foreach (GeeTraversable* base,
                                    GeeForallFunc f,
                                    gpointer f_target)
{
	GeeHashSetIterator * self;
	GeeHashSet* _tmp0_;
	GeeHashSetNode* node = NULL;
	GeeHashSetNode* _tmp1_;
	GeeHashSetNode* next = NULL;
	GeeHashSetNode* _tmp2_;
	GeeHashSetNode* current = NULL;
	GeeHashSetNode* prev = NULL;
	GeeHashSetNode* _tmp3_;
	GeeHashSetNode* _tmp10_;
	GeeHashSetNode* _tmp35_;
	gboolean result;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->_set;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _set._stamp");
	_tmp1_ = self->_node;
	node = _tmp1_;
	_tmp2_ = self->_next;
	next = _tmp2_;
	current = NULL;
	prev = NULL;
	_tmp3_ = node;
	if (_tmp3_ != NULL) {
		GeeHashSetNode* _tmp4_;
		gconstpointer _tmp5_;
		gpointer _tmp6_;
		GeeHashSetNode* _tmp7_;
		GeeHashSetNode* _tmp8_;
		GeeHashSetNode* _tmp9_;
		_tmp4_ = node;
		_tmp5_ = _tmp4_->key;
		_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
		if (!f (_tmp6_, f_target)) {
			result = FALSE;
			return result;
		}
		_tmp7_ = node;
		prev = _tmp7_;
		_tmp8_ = node;
		_tmp9_ = _tmp8_->next;
		current = _tmp9_;
	}
	_tmp10_ = next;
	if (_tmp10_ != NULL) {
		GeeHashSetNode* _tmp11_;
		gconstpointer _tmp12_;
		gpointer _tmp13_;
		GeeHashSetNode* _tmp15_;
		GeeHashSetNode* _tmp16_;
		GeeHashSetNode* _tmp17_;
		_tmp11_ = next;
		_tmp12_ = _tmp11_->key;
		_tmp13_ = ((_tmp12_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp12_) : ((gpointer) _tmp12_);
		if (!f (_tmp13_, f_target)) {
			GeeHashSetNode* _tmp14_;
			_tmp14_ = next;
			self->_node = _tmp14_;
			self->_next = NULL;
			result = FALSE;
			return result;
		}
		_tmp15_ = next;
		prev = _tmp15_;
		_tmp16_ = next;
		_tmp17_ = _tmp16_->next;
		current = _tmp17_;
	}
	{
		gboolean _tmp18_ = FALSE;
		_tmp18_ = TRUE;
		while (TRUE) {
			if (!_tmp18_) {
				GeeHashSetNode* _tmp19_;
				_tmp19_ = current;
				if (!(_tmp19_ != NULL)) {
					break;
				}
			}
			_tmp18_ = FALSE;
			while (TRUE) {
				GeeHashSetNode* _tmp20_;
				GeeHashSetNode* _tmp21_;
				gconstpointer _tmp22_;
				gpointer _tmp23_;
				GeeHashSetNode* _tmp25_;
				GeeHashSetNode* _tmp26_;
				GeeHashSetNode* _tmp27_;
				_tmp20_ = current;
				if (!(_tmp20_ != NULL)) {
					break;
				}
				_tmp21_ = current;
				_tmp22_ = _tmp21_->key;
				_tmp23_ = ((_tmp22_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp22_) : ((gpointer) _tmp22_);
				if (!f (_tmp23_, f_target)) {
					GeeHashSetNode* _tmp24_;
					_tmp24_ = current;
					self->_node = _tmp24_;
					self->_next = NULL;
					result = FALSE;
					return result;
				}
				_tmp25_ = current;
				prev = _tmp25_;
				_tmp26_ = current;
				_tmp27_ = _tmp26_->next;
				current = _tmp27_;
			}
			while (TRUE) {
				gboolean _tmp28_ = FALSE;
				GeeHashSetNode* _tmp29_;
				gint _tmp31_;
				GeeHashSet* _tmp32_;
				GeeHashSetNode** _tmp33_;
				gint _tmp33__length1;
				GeeHashSetNode* _tmp34_;
				_tmp29_ = current;
				if (_tmp29_ == NULL) {
					GeeHashSet* _tmp30_;
					_tmp30_ = self->_set;
					_tmp28_ = (self->_index + 1) < _tmp30_->priv->_array_size;
				} else {
					_tmp28_ = FALSE;
				}
				if (!_tmp28_) {
					break;
				}
				_tmp31_ = self->_index;
				self->_index = _tmp31_ + 1;
				_tmp32_ = self->_set;
				_tmp33_ = _tmp32_->priv->_nodes;
				_tmp33__length1 = _tmp32_->priv->_nodes_length1;
				_tmp34_ = _tmp33_[self->_index];
				current = _tmp34_;
			}
		}
	}
	_tmp35_ = prev;
	self->_node = _tmp35_;
	self->_next = NULL;
	result = TRUE;
	return result;
}

static GeeIterator**
gee_hash_set_iterator_real_tee (GeeTraversable* base,
                                guint forks,
                                gint* result_length1)
{
	GeeHashSetIterator * self;
	GeeIterator** result;
	self = (GeeHashSetIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp2_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp3_;
		gint _tmp3__length1;
		GeeIterator* _tmp4_;
		GeeIterator** _tmp9_;
		gint _tmp9__length1;
		_tmp2_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp2_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp3_ = _result_;
		_tmp3__length1 = _result__length1;
		_tmp4_ = _g_object_ref0 ((GeeIterator*) self);
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp4_;
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp7_;
					gint _tmp7__length1;
					GeeHashSetIterator* _tmp8_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp7_ = _result_;
					_tmp7__length1 = _result__length1;
					_tmp8_ = gee_hash_set_iterator_new_from_iterator (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
					_g_object_unref0 (_tmp7_[0]);
					_tmp7_[0] = (GeeIterator*) _tmp8_;
				}
			}
		}
		_tmp9_ = _result_;
		_tmp9__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
}

static gboolean
gee_hash_set_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeeHashSetIterator* self;
	self = (GeeHashSetIterator*) base;
	result = FALSE;
	return result;
}

static gboolean
gee_hash_set_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeeHashSetIterator* self;
	GeeHashSetNode* _tmp0_;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->_node;
	result = _tmp0_ != NULL;
	return result;
}

static void
gee_hash_set_iterator_class_init (GeeHashSetIteratorClass * klass,
                                  gpointer klass_data)
{
	gee_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeHashSetIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_READ_ONLY_PROPERTY, gee_hash_set_iterator_properties[GEE_HASH_SET_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_VALID_PROPERTY, gee_hash_set_iterator_properties[GEE_HASH_SET_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_hash_set_iterator_gee_traversable_get_g_type (GeeHashSetIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_hash_set_iterator_gee_traversable_get_g_dup_func (GeeHashSetIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_hash_set_iterator_gee_traversable_get_g_destroy_func (GeeHashSetIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_hash_set_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                      gpointer iface_data)
{
	gee_hash_set_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_hash_set_iterator_real_foreach;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_hash_set_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_hash_set_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_hash_set_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_hash_set_iterator_gee_traversable_get_g_destroy_func;
}

static void
gee_hash_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                   gpointer iface_data)
{
	gee_hash_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_hash_set_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_hash_set_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_hash_set_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_hash_set_iterator_real_remove;
	iface->get_read_only = gee_hash_set_iterator_real_get_read_only;
	iface->get_valid = gee_hash_set_iterator_real_get_valid;
}

static void
gee_hash_set_iterator_instance_init (GeeHashSetIterator * self,
                                     gpointer klass)
{
	self->priv = gee_hash_set_iterator_get_instance_private (self);
	self->_index = -1;
	self->_stamp = 0;
}

static void
gee_hash_set_iterator_finalize (GObject * obj)
{
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
	_g_object_unref0 (self->_set);
	G_OBJECT_CLASS (gee_hash_set_iterator_parent_class)->finalize (obj);
}

static GType
gee_hash_set_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSetIterator), 0, (GInstanceInitFunc) gee_hash_set_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_hash_set_iterator_type_id;
	gee_hash_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeHashSetIterator", &g_define_type_info, 0);
	g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	GeeHashSetIterator_private_offset = g_type_add_instance_private (gee_hash_set_iterator_type_id, sizeof (GeeHashSetIteratorPrivate));
	return gee_hash_set_iterator_type_id;
}

static GType
gee_hash_set_iterator_get_type (void)
{
	static volatile gsize gee_hash_set_iterator_type_id__once = 0;
	if (g_once_init_enter (&gee_hash_set_iterator_type_id__once)) {
		GType gee_hash_set_iterator_type_id;
		gee_hash_set_iterator_type_id = gee_hash_set_iterator_get_type_once ();
		g_once_init_leave (&gee_hash_set_iterator_type_id__once, gee_hash_set_iterator_type_id);
	}
	return gee_hash_set_iterator_type_id__once;
}

static void
_vala_gee_hash_set_iterator_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
	switch (property_id) {
		case GEE_HASH_SET_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_HASH_SET_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_HASH_SET_ITERATOR_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_HASH_SET_ITERATOR_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_hash_set_iterator_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
	switch (property_id) {
		case GEE_HASH_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_HASH_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_hash_set_class_init (GeeHashSetClass * klass,
                         gpointer klass_data)
{
	gee_hash_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeHashSet_private_offset);
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_hash_set_real_contains;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) gee_hash_set_real_iterator;
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_hash_set_real_add;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_hash_set_real_remove;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) gee_hash_set_real_clear;
	((GeeAbstractCollectionClass *) klass)->foreach = (gboolean (*) (GeeAbstractCollection*, GeeForallFunc, gpointer)) gee_hash_set_real_foreach;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_hash_set_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_hash_set_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_SIZE_PROPERTY, gee_hash_set_properties[GEE_HASH_SET_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_READ_ONLY_PROPERTY, gee_hash_set_properties[GEE_HASH_SET_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_hash_set_instance_init (GeeHashSet * self,
                            gpointer klass)
{
	self->priv = gee_hash_set_get_instance_private (self);
	self->priv->_stamp = 0;
}

static void
gee_hash_set_finalize (GObject * obj)
{
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_HASH_SET, GeeHashSet);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	_gee_functions_hash_data_func_closure_unref0 (self->priv->_hash_func);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	G_OBJECT_CLASS (gee_hash_set_parent_class)->finalize (obj);
}

/**
 * Hash table implementation of the {@link Set} interface.
 *
 * This implementation is better fit for highly heterogeneous values.
 * In case of high value hashes redundancy or higher amount of data prefer using
 * tree implementation like {@link TreeSet}.
 *
 * @see TreeSet
 */
static GType
gee_hash_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSet), 0, (GInstanceInitFunc) gee_hash_set_instance_init, NULL };
	GType gee_hash_set_type_id;
	gee_hash_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeHashSet", &g_define_type_info, 0);
	GeeHashSet_private_offset = g_type_add_instance_private (gee_hash_set_type_id, sizeof (GeeHashSetPrivate));
	return gee_hash_set_type_id;
}

GType
gee_hash_set_get_type (void)
{
	static volatile gsize gee_hash_set_type_id__once = 0;
	if (g_once_init_enter (&gee_hash_set_type_id__once)) {
		GType gee_hash_set_type_id;
		gee_hash_set_type_id = gee_hash_set_get_type_once ();
		g_once_init_leave (&gee_hash_set_type_id__once, gee_hash_set_type_id);
	}
	return gee_hash_set_type_id__once;
}

static void
_vala_gee_hash_set_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
	switch (property_id) {
		case GEE_HASH_SET_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_HASH_SET_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_HASH_SET_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_HASH_SET_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_HASH_SET_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_hash_set_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
	switch (property_id) {
		case GEE_HASH_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_HASH_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_HASH_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

