/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;
import org.hsqldb.ClientConnection;
import org.hsqldb.ColumnBase;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HashSet;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.server.OdbcPacketInputStream;
import org.hsqldb.server.OdbcPacketOutputStream;
import org.hsqldb.server.OdbcPreparedStatement;
import org.hsqldb.server.OdbcUtil;
import org.hsqldb.server.PgType;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.server.Server;
import org.hsqldb.server.StatementPortal;
import org.hsqldb.types.Type;

class ServerConnection
implements Runnable {
    boolean keepAlive;
    private String user;
    int dbID;
    int dbIndex;
    private volatile Session session;
    private Socket socket;
    private Server server;
    private DataInputStream dataInput;
    private DataOutputStream dataOutput;
    private int mThread;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    RowOutputInterface rowOut;
    RowInputBinary rowIn;
    Thread runnerThread;
    private static AtomicInteger mCurrentThread = new AtomicInteger(0);
    protected static String TEXTBANNER_PART1 = null;
    protected static String TEXTBANNER_PART2 = null;
    private CleanExit cleanExit = new CleanExit();
    private OdbcPacketOutputStream outPacket = null;
    public static long MAX_WAIT_FOR_CLIENT_DATA;
    public static long CLIENT_DATA_POLLING_PERIOD;
    private Map sessionOdbcPsMap = new HashMap();
    private Map sessionOdbcPortalMap = new HashMap();
    private int streamProtocol = 0;
    static final int UNDEFINED_STREAM_PROTOCOL = 0;
    static final int HSQL_STREAM_PROTOCOL = 1;
    static final int ODBC_STREAM_PROTOCOL = 2;
    int odbcCommMode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection(Socket socket, Server server) {
        RowOutputBinary rowOutputBinary = new RowOutputBinary(this.mainBuffer);
        this.rowIn = new RowInputBinary(rowOutputBinary);
        this.rowOut = rowOutputBinary;
        this.socket = socket;
        this.server = server;
        this.mThread = mCurrentThread.getAndIncrement();
        HashSet hashSet = server.serverConnSet;
        synchronized (hashSet) {
            server.serverConnSet.add(this);
        }
    }

    void signalClose() {
        this.keepAlive = false;
        if (Thread.currentThread().equals(this.runnerThread)) {
            Result result = Result.updateZeroResult;
            try {
                result.write(this.session, this.dataOutput, this.rowOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        Object object = this;
        synchronized (object) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        object = this.server.serverConnSet;
        synchronized (object) {
            this.server.serverConnSet.remove(this);
        }
        try {
            this.runnerThread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void init() {
        this.runnerThread = Thread.currentThread();
        this.keepAlive = true;
        try {
            this.socket.setTcpNoDelay(true);
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            int n = this.handshake();
            switch (this.streamProtocol) {
                case 1: {
                    if (n != -2030400) {
                        if (n == -1900000) {
                            n = -2000000;
                        }
                        String string = ClientConnection.toNetCompVersionString(n);
                        throw Error.error(null, 403, 0, new String[]{"2.4.1", string});
                    }
                    byte by = this.dataInput.readByte();
                    this.receiveResult(by);
                    break;
                }
                case 2: {
                    this.odbcConnect(n);
                    break;
                }
                default: {
                    this.keepAlive = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer(this.mThread + ":Failed to connect client.");
            if (this.user != null) {
                stringBuffer.append("  User '" + this.user + "'.");
            }
            this.server.printWithThread(stringBuffer.toString() + "  Stack trace follows.");
            this.server.printStackTrace(exception);
        }
    }

    private void receiveResult(int n) throws CleanExit, IOException {
        boolean bl = false;
        Result result = Result.newResult(this.session, n, this.dataInput, this.rowIn);
        result.readLobResults(this.session, this.dataInput, this.rowIn);
        this.server.printRequest(this.mThread, result);
        Result result2 = null;
        switch (result.getType()) {
            case 31: {
                result2 = this.setDatabase(result);
                break;
            }
            case 5: {
                result2 = this.cancelStatement(result);
                bl = true;
                break;
            }
            case 32: {
                result2 = Result.updateZeroResult;
                bl = true;
                break;
            }
            case 10: {
                this.session.resetSession();
                result2 = Result.updateZeroResult;
                break;
            }
            case 21: {
                result2 = Result.newErrorResult(Error.error(1252));
                break;
            }
            default: {
                result2 = this.session.execute(result);
            }
        }
        result2.write(this.session, this.dataOutput, this.rowOut);
        this.rowOut.reset(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        if (bl) {
            throw this.cleanExit;
        }
    }

    private void receiveOdbcPacket(char c) throws IOException, CleanExit {
        boolean bl = false;
        String string = null;
        OdbcPacketInputStream odbcPacketInputStream = null;
        try {
            odbcPacketInputStream = OdbcPacketInputStream.newOdbcPacketInputStream(c, this.dataInput);
            this.server.printWithThread("Got op (" + odbcPacketInputStream.packetType + ')');
            this.server.printWithThread("Got packet length of " + odbcPacketInputStream.available() + " + type byte + 4 size header");
            if (odbcPacketInputStream.available() >= 1000000000) {
                throw new IOException("Insane packet length: " + odbcPacketInputStream.available() + " + type byte + 4 size header");
            }
        }
        catch (SocketException socketException) {
            this.server.printWithThread("Ungraceful client exit: " + socketException);
            throw this.cleanExit;
        }
        catch (IOException iOException) {
            this.server.printWithThread("Fatal ODBC protocol failure: " + iOException);
            try {
                OdbcUtil.alertClient(1, iOException.toString(), "08P01", this.dataOutput);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.cleanExit;
        }
        switch (this.odbcCommMode) {
            case 2: {
                if (odbcPacketInputStream.packetType != 'S') {
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Ignoring a '" + odbcPacketInputStream.packetType + "'");
                    }
                    return;
                }
                this.odbcCommMode = 1;
                this.server.printWithThread("EXTENDED comm session being recovered");
                break;
            }
            case 0: {
                switch (odbcPacketInputStream.packetType) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'H': 
                    case 'P': 
                    case 'S': {
                        this.odbcCommMode = 1;
                        this.server.printWithThread("Switching mode from SIMPLE to EXTENDED");
                    }
                }
                break;
            }
            case 1: {
                switch (odbcPacketInputStream.packetType) {
                    case 'Q': {
                        this.odbcCommMode = 0;
                        this.server.printWithThread("Switching mode from EXTENDED to SIMPLE");
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ODBC comm mode value: " + this.odbcCommMode);
            }
        }
        this.outPacket.reset();
        try {
            block17 : switch (odbcPacketInputStream.packetType) {
                case 'Q': {
                    String string2;
                    int n;
                    String string3 = odbcPacketInputStream.readString();
                    if (string3.startsWith("BEGIN;") || string3.equals("BEGIN")) {
                        string3 = string3.equals("BEGIN") ? null : string3.substring("BEGIN;".length());
                        this.server.printWithThread("ODBC Trans started.  Session AutoCommit -> F");
                        try {
                            this.session.setAutoCommit(false);
                        }
                        catch (HsqlException hsqlException) {
                            throw new RecoverableOdbcFailure("Failed to change transaction state: " + hsqlException.getMessage(), hsqlException.getSQLState());
                        }
                        this.outPacket.write("BEGIN");
                        this.outPacket.xmit('C', this.dataOutput);
                        if (string3 == null) {
                            bl = true;
                            break;
                        }
                    }
                    if (string3.startsWith("SAVEPOINT ") && string3.indexOf(59) > 0) {
                        int n2 = string3.indexOf(59);
                        this.server.printWithThread("Interposing BEFORE primary statement: " + string3.substring(0, n2));
                        this.odbcExecDirect(string3.substring(0, n2));
                        string3 = string3.substring(n2 + 1);
                    }
                    if ((n = string3.lastIndexOf(59)) > 0 && (string2 = string3.substring(n + 1)).startsWith("RELEASE ")) {
                        string = string2;
                        string3 = string3.substring(0, n);
                    }
                    String string4 = string3.trim().toLowerCase();
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received query (" + string3 + ')');
                    }
                    if (string4.startsWith("select current_schema()")) {
                        this.server.printWithThread("Implement 'select current_schema() emulation!");
                        throw new RecoverableOdbcFailure("current_schema() not supported yet", "0A000");
                    }
                    if (string4.startsWith("select n.nspname,")) {
                        this.server.printWithThread("Swallowing 'select n.nspname,...'");
                        this.outPacket.writeShort(1);
                        this.outPacket.write("oid");
                        this.outPacket.writeInt(201);
                        this.outPacket.writeShort(1);
                        this.outPacket.writeInt(23);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.xmit('T', this.dataOutput);
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (string4.startsWith("select oid, typbasetype from")) {
                        this.server.printWithThread("Simulating 'select oid, typbasetype...'");
                        this.outPacket.writeShort(2);
                        this.outPacket.write("oid");
                        this.outPacket.writeInt(101);
                        this.outPacket.writeShort(102);
                        this.outPacket.writeInt(26);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.write("typbasetype");
                        this.outPacket.writeInt(101);
                        this.outPacket.writeShort(103);
                        this.outPacket.writeInt(26);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.xmit('T', this.dataOutput);
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (string4.startsWith("select ")) {
                        int n3;
                        this.server.printWithThread("Performing a real non-prepared SELECT...");
                        Result result = Result.newExecuteDirectRequest();
                        result.setPrepareOrExecuteProperties(string3, 0, 0, 2, 0, 0, 2, null, null);
                        Result result2 = this.session.execute(result);
                        switch (result2.getType()) {
                            case 3: {
                                break;
                            }
                            case 2: {
                                throw new RecoverableOdbcFailure(result2);
                            }
                            default: {
                                throw new RecoverableOdbcFailure("Output Result from Query execution is of unexpected type: " + result2.getType());
                            }
                        }
                        RowSetNavigator rowSetNavigator = result2.getNavigator();
                        ResultMetaData resultMetaData = result2.metaData;
                        if (resultMetaData == null) {
                            throw new RecoverableOdbcFailure("Failed to get metadata for query results");
                        }
                        int n4 = resultMetaData.getColumnCount();
                        String[] stringArray = resultMetaData.getGeneratedColumnNames();
                        Type[] typeArray = resultMetaData.columnTypes;
                        PgType[] pgTypeArray = new PgType[n4];
                        for (int i = 0; i < pgTypeArray.length; ++i) {
                            pgTypeArray[i] = PgType.getPgType(typeArray[i], resultMetaData.isTableColumn(i));
                        }
                        ColumnBase[] columnBaseArray = resultMetaData.columns;
                        this.outPacket.writeShort(n4);
                        for (n3 = 0; n3 < n4; ++n3) {
                            if (stringArray[n3] != null) {
                                this.outPacket.write(stringArray[n3]);
                            } else {
                                this.outPacket.write(columnBaseArray[n3].getNameString());
                            }
                            this.outPacket.writeInt(OdbcUtil.getTableOidForColumn(n3, resultMetaData));
                            this.outPacket.writeShort(OdbcUtil.getIdForColumn(n3, resultMetaData));
                            this.outPacket.writeInt(pgTypeArray[n3].getOid());
                            this.outPacket.writeShort(pgTypeArray[n3].getTypeWidth());
                            this.outPacket.writeInt(pgTypeArray[n3].getLPConstraint());
                            this.outPacket.writeShort(0);
                        }
                        this.outPacket.xmit('T', this.dataOutput);
                        n3 = 0;
                        while (rowSetNavigator.next()) {
                            ++n3;
                            Object[] objectArray = rowSetNavigator.getCurrent();
                            if (objectArray == null) {
                                throw new RecoverableOdbcFailure("Null row?");
                            }
                            if (objectArray.length < n4) {
                                throw new RecoverableOdbcFailure("Data element mismatch. " + n4 + " metadata cols, yet " + objectArray.length + " data elements for row " + n3);
                            }
                            this.outPacket.writeShort(n4);
                            for (int i = 0; i < n4; ++i) {
                                if (objectArray[i] == null) {
                                    this.outPacket.writeInt(-1);
                                    continue;
                                }
                                String string5 = pgTypeArray[i].valueString(objectArray[i]);
                                this.outPacket.writeSized(string5);
                                if (!this.server.isTrace()) continue;
                                this.server.printWithThread("R" + n3 + "C" + (i + 1) + " => (" + objectArray[i].getClass().getName() + ") [" + string5 + ']');
                            }
                            this.outPacket.xmit('D', this.dataOutput);
                        }
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (string4.startsWith("deallocate \"") && string4.charAt(string4.length() - 1) == '\"') {
                        StatementPortal statementPortal;
                        String string6 = string3.trim().substring("deallocate \"".length()).trim();
                        String string7 = string6.substring(0, string6.length() - 1);
                        OdbcPreparedStatement odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string7);
                        if (odbcPreparedStatement != null) {
                            odbcPreparedStatement.close();
                        }
                        if ((statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string7)) != null) {
                            statementPortal.close();
                        }
                        if (odbcPreparedStatement == null && statementPortal == null) {
                            this.server.printWithThread("Ignoring bad 'DEALLOCATE' cmd");
                        }
                        if (this.server.isTrace()) {
                            this.server.printWithThread("Deallocated PS/Portal '" + string7 + "'");
                        }
                        this.outPacket.write("DEALLOCATE");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    if (string4.startsWith("set client_encoding to ")) {
                        this.server.printWithThread("Stubbing EXECDIR for: " + string3);
                        this.outPacket.write("SET");
                        this.outPacket.xmit('C', this.dataOutput);
                        bl = true;
                        break;
                    }
                    this.server.printWithThread("Performing a real EXECDIRECT...");
                    this.odbcExecDirect(string3);
                    bl = true;
                    break;
                }
                case 'X': {
                    if (this.sessionOdbcPsMap.size() > (this.sessionOdbcPsMap.containsKey("") ? 1 : 0)) {
                        this.server.printWithThread("Client left " + this.sessionOdbcPsMap.size() + " PS objects open");
                    }
                    if (this.sessionOdbcPortalMap.size() > (this.sessionOdbcPortalMap.containsKey("") ? 1 : 0)) {
                        this.server.printWithThread("Client left " + this.sessionOdbcPortalMap.size() + " Portal objects open");
                    }
                    OdbcUtil.validateInputPacketSize(odbcPacketInputStream);
                    throw this.cleanExit;
                }
                case 'H': {
                    break;
                }
                case 'S': {
                    if (this.session.isAutoCommit()) {
                        try {
                            this.server.printWithThread("Silly implicit commit by Sync");
                            this.session.commit(true);
                        }
                        catch (HsqlException hsqlException) {
                            this.server.printWithThread("Implicit commit failed: " + hsqlException);
                            OdbcUtil.alertClient(2, "Implicit commit failed", hsqlException.getSQLState(), this.dataOutput);
                        }
                    }
                    bl = true;
                    break;
                }
                case 'P': {
                    String string8 = odbcPacketInputStream.readString();
                    String string9 = OdbcUtil.revertMungledPreparedQuery(odbcPacketInputStream.readString());
                    int n = odbcPacketInputStream.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        if (odbcPacketInputStream.readInt() == 0) continue;
                        throw new RecoverableOdbcFailure(null, "Parameter-type OID specifiers not supported yet", "0A000");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Prepare request for query (" + string9 + ") with handle '" + string8 + "'");
                    }
                    if (string8.length() > 0 && this.sessionOdbcPsMap.containsKey(string8)) {
                        throw new RecoverableOdbcFailure(null, "PS handle '" + string8 + "' already in use.  You must close it before recreating", "08P01");
                    }
                    new OdbcPreparedStatement(string8, string9, this.sessionOdbcPsMap, this.session);
                    this.outPacket.xmit('1', this.dataOutput);
                    break;
                }
                case 'D': {
                    int n;
                    ResultMetaData resultMetaData;
                    Type[] typeArray;
                    char c2 = odbcPacketInputStream.readByteChar();
                    String string10 = odbcPacketInputStream.readString();
                    OdbcPreparedStatement odbcPreparedStatement = null;
                    StatementPortal statementPortal = null;
                    if (c2 == 'S') {
                        odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string10);
                    } else if (c2 == 'P') {
                        statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string10);
                    } else {
                        throw new RecoverableOdbcFailure(null, "Description packet request type invalid: " + c2, "08P01");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Describe request for " + c2 + " of  handle '" + string10 + "'");
                    }
                    if (odbcPreparedStatement == null && statementPortal == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for " + c2 + " handle: " + string10, "08P01");
                    }
                    Result result = odbcPreparedStatement == null ? statementPortal.ackResult : odbcPreparedStatement.ackResult;
                    ResultMetaData resultMetaData2 = result.parameterMetaData;
                    int n5 = resultMetaData2.getColumnCount();
                    if (n5 != (typeArray = resultMetaData2.getParameterTypes()).length) {
                        throw new RecoverableOdbcFailure("Parameter count mismatch.  Count of " + n5 + " reported, but there are " + typeArray.length + " param md objects");
                    }
                    if (c2 == 'S') {
                        this.outPacket.writeShort(n5);
                        for (int i = 0; i < typeArray.length; ++i) {
                            this.outPacket.writeInt(PgType.getPgType(typeArray[i], true).getOid());
                        }
                        this.outPacket.xmit('t', this.dataOutput);
                    }
                    if ((resultMetaData = result.metaData).getColumnCount() < 1) {
                        if (this.server.isTrace()) {
                            this.server.printWithThread("Non-rowset query so returning NoData packet");
                        }
                        this.outPacket.xmit('n', this.dataOutput);
                        break;
                    }
                    String[] stringArray = resultMetaData.getGeneratedColumnNames();
                    if (resultMetaData.getColumnCount() != stringArray.length) {
                        throw new RecoverableOdbcFailure("Couldn't get all column names: " + resultMetaData.getColumnCount() + " cols. but only got " + stringArray.length + " col. names");
                    }
                    Type[] typeArray2 = resultMetaData.columnTypes;
                    PgType[] pgTypeArray = new PgType[stringArray.length];
                    ColumnBase[] columnBaseArray = resultMetaData.columns;
                    for (n = 0; n < pgTypeArray.length; ++n) {
                        pgTypeArray[n] = PgType.getPgType(typeArray2[n], resultMetaData.isTableColumn(n));
                    }
                    if (stringArray.length != columnBaseArray.length) {
                        throw new RecoverableOdbcFailure("Col data mismatch.  " + columnBaseArray.length + " col instances but " + stringArray.length + " col names");
                    }
                    this.outPacket.writeShort(stringArray.length);
                    for (n = 0; n < stringArray.length; ++n) {
                        this.outPacket.write(stringArray[n]);
                        this.outPacket.writeInt(OdbcUtil.getTableOidForColumn(n, resultMetaData));
                        this.outPacket.writeShort(OdbcUtil.getIdForColumn(n, resultMetaData));
                        this.outPacket.writeInt(pgTypeArray[n].getOid());
                        this.outPacket.writeShort(pgTypeArray[n].getTypeWidth());
                        this.outPacket.writeInt(pgTypeArray[n].getLPConstraint());
                        this.outPacket.writeShort(0);
                    }
                    this.outPacket.xmit('T', this.dataOutput);
                    break;
                }
                case 'B': {
                    OdbcPreparedStatement odbcPreparedStatement;
                    int n;
                    String string11 = odbcPacketInputStream.readString();
                    String string12 = odbcPacketInputStream.readString();
                    int n6 = odbcPacketInputStream.readUnsignedShort();
                    boolean[] blArray = new boolean[n6];
                    for (int i = 0; i < n6; ++i) {
                        boolean bl2 = blArray[i] = odbcPacketInputStream.readUnsignedShort() != 0;
                        if (!this.server.isTrace() || !blArray[i]) continue;
                        this.server.printWithThread("Binary param #" + i);
                    }
                    int n7 = odbcPacketInputStream.readUnsignedShort();
                    Object[] objectArray = new Object[n7];
                    for (n = 0; n < objectArray.length; ++n) {
                        objectArray[n] = n < blArray.length && blArray[n] ? odbcPacketInputStream.readSizedBinaryData() : odbcPacketInputStream.readSizedString();
                    }
                    n = odbcPacketInputStream.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        if (odbcPacketInputStream.readUnsignedShort() == 0) continue;
                        throw new RecoverableOdbcFailure(null, "Binary output values not supported", "0A000");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Bind request to make Portal from (" + string12 + ")' with handle '" + string11 + "'");
                    }
                    if ((odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string12)) == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for PS handle: " + string12, "08P01");
                    }
                    if (string11.length() > 0 && this.sessionOdbcPortalMap.containsKey(string11)) {
                        throw new RecoverableOdbcFailure(null, "Portal handle '" + string11 + "' already in use.  You must close it before recreating", "08P01");
                    }
                    ResultMetaData resultMetaData = odbcPreparedStatement.ackResult.parameterMetaData;
                    if (n7 != resultMetaData.getColumnCount()) {
                        throw new RecoverableOdbcFailure(null, "Client didn't specify all " + resultMetaData.getColumnCount() + " parameters (" + n7 + ')', "08P01");
                    }
                    new StatementPortal(string11, odbcPreparedStatement, objectArray, this.sessionOdbcPortalMap);
                    this.outPacket.xmit('2', this.dataOutput);
                    break;
                }
                case 'E': {
                    StatementPortal statementPortal;
                    String string13 = odbcPacketInputStream.readString();
                    int n = odbcPacketInputStream.readInt();
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Exec request for " + n + " rows from portal handle '" + string13 + "'");
                    }
                    if ((statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string13)) == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for Portal handle: " + string13, "08P01");
                    }
                    statementPortal.bindResult.setPreparedExecuteProperties(statementPortal.parameters, n, 0, 0, 0);
                    Result result = this.session.execute(statementPortal.bindResult);
                    switch (result.getType()) {
                        case 1: {
                            this.outPacket.write(OdbcUtil.echoBackReplyString(statementPortal.lcQuery, result.getUpdateCount()));
                            this.outPacket.xmit('C', this.dataOutput);
                            if (!statementPortal.lcQuery.equals("commit") && !statementPortal.lcQuery.startsWith("commit ") && !statementPortal.lcQuery.equals("rollback") && !statementPortal.lcQuery.startsWith("rollback ")) break block17;
                            try {
                                this.session.setAutoCommit(true);
                                break block17;
                            }
                            catch (HsqlException hsqlException) {
                                throw new RecoverableOdbcFailure("Failed to change transaction state: " + hsqlException.getMessage(), hsqlException.getSQLState());
                            }
                        }
                        case 3: {
                            break;
                        }
                        case 2: {
                            throw new RecoverableOdbcFailure(result);
                        }
                        default: {
                            throw new RecoverableOdbcFailure("Output Result from Portal execution is of unexpected type: " + result.getType());
                        }
                    }
                    RowSetNavigator rowSetNavigator = result.getNavigator();
                    int n8 = 0;
                    int n9 = statementPortal.ackResult.metaData.getColumnCount();
                    while (rowSetNavigator.next()) {
                        int n10;
                        ++n8;
                        Object[] objectArray = rowSetNavigator.getCurrent();
                        if (objectArray == null) {
                            throw new RecoverableOdbcFailure("Null row?");
                        }
                        if (objectArray.length < n9) {
                            throw new RecoverableOdbcFailure("Data element mismatch. " + n9 + " metadata cols, yet " + objectArray.length + " data elements for row " + n8);
                        }
                        this.outPacket.writeShort(n9);
                        Type[] typeArray = statementPortal.ackResult.metaData.columnTypes;
                        PgType[] pgTypeArray = new PgType[n9];
                        for (n10 = 0; n10 < pgTypeArray.length; ++n10) {
                            pgTypeArray[n10] = PgType.getPgType(typeArray[n10], statementPortal.ackResult.metaData.isTableColumn(n10));
                        }
                        for (n10 = 0; n10 < n9; ++n10) {
                            if (objectArray[n10] == null) {
                                this.outPacket.writeInt(-1);
                                continue;
                            }
                            String string14 = pgTypeArray[n10].valueString(objectArray[n10]);
                            this.outPacket.writeSized(string14);
                            if (!this.server.isTrace()) continue;
                            this.server.printWithThread("R" + n8 + "C" + (n10 + 1) + " => (" + objectArray[n10].getClass().getName() + ") [" + string14 + ']');
                        }
                        this.outPacket.xmit('D', this.dataOutput);
                    }
                    if (rowSetNavigator.afterLast()) {
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        break;
                    }
                    this.outPacket.xmit('s', this.dataOutput);
                    break;
                }
                case 'C': {
                    char c3 = odbcPacketInputStream.readByteChar();
                    String string15 = odbcPacketInputStream.readString();
                    OdbcPreparedStatement odbcPreparedStatement = null;
                    StatementPortal statementPortal = null;
                    if (c3 == 'S') {
                        odbcPreparedStatement = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(string15);
                        if (odbcPreparedStatement != null) {
                            odbcPreparedStatement.close();
                        }
                    } else if (c3 == 'P') {
                        statementPortal = (StatementPortal)this.sessionOdbcPortalMap.get(string15);
                        if (statementPortal != null) {
                            statementPortal.close();
                        }
                    } else {
                        throw new RecoverableOdbcFailure(null, "Description packet request type invalid: " + c3, "08P01");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Closed " + c3 + " '" + string15 + "'? " + (odbcPreparedStatement != null || statementPortal != null));
                    }
                    this.outPacket.xmit('3', this.dataOutput);
                    break;
                }
                default: {
                    throw new RecoverableOdbcFailure(null, "Unsupported operation type (" + odbcPacketInputStream.packetType + ')', "0A000");
                }
            }
            OdbcUtil.validateInputPacketSize(odbcPacketInputStream);
            if (string != null) {
                this.server.printWithThread("Interposing AFTER primary statement: " + string);
                this.odbcExecDirect(string);
            }
            if (bl) {
                this.outPacket.reset();
                this.outPacket.writeByte(this.session.isAutoCommit() ? 73 : 84);
                this.outPacket.xmit('Z', this.dataOutput);
            }
        }
        catch (RecoverableOdbcFailure recoverableOdbcFailure) {
            Result result = recoverableOdbcFailure.getErrorResult();
            if (result == null) {
                String string16 = recoverableOdbcFailure.getSqlStateCode();
                String string17 = recoverableOdbcFailure.toString();
                String string18 = recoverableOdbcFailure.getClientMessage();
                if (this.server.isTrace()) {
                    this.server.printWithThread(string17);
                }
                if (string18 != null) {
                    OdbcUtil.alertClient(2, string18, string16, this.dataOutput);
                }
            } else {
                if (this.server.isTrace()) {
                    this.server.printWithThread("Result object error: " + result.getMainString());
                }
                OdbcUtil.alertClient(2, result.getMainString(), result.getSubString(), this.dataOutput);
            }
            switch (this.odbcCommMode) {
                case 0: {
                    this.outPacket.reset();
                    this.outPacket.writeByte(69);
                    this.outPacket.xmit('Z', this.dataOutput);
                    break;
                }
                case 1: {
                    this.odbcCommMode = 2;
                    this.server.printWithThread("Reverting to EXT_RECOVER mode");
                }
            }
        }
    }

    @Override
    public void run() {
        block9: {
            this.init();
            if (this.session != null) {
                try {
                    while (this.keepAlive) {
                        byte by = this.dataInput.readByte();
                        if (by < 48) {
                            this.receiveResult(by);
                            continue;
                        }
                        this.receiveOdbcPacket((char)by);
                    }
                }
                catch (CleanExit cleanExit) {
                    this.keepAlive = false;
                }
                catch (IOException iOException) {
                    this.server.printWithThread(this.mThread + ":disconnected " + this.user);
                }
                catch (HsqlException hsqlException) {
                    if (this.keepAlive) {
                        this.server.printStackTrace(hsqlException);
                    }
                }
                catch (Throwable throwable) {
                    if (!this.keepAlive) break block9;
                    this.server.printStackTrace(throwable);
                }
            }
        }
        this.close();
    }

    private Result setDatabase(Result result) {
        try {
            String string = result.getDatabaseName();
            this.dbIndex = this.server.getDBIndex(string);
            this.dbID = this.server.dbID[this.dbIndex];
            this.user = result.getMainString();
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to connect user '" + this.user + "' to DB (" + string + ')');
            }
            this.session = DatabaseManager.newSession(this.dbID, this.user, result.getSubString(), result.getZoneString(), result.getUpdateCount());
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Connected user '" + this.user + "'");
            }
            return Result.newConnectionAcknowledgeResponse(this.session);
        }
        catch (HsqlException hsqlException) {
            this.session = null;
            return Result.newErrorResult(hsqlException);
        }
        catch (RuntimeException runtimeException) {
            this.session = null;
            return Result.newErrorResult(runtimeException);
        }
    }

    private Result cancelStatement(Result result) {
        try {
            this.dbID = result.getDatabaseId();
            long l = result.getSessionId();
            this.session = DatabaseManager.getSession(this.dbID, l);
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to cancel statement  to DB (" + this.dbID + ')');
            }
            return this.session.cancel(result);
        }
        catch (HsqlException hsqlException) {}
        finally {
            this.session = null;
            return Result.updateZeroResult;
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB Connection @" + Integer.toString(this.hashCode(), 16);
    }

    public int handshake() throws IOException {
        long l = new Date().getTime() + MAX_WAIT_FOR_CLIENT_DATA;
        if (!(this.socket instanceof SSLSocket)) {
            do {
                try {
                    Thread.sleep(CLIENT_DATA_POLLING_PERIOD);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.dataInput.available() < 5 && new Date().getTime() < l);
            if (this.dataInput.available() < 1) {
                this.dataOutput.write((TEXTBANNER_PART1 + "2.3.4.0" + TEXTBANNER_PART2 + '\n').getBytes());
                this.dataOutput.flush();
                throw Error.error(404);
            }
        }
        int n = this.dataInput.readInt();
        switch (n >> 24) {
            case 80: {
                this.server.print("Rejected attempt from client using hsql HTTP protocol");
                return 0;
            }
            case 0: {
                this.streamProtocol = 2;
                break;
            }
            default: {
                this.streamProtocol = 1;
            }
        }
        return n;
    }

    private void odbcConnect(int n) throws IOException {
        int n2 = this.dataInput.readUnsignedShort();
        int n3 = this.dataInput.readUnsignedShort();
        if (n2 == 1 && n3 == 7) {
            this.server.print("A pre-version 2.0 client attempted to connect.  We rejected them.");
            return;
        }
        if (n2 == 1234 && n3 == 5679) {
            this.dataOutput.writeByte(78);
            this.odbcConnect(this.dataInput.readInt());
            return;
        }
        if (n2 == 1234 && n3 == 5678) {
            if (n != 16) {
                this.server.print("ODBC cancellation request sent wrong packet length: " + n);
            }
            this.server.print("Got an ODBC cancellation request for thread ID " + this.dataInput.readInt() + ", but we don't support OOB cancellation yet.  Ignoring this request and closing the connection.");
            return;
        }
        this.server.printWithThread("ODBC client connected.  ODBC Protocol Compatibility Version " + n2 + '.' + n3);
        OdbcPacketInputStream odbcPacketInputStream = OdbcPacketInputStream.newOdbcPacketInputStream('\u0000', (InputStream)this.dataInput, n - 8);
        Map map = odbcPacketInputStream.readStringPairs();
        if (this.server.isTrace()) {
            this.server.print("String Pairs from ODBC client: " + map);
        }
        try {
            try {
                OdbcUtil.validateInputPacketSize(odbcPacketInputStream);
            }
            catch (RecoverableOdbcFailure recoverableOdbcFailure) {
                throw new ClientFailure(recoverableOdbcFailure.toString(), recoverableOdbcFailure.getClientMessage());
            }
            odbcPacketInputStream.close();
            if (!map.containsKey("database")) {
                throw new ClientFailure("Client did not identify database", "Target database not identified");
            }
            if (!map.containsKey("user")) {
                throw new ClientFailure("Client did not identify user", "Target account not identified");
            }
            String string = (String)map.get("database");
            this.user = (String)map.get("user");
            if (string.equals("/")) {
                string = "";
            }
            this.dataOutput.writeByte(82);
            this.dataOutput.writeInt(8);
            this.dataOutput.writeInt(3);
            this.dataOutput.flush();
            char c = '\u0000';
            try {
                c = (char)this.dataInput.readByte();
            }
            catch (EOFException eOFException) {
                this.server.printWithThread("Looks like we got a goofy psql no-auth attempt.  Will probably retry properly very shortly");
                return;
            }
            if (c != 'p') {
                throw new ClientFailure("Expected password prefix 'p', but got '" + c + "'", "Password value not prefixed with 'p'");
            }
            int n4 = this.dataInput.readInt() - 5;
            if (n4 < 0) {
                throw new ClientFailure("Client submitted invalid password length " + n4, "Invalid password length " + n4);
            }
            String string2 = ServerConnection.readNullTermdUTF(n4, this.dataInput);
            this.dbIndex = this.server.getDBIndex(string);
            this.dbID = this.server.dbID[this.dbIndex];
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to connect user '" + this.user + "' to DB (" + string + ')');
            }
            try {
                this.session = DatabaseManager.newSession(this.dbID, this.user, string2, null, 0);
            }
            catch (Exception exception) {
                throw new ClientFailure("User name or password denied: " + exception, "Login attempt rejected");
            }
        }
        catch (ClientFailure clientFailure) {
            this.server.print(clientFailure.toString());
            OdbcUtil.alertClient(1, clientFailure.getClientMessage(), "08006", this.dataOutput);
            return;
        }
        this.outPacket = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        this.outPacket.writeInt(0);
        this.outPacket.xmit('R', this.dataOutput);
        for (int i = 0; i < OdbcUtil.hardcodedParams.length; ++i) {
            OdbcUtil.writeParam(OdbcUtil.hardcodedParams[i][0], OdbcUtil.hardcodedParams[i][1], this.dataOutput);
        }
        this.outPacket.writeByte(73);
        this.outPacket.xmit('Z', this.dataOutput);
        OdbcUtil.alertClient(7, "MHello\nYou have connected to HyperSQL ODBC Server", this.dataOutput);
        this.dataOutput.flush();
    }

    private static String readNullTermdUTF(int n, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[n + 3];
        byArray[0] = (byte)(n >>> 8);
        byArray[1] = (byte)n;
        for (int i = 0; i < n + 1; i += inputStream.read(byArray, 2 + i, n + 1 - i)) {
        }
        if (byArray[byArray.length - 1] != 0) {
            throw new IOException("String not null-terminated");
        }
        for (int i = 2; i < byArray.length - 1; ++i) {
            if (byArray[i] != 0) continue;
            throw new RuntimeException("Null internal to String at offset " + (i - 2));
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    private void odbcExecDirect(String string) throws RecoverableOdbcFailure, IOException {
        String string2 = string;
        String string3 = string2.trim().toLowerCase();
        if (string3.startsWith("release ") && !string3.startsWith("release savepoint")) {
            this.server.printWithThread("Transmogrifying 'RELEASE ...' to 'RELEASE SAVEPOINT...");
            string2 = string2.trim().substring(0, "release ".length()) + "SAVEPOINT " + string2.trim().substring("release ".length());
        }
        Result result = Result.newExecuteDirectRequest();
        result.setPrepareOrExecuteProperties(string2, 0, 0, 1, 0, 0, 2, null, null);
        Result result2 = this.session.execute(result);
        switch (result2.getType()) {
            case 1: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(result2);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from execution is of unexpected type: " + result2.getType());
            }
        }
        this.outPacket.reset();
        this.outPacket.write(OdbcUtil.echoBackReplyString(string3, result2.getUpdateCount()));
        this.outPacket.xmit('C', this.dataOutput);
        if (string3.equals("commit") || string3.startsWith("commit ") || string3.equals("rollback") || string3.startsWith("rollback ")) {
            try {
                this.session.setAutoCommit(true);
            }
            catch (HsqlException hsqlException) {
                throw new RecoverableOdbcFailure("Failed to change transaction state: " + hsqlException.getMessage(), hsqlException.getSQLState());
            }
        }
    }

    static {
        int n = ResourceBundleHandler.getBundleHandle("org_hsqldb_server_Server_messages", null);
        if (n < 0) {
            throw new RuntimeException("MISSING Resource Bundle.  See source code");
        }
        TEXTBANNER_PART1 = ResourceBundleHandler.getString(n, "textbanner.part1");
        TEXTBANNER_PART2 = ResourceBundleHandler.getString(n, "textbanner.part2");
        if (TEXTBANNER_PART1 == null || TEXTBANNER_PART2 == null) {
            throw new RuntimeException("MISSING Resource Bundle msg definition.  See source code");
        }
        MAX_WAIT_FOR_CLIENT_DATA = 1000L;
        CLIENT_DATA_POLLING_PERIOD = 100L;
    }

    private static class ClientFailure
    extends Exception {
        private String clientMessage = null;

        public ClientFailure(String string, String string2) {
            super(string);
            this.clientMessage = string2;
        }

        public String getClientMessage() {
            return this.clientMessage;
        }
    }

    private static class CleanExit
    extends Exception {
        private CleanExit() {
        }
    }
}

