/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.quantization;

import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.quantization.HashMultiset;
import net.sourceforge.plantuml.quantization.Multiset;
import net.sourceforge.plantuml.quantization.QColor;

public final class QImage {
    private final QColor[][] colors;

    private QImage(QColor[][] colors) {
        this.colors = colors;
    }

    public static QImage fromBufferedImage(ColorMapper mapper, BufferedImage img) {
        int height = img.getHeight();
        int width = img.getWidth();
        QColor[][] colors = new QColor[height][width];
        if (img.getType() == 2) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    colors[y][x] = QColor.fromArgbInt(mapper, img.getRGB(x, y));
                }
            }
        } else if (img.getType() == 1) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    colors[y][x] = QColor.fromRgbInt(img.getRGB(x, y));
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        return new QImage(colors);
    }

    public static QImage fromColors(QColor[][] colors) {
        return new QImage(colors);
    }

    public QColor getColor(int x, int y) {
        return this.colors[y][x];
    }

    public QColor getColor(int index) {
        return this.colors[index / this.getWidth()][index % this.getWidth()];
    }

    Multiset<QColor> getColors() {
        HashMultiset<QColor> colorCounts = new HashMultiset<QColor>();
        for (int i = 0; i < this.getNumPixels(); ++i) {
            QColor color = this.getColor(i);
            colorCounts.add(color);
        }
        return colorCounts;
    }

    public int getWidth() {
        return this.colors[0].length;
    }

    public int getHeight() {
        return this.colors.length;
    }

    public int getNumPixels() {
        return this.getWidth() * this.getHeight();
    }

    public BufferedImage toBufferedImage() {
        BufferedImage result = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        for (int i = 0; i < result.getWidth(); ++i) {
            for (int j = 0; j < result.getHeight(); ++j) {
                result.setRGB(i, j, this.colors[j][i].getRgbInt());
            }
        }
        return result;
    }

    public BufferedImage toBufferedImageKeepTransparency(BufferedImage orig) {
        BufferedImage result = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        for (int i = 0; i < result.getWidth(); ++i) {
            for (int j = 0; j < result.getHeight(); ++j) {
                if (orig.getRGB(i, j) == 0) continue;
                result.setRGB(i, j, this.colors[j][i].getRgbInt() | 0xFF000000);
            }
        }
        return result;
    }
}

