from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Expr import *
from OCC.Core.TCollection import *


class ExprIntrp_SequenceOfNamedExpression:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class ExprIntrp_SequenceOfNamedFunction:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class ExprIntrp_StackOfGeneralExpression:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class ExprIntrp_StackOfGeneralFunction:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class ExprIntrp_StackOfGeneralRelation:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class exprintrp:
    pass

class ExprIntrp_Analysis:
    def __init__(self) -> None: ...
    def GetFunction(self, name: TCollection_AsciiString) -> Expr_NamedFunction: ...
    def GetNamed(self, name: TCollection_AsciiString) -> Expr_NamedExpression: ...
    def IsExpStackEmpty(self) -> bool: ...
    def IsRelStackEmpty(self) -> bool: ...
    def Pop(self) -> Expr_GeneralExpression: ...
    def PopFunction(self) -> Expr_GeneralFunction: ...
    def PopName(self) -> TCollection_AsciiString: ...
    def PopRelation(self) -> Expr_GeneralRelation: ...
    def PopValue(self) -> int: ...
    def Push(self, exp: Expr_GeneralExpression) -> None: ...
    def PushFunction(self, func: Expr_GeneralFunction) -> None: ...
    def PushName(self, name: TCollection_AsciiString) -> None: ...
    def PushRelation(self, rel: Expr_GeneralRelation) -> None: ...
    def PushValue(self, degree: int) -> None: ...
    def ResetAll(self) -> None: ...
    def SetMaster(self, agen: ExprIntrp_Generator) -> None: ...
    @overload
    def Use(self, func: Expr_NamedFunction) -> None: ...
    @overload
    def Use(self, named: Expr_NamedExpression) -> None: ...

class ExprIntrp_Generator(Standard_Transient):
    def GetFunction(self, name: TCollection_AsciiString) -> Expr_NamedFunction: ...
    def GetFunctions(self) -> ExprIntrp_SequenceOfNamedFunction: ...
    @overload
    def GetNamed(self) -> ExprIntrp_SequenceOfNamedExpression: ...
    @overload
    def GetNamed(self, name: TCollection_AsciiString) -> Expr_NamedExpression: ...
    @overload
    def Use(self, func: Expr_NamedFunction) -> None: ...
    @overload
    def Use(self, named: Expr_NamedExpression) -> None: ...

class ExprIntrp_GenExp(ExprIntrp_Generator):
    @staticmethod
    def Create() -> ExprIntrp_GenExp: ...
    def Expression(self) -> Expr_GeneralExpression: ...
    def IsDone(self) -> bool: ...
    def Process(self, str: TCollection_AsciiString) -> None: ...

class ExprIntrp_GenFct(ExprIntrp_Generator):
    @staticmethod
    def Create() -> ExprIntrp_GenFct: ...
    def IsDone(self) -> bool: ...
    def Process(self, str: TCollection_AsciiString) -> None: ...

class ExprIntrp_GenRel(ExprIntrp_Generator):
    @staticmethod
    def Create() -> ExprIntrp_GenRel: ...
    def IsDone(self) -> bool: ...
    def Process(self, str: TCollection_AsciiString) -> None: ...
    def Relation(self) -> Expr_GeneralRelation: ...

# harray1 classes
# harray2 classes
# hsequence classes

ExprIntrp_GenExp_Create = ExprIntrp_GenExp.Create
ExprIntrp_GenFct_Create = ExprIntrp_GenFct.Create
ExprIntrp_GenRel_Create = ExprIntrp_GenRel.Create
