# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
ShapeAnalysis module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_shapeanalysis.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ShapeAnalysis
else:
    import _ShapeAnalysis

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ShapeAnalysis.delete_SwigPyIterator

    def value(self):
        return _ShapeAnalysis.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _ShapeAnalysis.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _ShapeAnalysis.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _ShapeAnalysis.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _ShapeAnalysis.SwigPyIterator_equal(self, x)

    def copy(self):
        return _ShapeAnalysis.SwigPyIterator_copy(self)

    def next(self):
        return _ShapeAnalysis.SwigPyIterator_next(self)

    def __next__(self):
        return _ShapeAnalysis.SwigPyIterator___next__(self)

    def previous(self):
        return _ShapeAnalysis.SwigPyIterator_previous(self)

    def advance(self, n):
        return _ShapeAnalysis.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _ShapeAnalysis.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _ShapeAnalysis.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _ShapeAnalysis.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _ShapeAnalysis.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _ShapeAnalysis.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _ShapeAnalysis.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ShapeAnalysis:
_ShapeAnalysis.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _ShapeAnalysis.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.ShapeExtend
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TColGeom
import OCC.Core.TopTools
import OCC.Core.Geom2d
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.IntRes2d

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_ShapeAnalysis_FreeBoundData_Create():
    return _ShapeAnalysis.Handle_ShapeAnalysis_FreeBoundData_Create()

def Handle_ShapeAnalysis_FreeBoundData_DownCast(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_FreeBoundData_DownCast(t)

def Handle_ShapeAnalysis_FreeBoundData_IsNull(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_FreeBoundData_IsNull(t)

def Handle_ShapeAnalysis_Surface_Create():
    return _ShapeAnalysis.Handle_ShapeAnalysis_Surface_Create()

def Handle_ShapeAnalysis_Surface_DownCast(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_Surface_DownCast(t)

def Handle_ShapeAnalysis_Surface_IsNull(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_Surface_IsNull(t)

def Handle_ShapeAnalysis_TransferParameters_Create():
    return _ShapeAnalysis.Handle_ShapeAnalysis_TransferParameters_Create()

def Handle_ShapeAnalysis_TransferParameters_DownCast(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_TransferParameters_DownCast(t)

def Handle_ShapeAnalysis_TransferParameters_IsNull(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_TransferParameters_IsNull(t)

def Handle_ShapeAnalysis_Wire_Create():
    return _ShapeAnalysis.Handle_ShapeAnalysis_Wire_Create()

def Handle_ShapeAnalysis_Wire_DownCast(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_Wire_DownCast(t)

def Handle_ShapeAnalysis_Wire_IsNull(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_Wire_IsNull(t)

def Handle_ShapeAnalysis_TransferParametersProj_Create():
    return _ShapeAnalysis.Handle_ShapeAnalysis_TransferParametersProj_Create()

def Handle_ShapeAnalysis_TransferParametersProj_DownCast(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_TransferParametersProj_DownCast(t)

def Handle_ShapeAnalysis_TransferParametersProj_IsNull(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_TransferParametersProj_IsNull(t)

def Handle_ShapeAnalysis_HSequenceOfFreeBounds_Create():
    return _ShapeAnalysis.Handle_ShapeAnalysis_HSequenceOfFreeBounds_Create()

def Handle_ShapeAnalysis_HSequenceOfFreeBounds_DownCast(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_HSequenceOfFreeBounds_DownCast(t)

def Handle_ShapeAnalysis_HSequenceOfFreeBounds_IsNull(t):
    return _ShapeAnalysis.Handle_ShapeAnalysis_HSequenceOfFreeBounds_IsNull(t)
class ShapeAnalysis_BoxBndTree(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _ShapeAnalysis.ShapeAnalysis_BoxBndTree_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_BoxBndTree(*args))

    def Add(self, theObj, theBnd):
        return _ShapeAnalysis.ShapeAnalysis_BoxBndTree_Add(self, theObj, theBnd)

    def Select(self, theSelector):
        return _ShapeAnalysis.ShapeAnalysis_BoxBndTree_Select(self, theSelector)

    def Clear(self, aNewAlloc=0):
        return _ShapeAnalysis.ShapeAnalysis_BoxBndTree_Clear(self, aNewAlloc)

    def IsEmpty(self):
        return _ShapeAnalysis.ShapeAnalysis_BoxBndTree_IsEmpty(self)

    def Root(self):
        return _ShapeAnalysis.ShapeAnalysis_BoxBndTree_Root(self)
    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_BoxBndTree

    def Allocator(self):
        return _ShapeAnalysis.ShapeAnalysis_BoxBndTree_Allocator(self)

# Register ShapeAnalysis_BoxBndTree in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_BoxBndTree_swigregister(ShapeAnalysis_BoxBndTree)
class ShapeAnalysis_DataMapOfShapeListOfReal(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_begin(self)

    def end(self):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_end(self)

    def cbegin(self):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_cbegin(self)

    def cend(self):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_cend(self)

    def __init__(self, *args):
        _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_DataMapOfShapeListOfReal(*args))

    def Exchange(self, theOther):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Exchange(self, theOther)

    def Assign(self, theOther):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Assign(self, theOther)

    def Set(self, theOther):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Set(self, theOther)

    def ReSize(self, N):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_ReSize(self, N)

    def Bind(self, theKey, theItem):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Bind(self, theKey, theItem)

    def Bound(self, theKey, theItem):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Bound(self, theKey, theItem)

    def IsBound(self, theKey):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_UnBind(self, theKey)

    def Seek(self, theKey):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Seek(self, theKey)

    def Find(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal___call__(self, *args)

    def Clear(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Clear(self, *args)
    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_DataMapOfShapeListOfReal

    def Size(self):
        return _ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_Size(self)

# Register ShapeAnalysis_DataMapOfShapeListOfReal in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_DataMapOfShapeListOfReal_swigregister(ShapeAnalysis_DataMapOfShapeListOfReal)
class ShapeAnalysis_SequenceOfFreeBounds(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_begin(self)

    def end(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_end(self)

    def cbegin(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_cbegin(self)

    def cend(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_cend(self)

    def __init__(self, *args):
        _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_SequenceOfFreeBounds(*args))

    def Size(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Size(self)

    def Length(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Length(self)

    def Lower(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Lower(self)

    def Upper(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Upper(self)

    def IsEmpty(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_IsEmpty(self)

    def Reverse(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Reverse(self)

    def Exchange(self, I, J):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Assign(self, theOther)

    def Set(self, theOther):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Set(self, theOther)

    def Remove(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Remove(self, *args)

    def Append(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Append(self, *args)

    def Prepend(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Split(self, theIndex, theSeq)

    def First(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_First(self)

    def ChangeFirst(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_ChangeFirst(self)

    def Last(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Last(self)

    def ChangeLast(self):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_ChangeLast(self)

    def Value(self, theIndex):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_SequenceOfFreeBounds

    def __len__(self):
        return self.Size()


# Register ShapeAnalysis_SequenceOfFreeBounds in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_SequenceOfFreeBounds_swigregister(ShapeAnalysis_SequenceOfFreeBounds)
class shapeanalysis(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AdjustByPeriod(*args):
        r"""
        Returns a shift required to move point <val> to the range [toval-period/2,toval+period/2]. this shift will be the divisible by period. intended for adjusting parameters on periodic surfaces.

        Parameters
        ----------
        Val: float
        ToVal: float
        Period: float

        Returns
        -------
        float

        """
        return _ShapeAnalysis.shapeanalysis_AdjustByPeriod(*args)

    @staticmethod
    def AdjustToPeriod(*args):
        r"""
        Returns a shift required to move point <val> to the range [valmin,valmax]. this shift will be the divisible by period with period = valmax - valmin. intended for adjusting parameters on periodic surfaces.

        Parameters
        ----------
        Val: float
        ValMin: float
        ValMax: float

        Returns
        -------
        float

        """
        return _ShapeAnalysis.shapeanalysis_AdjustToPeriod(*args)

    @staticmethod
    def ContourArea(*args):
        r"""
        Returns a total area of 3d wire.

        Parameters
        ----------
        theWire: TopoDS_Wire

        Returns
        -------
        float

        """
        return _ShapeAnalysis.shapeanalysis_ContourArea(*args)

    @staticmethod
    def FindBounds(*args):
        r"""
        Finds the start and end vertices of the shape shape can be of the following type: vertex: v1 and v2 are the same and equal to <shape>, edge : v1 is start and v2 is end vertex (see shapeanalysis_edge methods firstvertex and lastvertex), wire : v1 is start vertex of the first edge, v2 is end vertex of the last edge (also see shapeanalysis_edge). if wire contains no edges v1 and v2 are nullified if none of the above v1 and v2 are nullified.

        Parameters
        ----------
        shape: TopoDS_Shape
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        None

        """
        return _ShapeAnalysis.shapeanalysis_FindBounds(*args)

    @staticmethod
    def GetFaceUVBounds(*args):
        r"""
        Computes exact uv bounds of all wires on the face.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        Umin: float
        Umax: float
        Vmin: float
        Vmax: float

        """
        return _ShapeAnalysis.shapeanalysis_GetFaceUVBounds(*args)

    @staticmethod
    def IsOuterBound(*args):
        r"""
        Returns true if <f> has outer bound.

        Parameters
        ----------
        face: TopoDS_Face

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.shapeanalysis_IsOuterBound(*args)

    @staticmethod
    def OuterWire(*args):
        r"""
        Returns the outer wire on the face <face>. this is replacement of the method breptools::outerwire until it works badly. returns the first wire oriented as outer according to fclass2d_classifier. if none, last wire is returned.

        Parameters
        ----------
        face: TopoDS_Face

        Returns
        -------
        TopoDS_Wire

        """
        return _ShapeAnalysis.shapeanalysis_OuterWire(*args)

    @staticmethod
    def TotCross2D(*args):
        r"""
        Returns a total area of 2d wire.

        Parameters
        ----------
        sewd: ShapeExtend_WireData
        aFace: TopoDS_Face

        Returns
        -------
        float

        """
        return _ShapeAnalysis.shapeanalysis_TotCross2D(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeAnalysis.shapeanalysis_swiginit(self, _ShapeAnalysis.new_shapeanalysis())
    __swig_destroy__ = _ShapeAnalysis.delete_shapeanalysis

# Register shapeanalysis in _ShapeAnalysis:
_ShapeAnalysis.shapeanalysis_swigregister(shapeanalysis)
class ShapeAnalysis_CheckSmallFace(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty tool checks a shape i.e. each of its faces, records checks as diagnostics in the <infos> //! if <infos> has not been set before, no check is done //! for faces which are in a shell, topological data are recorded to allow recovering connectivities after fixing or removing the small faces or parts of faces enchains various checks on a face inshell : to compute more information, relevant to topology.

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_CheckSmallFace(*args))

    def CheckPin(self, *args):
        r"""
        Checks if a face has a pin, which can be edited no singularity : no pin, returns 0 if there is a pin, checked topics, with returned value : - 0 : nothing to do more - 1 : 'smooth', i.e. not a really sharp pin -> diagnostic 'smoothpin' - 2 : stretched pin, i.e. is possible to relimit the face by another vertex, so that this vertex still gives a pin -> diagnostic 'stretchedpin' with location of vertex (pnt).

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        whatrow: int
        sence: int

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckPin(self, *args)

    def CheckPinEdges(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theFirstEdge: TopoDS_Edge
        theSecondEdge: TopoDS_Edge
        coef1: float
        coef2: float
        toler: float

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckPinEdges(self, *args)

    def CheckPinFace(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        F: TopoDS_Face
        mapEdges: TopTools_DataMapOfShapeShape
        toler: float,optional
        	default value is -1.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckPinFace(self, *args)

    def CheckSingleStrip(self, *args):
        r"""
        Checks if a face is a single strip, i.e. brings two great edges which are confused on their whole length, possible other edges are small or null length //! returns 0 if not a strip support, 1 strip in u, 2 strip in v records diagnostic in info if it is a single strip.

        Parameters
        ----------
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        tol: float,optional
        	default value is -1.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckSingleStrip(self, *args)

    def CheckSplittingVertices(self, *args):
        r"""
        Checks if a face brings vertices which split it, either confused with non adjacent vertices, or confused with their projection on non adjacent edges returns the count of found splitting vertices each vertex then brings a diagnostic 'splittingvertex', with data : 'face' for the face, 'edge' for the split edge.

        Parameters
        ----------
        F: TopoDS_Face
        MapEdges: TopTools_DataMapOfShapeListOfShape
        MapParam: ShapeAnalysis_DataMapOfShapeListOfReal
        theAllVert: TopoDS_Compound

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckSplittingVertices(self, *args)

    def CheckSpotFace(self, *args):
        r"""
        Acts as isspotface, but records in <infos> a diagnostic 'spotface' with the pnt as value (data 'location').

        Parameters
        ----------
        F: TopoDS_Face
        tol: float,optional
        	default value is -1.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckSpotFace(self, *args)

    def CheckStripEdges(self, *args):
        r"""
        Checks if two edges define a strip, i.e. distance maxi below tolerance, given or some of those of e1 and e2.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        tol: float

        Returns
        -------
        dmax: float

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckStripEdges(self, *args)

    def CheckStripFace(self, *args):
        r"""
        Checks if a face is as a strip returns 0 if not or non determined, 1 if in u, 2 if in v by default, considers the tolerance zone of its edges a given value <tol> may be given to check a strip of max this width //! if a face is determined as a strip, it is delinited by two lists of edges. these lists are recorded in diagnostic diagnostic 'stripface' brings data 'direction' (u or v), 'list1' , 'list2' (if they could be computed).

        Parameters
        ----------
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        tol: float,optional
        	default value is -1.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckStripFace(self, *args)

    def CheckTwisted(self, *args):
        r"""
        Checks if a face is twisted (apart from checking pin, i.e. it does not give information on pin, only 'it is twisted').

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        paramu: float
        paramv: float

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_CheckTwisted(self, *args)

    def FindStripEdges(self, *args):
        r"""
        Searches for two and only two edges up tolerance returns true if ok, false if not 2 edges if true, returns the two edges and their maximum distance.

        Parameters
        ----------
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        tol: float

        Returns
        -------
        dmax: float

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_FindStripEdges(self, *args)

    def IsSpotFace(self, *args):
        r"""
        Checks if a face is as a spot returns 0 if not, 1 if yes, 2 if yes and all vertices are the same by default, considers the tolerance zone of its vertices a given value <tol> may be given to check a spot of this size if a face is a spot, its location is returned in <spot>, and <spotol> returns an equivalent tolerance, which is computed as half of max dimension of min-max box of the face.

        Parameters
        ----------
        F: TopoDS_Face
        spot: gp_Pnt
        tol: float,optional
        	default value is -1.0

        Returns
        -------
        spotol: float

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_IsSpotFace(self, *args)

    def IsStripSupport(self, *args):
        r"""
        Checks if a face lies on a surface which is a strip so the face is a strip. but a face may be a strip elsewhere .. //! a given value <tol> may be given to check max width by default, considers the tolerance zone of its edges returns 0 if not a strip support, 1 strip in u, 2 strip in v.

        Parameters
        ----------
        F: TopoDS_Face
        tol: float,optional
        	default value is -1.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_IsStripSupport(self, *args)

    def SetTolerance(self, *args):
        r"""
        Sets a fixed tolerance to check small face by default, local tolerance zone is considered sets a fixed maxtolerance to check small face sets a fixed tolerance to check small face by default, local tolerance zone is considered unset fixed tolerance, comes back to local tolerance zones unset fixed tolerance, comes back to local tolerance zones.

        Parameters
        ----------
        tol: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_SetTolerance(self, *args)

    def Status(self, *args):
        r"""
        Returns the status of last call to perform() shapeextend_ok : face was ok, nothing done shapeextend_done1: some wires are fixed shapeextend_done2: orientation of wires fixed shapeextend_done3: missing seam added shapeextend_done4: small area wire removed shapeextend_done5: natural bounds added shapeextend_fail1: some fails during fixing wires shapeextend_fail2: cannot fix orientation of wires shapeextend_fail3: cannot add missing seam shapeextend_fail4: cannot remove small area wire.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_Status(self, *args)

    def StatusPin(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusPin(self, *args)

    def StatusPinEdges(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusPinEdges(self, *args)

    def StatusPinFace(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusPinFace(self, *args)

    def StatusSplitVert(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusSplitVert(self, *args)

    def StatusSpot(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusSpot(self, *args)

    def StatusStrip(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusStrip(self, *args)

    def StatusTwisted(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_StatusTwisted(self, *args)

    def Tolerance(self, *args):
        r"""
        Returns the tolerance to check small faces, negative value if local tolerances zones are to be considered.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_CheckSmallFace_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_CheckSmallFace

# Register ShapeAnalysis_CheckSmallFace in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_CheckSmallFace_swigregister(ShapeAnalysis_CheckSmallFace)
class ShapeAnalysis_Curve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def FillBndBox(self, *args):
        r"""
        Computes a boundary box on segment of curve c2d from first to last. this is done by taking npoints points from the curve and, if exact is true, by searching for exact extrema. all these points are added to box.

        Parameters
        ----------
        C2d: Geom2d_Curve
        First: float
        Last: float
        NPoints: int
        Exact: bool
        Box: Bnd_Box2d

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_FillBndBox(self, *args)

    @staticmethod
    def GetSamplePoints(*args):
        r"""
        Returns sample points which will serve as linearisation of the2d curve in range (first, last) the distribution of sample points is consystent with what is used by breptopadaptor_fclass2d.

        Parameters
        ----------
        curve: Geom2d_Curve
        first: float
        last: float
        seq: TColgp_SequenceOfPnt2d

        Returns
        -------
        bool
        Returns sample points which will serve as linearisation of the curve in range (first, last).

        Parameters
        ----------
        curve: Geom_Curve
        first: float
        last: float
        seq: TColgp_SequenceOfPnt

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_GetSamplePoints(*args)

    @staticmethod
    def IsClosed(*args):
        r"""
        Tells if the curve is closed with given precision. if <preci> < 0 then precision::confusion is used.

        Parameters
        ----------
        curve: Geom_Curve
        preci: float,optional
        	default value is -1

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_IsClosed(*args)

    @staticmethod
    def IsPeriodic(*args):
        r"""
        This method was implemented as fix for changes in trimmed curve behaviour. for the moment trimmed curve returns false anyway. so it is necessary to adapt all data exchange tools for this behaviour. current implementation takes into account that curve may be offset.

        Parameters
        ----------
        curve: Geom_Curve

        Returns
        -------
        bool
        The same as for curve3d.

        Parameters
        ----------
        curve: Geom2d_Curve

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_IsPeriodic(*args)

    @staticmethod
    def IsPlanar(*args):
        r"""
        Checks if points are planar with given preci. if normal has not zero modulus, checks with given normal.

        Parameters
        ----------
        pnts: TColgp_Array1OfPnt
        Normal: gp_XYZ
        preci: float,optional
        	default value is 0

        Returns
        -------
        bool
        Checks if curve is planar with given preci. if normal has not zero modulus, checks with given normal.

        Parameters
        ----------
        curve: Geom_Curve
        Normal: gp_XYZ
        preci: float,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_IsPlanar(*args)

    def NextProject(self, *args):
        r"""
        Projects a point on a curve using newton method. <paramprev> is taken as the first approximation of solution. if newton algorithm fails the method project() is used. if adjusttoends is true, point will be adjusted to the end of the curve if distance is less than <preci>.

        Parameters
        ----------
        paramPrev: float
        C3D: Geom_Curve
        P3D: gp_Pnt
        preci: float
        proj: gp_Pnt
        cf: float
        cl: float
        AdjustToEnds: bool,optional
        	default value is Standard_True

        Returns
        -------
        param: float
        Projects a point on a curve using newton method. <paramprev> is taken as the first approximation of solution. if newton algorithm fails the method project() is used.

        Parameters
        ----------
        paramPrev: float
        C3D: Adaptor3d_Curve
        P3D: gp_Pnt
        preci: float
        proj: gp_Pnt

        Returns
        -------
        param: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_NextProject(self, *args)

    def Project(self, *args):
        r"""
        Projects a point on a curve. computes the projected point and its parameter on the curve. <preci> is used as 3d precision (hence, 0 will produce reject unless exact confusion). the number of iterations is limited. if adjusttoends is true, point will be adjusted to the end of the curve if distance is less than <preci> //! returned value is the distance between the given point and computed one.

        Parameters
        ----------
        C3D: Geom_Curve
        P3D: gp_Pnt
        preci: float
        proj: gp_Pnt
        AdjustToEnds: bool,optional
        	default value is Standard_True

        Returns
        -------
        param: float
        Projects a point on a curve. computes the projected point and its parameter on the curve. <preci> is used as 3d precision (hence, 0 will produce reject unless exact confusion). the number of iterations is limited. //! returned value is the distance between the given point and computed one.

        Parameters
        ----------
        C3D: Adaptor3d_Curve
        P3D: gp_Pnt
        preci: float
        proj: gp_Pnt
        AdjustToEnds: bool,optional
        	default value is Standard_True

        Returns
        -------
        param: float
        Projects a point on a curve, but parameters are limited between <cf> and <cl>. the range [cf, cl] is extended with help of adaptor3d on the basis of 3d precision <preci>. if adjusttoends is true, point will be adjusted to the end of the curve if distance is less than <preci>.

        Parameters
        ----------
        C3D: Geom_Curve
        P3D: gp_Pnt
        preci: float
        proj: gp_Pnt
        cf: float
        cl: float
        AdjustToEnds: bool,optional
        	default value is Standard_True

        Returns
        -------
        param: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_Project(self, *args)

    def ProjectAct(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        C3D: Adaptor3d_Curve
        P3D: gp_Pnt
        preci: float
        proj: gp_Pnt

        Returns
        -------
        param: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_ProjectAct(self, *args)

    def SelectForwardSeam(self, *args):
        r"""
        Defines which pcurve (c1 or c2) should be chosen for forward seam edge.

        Parameters
        ----------
        C1: Geom2d_Curve
        C2: Geom2d_Curve

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_SelectForwardSeam(self, *args)

    def ValidateRange(self, *args):
        r"""
        Validate parameters first and last for the given curve in order to make them valid for creation of edge. this includes: - limiting range [first,last] by range of curve - adjusting range [first,last] for periodic (or closed) curve if last < first returns true if parameters are ok or are successfully corrected, or false if parameters cannot be corrected. in the latter case, parameters are reset to range of curve.

        Parameters
        ----------
        Crv: Geom_Curve
        prec: float

        Returns
        -------
        First: float
        Last: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Curve_ValidateRange(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeAnalysis.ShapeAnalysis_Curve_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_Curve())
    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_Curve

# Register ShapeAnalysis_Curve in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_Curve_swigregister(ShapeAnalysis_Curve)
class ShapeAnalysis_Edge(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor; initialises status to ok.

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_Edge_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_Edge(*args))

    def BoundUV(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        first: gp_Pnt2d
        last: gp_Pnt2d

        Returns
        -------
        bool
        Returns the ends of pcurve calls method pcurve with <orient> equal to true.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location
        first: gp_Pnt2d
        last: gp_Pnt2d

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_BoundUV(self, *args)

    def CheckCurve3dWithPCurve(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Returns
        -------
        bool
        Checks mutual orientation of 3d curve and pcurve on the analysis of curves bounding points.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckCurve3dWithPCurve(self, *args)

    def CheckOverlapping(self, *args):
        r"""
        Checks the first edge is overlapped with second edge. if distance between two edges is less then thetoloverlap edges are overlapped. thedomaindis - length of part of edges on which edges are overlapped.

        Parameters
        ----------
        theEdge1: TopoDS_Edge
        theEdge2: TopoDS_Edge
        theDomainDist: float,optional
        	default value is 0.0

        Returns
        -------
        theTolOverlap: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckOverlapping(self, *args)

    def CheckPCurveRange(self, *args):
        r"""
        Checks possibility for pcurve thepc to have range [thefirst, thelast] (edge range) having respect to real first, last parameters of thepc .

        Parameters
        ----------
        theFirst: float
        theLast: float
        thePC: Geom2d_Curve

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckPCurveRange(self, *args)

    def CheckSameParameter(self, *args):
        r"""
        Checks the edge to be sameparameter. calculates the maximal deviation between 3d curve and each pcurve of the edge on <nbcontrol> equidistant points (the same algorithm as in brepcheck; default value is 23 as in brepcheck). this deviation is returned in <maxdev> parameter. if deviation is greater than tolerance of the edge (i.e. incorrect flag) returns false, else returns true.

        Parameters
        ----------
        edge: TopoDS_Edge
        NbControl: int,optional
        	default value is 23

        Returns
        -------
        maxdev: float
        Checks the edge to be sameparameter. calculates the maximal deviation between 3d curve and each pcurve of the edge on <nbcontrol> equidistant points (the same algorithm as in brepcheck; default value is 23 as in brepcheck). this deviation is returned in <maxdev> parameter. if deviation is greater than tolerance of the edge (i.e. incorrect flag) returns false, else returns true.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face
        theNbControl: int,optional
        	default value is 23

        Returns
        -------
        theMaxdev: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckSameParameter(self, *args)

    def CheckVertexTolerance(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Returns
        -------
        toler1: float
        toler2: float
        Checks if it is necessary to increase tolerances of the edge vertices to comprise the ends of 3d curve and pcurve on the given face (first method) or all pcurves stored in an edge (second one) toler1 returns necessary tolerance for first vertex, toler2 returns necessary tolerance for last vertex.

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        toler1: float
        toler2: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckVertexTolerance(self, *args)

    def CheckVerticesWithCurve3d(self, *args):
        r"""
        Checks the start and/or end vertex of the edge for matching with 3d curve with the given precision. <vtx> = 1 : start vertex only <vtx> = 2 : end vertex only <vtx> = 0 : both (default) if preci < 0 the vertices are considered with their own tolerances, else with the given <preci>.

        Parameters
        ----------
        edge: TopoDS_Edge
        preci: float,optional
        	default value is -1
        vtx: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckVerticesWithCurve3d(self, *args)

    def CheckVerticesWithPCurve(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        preci: float,optional
        	default value is -1
        vtx: int,optional
        	default value is 0

        Returns
        -------
        bool
        Checks the start and/or end vertex of the edge for matching with pcurve with the given precision. <vtx> = 1 : start vertex <vtx> = 2 : end vertex <vtx> = 0 : both if preci < 0 the vertices are considered with their own tolerances, else with the given <preci>.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location
        preci: float,optional
        	default value is -1
        vtx: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_CheckVerticesWithPCurve(self, *args)

    def Curve3d(self, *args):
        r"""
        Returns the 3d curve and bounding parameteres for the edge returns false if no 3d curve. if <orient> is true (default), takes orientation into account: if the edge is reversed, cf and cl are toggled.

        Parameters
        ----------
        edge: TopoDS_Edge
        C3d: Geom_Curve
        orient: bool,optional
        	default value is Standard_True

        Returns
        -------
        cf: float
        cl: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_Curve3d(self, *args)

    def FirstVertex(self, *args):
        r"""
        Returns start vertex of the edge (taking edge orientation into account).

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        TopoDS_Vertex

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_FirstVertex(self, *args)

    def GetEndTangent2d(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        atEnd: bool
        pos: gp_Pnt2d
        tang: gp_Vec2d
        dparam: float,optional
        	default value is 0.0

        Returns
        -------
        bool
        Returns tangent of the edge pcurve at its start (if atend is false) or end (if true), regarding the orientation of edge. if edge is reversed, tangent is reversed before return. returns true if pcurve is available and tangent is computed and is not null, else false.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location
        atEnd: bool
        pos: gp_Pnt2d
        tang: gp_Vec2d
        dparam: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_GetEndTangent2d(self, *args)

    def HasCurve3d(self, *args):
        r"""
        Tells if the edge has a 3d curve.

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_HasCurve3d(self, *args)

    def HasPCurve(self, *args):
        r"""
        Tells if the edge has a pcurve on the face.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Returns
        -------
        bool
        Tells if the edge has a pcurve on the surface (with location).

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_HasPCurve(self, *args)

    def IsClosed3d(self, *args):
        r"""
        Gives true if the edge has a 3d curve, this curve is closed, and the edge has the same vertex at start and end.

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_IsClosed3d(self, *args)

    def IsSeam(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Returns
        -------
        bool
        Returns true if the edge has two pcurves on one surface.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_IsSeam(self, *args)

    def LastVertex(self, *args):
        r"""
        Returns end vertex of the edge (taking edge orientation into account).

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        TopoDS_Vertex

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_LastVertex(self, *args)

    def PCurve(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        C2d: Geom2d_Curve
        orient: bool,optional
        	default value is Standard_True

        Returns
        -------
        cf: float
        cl: float
        Returns the pcurve and bounding parameteres for the edge lying on the surface. returns false if the edge has no pcurve on this surface. if <orient> is true (default), takes orientation into account: if the edge is reversed, cf and cl are toggled.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location
        C2d: Geom2d_Curve
        orient: bool,optional
        	default value is Standard_True

        Returns
        -------
        cf: float
        cl: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_PCurve(self, *args)

    def Status(self, *args):
        r"""
        Returns the status (in the form of true/false) of last check.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Edge_Status(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_Edge

# Register ShapeAnalysis_Edge in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_Edge_swigregister(ShapeAnalysis_Edge)
class ShapeAnalysis_FreeBoundData(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        Creates object with contour given in the form of topods_wire.

        Parameters
        ----------
        freebound: TopoDS_Wire

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_FreeBoundData_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_FreeBoundData(*args))

    def AddNotch(self, *args):
        r"""
        Adds notch on the contour with its maximum width.

        Parameters
        ----------
        notch: TopoDS_Wire
        width: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_AddNotch(self, *args)

    def Area(self, *args):
        r"""
        Returns area of the contour.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Area(self, *args)

    def Clear(self, *args):
        r"""
        Clears all properties of the contour. contour bound itself is not cleared.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Clear(self, *args)

    def FreeBound(self, *args):
        r"""
        Returns contour.

        Returns
        -------
        TopoDS_Wire

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_FreeBound(self, *args)

    def NbNotches(self, *args):
        r"""
        Returns number of notches on the contour.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_NbNotches(self, *args)

    def Notch(self, *args):
        r"""
        Returns notch on the contour.

        Parameters
        ----------
        index: int

        Returns
        -------
        TopoDS_Wire

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Notch(self, *args)

    def NotchWidth(self, *args):
        r"""
        Returns maximum width of notch specified by its rank number on the contour.

        Parameters
        ----------
        index: int

        Returns
        -------
        float
        Returns maximum width of notch specified as topods_wire on the contour.

        Parameters
        ----------
        notch: TopoDS_Wire

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_NotchWidth(self, *args)

    def Notches(self, *args):
        r"""
        Returns sequence of notches on the contour.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Notches(self, *args)

    def Perimeter(self, *args):
        r"""
        Returns perimeter of the contour.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Perimeter(self, *args)

    def Ratio(self, *args):
        r"""
        Returns ratio of average length to average width of the contour.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Ratio(self, *args)

    def SetArea(self, *args):
        r"""
        Sets area of the contour.

        Parameters
        ----------
        area: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_SetArea(self, *args)

    def SetFreeBound(self, *args):
        r"""
        Sets contour.

        Parameters
        ----------
        freebound: TopoDS_Wire

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_SetFreeBound(self, *args)

    def SetPerimeter(self, *args):
        r"""
        Sets perimeter of the contour.

        Parameters
        ----------
        perimeter: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_SetPerimeter(self, *args)

    def SetRatio(self, *args):
        r"""
        Sets ratio of average length to average width of the contour.

        Parameters
        ----------
        ratio: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_SetRatio(self, *args)

    def SetWidth(self, *args):
        r"""
        Sets average width of the contour.

        Parameters
        ----------
        width: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_SetWidth(self, *args)

    def Width(self, *args):
        r"""
        Returns average width of the contour.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundData_Width(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeAnalysis_FreeBoundData_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_FreeBoundData

# Register ShapeAnalysis_FreeBoundData in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_FreeBoundData_swigregister(ShapeAnalysis_FreeBoundData)
class ShapeAnalysis_FreeBounds(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        Builds forecasting free bounds of the <shape>. <shape> should be a compound of faces. this constructor is to be used for forecasting free edges with help of sewing analyzer brepalgo_sewing which is called with tolerance <toler>. free edges are connected into wires only when their ends are at distance less than <toler>. if <splitclosed> is true extracts closed sub-wires out of built closed wires. if <splitopen> is true extracts closed sub-wires out of built open wires.

        Parameters
        ----------
        shape: TopoDS_Shape
        toler: float
        splitclosed: bool,optional
        	default value is Standard_False
        splitopen: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Builds actual free bounds of the <shape>. <shape> should be a compound of shells. this constructor is to be used for getting free edges (ones referenced by the only face) with help of analyzer shapeanalysis_shell. free edges are connected into wires only when they share the same vertex. if <splitclosed> is true extracts closed sub-wires out of built closed wires. if <splitopen> is true extracts closed sub-wires out of built open wires.

        Parameters
        ----------
        shape: TopoDS_Shape
        splitclosed: bool,optional
        	default value is Standard_False
        splitopen: bool,optional
        	default value is Standard_True
        checkinternaledges: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_FreeBounds_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_FreeBounds(*args))

    @staticmethod
    def ConnectEdgesToWires(*args):
        r"""
        Builds sequnce of <wires> out of sequence of not sorted <edges>. tries to build wires of maximum length. building a wire is stopped when no edges can be connected to it at its head or at its tail. //! orientation of the edge can change when connecting. if <shared> is true connection is performed only when adjacent edges share the same vertex. if <shared> is false connection is performed only when ends of adjacent edges are at distance less than <toler>.

        Parameters
        ----------
        edges: TopTools_HSequenceOfShape
        toler: float
        shared: bool
        wires: TopTools_HSequenceOfShape

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBounds_ConnectEdgesToWires(*args)

    @staticmethod
    def ConnectWiresToWires(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        iwires: TopTools_HSequenceOfShape
        toler: float
        shared: bool
        owires: TopTools_HSequenceOfShape

        Returns
        -------
        None
        Builds sequnce of <owires> out of sequence of not sorted <iwires>. tries to build wires of maximum length. building a wire is stopped when no wires can be connected to it at its head or at its tail. //! orientation of the wire can change when connecting. if <shared> is true connection is performed only when adjacent wires share the same vertex. if <shared> is false connection is performed only when ends of adjacent wires are at distance less than <toler>. map <vertices> stores the correspondence between original end vertices of the wires and new connecting vertices.

        Parameters
        ----------
        iwires: TopTools_HSequenceOfShape
        toler: float
        shared: bool
        owires: TopTools_HSequenceOfShape
        vertices: TopTools_DataMapOfShapeShape

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBounds_ConnectWiresToWires(*args)

    @staticmethod
    def DispatchWires(*args):
        r"""
        Dispatches sequence of <wires> into two compounds <closed> for closed wires and <open> for open wires. if a compound is not empty wires are added into it.

        Parameters
        ----------
        wires: TopTools_HSequenceOfShape
        closed: TopoDS_Compound
        open: TopoDS_Compound

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBounds_DispatchWires(*args)

    def GetClosedWires(self, *args):
        r"""
        Returns compound of closed wires out of free edges.

        Returns
        -------
        TopoDS_Compound

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBounds_GetClosedWires(self, *args)

    def GetOpenWires(self, *args):
        r"""
        Returns compound of open wires out of free edges.

        Returns
        -------
        TopoDS_Compound

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBounds_GetOpenWires(self, *args)

    @staticmethod
    def SplitWires(*args):
        r"""
        Extracts closed sub-wires out of <wires> and adds them to <closed>, open wires remained after extraction are put into <open>. if <shared> is true extraction is performed only when edges share the same vertex. if <shared> is false connection is performed only when ends of the edges are at distance less than <toler>.

        Parameters
        ----------
        wires: TopTools_HSequenceOfShape
        toler: float
        shared: bool
        closed: TopTools_HSequenceOfShape
        open: TopTools_HSequenceOfShape

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBounds_SplitWires(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_FreeBounds

# Register ShapeAnalysis_FreeBounds in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_FreeBounds_swigregister(ShapeAnalysis_FreeBounds)
class ShapeAnalysis_FreeBoundsProperties(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        Creates the object and calls corresponding init. <shape> should be a compound of faces.

        Parameters
        ----------
        shape: TopoDS_Shape
        tolerance: float
        splitclosed: bool,optional
        	default value is Standard_False
        splitopen: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Creates the object and calls corresponding init. <shape> should be a compound of shells.

        Parameters
        ----------
        shape: TopoDS_Shape
        splitclosed: bool,optional
        	default value is Standard_False
        splitopen: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_FreeBoundsProperties(*args))

    def CheckContours(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_CheckContours(self, *args)

    def CheckNotches(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool
        No available documentation.

        Parameters
        ----------
        fbData: ShapeAnalysis_FreeBoundData
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool
        No available documentation.

        Parameters
        ----------
        freebound: TopoDS_Wire
        num: int
        notch: TopoDS_Wire
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        distMax: float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_CheckNotches(self, *args)

    def ClosedFreeBound(self, *args):
        r"""
        Returns properties of closed free bound specified by its rank number.

        Parameters
        ----------
        index: int

        Returns
        -------
        opencascade::handle<ShapeAnalysis_FreeBoundData>

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_ClosedFreeBound(self, *args)

    def ClosedFreeBounds(self, *args):
        r"""
        Returns all closed free bounds.

        Returns
        -------
        opencascade::handle<ShapeAnalysis_HSequenceOfFreeBounds>

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_ClosedFreeBounds(self, *args)

    def DispatchBounds(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_DispatchBounds(self, *args)

    def FillProperties(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        fbData: ShapeAnalysis_FreeBoundData
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_FillProperties(self, *args)

    def Init(self, *args):
        r"""
        Initializes the object with given parameters. <shape> should be a compound of faces.

        Parameters
        ----------
        shape: TopoDS_Shape
        tolerance: float
        splitclosed: bool,optional
        	default value is Standard_False
        splitopen: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Initializes the object with given parameters. <shape> should be a compound of shells.

        Parameters
        ----------
        shape: TopoDS_Shape
        splitclosed: bool,optional
        	default value is Standard_False
        splitopen: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_Init(self, *args)

    def IsLoaded(self, *args):
        r"""
        Returns true if shape is loaded.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_IsLoaded(self, *args)

    def NbClosedFreeBounds(self, *args):
        r"""
        Returns number of closed free bounds.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_NbClosedFreeBounds(self, *args)

    def NbFreeBounds(self, *args):
        r"""
        Returns number of free bounds.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_NbFreeBounds(self, *args)

    def NbOpenFreeBounds(self, *args):
        r"""
        Returns number of open free bounds.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_NbOpenFreeBounds(self, *args)

    def OpenFreeBound(self, *args):
        r"""
        Returns properties of open free bound specified by its rank number.

        Parameters
        ----------
        index: int

        Returns
        -------
        opencascade::handle<ShapeAnalysis_FreeBoundData>

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_OpenFreeBound(self, *args)

    def OpenFreeBounds(self, *args):
        r"""
        Returns all open free bounds.

        Returns
        -------
        opencascade::handle<ShapeAnalysis_HSequenceOfFreeBounds>

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_OpenFreeBounds(self, *args)

    def Perform(self, *args):
        r"""
        Builds and analyzes free bounds of the shape. first calls shapeanalysis_freebounds for building free bounds. then on each free bound computes its properties: - area of the contour, - perimeter of the contour, - ratio of average length to average width of the contour, - average width of contour, - notches on the contour and for each notch - maximum width of the notch.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_Perform(self, *args)

    def Shape(self, *args):
        r"""
        Returns shape.

        Returns
        -------
        TopoDS_Shape

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_Shape(self, *args)

    def Tolerance(self, *args):
        r"""
        Returns tolerance.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_FreeBoundsProperties

# Register ShapeAnalysis_FreeBoundsProperties in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_FreeBoundsProperties_swigregister(ShapeAnalysis_FreeBoundsProperties)
class ShapeAnalysis_Geom(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def NearestPlane(*args):
        r"""
        Builds a plane out of a set of points in array returns in <dmax> the maximal distance between the produced plane and given points.

        Parameters
        ----------
        Pnts: TColgp_Array1OfPnt
        aPln: gp_Pln

        Returns
        -------
        Dmax: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Geom_NearestPlane(*args)

    @staticmethod
    def PositionTrsf(*args):
        r"""
        Builds transformation object out of matrix. matrix must be 3 x 4. unit is used as multiplier.

        Parameters
        ----------
        coefs: TColStd_HArray2OfReal
        trsf: gp_Trsf
        unit: float
        prec: float

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Geom_PositionTrsf(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeAnalysis.ShapeAnalysis_Geom_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_Geom())
    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_Geom

# Register ShapeAnalysis_Geom in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_Geom_swigregister(ShapeAnalysis_Geom)
class ShapeAnalysis_ShapeContents(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initialize fields and call clearflags().

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_ShapeContents_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_ShapeContents(*args))

    def BigSplineSec(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_BigSplineSec(self, *args)

    def Clear(self, *args):
        r"""
        Clears all accumulated statistics.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_Clear(self, *args)

    def ClearFlags(self, *args):
        r"""
        Clears all flags.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_ClearFlags(self, *args)

    def IndirectSec(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_IndirectSec(self, *args)

    def GetModifyBigSplineMode(self):
        r"""GetModifyBigSplineMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyBigSplineMode(self)

    def SetModifyBigSplineMode(self, value):
        r"""SetModifyBigSplineMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyBigSplineMode(self, value)

    def GetModifyIndirectMode(self):
        r"""GetModifyIndirectMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyIndirectMode(self)

    def SetModifyIndirectMode(self, value):
        r"""SetModifyIndirectMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyIndirectMode(self, value)

    def GetModifyOffestSurfaceMode(self):
        r"""GetModifyOffestSurfaceMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyOffestSurfaceMode(self)

    def SetModifyOffestSurfaceMode(self, value):
        r"""SetModifyOffestSurfaceMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyOffestSurfaceMode(self, value)

    def GetModifyOffsetCurveMode(self):
        r"""GetModifyOffsetCurveMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyOffsetCurveMode(self)

    def SetModifyOffsetCurveMode(self, value):
        r"""SetModifyOffsetCurveMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyOffsetCurveMode(self, value)

    def GetModifyOffsetSurfaceMode(self):
        r"""GetModifyOffsetSurfaceMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyOffsetSurfaceMode(self)

    def SetModifyOffsetSurfaceMode(self, value):
        r"""SetModifyOffsetSurfaceMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyOffsetSurfaceMode(self, value)

    def GetModifyTrimmed2dMode(self):
        r"""GetModifyTrimmed2dMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyTrimmed2dMode(self)

    def SetModifyTrimmed2dMode(self, value):
        r"""SetModifyTrimmed2dMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyTrimmed2dMode(self, value)

    def GetModifyTrimmed3dMode(self):
        r"""GetModifyTrimmed3dMode(ShapeAnalysis_ShapeContents self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_GetModifyTrimmed3dMode(self)

    def SetModifyTrimmed3dMode(self, value):
        r"""SetModifyTrimmed3dMode(ShapeAnalysis_ShapeContents self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_SetModifyTrimmed3dMode(self, value)

    def NbBSplibeSurf(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbBSplibeSurf(self, *args)

    def NbBezierSurf(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbBezierSurf(self, *args)

    def NbBigSplines(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbBigSplines(self, *args)

    def NbC0Curves(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbC0Curves(self, *args)

    def NbC0Surfaces(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbC0Surfaces(self, *args)

    def NbEdges(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbEdges(self, *args)

    def NbFaceWithSevWires(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbFaceWithSevWires(self, *args)

    def NbFaces(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbFaces(self, *args)

    def NbFreeEdges(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbFreeEdges(self, *args)

    def NbFreeFaces(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbFreeFaces(self, *args)

    def NbFreeWires(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbFreeWires(self, *args)

    def NbIndirectSurf(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbIndirectSurf(self, *args)

    def NbNoPCurve(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbNoPCurve(self, *args)

    def NbOffsetCurves(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbOffsetCurves(self, *args)

    def NbOffsetSurf(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbOffsetSurf(self, *args)

    def NbSharedEdges(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedEdges(self, *args)

    def NbSharedFaces(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedFaces(self, *args)

    def NbSharedFreeEdges(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedFreeEdges(self, *args)

    def NbSharedFreeWires(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedFreeWires(self, *args)

    def NbSharedShells(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedShells(self, *args)

    def NbSharedSolids(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedSolids(self, *args)

    def NbSharedVertices(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedVertices(self, *args)

    def NbSharedWires(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSharedWires(self, *args)

    def NbShells(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbShells(self, *args)

    def NbSolids(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSolids(self, *args)

    def NbSolidsWithVoids(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbSolidsWithVoids(self, *args)

    def NbTrimSurf(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbTrimSurf(self, *args)

    def NbTrimmedCurve2d(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbTrimmedCurve2d(self, *args)

    def NbTrimmedCurve3d(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbTrimmedCurve3d(self, *args)

    def NbVertices(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbVertices(self, *args)

    def NbWireWithSevSeams(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbWireWithSevSeams(self, *args)

    def NbWireWitnSeam(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbWireWitnSeam(self, *args)

    def NbWires(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_NbWires(self, *args)

    def OffsetCurveSec(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_OffsetCurveSec(self, *args)

    def OffsetSurfaceSec(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_OffsetSurfaceSec(self, *args)

    def Perform(self, *args):
        r"""
        Counts quantities of sun-shapes in shape and stores sub-shapes according to flags.

        Parameters
        ----------
        shape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_Perform(self, *args)

    def Trimmed2dSec(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_Trimmed2dSec(self, *args)

    def Trimmed3dSec(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeContents_Trimmed3dSec(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_ShapeContents

# Register ShapeAnalysis_ShapeContents in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_ShapeContents_swigregister(ShapeAnalysis_ShapeContents)
class ShapeAnalysis_ShapeTolerance(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_ShapeTolerance(*args))

    def AddTolerance(self, *args):
        r"""
        Adds data on new shape to compute cumulated tolerance (prepares three computations : maximal, average, minimal).

        Parameters
        ----------
        shape: TopoDS_Shape
        type: TopAbs_ShapeEnum,optional
        	default value is TopAbs_SHAPE

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_AddTolerance(self, *args)

    def GlobalTolerance(self, *args):
        r"""
        Returns the computed tolerance according to the <mode> <mode> = 0 : average <mode> > 0 : maximal <mode> < 0 : minimal.

        Parameters
        ----------
        mode: int

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_GlobalTolerance(self, *args)

    def InTolerance(self, *args):
        r"""
        Determines which shapes have a tolerance within a given interval <type> is interpreted as in the method tolerance.

        Parameters
        ----------
        shape: TopoDS_Shape
        valmin: float
        valmax: float
        type: TopAbs_ShapeEnum,optional
        	default value is TopAbs_SHAPE

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_InTolerance(self, *args)

    def InitTolerance(self, *args):
        r"""
        Initializes computation of cumulated tolerance.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_InitTolerance(self, *args)

    def OverTolerance(self, *args):
        r"""
        Determines which shapes have a tolerance over the given value <type> is interpreted as in the method tolerance.

        Parameters
        ----------
        shape: TopoDS_Shape
        value: float
        type: TopAbs_ShapeEnum,optional
        	default value is TopAbs_SHAPE

        Returns
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_OverTolerance(self, *args)

    def Tolerance(self, *args):
        r"""
        Determines a tolerance from the ones stored in a shape remark : calls inittolerance and addtolerance, hence, can be used to start a series for cumulating tolerance <mode> = 0 : returns the average value between sub-shapes, <mode> > 0 : returns the maximal found, <mode> < 0 : returns the minimal found. <type> defines what kinds of sub-shapes to consider: shape (default) : all : vertex, edge, face, vertex : only vertices, edge : only edges, face : only faces, shell : combined shell + face, for each face (and containing shell), also checks edge and vertex.

        Parameters
        ----------
        shape: TopoDS_Shape
        mode: int
        type: TopAbs_ShapeEnum,optional
        	default value is TopAbs_SHAPE

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_ShapeTolerance_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_ShapeTolerance

# Register ShapeAnalysis_ShapeTolerance in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_ShapeTolerance_swigregister(ShapeAnalysis_ShapeTolerance)
class ShapeAnalysis_Shell(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_Shell_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_Shell(*args))

    def BadEdges(self, *args):
        r"""
        Returns the list of bad edges as a compound it is empty (not null) if no edge are recorded as bad.

        Returns
        -------
        TopoDS_Compound

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_BadEdges(self, *args)

    def CheckOrientedShells(self, *args):
        r"""
        Checks if shells fulfill orientation condition, i.e. if each edge is, either present once (free edge) or twice (connected edge) but with different orientations (forward/reversed) edges which do not fulfill these conditions are bad //! if <alsofree> is true free edges are considered. free edges can be queried but are not bad.

        Parameters
        ----------
        shape: TopoDS_Shape
        alsofree: bool,optional
        	default value is Standard_False
        checkinternaledges: bool,optional
        	default value is Standard_False

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_CheckOrientedShells(self, *args)

    def Clear(self, *args):
        r"""
        Clears data about loaded shells and performed checks.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_Clear(self, *args)

    def FreeEdges(self, *args):
        r"""
        Returns the list of free (not connected) edges as a compound it is empty (not null) if no edge are recorded as free.

        Returns
        -------
        TopoDS_Compound

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_FreeEdges(self, *args)

    def HasBadEdges(self, *args):
        r"""
        Tells if at least one edge is recorded as bad.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_HasBadEdges(self, *args)

    def HasConnectedEdges(self, *args):
        r"""
        Tells if at least one edge is connected (shared twice or more).

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_HasConnectedEdges(self, *args)

    def HasFreeEdges(self, *args):
        r"""
        Tells if at least one edge is recorded as free (not connected).

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_HasFreeEdges(self, *args)

    def IsLoaded(self, *args):
        r"""
        Tells if a shape is loaded (only shells are checked).

        Parameters
        ----------
        shape: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_IsLoaded(self, *args)

    def LoadShells(self, *args):
        r"""
        Adds shells contained in the <shape> to the list of loaded shells.

        Parameters
        ----------
        shape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_LoadShells(self, *args)

    def Loaded(self, *args):
        r"""
        Returns a loaded shape specified by its rank number. returns null shape if <num> is out of range.

        Parameters
        ----------
        num: int

        Returns
        -------
        TopoDS_Shape

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_Loaded(self, *args)

    def NbLoaded(self, *args):
        r"""
        Returns the actual number of loaded shapes (i.e. shells).

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_Shell_NbLoaded(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_Shell

# Register ShapeAnalysis_Shell in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_Shell_swigregister(ShapeAnalysis_Shell)
class ShapeAnalysis_Surface(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an analyzer object on the basis of existing surface.

        Parameters
        ----------
        S: Geom_Surface

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_Surface_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_Surface(*args))

    def Adaptor3d(self, *args):
        r"""
        Returns the adaptor. creates it if not yet done.

        Returns
        -------
        opencascade::handle<GeomAdaptor_Surface>

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Adaptor3d(self, *args)

    def Bounds(self, *args):
        r"""
        Returns the bounds of the surface (from bounds from surface, but buffered).

        Parameters
        ----------

        Returns
        -------
        ufirst: float
        ulast: float
        vfirst: float
        vlast: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Bounds(self, *args)

    def ComputeBoundIsos(self, *args):
        r"""
        Computes bound isos (protected against exceptions).

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_ComputeBoundIsos(self, *args)

    def DegeneratedValues(self, *args):
        r"""
        Returns true if there is at least one surface iso-line which is considered as degenerated with <preci> and distance between p3d and corresponding singular point is less than <preci> (like isdegenerated). returns characteristics of the first found boundary matching those criteria.

        Parameters
        ----------
        P3d: gp_Pnt
        preci: float
        firstP2d: gp_Pnt2d
        lastP2d: gp_Pnt2d
        forward: bool,optional
        	default value is Standard_True

        Returns
        -------
        firstpar: float
        lastpar: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_DegeneratedValues(self, *args)

    def Gap(self, *args):
        r"""
        Returns 3d distance found by one of the following methods. isdegenerated, degeneratedvalues, projectdegenerated (distance between 3d point and found or last (if not found) singularity), isuclosed, isvclosed (minimum value of precision to consider the surface to be closed), valueofuv (distance between 3d point and found solution).

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Gap(self, *args)

    def GetBoxUF(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        Bnd_Box

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_GetBoxUF(self, *args)

    def GetBoxUL(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        Bnd_Box

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_GetBoxUL(self, *args)

    def GetBoxVF(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        Bnd_Box

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_GetBoxVF(self, *args)

    def GetBoxVL(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        Bnd_Box

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_GetBoxVL(self, *args)

    def HasSingularities(self, *args):
        r"""
        Returns true if the surface has singularities for the given precision (i.e. if there are surface singularities with sizes not greater than precision).

        Parameters
        ----------
        preci: float

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_HasSingularities(self, *args)

    def Init(self, *args):
        r"""
        Loads existing surface.

        Parameters
        ----------
        S: Geom_Surface

        Returns
        -------
        None
        Reads all the data from another surface, without recomputing.

        Parameters
        ----------
        other: ShapeAnalysis_Surface

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Init(self, *args)

    def IsDegenerated(self, *args):
        r"""
        Returns true if there is at least one surface boundary which is considered as degenerated with <preci> and distance between p3d and corresponding singular point is less than <preci>.

        Parameters
        ----------
        P3d: gp_Pnt
        preci: float

        Returns
        -------
        bool
        Returns true if straight pcurve going from point p2d1 to p2d2 is degenerate, i.e. lies in the singularity of the surface. note: it uses another method of detecting singularity than used by computesingularities() et al.! for that, maximums of distances between points p2d1, p2d2 and 0.5*(p2d1+p2d2) and between corresponding 3d points are computed. the pcurve (p2d1, p2d2) is considered as degenerate if: - max distance in 3d is less than <tol> - max distance in 2d is at least <ratio> times greater than the resolution computed from max distance in 3d (max3d < tol && max2d > ratio * resolution(max3d)) note: <ratio> should be >1 (e.g. 10).

        Parameters
        ----------
        p2d1: gp_Pnt2d
        p2d2: gp_Pnt2d
        tol: float
        ratio: float

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_IsDegenerated(self, *args)

    def IsUClosed(self, *args):
        r"""
        Tells if the surface is spatially closed in u with given precision. if <preci> < 0 then precision::confusion is used. if geom_surface says that the surface is u-closed, this method also says this. otherwise additional analysis is performed, comparing given precision with the following distances: - periodic b-splines are closed, - polinomial b-spline with boundary multiplicities degree+1 and bezier - maximum distance between poles, - rational b-spline or one with boundary multiplicities not degree+1 - maximum distance computed at knots and their middles, - surface of extrusion - distance between ends of basis curve, - other (rectangulartrimmed and offset) - maximum distance computed at 100 equi-distanted points.

        Parameters
        ----------
        preci: float,optional
        	default value is -1

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_IsUClosed(self, *args)

    def IsVClosed(self, *args):
        r"""
        Tells if the surface is spatially closed in v with given precision. if <preci> < 0 then precision::confusion is used. if geom_surface says that the surface is v-closed, this method also says this. otherwise additional analysis is performed, comparing given precision with the following distances: - periodic b-splines are closed, - polinomial b-spline with boundary multiplicities degree+1 and bezier - maximum distance between poles, - rational b-spline or one with boundary multiplicities not degree+1 - maximum distance computed at knots and their middles, - surface of revolution - distance between ends of basis curve, - other (rectangulartrimmed and offset) - maximum distance computed at 100 equi-distanted points.

        Parameters
        ----------
        preci: float,optional
        	default value is -1

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_IsVClosed(self, *args)

    def NbSingularities(self, *args):
        r"""
        Returns the number of singularities for the given precision (i.e. number of surface singularities with sizes not greater than precision).

        Parameters
        ----------
        preci: float

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_NbSingularities(self, *args)

    def NextValueOfUV(self, *args):
        r"""
        Projects a point p3d on the surface. does the same thing as valueofuv but tries to optimize computations by taking into account previous point <p2dprev>: makes a step by uv and tries newton algorithm. if <maxpreci> >0. and distance between solution and p3d is greater than <maxpreci>, that solution is considered as bad, and valueofuv() is used. if not succeeded, calls valueofuv().

        Parameters
        ----------
        p2dPrev: gp_Pnt2d
        P3D: gp_Pnt
        preci: float
        maxpreci: float,optional
        	default value is -1.0

        Returns
        -------
        gp_Pnt2d

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_NextValueOfUV(self, *args)

    def ProjectDegenerated(self, *args):
        r"""
        Projects a point <p3d> on a singularity by computing one of the coordinates of preliminary computed <result>. //! finds the iso-line which is considered as degenerated with <preci> and a. distance between p3d and corresponding singular point is less than <preci> (like isdegenerated) or b. difference between already computed <result>'s coordinate and iso-coordinate of the boundary is less than 2d resolution (computed from <preci> by geom_adaptor). then sets not yet computed <result>'s coordinate taking it from <neighbour> and returns true.

        Parameters
        ----------
        P3d: gp_Pnt
        preci: float
        neighbour: gp_Pnt2d
        result: gp_Pnt2d

        Returns
        -------
        bool
        Checks points at the beginning (direct is true) or end (direct is false) of array <points> to lie in singularity of surface, and if yes, adjusts the indeterminate 2d coordinate of these points by nearest point which is not in singularity. returns true if some points were adjusted.

        Parameters
        ----------
        nbrPnt: int
        points: TColgp_SequenceOfPnt
        pnt2d: TColgp_SequenceOfPnt2d
        preci: float
        direct: bool

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_ProjectDegenerated(self, *args)

    def SetDomain(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        U1: float
        U2: float
        V1: float
        V2: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_SetDomain(self, *args)

    def Singularity(self, *args):
        r"""
        Returns the characteristics of the singularity specified by its rank number <num>. that means, that it is not necessary for <num> to be in the range [1, nbsingularities] but must be not greater than possible (see computesingularities). the returned characteristics are: preci: the smallest precision with which the iso-line is considered as degenerated, p3d: 3d point of singularity (middle point of the surface iso-line), firstp2d and lastp2d: first and last 2d points of the iso-line in parametrical surface, firstpar and lastpar: first and last parameters of the iso-line in parametrical surface, uisodeg: if the degenerated iso-line is u-iso (true) or v-iso (false). returns false if <num> is out of range, else returns true.

        Parameters
        ----------
        num: int
        P3d: gp_Pnt
        firstP2d: gp_Pnt2d
        lastP2d: gp_Pnt2d

        Returns
        -------
        preci: float
        firstpar: float
        lastpar: float
        uisodeg: bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Singularity(self, *args)

    def Surface(self, *args):
        r"""
        Returns a surface being analyzed.

        Returns
        -------
        opencascade::handle<Geom_Surface>

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Surface(self, *args)

    def TrueAdaptor3d(self, *args):
        r"""
        Returns the adaptor (may be null if method adaptor() was not called).

        Returns
        -------
        opencascade::handle<GeomAdaptor_Surface>

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_TrueAdaptor3d(self, *args)

    def UCloseVal(self, *args):
        r"""
        Returns minimum value to consider the surface as u-closed.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_UCloseVal(self, *args)

    def UIso(self, *args):
        r"""
        Returns a u-iso. null if not possible or failed remark : bound isos are buffered.

        Parameters
        ----------
        U: float

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_UIso(self, *args)

    def UVFromIso(self, *args):
        r"""
        Tries a refinement of an already computed couple (u,v) by using projecting 3d point on iso-lines: 1. boundaries of the surface, 2. iso-lines passing through (u,v) 3. iteratively received iso-lines passing through new u and new v (number of iterations is limited by 5 in each direction) returns the best resulting distance between p3d and value(u,v) in the case of success. else, returns a very great value.

        Parameters
        ----------
        P3D: gp_Pnt
        preci: float

        Returns
        -------
        U: float
        V: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_UVFromIso(self, *args)

    def VCloseVal(self, *args):
        r"""
        Returns minimum value to consider the surface as v-closed.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_VCloseVal(self, *args)

    def VIso(self, *args):
        r"""
        Returns a v-iso. null if not possible or failed remark : bound isos are buffered.

        Parameters
        ----------
        V: float

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_VIso(self, *args)

    def Value(self, *args):
        r"""
        Returns a 3d point specified by parameters in surface parametrical space.

        Parameters
        ----------
        u: float
        v: float

        Returns
        -------
        gp_Pnt
        Returns a 3d point specified by a point in surface parametrical space.

        Parameters
        ----------
        p2d: gp_Pnt2d

        Returns
        -------
        gp_Pnt

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_Value(self, *args)

    def ValueOfUV(self, *args):
        r"""
        Computes the parameters in the surface parametrical space of 3d point. the result is parameters of the point projected onto the surface. this method enhances functionality provided by the standard tool geomapi_projectpointonsurface by treatment of cases when the projected point is near to the surface boundaries and when this standard tool fails.

        Parameters
        ----------
        P3D: gp_Pnt
        preci: float

        Returns
        -------
        gp_Pnt2d

        """
        return _ShapeAnalysis.ShapeAnalysis_Surface_ValueOfUV(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeAnalysis_Surface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_Surface

# Register ShapeAnalysis_Surface in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_Surface_swigregister(ShapeAnalysis_Surface)
class ShapeAnalysis_TransferParameters(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates empty tool with myshift = 0 and myscale = 1.

        Returns
        -------
        None
        Creates a tool and initializes it with edge and face.

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_TransferParameters_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_TransferParameters(*args))

    def Init(self, *args):
        r"""
        Initialize a tool with edge and face.

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParameters_Init(self, *args)

    def IsSameRange(self, *args):
        r"""
        Returns true if 3d curve of edge and pcurve are samerange (in default implementation, if myscale == 1 and myshift == 0).

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParameters_IsSameRange(self, *args)

    def Perform(self, *args):
        r"""
        Transfers parameters given by sequence params from 3d curve to pcurve (if to2d is true) or back (if to2d is false).

        Parameters
        ----------
        Params: TColStd_HSequenceOfReal
        To2d: bool

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfReal>
        Transfers parameter given by sequence params from 3d curve to pcurve (if to2d is true) or back (if to2d is false).

        Parameters
        ----------
        Param: float
        To2d: bool

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParameters_Perform(self, *args)

    def SetMaxTolerance(self, *args):
        r"""
        Sets maximal tolerance to use linear recomputation of parameters.

        Parameters
        ----------
        maxtol: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParameters_SetMaxTolerance(self, *args)

    def TransferRange(self, *args):
        r"""
        Recomputes range of curves from newedge. if is2d equals true parameters are recomputed by curve2d else by curve3d.

        Parameters
        ----------
        newEdge: TopoDS_Edge
        prevPar: float
        currPar: float
        To2d: bool

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParameters_TransferRange(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeAnalysis_TransferParameters_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_TransferParameters

# Register ShapeAnalysis_TransferParameters in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_TransferParameters_swigregister(ShapeAnalysis_TransferParameters)
class ShapeAnalysis_Wire(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        Creates object with standard topods_wire, face and precision.

        Parameters
        ----------
        wire: TopoDS_Wire
        face: TopoDS_Face
        precision: float

        Returns
        -------
        None
        Creates the object with wiredata object, face and precision.

        Parameters
        ----------
        sbwd: ShapeExtend_WireData
        face: TopoDS_Face
        precision: float

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_Wire_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_Wire(*args))

    def CheckClosed(self, *args):
        r"""
        Checks if wire is closed, performs checkconnected, checkdegenerated and checklacking for the first and the last edges returns: true if at least one check returned true status: fail1 or done1: see checkconnected fail2 or done2: see checkdegenerated.

        Parameters
        ----------
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckClosed(self, *args)

    def CheckConnected(self, *args):
        r"""
        Calls to checkconnected for each edge returns: true if at least one pair of disconnected edges (not sharing the same vertex) was detected.

        Parameters
        ----------
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool
        Checks connected edges (num-th and preceding). tests with starting preci from <sbwd> or with <prec> if it is greater. considers vertices. returns: false if edges are connected by the common vertex, else true status : ok : vertices (end of num-1 th edge and start on num-th one) are already the same done1 : absolutely confused (gp::resolution) done2 : confused at starting <preci> from <sbwd> done3 : confused at <prec> but not <preci> fail1 : not confused fail2 : not confused but confused with <preci> if reverse num-th edge.

        Parameters
        ----------
        num: int
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckConnected(self, *args)

    def CheckCurveGap(self, *args):
        r"""
        Checks gap between points on 3d curve and points on surface generated by pcurve of the num-th edge. the distance can be queried by mindistance3d. //! returns: true if status is done status: ok : gap is less than myprecision done : gap is greater than myprecision fail : no 3d curve(s) on the edge(s).

        Parameters
        ----------
        num: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckCurveGap(self, *args)

    def CheckCurveGaps(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckCurveGaps(self, *args)

    def CheckDegenerated(self, *args):
        r"""
        Calls to checkdegenerated for each edge returns: true if at least one incorrect degenerated edge was detected.

        Returns
        -------
        bool
        Checks for degenerated edge between two adjacent ones. fills parameters dgnr1 and dgnr2 with points in parametric space that correspond to the singularity (either gap that needs to be filled by degenerated edge or that already filled) returns: false if no singularity or edge is already degenerated, otherwise true status: ok : no surface singularity, or edge is already degenerated done1: degenerated edge should be inserted (gap in 2d) done2: edge <num> should be made degenerated (recompute pcurve and set the flag) fail1: one of edges neighbouring to degenerated one has no pcurve fail2: edge marked as degenerated and has no pcurve but singularity is not detected.

        Parameters
        ----------
        num: int
        dgnr1: gp_Pnt2d
        dgnr2: gp_Pnt2d

        Returns
        -------
        bool
        Checks for degenerated edge between two adjacent ones. remark : calls previous function status : see the function above for details.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckDegenerated(self, *args)

    def CheckEdgeCurves(self, *args):
        r"""
        Checks edges geometry (consistency of 2d and 3d senses, adjasment of curves to the vertices, etc.). the order of the checks : call shapeanalysis_wire to check: shapeanalysis_edge::checkcurve3dwithpcurve (1), shapeanalysis_edge::checkvertceswithpcurve (2), shapeanalysis_edge::checkvertceswithcurve3d (3), checkseam   (4) additional: checkgap3d  (5), checkgap2d  (6), shapeanalysis_edge::checksameparameter (7) returns: true if at least one check returned true remark: the numbers in brackets show with what donei or faili the status can be queried.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckEdgeCurves(self, *args)

    def CheckGap2d(self, *args):
        r"""
        Checks gap between edges in 2d (pcurves). checks the distance between ends of pcurves of the num-th and preceding edge. the distance can be queried by mindistance2d. //! returns: true if status is done status: ok : gap is less than parametric precision out of myprecision done : gap is greater than parametric precision out of myprecision fail : no pcurve(s) on the edge(s).

        Parameters
        ----------
        num: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckGap2d(self, *args)

    def CheckGap3d(self, *args):
        r"""
        Checks gap between edges in 3d (3d curves). checks the distance between ends of 3d curves of the num-th and preceding edge. the distance can be queried by mindistance3d. //! returns: true if status is done status: ok : gap is less than myprecision done : gap is greater than myprecision fail : no 3d curve(s) on the edge(s).

        Parameters
        ----------
        num: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckGap3d(self, *args)

    def CheckGaps2d(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckGaps2d(self, *args)

    def CheckGaps3d(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckGaps3d(self, *args)

    def CheckIntersectingEdges(self, *args):
        r"""
        Checks two adjacent edges for intersecting. intersection is reported only if intersection point is not enclosed by the common end vertex of the edges. returns: true if intersection is found. if returns true it also fills the sequences of intersection points, corresponding 3d points, and errors for them (half-distances between intersection points in 3d calculated from one and from another edge) status: fail1 : no pcurve fail2 : no vertices done1 : self-intersection found.

        Parameters
        ----------
        num: int
        points2d: IntRes2d_SequenceOfIntersectionPoint
        points3d: TColgp_SequenceOfPnt
        errors: TColStd_SequenceOfReal

        Returns
        -------
        bool
        Checks two adjacent edges for intersecting. remark : calls the previous method status : see the function above for details.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool
        Checks i-th and j-th edges for intersecting. remark : see the previous method for details.

        Parameters
        ----------
        num1: int
        num2: int
        points2d: IntRes2d_SequenceOfIntersectionPoint
        points3d: TColgp_SequenceOfPnt
        errors: TColStd_SequenceOfReal

        Returns
        -------
        bool
        Checks i-th and j-th edges for intersecting. remark : calls previous method. status : see the function above for details.

        Parameters
        ----------
        num1: int
        num2: int

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckIntersectingEdges(self, *args)

    def CheckLacking(self, *args):
        r"""
        Calls to checklacking for each edge returns: true if at least one lacking edge was detected.

        Returns
        -------
        bool
        Checks if there is a gap in 2d between edges, not comprised by the tolerance of their common vertex. if <tolerance> is greater than 0. and less than tolerance of the vertex, then this value is used for check. returns: true if not closed gap was detected p2d1 and p2d2 are the endpoint of <num-1>th edge and start of the <num>th edge in 2d. status: ok: no edge is lacking (3d and 2d connection) fail1: edges have no vertices (at least one of them) fail2: edges are neither connected by common vertex, nor have coincided vertices fail1: edges have no pcurves done1: the gap is detected which cannot be closed by the tolerance of the common vertex (or with value of <tolerance>) done2: is set (together with done1) if gap is detected and the vector (p2d2 - p2d1) goes in direction opposite to the pcurves of the edges (if angle is more than 0.9*pi).

        Parameters
        ----------
        num: int
        Tolerance: float
        p2d1: gp_Pnt2d
        p2d2: gp_Pnt2d

        Returns
        -------
        bool
        Checks if there is a gap in 2d between edges and not comprised by vertex tolerance the value of sbwd.thepreci is used. returns: false if no edge should be inserted status: ok : no edge is lacking (3d and 2d connection) done1 : the vertex tolerance should be increased only (2d gap is small) done2 : edge can be inserted (3d and 2d gaps are large enough).

        Parameters
        ----------
        num: int
        Tolerance: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckLacking(self, *args)

    def CheckLoop(self, *args):
        r"""
        Checks existence of loop on wire and return vertices which are loop vertices (vertices belonging to a few pairs of edges).

        Parameters
        ----------
        aMapLoopVertices: TopTools_IndexedMapOfShape
        aMapVertexEdges: TopTools_DataMapOfShapeListOfShape
        aMapSmallEdges: TopTools_MapOfShape
        aMapSeemEdges: TopTools_MapOfShape

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckLoop(self, *args)

    def CheckNotchedEdges(self, *args):
        r"""
        Detects a notch.

        Parameters
        ----------
        num: int
        Tolerance: float,optional
        	default value is 0.0

        Returns
        -------
        shortNum: int
        param: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckNotchedEdges(self, *args)

    def CheckOrder(self, *args):
        r"""
        Calls checkorder and returns false if wire is already ordered (tail-to-head), true otherwise flag <isclosed> defines if the wire is closed or not flag <mode3d> defines which mode is used (3d or 2d).

        Parameters
        ----------
        isClosed: bool,optional
        	default value is Standard_True
        mode3d: bool,optional
        	default value is Standard_True

        Returns
        -------
        bool
        Analyzes the order of the edges in the wire, uses class wireorder for that purpose. flag <isclosed> defines if the wire is closed or not flag <mode3d> defines which mode is used (3d or 2d) returns false if wire is already ordered (tail-to-head), true otherwise. use returned wireorder object for deeper analysis. status: ok : the same edges orientation, the same edges sequence done1: the same edges orientation, not the same edges sequence done2: as done1 and gaps more than myprecision done3: not the same edges orientation (some need to be reversed) done4: as done3 and gaps more than myprecision fail : algorithm failed (could not detect order).

        Parameters
        ----------
        sawo: ShapeAnalysis_WireOrder
        isClosed: bool,optional
        	default value is Standard_True
        mode3d: bool,optional
        	default value is Standard_True

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckOrder(self, *args)

    def CheckOuterBound(self, *args):
        r"""
        Checks if wire defines an outer bound on the face uses shapeanalysis::isouterbound for analysis if <apimake> is true uses brepapi_makewire to build the wire, if false (to be used only when edges share common vertices) uses brep_builder to build the wire.

        Parameters
        ----------
        APIMake: bool,optional
        	default value is Standard_True

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckOuterBound(self, *args)

    def CheckSeam(self, *args):
        r"""
        Checks if a seam pcurves are correct oriented returns: false (status ok) if given edge is not a seam or if it is ok c1 - current pcurve for forward edge, c2 - current pcurve for reversed edge (if returns true they should be swapped for the seam), cf, cl - first and last parameters on curves status: ok : pcurves are correct or edge is not seam done : seam pcurves should be swapped.

        Parameters
        ----------
        num: int
        C1: Geom2d_Curve
        C2: Geom2d_Curve

        Returns
        -------
        cf: float
        cl: float
        Checks if a seam pcurves are correct oriented see previous functions for details.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckSeam(self, *args)

    def CheckSelfIntersectingEdge(self, *args):
        r"""
        Checks if num-th edge is self-intersecting. self-intersection is reported only if intersection point lies outside of both end vertices of the edge. returns: true if edge is self-intersecting. if returns true it also fills the sequences of intersection points and corresponding 3d points (only that are not enclosed by a vertices) status: fail1 : no pcurve fail2 : no vertices done1 : self-intersection found.

        Parameters
        ----------
        num: int
        points2d: IntRes2d_SequenceOfIntersectionPoint
        points3d: TColgp_SequenceOfPnt

        Returns
        -------
        bool
        No available documentation.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckSelfIntersectingEdge(self, *args)

    def CheckSelfIntersection(self, *args):
        r"""
        Checks self-intersection of the wire (considering pcurves) looks for self-intersecting edges and each pair of intersecting edges. warning: it does not check each edge with any other one (only each two adjacent edges) the order of the checks : checkselfintersectingedge, checkintersectingedges returns: true if at least one check returned true status: fail1 or done1 - see checkselfintersectingedge fail2 or done2 - see checkintersectingedges.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckSelfIntersection(self, *args)

    def CheckShapeConnect(self, *args):
        r"""
        Checks with what orientation <shape> (wire or edge) can be connected to the wire. tests distances with starting <preci> from <sbwd> (close confusion), but if given <prec> is greater, tests with <prec> (coarse confusion). the smallest found distance can be returned by mindistance3d //! returns: false if status is fail (see below) status: done1 : if <shape> follows <sbwd>, direct sense (normal) done2 : if <shape> follows <sbwd>, but if reversed done3 : if <shape> precedes <sbwd>, direct sense done4 : if <shape> precedes <sbwd>, but if reversed fail1 : if <shape> is neither an edge nor a wire fail2 : if <shape> cannot be connected to <sbwd> //! done5 : to the tail of <sbwd> the <shape> is closer with direct sense done6 : to the head of <sbwd> the <shape> is closer with direct sense //! remark: statuses done1 - done4, fail1 - fail2 are basic and describe the nearest connection of the <shape> to <sbwd>. statuses done5 and done6 are advanced and are to be used when analyzing with what sense (direct or reversed) the <shape> should be connected to <sbwd>: for tail of <sbwd> if done4 is true <shape> should be direct, otherwise reversed. for head of <sbwd> if done5 is true <shape> should be direct, otherwise reversed.

        Parameters
        ----------
        shape: TopoDS_Shape
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        bool
        The same as previous checkshapeconnect but is more advanced. it returns the distances between each end of <sbwd> and each end of <shape>. for example, <tailhead> stores distance between tail of <sbwd> and head of <shape> remark: first method checkshapeconnect calls this one.

        Parameters
        ----------
        shape: TopoDS_Shape
        prec: float,optional
        	default value is 0.0

        Returns
        -------
        tailhead: float
        tailtail: float
        headtail: float
        headhead: float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckShapeConnect(self, *args)

    def CheckSmall(self, *args):
        r"""
        Calls to checksmall for each edge returns: true if at least one small edge was detected.

        Parameters
        ----------
        precsmall: float,optional
        	default value is 0.0

        Returns
        -------
        bool
        Checks if an edge has a length not greater than mypreci or precsmall (if it is smaller) returns: false if its length is greater than precision status: ok : edge is not small or degenerated done1: edge is small, vertices are the same done2: edge is small, vertices are not the same fail : no 3d curve and pcurve.

        Parameters
        ----------
        num: int
        precsmall: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckSmall(self, *args)

    def CheckSmallArea(self, *args):
        r"""
        Checks if wire has parametric area less than precision.

        Parameters
        ----------
        theWire: TopoDS_Wire

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckSmallArea(self, *args)

    def CheckTail(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theEdge1: TopoDS_Edge
        theEdge2: TopoDS_Edge
        theMaxSine: float
        theMaxWidth: float
        theMaxTolerance: float
        theEdge11: TopoDS_Edge
        theEdge12: TopoDS_Edge
        theEdge21: TopoDS_Edge
        theEdge22: TopoDS_Edge

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_CheckTail(self, *args)

    def ClearStatuses(self, *args):
        r"""
        Unsets all the status and distance fields wire, face and precision are not cleared.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_ClearStatuses(self, *args)

    def Face(self, *args):
        r"""
        Returns the working face.

        Returns
        -------
        TopoDS_Face

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_Face(self, *args)

    def Init(self, *args):
        r"""
        Initializes the object with standard topods_wire, face and precision.

        Parameters
        ----------
        wire: TopoDS_Wire
        face: TopoDS_Face
        precision: float

        Returns
        -------
        None
        Initializes the object with wiredata object, face and precision.

        Parameters
        ----------
        sbwd: ShapeExtend_WireData
        face: TopoDS_Face
        precision: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_Init(self, *args)

    def IsLoaded(self, *args):
        r"""
        Returns true if wire is loaded and has number of edges >0.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_IsLoaded(self, *args)

    def IsReady(self, *args):
        r"""
        Returns true if isloaded and underlying face is not null.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_IsReady(self, *args)

    def LastCheckStatus(self, *args):
        r"""
        Querying the status of the last performed 'advanced' checking procedure.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_LastCheckStatus(self, *args)

    def Load(self, *args):
        r"""
        Loads the object with standard topods_wire.

        Parameters
        ----------
        wire: TopoDS_Wire

        Returns
        -------
        None
        Loads the object with wiredata object.

        Parameters
        ----------
        sbwd: ShapeExtend_WireData

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_Load(self, *args)

    def MaxDistance2d(self, *args):
        r"""
        Returns the last maximal distance in 2d-uv computed by checkcontinuity2d.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_MaxDistance2d(self, *args)

    def MaxDistance3d(self, *args):
        r"""
        Returns the last maximal distance in 3d computed by checkorientation, checkconnected, checkcontinuity3d, checkvertex, checknewvertex, checksameparameter.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_MaxDistance3d(self, *args)

    def MinDistance2d(self, *args):
        r"""
        Returns the last lowest distance in 2d-uv computed by checkcontinuity2d.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_MinDistance2d(self, *args)

    def MinDistance3d(self, *args):
        r"""
        Returns the last lowest distance in 3d computed by checkorientation, checkconnected, checkcontinuity3d, checkvertex, checknewvertex.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_MinDistance3d(self, *args)

    def NbEdges(self, *args):
        r"""
        Returns the number of edges in the wire, or 0 if it is not loaded.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_NbEdges(self, *args)

    def Perform(self, *args):
        r"""
        Performs all the checks in the following order : checkorder, checksmall, checkconnected, checkedgecurves, checkdegenerated, checkselfintersection, checklacking, checkclosed returns: true if at least one method returned true; for deeper analysis use status...(status) methods.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_Perform(self, *args)

    def Precision(self, *args):
        r"""
        Returns the value of precision.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_Precision(self, *args)

    def SetFace(self, *args):
        r"""
        Loads the face the wire lies on.

        Parameters
        ----------
        face: TopoDS_Face

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_SetFace(self, *args)

    def SetPrecision(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        precision: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_SetPrecision(self, *args)

    def SetSurface(self, *args):
        r"""
        Loads the surface the wire lies on.

        Parameters
        ----------
        surface: Geom_Surface

        Returns
        -------
        None
        Loads the surface the wire lies on.

        Parameters
        ----------
        surface: Geom_Surface
        location: TopLoc_Location

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_SetSurface(self, *args)

    def StatusClosed(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusClosed(self, *args)

    def StatusConnected(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusConnected(self, *args)

    def StatusCurveGaps(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusCurveGaps(self, *args)

    def StatusDegenerated(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusDegenerated(self, *args)

    def StatusEdgeCurves(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusEdgeCurves(self, *args)

    def StatusGaps2d(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusGaps2d(self, *args)

    def StatusGaps3d(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusGaps3d(self, *args)

    def StatusLacking(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusLacking(self, *args)

    def StatusLoop(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusLoop(self, *args)

    def StatusOrder(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusOrder(self, *args)

    def StatusSelfIntersection(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusSelfIntersection(self, *args)

    def StatusSmall(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_StatusSmall(self, *args)

    def Surface(self, *args):
        r"""
        Returns the working surface.

        Returns
        -------
        opencascade::handle<ShapeAnalysis_Surface>

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_Surface(self, *args)

    def WireData(self, *args):
        r"""
        Returns wire object being analyzed.

        Returns
        -------
        opencascade::handle<ShapeExtend_WireData>

        """
        return _ShapeAnalysis.ShapeAnalysis_Wire_WireData(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeAnalysis_Wire_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_Wire

# Register ShapeAnalysis_Wire in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_Wire_swigregister(ShapeAnalysis_Wire)
class ShapeAnalysis_WireOrder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        Creates a wireorder in 3d (if mode3d is true) or 2d (if false) with a tolerance.

        Parameters
        ----------
        mode3d: bool
        tol: float

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_WireOrder_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_WireOrder(*args))

    def Add(self, *args):
        r"""
        Adds a couple of points 3d (start,end).

        Parameters
        ----------
        start3d: gp_XYZ
        end3d: gp_XYZ

        Returns
        -------
        None
        Adds a couple of points 2d (start,end).

        Parameters
        ----------
        start2d: gp_XY
        end2d: gp_XY

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Add(self, *args)

    def Chain(self, *args):
        r"""
        Returns, for the chain n0 num, starting and ending numbers of edges. in the list of ordered edges (see ordered for originals).

        Parameters
        ----------
        num: int

        Returns
        -------
        n1: int
        n2: int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Chain(self, *args)

    def Clear(self, *args):
        r"""
        Clears the list of edges, but not mode and tol.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Clear(self, *args)

    def Couple(self, *args):
        r"""
        Returns, for the couple n0 num, the two implied edges in the list of ordered edges.

        Parameters
        ----------
        num: int

        Returns
        -------
        n1: int
        n2: int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Couple(self, *args)

    def Gap(self, *args):
        r"""
        Returns the gap between a couple and its preceding <num> is considered ordered if <num> = 0 (d), returns the greatest gap found.

        Parameters
        ----------
        num: int,optional
        	default value is 0

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Gap(self, *args)

    def IsDone(self, *args):
        r"""
        Tells if perform has been done else, the following methods returns original values.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_IsDone(self, *args)

    def GetKeepLoopsMode(self):
        r"""GetKeepLoopsMode(ShapeAnalysis_WireOrder self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_GetKeepLoopsMode(self)

    def SetKeepLoopsMode(self, value):
        r"""SetKeepLoopsMode(ShapeAnalysis_WireOrder self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_SetKeepLoopsMode(self, value)

    def NbChains(self, *args):
        r"""
        Returns the count of computed chains.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_NbChains(self, *args)

    def NbCouples(self, *args):
        r"""
        Returns the count of computed couples.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_NbCouples(self, *args)

    def NbEdges(self, *args):
        r"""
        Returns the count of added couples of points (one per edges).

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_NbEdges(self, *args)

    def Ordered(self, *args):
        r"""
        Returns the number of original edge which correspond to the newly ordered number <n> warning : the returned value is negative if edge should be reversed.

        Parameters
        ----------
        n: int

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Ordered(self, *args)

    def Perform(self, *args):
        r"""
        Computes the better order if <closed> is true (d) considers also closure optimised if the couples were already in order the criterium is : two couples in order if distance between end-prec and start-cur is less then starting tolerance <tol> else, the smallest distance is reached gap corresponds to a smallest distance greater than <tol>.

        Parameters
        ----------
        closed: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Perform(self, *args)

    def SetChains(self, *args):
        r"""
        Determines the chains inside which successive edges have a gap less than a given value. queried by nbchains and chain.

        Parameters
        ----------
        gap: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_SetChains(self, *args)

    def SetCouples(self, *args):
        r"""
        Determines the couples of edges for which end and start fit inside a given gap. queried by nbcouples and couple.

        Parameters
        ----------
        gap: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_SetCouples(self, *args)

    def SetMode(self, *args):
        r"""
        Sets new values. clears the connexion list if <mode3d> changes, also clears the edge list (else, doesn't).

        Parameters
        ----------
        mode3d: bool
        tol: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_SetMode(self, *args)

    def Status(self, *args):
        r"""
        Returns the status of the order (0 if not done) : 0 : all edges are direct and in sequence 1 : all edges are direct but some are not in sequence 2 : in addition, unresolved gaps remain -1 : some edges are reversed, but no gap remain -2 : some edges are reversed and some gaps remain -10 : could not be resolved, failure on reorder gap : regarding starting <tol>.

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Status(self, *args)

    def Tolerance(self, *args):
        r"""
        Returns the working tolerance.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_Tolerance(self, *args)

    def XY(self, *args):
        r"""
        Returns the values of the couple <num>, as 2d values.

        Parameters
        ----------
        num: int
        start2d: gp_XY
        end2d: gp_XY

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_XY(self, *args)

    def XYZ(self, *args):
        r"""
        Returns the values of the couple <num>, as 3d values.

        Parameters
        ----------
        num: int
        start3d: gp_XYZ
        end3d: gp_XYZ

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireOrder_XYZ(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_WireOrder

# Register ShapeAnalysis_WireOrder in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_WireOrder_swigregister(ShapeAnalysis_WireOrder)
class ShapeAnalysis_WireVertex(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_WireVertex_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_WireVertex(*args))

    def Analyze(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Analyze(self, *args)

    def Data(self, *args):
        r"""
        Returns the recorded status for a vertex with its recorded position and parameters on both edges these values are relevant regarding the status: status meaning position preceding following 0 same no no no 1 samecoord no no no 2 close no no no 3 end yes no yes 4 start yes yes no 5 inters yes yes yes -1 disjoined no no no.

        Parameters
        ----------
        num: int
        pos: gp_XYZ

        Returns
        -------
        upre: float
        ufol: float

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Data(self, *args)

    def Init(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        wire: TopoDS_Wire
        preci: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        swbd: ShapeExtend_WireData
        preci: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Init(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if analysis was performed, else returns false.

        Returns
        -------
        bool

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_IsDone(self, *args)

    def Load(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        wire: TopoDS_Wire

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        sbwd: ShapeExtend_WireData

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Load(self, *args)

    def NbEdges(self, *args):
        r"""
        Returns the number of edges in analyzed wire (i.e. the length of all arrays).

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_NbEdges(self, *args)

    def NextCriter(self, *args):
        r"""
        For a given criter, returns the rank of the vertex which follows <num> and has the same status. 0 if no more acts as an iterator, starts on the first one criters are: 0: same vertex (status 0) 1: a solution exists (status >= 0) 2: same coords (i.e. same params) (status 0 1 2) 3: same coods but not same vertex (status 1 2) 4: redefined coords (status 3 4 5) -1: no solution (status -1).

        Parameters
        ----------
        crit: int
        num: int,optional
        	default value is 0

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_NextCriter(self, *args)

    def NextStatus(self, *args):
        r"""
        For a given status, returns the rank of the vertex which follows <num> and has the same status. 0 if no more acts as an iterator, starts on the first one.

        Parameters
        ----------
        stat: int
        num: int,optional
        	default value is 0

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_NextStatus(self, *args)

    def Position(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        num: int

        Returns
        -------
        gp_XYZ

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Position(self, *args)

    def Precision(self, *args):
        r"""
        Returns precision value used in analysis.

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Precision(self, *args)

    def SetClose(self, *args):
        r"""
        Records status 'close coords' (at the precision of <self>).

        Parameters
        ----------
        num: int

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetClose(self, *args)

    def SetDisjoined(self, *args):
        r"""
        <num> cannot be said as same vertex.

        Parameters
        ----------
        num: int

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetDisjoined(self, *args)

    def SetEnd(self, *args):
        r"""
        <num> is the end of preceding edge, and its projection on the following one lies on it at the precision of <self> <ufol> gives the parameter on the following edge.

        Parameters
        ----------
        num: int
        pos: gp_XYZ
        ufol: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetEnd(self, *args)

    def SetInters(self, *args):
        r"""
        <num> is the intersection of both edges <upre> is the parameter on preceding edge, <ufol> on following edge.

        Parameters
        ----------
        num: int
        pos: gp_XYZ
        upre: float
        ufol: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetInters(self, *args)

    def SetPrecision(self, *args):
        r"""
        Sets the precision for work analysing: for each vertex, comparison between the end of the preceding edge and the start of the following edge each vertex rank corresponds to the end vertex of the edge of same rank, in the shapeextend_wiredata. i.e. for vertex <num>, edge <num> is the preceding one, <num+1> is the following one.

        Parameters
        ----------
        preci: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetPrecision(self, *args)

    def SetSameCoords(self, *args):
        r"""
        Records status 'same coords' (at the vertices tolerances).

        Parameters
        ----------
        num: int

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetSameCoords(self, *args)

    def SetSameVertex(self, *args):
        r"""
        Records status 'same vertex' (logically) on vertex <num>.

        Parameters
        ----------
        num: int

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetSameVertex(self, *args)

    def SetStart(self, *args):
        r"""
        <num> is the start of following edge, its projection on the preceding one lies on it at the precision of <self> <upre> gives the parameter on the preceding edge.

        Parameters
        ----------
        num: int
        pos: gp_XYZ
        upre: float

        Returns
        -------
        None

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_SetStart(self, *args)

    def Status(self, *args):
        r"""
        Returns the recorded status for a vertex more detail by method data.

        Parameters
        ----------
        num: int

        Returns
        -------
        int

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_Status(self, *args)

    def UFollowing(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        num: int

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_UFollowing(self, *args)

    def UPrevious(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        num: int

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_UPrevious(self, *args)

    def WireData(self, *args):
        r"""
        Returns analyzed wire.

        Returns
        -------
        opencascade::handle<ShapeExtend_WireData>

        """
        return _ShapeAnalysis.ShapeAnalysis_WireVertex_WireData(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_WireVertex

# Register ShapeAnalysis_WireVertex in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_WireVertex_swigregister(ShapeAnalysis_WireVertex)
class ShapeAnalysis_TransferParametersProj(ShapeAnalysis_TransferParameters):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates empty constructor.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face

        Returns
        -------
        None

        """
        _ShapeAnalysis.ShapeAnalysis_TransferParametersProj_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_TransferParametersProj(*args))

    @staticmethod
    def CopyNMVertex(*args):
        r"""
        Make a copy of non-manifold vertex thevert (i.e. create new tvertex and replace pointrepresentations for this vertex from fromedge to toedge. other representations were copied).

        Parameters
        ----------
        theVert: TopoDS_Vertex
        toedge: TopoDS_Edge
        fromedge: TopoDS_Edge

        Returns
        -------
        TopoDS_Vertex
        Make a copy of non-manifold vertex thevert (i.e. create new tvertex and replace pointrepresentations for this vertex from fromface to toface. other representations were copied).

        Parameters
        ----------
        theVert: TopoDS_Vertex
        toFace: TopoDS_Face
        fromFace: TopoDS_Face

        Returns
        -------
        TopoDS_Vertex

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParametersProj_CopyNMVertex(*args)

    def GetForceProjection(self):
        r"""GetForceProjection(ShapeAnalysis_TransferParametersProj self) -> Standard_Boolean"""
        return _ShapeAnalysis.ShapeAnalysis_TransferParametersProj_GetForceProjection(self)

    def SetForceProjection(self, value):
        r"""SetForceProjection(ShapeAnalysis_TransferParametersProj self, Standard_Boolean value)"""
        return _ShapeAnalysis.ShapeAnalysis_TransferParametersProj_SetForceProjection(self, value)

    def Perform(self, *args):
        r"""
        Transfers parameters given by sequence params from 3d curve to pcurve (if to2d is true) or back (if to2d is false).

        Parameters
        ----------
        Papams: TColStd_HSequenceOfReal
        To2d: bool

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfReal>
        Transfers parameter given by param from 3d curve to pcurve (if to2d is true) or back (if to2d is false).

        Parameters
        ----------
        Param: float
        To2d: bool

        Returns
        -------
        float

        """
        return _ShapeAnalysis.ShapeAnalysis_TransferParametersProj_Perform(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeAnalysis_TransferParametersProj_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_TransferParametersProj

# Register ShapeAnalysis_TransferParametersProj in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_TransferParametersProj_swigregister(ShapeAnalysis_TransferParametersProj)

@classnotwrapped
class ShapeAnalysis_BoxBndTreeSelector:
	pass

@classnotwrapped
class ShapeCustom_ConvertToRevolution:
	pass


class ShapeAnalysis_HSequenceOfFreeBounds(ShapeAnalysis_SequenceOfFreeBounds, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _ShapeAnalysis.ShapeAnalysis_HSequenceOfFreeBounds_swiginit(self, _ShapeAnalysis.new_ShapeAnalysis_HSequenceOfFreeBounds(*args))

    def Sequence(self):
        return _ShapeAnalysis.ShapeAnalysis_HSequenceOfFreeBounds_Sequence(self)

    def Append(self, *args):
        return _ShapeAnalysis.ShapeAnalysis_HSequenceOfFreeBounds_Append(self, *args)

    def ChangeSequence(self):
        return _ShapeAnalysis.ShapeAnalysis_HSequenceOfFreeBounds_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeAnalysis_HSequenceOfFreeBounds_DownCast(t)

    __swig_destroy__ = _ShapeAnalysis.delete_ShapeAnalysis_HSequenceOfFreeBounds

# Register ShapeAnalysis_HSequenceOfFreeBounds in _ShapeAnalysis:
_ShapeAnalysis.ShapeAnalysis_HSequenceOfFreeBounds_swigregister(ShapeAnalysis_HSequenceOfFreeBounds)



