/* Generated by wayland-scanner 1.22.0 */

#ifndef QT_TOPLEVEL_DRAG_V1_CLIENT_PROTOCOL_H
#define QT_TOPLEVEL_DRAG_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_qt_toplevel_drag_v1 The qt_toplevel_drag_v1 protocol
 * @section page_ifaces_qt_toplevel_drag_v1 Interfaces
 * - @subpage page_iface_qt_toplevel_drag_manager_v1 - Move a window during a drag
 * - @subpage page_iface_qt_toplevel_drag_v1 - Object representing a toplevel move during a drag
 * @section page_copyright_qt_toplevel_drag_v1 Copyright
 * <pre>
 *
 * Copyright 2022 David Redondo  <kde@david-redondo.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct qt_toplevel_drag_manager_v1;
struct qt_toplevel_drag_v1;
struct wl_data_source;
struct xdg_toplevel;

#ifndef QT_TOPLEVEL_DRAG_MANAGER_V1_INTERFACE
#define QT_TOPLEVEL_DRAG_MANAGER_V1_INTERFACE
/**
 * @page page_iface_qt_toplevel_drag_manager_v1 qt_toplevel_drag_manager_v1
 * @section page_iface_qt_toplevel_drag_manager_v1_desc Description
 *
 * This protocol enhances normal drag and drop with the ability to move a
 * window at the same time. This allows having detachable windows that
 * can also be reattached when dragged back to another window or some special
 * zone.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_qt_toplevel_drag_manager_v1_api API
 * See @ref iface_qt_toplevel_drag_manager_v1.
 */
/**
 * @defgroup iface_qt_toplevel_drag_manager_v1 The qt_toplevel_drag_manager_v1 interface
 *
 * This protocol enhances normal drag and drop with the ability to move a
 * window at the same time. This allows having detachable windows that
 * can also be reattached when dragged back to another window or some special
 * zone.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface qt_toplevel_drag_manager_v1_interface;
#endif
#ifndef QT_TOPLEVEL_DRAG_V1_INTERFACE
#define QT_TOPLEVEL_DRAG_V1_INTERFACE
/**
 * @page page_iface_qt_toplevel_drag_v1 qt_toplevel_drag_v1
 * @section page_iface_qt_toplevel_drag_v1_desc Description
 *
 * @section page_iface_qt_toplevel_drag_v1_api API
 * See @ref iface_qt_toplevel_drag_v1.
 */
/**
 * @defgroup iface_qt_toplevel_drag_v1 The qt_toplevel_drag_v1 interface
 *
 */
extern const struct wl_interface qt_toplevel_drag_v1_interface;
#endif

#ifndef QT_TOPLEVEL_DRAG_MANAGER_V1_ERROR_ENUM
#define QT_TOPLEVEL_DRAG_MANAGER_V1_ERROR_ENUM
enum qt_toplevel_drag_manager_v1_error {
	/**
	 * data_source already used for toplevel drag
	 */
	QT_TOPLEVEL_DRAG_MANAGER_V1_ERROR_INVALID_SOURCE = 0,
};
#endif /* QT_TOPLEVEL_DRAG_MANAGER_V1_ERROR_ENUM */

#define QT_TOPLEVEL_DRAG_MANAGER_V1_GET_QT_TOPLEVEL_DRAG 0
#define QT_TOPLEVEL_DRAG_MANAGER_V1_RELEASE 1


/**
 * @ingroup iface_qt_toplevel_drag_manager_v1
 */
#define QT_TOPLEVEL_DRAG_MANAGER_V1_GET_QT_TOPLEVEL_DRAG_SINCE_VERSION 1
/**
 * @ingroup iface_qt_toplevel_drag_manager_v1
 */
#define QT_TOPLEVEL_DRAG_MANAGER_V1_RELEASE_SINCE_VERSION 1

/** @ingroup iface_qt_toplevel_drag_manager_v1 */
static inline void
qt_toplevel_drag_manager_v1_set_user_data(struct qt_toplevel_drag_manager_v1 *qt_toplevel_drag_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) qt_toplevel_drag_manager_v1, user_data);
}

/** @ingroup iface_qt_toplevel_drag_manager_v1 */
static inline void *
qt_toplevel_drag_manager_v1_get_user_data(struct qt_toplevel_drag_manager_v1 *qt_toplevel_drag_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) qt_toplevel_drag_manager_v1);
}

static inline uint32_t
qt_toplevel_drag_manager_v1_get_version(struct qt_toplevel_drag_manager_v1 *qt_toplevel_drag_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) qt_toplevel_drag_manager_v1);
}

/** @ingroup iface_qt_toplevel_drag_manager_v1 */
static inline void
qt_toplevel_drag_manager_v1_destroy(struct qt_toplevel_drag_manager_v1 *qt_toplevel_drag_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) qt_toplevel_drag_manager_v1);
}

/**
 * @ingroup iface_qt_toplevel_drag_manager_v1
 *
 * Create an qt_toplevel_drag for a drag and drop operation that is going
 * to be started with data_source.
 * This request can only be made on sources used in drag-and-drop, so it
 * must be performed before wl_data_device.start_drag. Attempting to use
 * the source other than for drag-and-drop will raise an invalid_source error.
 */
static inline struct qt_toplevel_drag_v1 *
qt_toplevel_drag_manager_v1_get_qt_toplevel_drag(struct qt_toplevel_drag_manager_v1 *qt_toplevel_drag_manager_v1, struct wl_data_source *data_source)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) qt_toplevel_drag_manager_v1,
			 QT_TOPLEVEL_DRAG_MANAGER_V1_GET_QT_TOPLEVEL_DRAG, &qt_toplevel_drag_v1_interface, wl_proxy_get_version((struct wl_proxy *) qt_toplevel_drag_manager_v1), 0, NULL, data_source);

	return (struct qt_toplevel_drag_v1 *) id;
}

/**
 * @ingroup iface_qt_toplevel_drag_manager_v1
 */
static inline void
qt_toplevel_drag_manager_v1_release(struct qt_toplevel_drag_manager_v1 *qt_toplevel_drag_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) qt_toplevel_drag_manager_v1,
			 QT_TOPLEVEL_DRAG_MANAGER_V1_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) qt_toplevel_drag_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef QT_TOPLEVEL_DRAG_V1_ERROR_ENUM
#define QT_TOPLEVEL_DRAG_V1_ERROR_ENUM
enum qt_toplevel_drag_v1_error {
	/**
	 * corresponding drag has ended
	 */
	QT_TOPLEVEL_DRAG_V1_ERROR_DRAG_ENDED = 0,
};
#endif /* QT_TOPLEVEL_DRAG_V1_ERROR_ENUM */

#define QT_TOPLEVEL_DRAG_V1_ATTACH 0
#define QT_TOPLEVEL_DRAG_V1_DESTROY 1


/**
 * @ingroup iface_qt_toplevel_drag_v1
 */
#define QT_TOPLEVEL_DRAG_V1_ATTACH_SINCE_VERSION 1
/**
 * @ingroup iface_qt_toplevel_drag_v1
 */
#define QT_TOPLEVEL_DRAG_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_qt_toplevel_drag_v1 */
static inline void
qt_toplevel_drag_v1_set_user_data(struct qt_toplevel_drag_v1 *qt_toplevel_drag_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) qt_toplevel_drag_v1, user_data);
}

/** @ingroup iface_qt_toplevel_drag_v1 */
static inline void *
qt_toplevel_drag_v1_get_user_data(struct qt_toplevel_drag_v1 *qt_toplevel_drag_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) qt_toplevel_drag_v1);
}

static inline uint32_t
qt_toplevel_drag_v1_get_version(struct qt_toplevel_drag_v1 *qt_toplevel_drag_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) qt_toplevel_drag_v1);
}

/**
 * @ingroup iface_qt_toplevel_drag_v1
 *
 * Request that the window will be moved with the cursor during the drag operation. The offset
 * describes how the toplevel will be positioned relative to the cursor hotspot
 * in surface local coordinates.
 * Issuing this request after the drag has ended will result in a drag_ended protocol error.
 */
static inline void
qt_toplevel_drag_v1_attach(struct qt_toplevel_drag_v1 *qt_toplevel_drag_v1, struct xdg_toplevel *toplevel, int32_t x_offset, int32_t y_offset)
{
	wl_proxy_marshal_flags((struct wl_proxy *) qt_toplevel_drag_v1,
			 QT_TOPLEVEL_DRAG_V1_ATTACH, NULL, wl_proxy_get_version((struct wl_proxy *) qt_toplevel_drag_v1), 0, toplevel, x_offset, y_offset);
}

/**
 * @ingroup iface_qt_toplevel_drag_v1
 */
static inline void
qt_toplevel_drag_v1_destroy(struct qt_toplevel_drag_v1 *qt_toplevel_drag_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) qt_toplevel_drag_v1,
			 QT_TOPLEVEL_DRAG_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) qt_toplevel_drag_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
