"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListTypes = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const ListTypesCommand_1 = require("../commands/ListTypesCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListTypesCommand_1.ListTypesCommand(input), ...args);
};
async function* paginateListTypes(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListTypes = paginateListTypes;
