import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { DeactivateOrganizationsAccessInput, DeactivateOrganizationsAccessOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeactivateOrganizationsAccessCommand}.
 */
export interface DeactivateOrganizationsAccessCommandInput extends DeactivateOrganizationsAccessInput {
}
/**
 * @public
 *
 * The output of {@link DeactivateOrganizationsAccessCommand}.
 */
export interface DeactivateOrganizationsAccessCommandOutput extends DeactivateOrganizationsAccessOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Deactivates trusted access with Organizations. If trusted access is deactivated,
 *       the management account does not have permissions to create and manage
 *       service-managed StackSets for your organization.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, DeactivateOrganizationsAccessCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, DeactivateOrganizationsAccessCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = {};
 * const command = new DeactivateOrganizationsAccessCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeactivateOrganizationsAccessCommandInput - {@link DeactivateOrganizationsAccessCommandInput}
 * @returns {@link DeactivateOrganizationsAccessCommandOutput}
 * @see {@link DeactivateOrganizationsAccessCommandInput} for command's `input` shape.
 * @see {@link DeactivateOrganizationsAccessCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link InvalidOperationException} (client fault)
 *  <p>The specified operation isn't valid.</p>
 *
 * @throws {@link OperationNotFoundException} (client fault)
 *  <p>The specified ID refers to an operation that doesn't exist.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class DeactivateOrganizationsAccessCommand extends $Command<DeactivateOrganizationsAccessCommandInput, DeactivateOrganizationsAccessCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: DeactivateOrganizationsAccessCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DeactivateOrganizationsAccessCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeactivateOrganizationsAccessCommandInput, DeactivateOrganizationsAccessCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
