/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import jakarta.servlet.jsp.tagext.VariableInfo;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.TrimSpacesOption;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ELInterpreter;
import org.apache.jasper.compiler.ELInterpreterFactory;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JasperTagInfo;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.StringInterpreter;
import org.apache.jasper.compiler.StringInterpreterFactory;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.Attributes;

class Generator {
    private final Log log = LogFactory.getLog(Generator.class);
    private static final Class<?>[] OBJECT_CLASS = new Class[]{Object.class};
    private static final Pattern PRE_TAG_PATTERN = Pattern.compile("(?s).*(<pre>|</pre>).*");
    private static final Pattern BLANK_LINE_PATTERN = Pattern.compile("(\\s*(\\n|\\r)+\\s*)");
    private final ServletWriter out;
    private final ArrayList<GenBuffer> methodsBuffered;
    private final FragmentHelperClass fragmentHelperClass;
    private final ErrorDispatcher err;
    private final BeanRepository beanInfo;
    private final Set<String> varInfoNames;
    private final JspCompilationContext ctxt;
    private final boolean isPoolingEnabled;
    private final boolean breakAtLF;
    private String jspIdPrefix;
    private int jspId;
    private final PageInfo pageInfo;
    private final List<String> tagHandlerPoolNames;
    private GenBuffer charArrayBuffer;
    private final DateFormat timestampFormat;
    private final ELInterpreter elInterpreter;
    private final StringInterpreter stringInterpreter;

    static String quote(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + Generator.escape(string) + "\"";
    }

    static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                stringBuilder.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                stringBuilder.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                stringBuilder.append('\\').append('r');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String quote(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\'');
        if (c == '\'') {
            stringBuilder.append('\\').append('\'');
        } else if (c == '\\') {
            stringBuilder.append('\\').append('\\');
        } else if (c == '\n') {
            stringBuilder.append('\\').append('n');
        } else if (c == '\r') {
            stringBuilder.append('\\').append('r');
        } else {
            stringBuilder.append(c);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private String createJspId() {
        if (this.jspIdPrefix == null) {
            StringBuilder stringBuilder = new StringBuilder(32);
            String string = this.ctxt.getServletJavaFileName();
            stringBuilder.append("jsp_");
            stringBuilder.append(Math.abs((long)string.hashCode()));
            stringBuilder.append('_');
            this.jspIdPrefix = stringBuilder.toString();
        }
        return this.jspIdPrefix + this.jspId++;
    }

    private void generateDeclarations(Node.Nodes nodes) throws JasperException {
        this.out.println();
        class DeclarationVisitor
        extends Node.Visitor {
            private boolean getServletInfoGenerated = false;

            DeclarationVisitor() {
            }

            @Override
            public void visit(Node.PageDirective pageDirective) throws JasperException {
                if (this.getServletInfoGenerated) {
                    return;
                }
                String string = pageDirective.getAttributeValue("info");
                if (string == null) {
                    return;
                }
                this.getServletInfoGenerated = true;
                Generator.this.out.printil("public java.lang.String getServletInfo() {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin("return ");
                Generator.this.out.print(Generator.quote(string));
                Generator.this.out.println(";");
                Generator.this.out.popIndent();
                Generator.this.out.printil("}");
                Generator.this.out.println();
            }

            @Override
            public void visit(Node.Declaration declaration) throws JasperException {
                declaration.setBeginJavaLine(Generator.this.out.getJavaLine());
                Generator.this.out.printMultiLn(declaration.getText());
                Generator.this.out.println();
                declaration.setEndJavaLine(Generator.this.out.getJavaLine());
            }

            @Override
            public void visit(Node.CustomTag customTag) throws JasperException {
                if (customTag.useTagPlugin()) {
                    customTag.getAtSTag().visit(this);
                    this.visitBody(customTag);
                    customTag.getAtETag().visit(this);
                } else {
                    this.visitBody(customTag);
                }
            }
        }
        nodes.visit(new DeclarationVisitor());
    }

    private void compileTagHandlerPoolList(Node.Nodes nodes) throws JasperException {
        class TagHandlerPoolVisitor
        extends Node.Visitor {
            private final List<String> names;

            TagHandlerPoolVisitor(List<String> list) {
                this.names = list;
            }

            @Override
            public void visit(Node.CustomTag customTag) throws JasperException {
                if (!customTag.implementsSimpleTag()) {
                    String string = this.createTagHandlerPoolName(customTag.getPrefix(), customTag.getLocalName(), customTag.getAttributes(), customTag.getNamedAttributeNodes(), customTag.hasEmptyBody());
                    customTag.setTagHandlerPoolName(string);
                    if (!this.names.contains(string)) {
                        this.names.add(string);
                    }
                }
                this.visitBody(customTag);
            }

            private String createTagHandlerPoolName(String string, String string2, Attributes attributes, Node.Nodes nodes, boolean bl) {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append("_jspx_tagPool_").append(string).append('_').append(string2);
                if (attributes != null) {
                    int n;
                    String[] stringArray = new String[attributes.getLength() + nodes.size()];
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = attributes.getQName(n);
                    }
                    for (n = 0; n < nodes.size(); ++n) {
                        stringArray[attributes.getLength() + n] = nodes.getNode(n).getQName();
                    }
                    Arrays.sort(stringArray, Collections.reverseOrder());
                    if (stringArray.length > 0) {
                        stringBuilder.append('&');
                    }
                    for (String string3 : stringArray) {
                        stringBuilder.append('_');
                        stringBuilder.append(string3);
                    }
                }
                if (bl) {
                    stringBuilder.append("_nobody");
                }
                return JspUtil.makeJavaIdentifier(stringBuilder.toString());
            }
        }
        nodes.visit(new TagHandlerPoolVisitor(this.tagHandlerPoolNames));
    }

    private void declareTemporaryScriptingVars(Node.Nodes nodes) throws JasperException {
        class ScriptingVarVisitor
        extends Node.Visitor {
            private final List<String> vars = new ArrayList<String>();

            ScriptingVarVisitor() {
            }

            @Override
            public void visit(Node.CustomTag customTag) throws JasperException {
                if (customTag.getCustomNestingLevel() > 0) {
                    TagVariableInfo[] tagVariableInfoArray = customTag.getTagVariableInfos();
                    VariableInfo[] variableInfoArray = customTag.getVariableInfos();
                    if (variableInfoArray.length > 0) {
                        for (VariableInfo variableInfo : variableInfoArray) {
                            String string = variableInfo.getVarName();
                            String string2 = "_jspx_" + string + "_" + customTag.getCustomNestingLevel();
                            if (this.vars.contains(string2)) continue;
                            this.vars.add(string2);
                            Generator.this.out.printin(variableInfo.getClassName());
                            Generator.this.out.print(" ");
                            Generator.this.out.print(string2);
                            Generator.this.out.print(" = ");
                            Generator.this.out.print(null);
                            Generator.this.out.println(";");
                        }
                    } else {
                        for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
                            String string = tagVariableInfo.getNameGiven();
                            if (string == null) {
                                string = customTag.getTagData().getAttributeString(tagVariableInfo.getNameFromAttribute());
                            } else if (tagVariableInfo.getNameFromAttribute() != null) continue;
                            String string3 = "_jspx_" + string + "_" + customTag.getCustomNestingLevel();
                            if (this.vars.contains(string3)) continue;
                            this.vars.add(string3);
                            Generator.this.out.printin(tagVariableInfo.getClassName());
                            Generator.this.out.print(" ");
                            Generator.this.out.print(string3);
                            Generator.this.out.print(" = ");
                            Generator.this.out.print(null);
                            Generator.this.out.println(";");
                        }
                    }
                }
                this.visitBody(customTag);
            }
        }
        nodes.visit(new ScriptingVarVisitor());
    }

    private void generateGetters() {
        this.out.printil("public jakarta.el.ExpressionFactory _jsp_getExpressionFactory() {");
        this.out.pushIndent();
        if (!this.ctxt.isTagFile()) {
            this.out.printin("if (");
            this.out.print(this.ctxt.getOptions().getVariableForExpressionFactory());
            this.out.println(" == null) {");
            this.out.pushIndent();
            this.out.printil("synchronized (this) {");
            this.out.pushIndent();
            this.out.printin("if (");
            this.out.print(this.ctxt.getOptions().getVariableForExpressionFactory());
            this.out.println(" == null) {");
            this.out.pushIndent();
            this.out.printin(this.ctxt.getOptions().getVariableForExpressionFactory());
            this.out.println(" = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();");
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
        }
        this.out.printin("return ");
        this.out.print(this.ctxt.getOptions().getVariableForExpressionFactory());
        this.out.println(";");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public org.apache.tomcat.InstanceManager _jsp_getInstanceManager() {");
        this.out.pushIndent();
        if (!this.ctxt.isTagFile()) {
            this.out.printin("if (");
            this.out.print(this.ctxt.getOptions().getVariableForInstanceManager());
            this.out.println(" == null) {");
            this.out.pushIndent();
            this.out.printil("synchronized (this) {");
            this.out.pushIndent();
            this.out.printin("if (");
            this.out.print(this.ctxt.getOptions().getVariableForInstanceManager());
            this.out.println(" == null) {");
            this.out.pushIndent();
            this.out.printin(this.ctxt.getOptions().getVariableForInstanceManager());
            this.out.println(" = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());");
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
        }
        this.out.printin("return ");
        this.out.print(this.ctxt.getOptions().getVariableForInstanceManager());
        this.out.println(";");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void generateInit() {
        if (this.ctxt.isTagFile()) {
            this.out.printil("private void _jspInit(jakarta.servlet.ServletConfig config) {");
        } else {
            this.out.printil("public void _jspInit() {");
        }
        this.out.pushIndent();
        if (this.isPoolingEnabled) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printin(this.tagHandlerPoolNames.get(i));
                this.out.print(" = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(");
                if (this.ctxt.isTagFile()) {
                    this.out.print("config");
                } else {
                    this.out.print("getServletConfig()");
                }
                this.out.println(");");
            }
        }
        if (this.ctxt.isTagFile()) {
            this.out.printin(this.ctxt.getOptions().getVariableForExpressionFactory());
            this.out.println(" = _jspxFactory.getJspApplicationContext(config.getServletContext()).getExpressionFactory();");
            this.out.printin(this.ctxt.getOptions().getVariableForInstanceManager());
            this.out.println(" = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(config);");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void generateDestroy() {
        this.out.printil("public void _jspDestroy() {");
        this.out.pushIndent();
        if (this.isPoolingEnabled) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printin(this.tagHandlerPoolNames.get(i));
                this.out.println(".release();");
            }
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void genPreamblePackage(String string) {
        this.out.printil("package " + string + ";");
        this.out.println();
    }

    private void genPreambleImports() {
        for (String string : this.pageInfo.getImports()) {
            this.out.printin("import ");
            this.out.print(string);
            this.out.println(";");
        }
        this.out.println();
    }

    private void genPreambleStaticInitializers() {
        this.out.printil("private static final jakarta.servlet.jsp.JspFactory _jspxFactory =");
        this.out.printil("        jakarta.servlet.jsp.JspFactory.getDefaultFactory();");
        this.out.println();
        this.out.printil("private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;");
        this.out.println();
        Map<String, Long> map = this.pageInfo.getDependants();
        if (!map.isEmpty()) {
            this.out.printil("static {");
            this.out.pushIndent();
            this.out.printin("_jspx_dependants = new java.util.HashMap<java.lang.String,java.lang.Long>(");
            this.out.print("" + map.size());
            this.out.println(");");
            for (Map.Entry object2 : map.entrySet()) {
                this.out.printin("_jspx_dependants.put(\"");
                this.out.print((String)object2.getKey());
                this.out.print("\", Long.valueOf(");
                this.out.print(((Long)object2.getValue()).toString());
                this.out.println("L));");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
        List<String> list = this.pageInfo.getImports();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = string.trim();
            if (string2.endsWith(".*")) {
                hashSet.add(string2.substring(0, string2.length() - 2));
                continue;
            }
            hashSet2.add(string2);
        }
        this.out.printil("private static final java.util.Set<java.lang.String> _jspx_imports_packages;");
        this.out.println();
        this.out.printil("private static final java.util.Set<java.lang.String> _jspx_imports_classes;");
        this.out.println();
        this.out.printil("static {");
        this.out.pushIndent();
        this.out.printin("_jspx_imports_packages = new java.util.HashSet<>();");
        this.out.println();
        for (String string : hashSet) {
            this.out.printin("_jspx_imports_packages.add(\"");
            this.out.print(string);
            this.out.println("\");");
        }
        if (hashSet2.size() == 0) {
            this.out.printin("_jspx_imports_classes = null;");
            this.out.println();
        } else {
            this.out.printin("_jspx_imports_classes = new java.util.HashSet<>();");
            this.out.println();
            for (String string : hashSet2) {
                this.out.printin("_jspx_imports_classes.add(\"");
                this.out.print(string);
                this.out.println("\");");
            }
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void genPreambleClassVariableDeclarations() {
        if (this.isPoolingEnabled && !this.tagHandlerPoolNames.isEmpty()) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printil("private org.apache.jasper.runtime.TagHandlerPool " + this.tagHandlerPoolNames.get(i) + ";");
            }
            this.out.println();
        }
        this.out.printin("private volatile jakarta.el.ExpressionFactory ");
        this.out.print(this.ctxt.getOptions().getVariableForExpressionFactory());
        this.out.println(";");
        this.out.printin("private volatile org.apache.tomcat.InstanceManager ");
        this.out.print(this.ctxt.getOptions().getVariableForInstanceManager());
        this.out.println(";");
        this.out.println();
    }

    private void genPreambleMethods() {
        this.out.printil("public java.util.Map<java.lang.String,java.lang.Long> getDependants() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_dependants;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public java.util.Set<java.lang.String> getPackageImports() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_imports_packages;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public java.util.Set<java.lang.String> getClassImports() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_imports_classes;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public boolean getErrorOnELNotFound() {");
        this.out.pushIndent();
        if (this.pageInfo.isErrorOnELNotFound()) {
            this.out.printil("return true;");
        } else {
            this.out.printil("return false;");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.generateGetters();
        this.generateInit();
        this.generateDestroy();
    }

    private void generatePreamble(Node.Nodes nodes) throws JasperException {
        String string = this.ctxt.getServletPackageName();
        String string2 = this.ctxt.getServletClassName();
        String string3 = this.ctxt.getOptions().getServiceMethodName();
        this.genPreamblePackage(string);
        this.genPreambleImports();
        this.out.printin("public final class ");
        this.out.print(string2);
        this.out.print(" extends ");
        this.out.println(this.pageInfo.getExtends());
        this.out.printin("    implements org.apache.jasper.runtime.JspSourceDependent,");
        this.out.println();
        this.out.printin("                 org.apache.jasper.runtime.JspSourceImports");
        this.out.println(",");
        this.out.printin("                 org.apache.jasper.runtime.JspSourceDirectives");
        this.out.println(" {");
        this.out.pushIndent();
        this.generateDeclarations(nodes);
        this.genPreambleStaticInitializers();
        this.genPreambleClassVariableDeclarations();
        this.genPreambleMethods();
        if (this.pageInfo.isThreadSafe()) {
            this.out.printin("public void ");
        } else {
            this.out.printin("public synchronized void ");
            this.log.warn((Object)Localizer.getMessage("jsp.warning.isThreadSafe", this.ctxt.getJspFile()));
        }
        this.out.print(string3);
        this.out.println("(final jakarta.servlet.http.HttpServletRequest request, final jakarta.servlet.http.HttpServletResponse response)");
        this.out.pushIndent();
        this.out.pushIndent();
        this.out.printil("throws java.io.IOException, jakarta.servlet.ServletException {");
        this.out.popIndent();
        this.out.println();
        if (!this.pageInfo.isErrorPage()) {
            this.out.printil("if (!jakarta.servlet.DispatcherType.ERROR.equals(request.getDispatcherType())) {");
            this.out.pushIndent();
            this.out.printil("final java.lang.String _jspx_method = request.getMethod();");
            this.out.printil("if (\"OPTIONS\".equals(_jspx_method)) {");
            this.out.pushIndent();
            this.out.printil("response.setHeader(\"Allow\",\"GET, HEAD, POST, OPTIONS\");");
            this.out.printil("return;");
            this.out.popIndent();
            this.out.printil("}");
            this.out.printil("if (!\"GET\".equals(_jspx_method) && !\"POST\".equals(_jspx_method) && !\"HEAD\".equals(_jspx_method)) {");
            this.out.pushIndent();
            this.out.printil("response.setHeader(\"Allow\",\"GET, HEAD, POST, OPTIONS\");");
            this.out.printin("response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED, ");
            this.out.println("\"" + Localizer.getMessage("jsp.error.servlet.invalid.method") + "\");");
            this.out.printil("return;");
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
        this.out.printil("final jakarta.servlet.jsp.PageContext pageContext;");
        if (this.pageInfo.isSession()) {
            this.out.printil("jakarta.servlet.http.HttpSession session = null;");
        }
        if (this.pageInfo.isErrorPage()) {
            this.out.printil("java.lang.Throwable exception = org.apache.jasper.runtime.JspRuntimeLibrary.getThrowable(request);");
            this.out.printil("if (exception != null) {");
            this.out.pushIndent();
            this.out.printil("response.setStatus(jakarta.servlet.http.HttpServletResponse.SC_INTERNAL_SERVER_ERROR);");
            this.out.popIndent();
            this.out.printil("}");
        }
        this.out.printil("final jakarta.servlet.ServletContext application;");
        this.out.printil("final jakarta.servlet.ServletConfig config;");
        this.out.printil("jakarta.servlet.jsp.JspWriter out = null;");
        this.out.printil("final java.lang.Object page = this;");
        this.out.printil("jakarta.servlet.jsp.JspWriter _jspx_out = null;");
        this.out.printil("jakarta.servlet.jsp.PageContext _jspx_page_context = null;");
        this.out.println();
        this.declareTemporaryScriptingVars(nodes);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printin("response.setContentType(");
        this.out.print(Generator.quote(this.pageInfo.getContentType()));
        this.out.println(");");
        if (this.ctxt.getOptions().isXpoweredBy()) {
            this.out.printil("response.addHeader(\"X-Powered-By\", \"JSP/3.1\");");
        }
        this.out.printil("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.out.printin("\t\t\t");
        this.out.print(Generator.quote(this.pageInfo.getErrorPage()));
        this.out.print(", " + this.pageInfo.isSession());
        this.out.print(", " + this.pageInfo.getBuffer());
        this.out.print(", " + this.pageInfo.isAutoFlush());
        this.out.println(");");
        this.out.printil("_jspx_page_context = pageContext;");
        this.out.printil("application = pageContext.getServletContext();");
        this.out.printil("config = pageContext.getServletConfig();");
        if (this.pageInfo.isSession()) {
            this.out.printil("session = pageContext.getSession();");
        }
        this.out.printil("out = pageContext.getOut();");
        this.out.printil("_jspx_out = out;");
        this.out.println();
    }

    private void generateXmlProlog(Node.Nodes nodes) {
        String string;
        String string2;
        String string3 = this.pageInfo.getOmitXmlDecl();
        if (string3 != null && !JspUtil.booleanValue(string3) || string3 == null && nodes.getRoot().isXmlSyntax() && !this.pageInfo.hasJspRoot() && !this.ctxt.isTagFile()) {
            string2 = this.pageInfo.getContentType();
            string = string2.substring(string2.indexOf("charset=") + 8);
            this.out.printil("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + string + "\\\"?>\\n\");");
        }
        if ((string2 = this.pageInfo.getDoctypeName()) != null) {
            string = this.pageInfo.getDoctypePublic();
            String string4 = this.pageInfo.getDoctypeSystem();
            this.out.printin("out.write(\"<!DOCTYPE ");
            this.out.print(string2);
            if (string == null) {
                this.out.print(" SYSTEM \\\"");
            } else {
                this.out.print(" PUBLIC \\\"");
                this.out.print(string);
                this.out.print("\\\" \\\"");
            }
            this.out.print(string4);
            this.out.println("\\\">\\n\");");
        }
    }

    private static void generateLocalVariables(ServletWriter servletWriter, Node.ChildInfoBase childInfoBase) {
        Node.ChildInfo childInfo = childInfoBase.getChildInfo();
        if (childInfo.hasUseBean()) {
            servletWriter.printil("jakarta.servlet.http.HttpSession session = _jspx_page_context.getSession();");
            servletWriter.printil("jakarta.servlet.ServletContext application = _jspx_page_context.getServletContext();");
        }
        if (childInfo.hasUseBean() || childInfo.hasIncludeAction() || childInfo.hasSetProperty() || childInfo.hasParamAction()) {
            servletWriter.printil("jakarta.servlet.http.HttpServletRequest request = (jakarta.servlet.http.HttpServletRequest)_jspx_page_context.getRequest();");
        }
        if (childInfo.hasIncludeAction()) {
            servletWriter.printil("jakarta.servlet.http.HttpServletResponse response = (jakarta.servlet.http.HttpServletResponse)_jspx_page_context.getResponse();");
        }
    }

    private void genCommonPostamble() {
        for (GenBuffer genBuffer : this.methodsBuffered) {
            genBuffer.adjustJavaLines(this.out.getJavaLine() - 1);
            this.out.printMultiLn(genBuffer.toString());
        }
        if (this.fragmentHelperClass.isUsed()) {
            this.fragmentHelperClass.generatePostamble();
            this.fragmentHelperClass.adjustJavaLines(this.out.getJavaLine() - 1);
            this.out.printMultiLn(this.fragmentHelperClass.toString());
        }
        if (this.charArrayBuffer != null) {
            this.out.printMultiLn(this.charArrayBuffer.toString());
        }
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePostamble() {
        this.out.popIndent();
        this.out.printil("} catch (java.lang.Throwable t) {");
        this.out.pushIndent();
        this.out.printil("if (!(t instanceof jakarta.servlet.jsp.SkipPageException)){");
        this.out.pushIndent();
        this.out.printil("out = _jspx_out;");
        this.out.printil("if (out != null && out.getBufferSize() != 0)");
        this.out.pushIndent();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printil("if (response.isCommitted()) {");
        this.out.pushIndent();
        this.out.printil("out.flush();");
        this.out.popIndent();
        this.out.printil("} else {");
        this.out.pushIndent();
        this.out.printil("out.clearBuffer();");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("} catch (java.io.IOException e) {}");
        this.out.popIndent();
        this.out.printil("if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);");
        this.out.printil("else throw new ServletException(t);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        this.out.printil("_jspxFactory.releasePageContext(_jspx_page_context);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.genCommonPostamble();
    }

    Generator(ServletWriter servletWriter, Compiler compiler) throws JasperException {
        this.out = servletWriter;
        this.methodsBuffered = new ArrayList();
        this.charArrayBuffer = null;
        this.err = compiler.getErrorDispatcher();
        this.ctxt = compiler.getCompilationContext();
        this.fragmentHelperClass = new FragmentHelperClass("Helper");
        this.pageInfo = compiler.getPageInfo();
        ELInterpreter eLInterpreter = null;
        try {
            eLInterpreter = ELInterpreterFactory.getELInterpreter(compiler.getCompilationContext().getServletContext());
        }
        catch (Exception exception) {
            this.err.jspError("jsp.error.el_interpreter_class.instantiation", exception.getMessage());
        }
        this.elInterpreter = eLInterpreter;
        StringInterpreter stringInterpreter = null;
        try {
            stringInterpreter = StringInterpreterFactory.getStringInterpreter(compiler.getCompilationContext().getServletContext());
        }
        catch (Exception exception) {
            this.err.jspError("jsp.error.string_interpreter_class.instantiation", exception.getMessage());
        }
        this.stringInterpreter = stringInterpreter;
        this.isPoolingEnabled = this.pageInfo.getExtends(false) == null || this.ctxt.getOptions().getPoolTagsWithExtends() ? this.ctxt.getOptions().isPoolingEnabled() : false;
        this.beanInfo = this.pageInfo.getBeanRepository();
        this.varInfoNames = this.pageInfo.getVarInfoNames();
        this.breakAtLF = this.ctxt.getOptions().getMappedFile();
        this.tagHandlerPoolNames = this.isPoolingEnabled ? new ArrayList<String>() : null;
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static void generate(ServletWriter servletWriter, Compiler compiler, Node.Nodes nodes) throws JasperException {
        Generator generator = new Generator(servletWriter, compiler);
        if (generator.isPoolingEnabled) {
            generator.compileTagHandlerPoolList(nodes);
        }
        generator.generateCommentHeader();
        if (generator.ctxt.isTagFile()) {
            JasperTagInfo jasperTagInfo = (JasperTagInfo)generator.ctxt.getTagInfo();
            generator.generateTagHandlerPreamble(jasperTagInfo, nodes);
            if (generator.ctxt.isPrototypeMode()) {
                return;
            }
            generator.generateXmlProlog(nodes);
            generator.fragmentHelperClass.generatePreamble();
            Generator generator2 = generator;
            Objects.requireNonNull(generator2);
            nodes.visit(generator2.new GenerateVisitor(generator.ctxt.isTagFile(), servletWriter, generator.methodsBuffered, generator.fragmentHelperClass, generator.ctxt.getOptions().getUseInstanceManagerForTags()));
            generator.generateTagHandlerPostamble(jasperTagInfo);
        } else {
            generator.generatePreamble(nodes);
            generator.generateXmlProlog(nodes);
            generator.fragmentHelperClass.generatePreamble();
            Generator generator3 = generator;
            Objects.requireNonNull(generator3);
            nodes.visit(generator3.new GenerateVisitor(generator.ctxt.isTagFile(), servletWriter, generator.methodsBuffered, generator.fragmentHelperClass, generator.ctxt.getOptions().getUseInstanceManagerForTags()));
            generator.generatePostamble();
        }
    }

    private void generateCommentHeader() {
        this.out.println("/*");
        this.out.println(" * Generated by the Jasper component of Apache Tomcat");
        this.out.println(" * Version: " + this.ctxt.getServletContext().getServerInfo());
        if (this.ctxt.getOptions().getGeneratedJavaAddTimestamp()) {
            this.out.println(" * Generated at: " + this.timestampFormat.format(new Date()) + " UTC");
        }
        this.out.println(" * Note: The last modified time of this file was set to");
        this.out.println(" *       the last modified time of the source file after");
        this.out.println(" *       generation to assist with modification tracking.");
        this.out.println(" */");
    }

    private void generateTagHandlerPreamble(JasperTagInfo jasperTagInfo, Node.Nodes nodes) throws JasperException {
        String string = jasperTagInfo.getTagClassName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        this.genPreamblePackage(string2);
        string = string.substring(n + 1);
        this.genPreambleImports();
        this.out.printin("public final class ");
        this.out.println(string);
        this.out.printil("    extends jakarta.servlet.jsp.tagext.SimpleTagSupport");
        this.out.printin("    implements org.apache.jasper.runtime.JspSourceDependent,");
        this.out.println();
        this.out.printin("                 org.apache.jasper.runtime.JspSourceImports");
        if (jasperTagInfo.hasDynamicAttributes()) {
            this.out.println(",");
            this.out.printin("               jakarta.servlet.jsp.tagext.DynamicAttributes");
        }
        this.out.println(",");
        this.out.printin("                 org.apache.jasper.runtime.JspSourceDirectives");
        this.out.println(" {");
        this.out.pushIndent();
        this.generateDeclarations(nodes);
        this.genPreambleStaticInitializers();
        this.out.printil("private jakarta.servlet.jsp.JspContext jspContext;");
        this.out.printil("private java.io.Writer _jspx_sout;");
        this.genPreambleClassVariableDeclarations();
        this.generateSetJspContext(jasperTagInfo);
        this.generateTagHandlerAttributes(jasperTagInfo);
        if (jasperTagInfo.hasDynamicAttributes()) {
            this.generateSetDynamicAttribute();
        }
        this.genPreambleMethods();
        this.out.printil("public void doTag() throws jakarta.servlet.jsp.JspException, java.io.IOException {");
        if (this.ctxt.isPrototypeMode()) {
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            return;
        }
        this.out.pushIndent();
        this.out.printil("jakarta.servlet.jsp.PageContext _jspx_page_context = (jakarta.servlet.jsp.PageContext)jspContext;");
        this.out.printil("jakarta.servlet.http.HttpServletRequest request = (jakarta.servlet.http.HttpServletRequest) _jspx_page_context.getRequest();");
        this.out.printil("jakarta.servlet.http.HttpServletResponse response = (jakarta.servlet.http.HttpServletResponse) _jspx_page_context.getResponse();");
        this.out.printil("jakarta.servlet.http.HttpSession session = _jspx_page_context.getSession();");
        this.out.printil("jakarta.servlet.ServletContext application = _jspx_page_context.getServletContext();");
        this.out.printil("jakarta.servlet.ServletConfig config = _jspx_page_context.getServletConfig();");
        this.out.printil("jakarta.servlet.jsp.JspWriter out = jspContext.getOut();");
        this.out.printil("_jspInit(config);");
        this.out.printil("jspContext.getELContext().putContext(jakarta.servlet.jsp.JspContext.class,jspContext);");
        this.generatePageScopedVariables(jasperTagInfo);
        this.declareTemporaryScriptingVars(nodes);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
    }

    private void generateTagHandlerPostamble(TagInfo tagInfo) {
        this.out.popIndent();
        this.out.printil("} catch( java.lang.Throwable t ) {");
        this.out.pushIndent();
        this.out.printil("if( t instanceof jakarta.servlet.jsp.SkipPageException )");
        this.out.printil("    throw (jakarta.servlet.jsp.SkipPageException) t;");
        this.out.printil("if( t instanceof java.io.IOException )");
        this.out.printil("    throw (java.io.IOException) t;");
        this.out.printil("if( t instanceof java.lang.IllegalStateException )");
        this.out.printil("    throw (java.lang.IllegalStateException) t;");
        this.out.printil("if( t instanceof jakarta.servlet.jsp.JspException )");
        this.out.printil("    throw (jakarta.servlet.jsp.JspException) t;");
        this.out.printil("throw new jakarta.servlet.jsp.JspException(t);");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
        for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
            if (!tagAttributeInfoArray[i].isDeferredMethod() && !tagAttributeInfoArray[i].isDeferredValue()) continue;
            this.out.printin("_el_variablemapper.setVariable(");
            this.out.print(Generator.quote(tagAttributeInfoArray[i].getName()));
            this.out.print(",_el_ve");
            this.out.print(i);
            this.out.println(");");
        }
        this.out.printil("jspContext.getELContext().putContext(jakarta.servlet.jsp.JspContext.class,super.getJspContext());");
        this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) jspContext).syncEndTagFile();");
        if (this.isPoolingEnabled && !this.tagHandlerPoolNames.isEmpty()) {
            this.out.printil("_jspDestroy();");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.genCommonPostamble();
    }

    private void generateTagHandlerAttributes(TagInfo tagInfo) {
        TagAttributeInfo[] tagAttributeInfoArray;
        if (tagInfo.hasDynamicAttributes()) {
            this.out.printil("private java.util.HashMap _jspx_dynamic_attrs = new java.util.HashMap();");
        }
        for (TagAttributeInfo tagAttributeInfo : tagAttributeInfoArray = tagInfo.getAttributes()) {
            this.out.printin("private ");
            if (tagAttributeInfo.isFragment()) {
                this.out.print("jakarta.servlet.jsp.tagext.JspFragment ");
            } else {
                this.out.print(JspUtil.toJavaSourceType(tagAttributeInfo.getTypeName()));
                this.out.print(" ");
            }
            this.out.print(JspUtil.makeJavaIdentifierForAttribute(tagAttributeInfo.getName()));
            this.out.println(";");
        }
        this.out.println();
        for (TagAttributeInfo tagAttributeInfo : tagAttributeInfoArray) {
            String string = JspUtil.makeJavaIdentifierForAttribute(tagAttributeInfo.getName());
            this.out.printin("public ");
            if (tagAttributeInfo.isFragment()) {
                this.out.print("jakarta.servlet.jsp.tagext.JspFragment ");
            } else {
                this.out.print(JspUtil.toJavaSourceType(tagAttributeInfo.getTypeName()));
                this.out.print(" ");
            }
            this.out.print(this.toGetterMethod(tagAttributeInfo.getName()));
            this.out.println(" {");
            this.out.pushIndent();
            this.out.printin("return this.");
            this.out.print(string);
            this.out.println(";");
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
            this.out.printin("public void ");
            this.out.print(this.toSetterMethodName(tagAttributeInfo.getName()));
            if (tagAttributeInfo.isFragment()) {
                this.out.print("(jakarta.servlet.jsp.tagext.JspFragment ");
            } else {
                this.out.print("(");
                this.out.print(JspUtil.toJavaSourceType(tagAttributeInfo.getTypeName()));
                this.out.print(" ");
            }
            this.out.print(string);
            this.out.println(") {");
            this.out.pushIndent();
            this.out.printin("this.");
            this.out.print(string);
            this.out.print(" = ");
            this.out.print(string);
            this.out.println(";");
            this.out.printin("jspContext.setAttribute(\"");
            this.out.print(tagAttributeInfo.getName());
            this.out.print("\", ");
            this.out.print(string);
            this.out.println(");");
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
    }

    private void generateSetJspContext(TagInfo tagInfo) {
        TagVariableInfo[] tagVariableInfoArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (TagVariableInfo tagVariableInfo : tagVariableInfoArray = tagInfo.getTagVariableInfos()) {
            if (tagVariableInfo.getNameFromAttribute() == null) continue;
            bl4 = true;
            break;
        }
        if (bl4) {
            this.out.printil("public void setJspContext(jakarta.servlet.jsp.JspContext ctx, java.util.Map aliasMap) {");
        } else {
            this.out.printil("public void setJspContext(jakarta.servlet.jsp.JspContext ctx) {");
        }
        this.out.pushIndent();
        this.out.printil("super.setJspContext(ctx);");
        this.out.printil("java.util.ArrayList _jspx_nested = null;");
        this.out.printil("java.util.ArrayList _jspx_at_begin = null;");
        this.out.printil("java.util.ArrayList _jspx_at_end = null;");
        for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
            switch (tagVariableInfo.getScope()) {
                case 0: {
                    if (!bl) {
                        this.out.printil("_jspx_nested = new java.util.ArrayList();");
                        bl = true;
                    }
                    this.out.printin("_jspx_nested.add(");
                    break;
                }
                case 1: {
                    if (!bl2) {
                        this.out.printil("_jspx_at_begin = new java.util.ArrayList();");
                        bl2 = true;
                    }
                    this.out.printin("_jspx_at_begin.add(");
                    break;
                }
                case 2: {
                    if (!bl3) {
                        this.out.printil("_jspx_at_end = new java.util.ArrayList();");
                        bl3 = true;
                    }
                    this.out.printin("_jspx_at_end.add(");
                }
            }
            this.out.print(Generator.quote(tagVariableInfo.getNameGiven()));
            this.out.println(");");
        }
        if (bl4) {
            this.out.printil("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(this, ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, aliasMap);");
        } else {
            this.out.printil("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(this, ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, null);");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public jakarta.servlet.jsp.JspContext getJspContext() {");
        this.out.pushIndent();
        this.out.printil("return this.jspContext;");
        this.out.popIndent();
        this.out.printil("}");
    }

    public void generateSetDynamicAttribute() {
        this.out.printil("public void setDynamicAttribute(java.lang.String uri, java.lang.String localName, java.lang.Object value) throws jakarta.servlet.jsp.JspException {");
        this.out.pushIndent();
        this.out.printil("if (uri == null)");
        this.out.pushIndent();
        this.out.printil("_jspx_dynamic_attrs.put(localName, value);");
        this.out.popIndent();
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePageScopedVariables(JasperTagInfo jasperTagInfo) {
        TagAttributeInfo[] tagAttributeInfoArray = jasperTagInfo.getAttributes();
        boolean bl = false;
        for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
            String string = tagAttributeInfoArray[i].getName();
            if (tagAttributeInfoArray[i].isDeferredValue() || tagAttributeInfoArray[i].isDeferredMethod()) {
                if (!bl) {
                    this.out.printil("jakarta.el.VariableMapper _el_variablemapper = jspContext.getELContext().getVariableMapper();");
                    bl = true;
                }
                this.out.printin("jakarta.el.ValueExpression _el_ve");
                this.out.print(i);
                this.out.print(" = _el_variablemapper.setVariable(");
                this.out.print(Generator.quote(string));
                this.out.print(',');
                if (tagAttributeInfoArray[i].isDeferredMethod()) {
                    this.out.print("_jsp_getExpressionFactory().createValueExpression(");
                    this.out.print(this.toGetterMethod(string));
                    this.out.print(",jakarta.el.MethodExpression.class)");
                } else {
                    this.out.print(this.toGetterMethod(string));
                }
                this.out.println(");");
                continue;
            }
            this.out.printil("if( " + this.toGetterMethod(string) + " != null ) ");
            this.out.pushIndent();
            this.out.printin("_jspx_page_context.setAttribute(");
            this.out.print(Generator.quote(string));
            this.out.print(", ");
            this.out.print(this.toGetterMethod(string));
            this.out.println(");");
            this.out.popIndent();
        }
        if (jasperTagInfo.hasDynamicAttributes()) {
            this.out.printin("_jspx_page_context.setAttribute(\"");
            this.out.print(jasperTagInfo.getDynamicAttributesMapName());
            this.out.print("\", _jspx_dynamic_attrs);");
        }
    }

    private String toGetterMethod(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return "get" + new String(cArray) + "()";
    }

    private String toSetterMethodName(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return "set" + new String(cArray);
    }

    private static class FragmentHelperClass {
        private boolean used = false;
        private List<Fragment> fragments = new ArrayList<Fragment>();
        private String className;
        private GenBuffer classBuffer = new GenBuffer();

        FragmentHelperClass(String string) {
            this.className = string;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void generatePreamble() {
            ServletWriter servletWriter = this.classBuffer.getOut();
            servletWriter.println();
            servletWriter.pushIndent();
            servletWriter.printil("private class " + this.className);
            servletWriter.printil("    extends org.apache.jasper.runtime.JspFragmentHelper");
            servletWriter.printil("{");
            servletWriter.pushIndent();
            servletWriter.printil("private jakarta.servlet.jsp.tagext.JspTag _jspx_parent;");
            servletWriter.printil("private int[] _jspx_push_body_count;");
            servletWriter.println();
            servletWriter.printil("public " + this.className + "( int discriminator, jakarta.servlet.jsp.JspContext jspContext, jakarta.servlet.jsp.tagext.JspTag _jspx_parent, int[] _jspx_push_body_count ) {");
            servletWriter.pushIndent();
            servletWriter.printil("super( discriminator, jspContext, _jspx_parent );");
            servletWriter.printil("this._jspx_parent = _jspx_parent;");
            servletWriter.printil("this._jspx_push_body_count = _jspx_push_body_count;");
            servletWriter.popIndent();
            servletWriter.printil("}");
        }

        public Fragment openFragment(Node.ChildInfoBase childInfoBase, int n) {
            Fragment fragment = new Fragment(this.fragments.size(), childInfoBase);
            this.fragments.add(fragment);
            this.used = true;
            childInfoBase.setInnerClassName(this.className);
            ServletWriter servletWriter = fragment.getGenBuffer().getOut();
            servletWriter.pushIndent();
            servletWriter.pushIndent();
            if (n > 0) {
                servletWriter.printin("public boolean invoke");
            } else {
                servletWriter.printin("public void invoke");
            }
            servletWriter.println(fragment.getId() + "( jakarta.servlet.jsp.JspWriter out ) ");
            servletWriter.pushIndent();
            servletWriter.printil("throws java.lang.Throwable");
            servletWriter.popIndent();
            servletWriter.printil("{");
            servletWriter.pushIndent();
            Generator.generateLocalVariables(servletWriter, childInfoBase);
            return fragment;
        }

        public void closeFragment(Fragment fragment, int n) {
            ServletWriter servletWriter = fragment.getGenBuffer().getOut();
            if (n > 0) {
                servletWriter.printil("return false;");
            } else {
                servletWriter.printil("return;");
            }
            servletWriter.popIndent();
            servletWriter.printil("}");
        }

        public void generatePostamble() {
            ServletWriter servletWriter = this.classBuffer.getOut();
            for (Fragment fragment : this.fragments) {
                fragment.getGenBuffer().adjustJavaLines(servletWriter.getJavaLine() - 1);
                servletWriter.printMultiLn(fragment.getGenBuffer().toString());
            }
            servletWriter.printil("public void invoke( java.io.Writer writer )");
            servletWriter.pushIndent();
            servletWriter.printil("throws jakarta.servlet.jsp.JspException");
            servletWriter.popIndent();
            servletWriter.printil("{");
            servletWriter.pushIndent();
            servletWriter.printil("jakarta.servlet.jsp.JspWriter out = null;");
            servletWriter.printil("if( writer != null ) {");
            servletWriter.pushIndent();
            servletWriter.printil("out = this.jspContext.pushBody(writer);");
            servletWriter.popIndent();
            servletWriter.printil("} else {");
            servletWriter.pushIndent();
            servletWriter.printil("out = this.jspContext.getOut();");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.printil("try {");
            servletWriter.pushIndent();
            servletWriter.printil("Object _jspx_saved_JspContext = this.jspContext.getELContext().getContext(jakarta.servlet.jsp.JspContext.class);");
            servletWriter.printil("this.jspContext.getELContext().putContext(jakarta.servlet.jsp.JspContext.class,this.jspContext);");
            servletWriter.printil("switch( this.discriminator ) {");
            servletWriter.pushIndent();
            for (int i = 0; i < this.fragments.size(); ++i) {
                servletWriter.printil("case " + i + ":");
                servletWriter.pushIndent();
                servletWriter.printil("invoke" + i + "( out );");
                servletWriter.printil("break;");
                servletWriter.popIndent();
            }
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.printil("jspContext.getELContext().putContext(jakarta.servlet.jsp.JspContext.class,_jspx_saved_JspContext);");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.printil("catch( java.lang.Throwable e ) {");
            servletWriter.pushIndent();
            servletWriter.printil("if (e instanceof jakarta.servlet.jsp.SkipPageException)");
            servletWriter.printil("    throw (jakarta.servlet.jsp.SkipPageException) e;");
            servletWriter.printil("throw new jakarta.servlet.jsp.JspException( e );");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.printil("finally {");
            servletWriter.pushIndent();
            servletWriter.printil("if( writer != null ) {");
            servletWriter.pushIndent();
            servletWriter.printil("this.jspContext.popBody();");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.popIndent();
            servletWriter.printil("}");
            servletWriter.popIndent();
        }

        public String toString() {
            return this.classBuffer.toString();
        }

        public void adjustJavaLines(int n) {
            for (Fragment fragment : this.fragments) {
                fragment.getGenBuffer().adjustJavaLines(n);
            }
        }

        private static class Fragment {
            private GenBuffer genBuffer;
            private int id;

            Fragment(int n, Node node) {
                this.id = n;
                this.genBuffer = new GenBuffer(null, node.getBody());
            }

            public GenBuffer getGenBuffer() {
                return this.genBuffer;
            }

            public int getId() {
                return this.id;
            }
        }
    }

    private static class GenBuffer {
        private Node node;
        private Node.Nodes body;
        private CharArrayWriter charWriter;
        protected ServletWriter out;

        GenBuffer() {
            this(null, null);
        }

        GenBuffer(Node node, Node.Nodes nodes) {
            this.node = node;
            this.body = nodes;
            if (this.body != null) {
                this.body.setGeneratedInBuffer(true);
            }
            this.charWriter = new CharArrayWriter();
            this.out = new ServletWriter(new PrintWriter(this.charWriter));
        }

        public ServletWriter getOut() {
            return this.out;
        }

        public String toString() {
            return this.charWriter.toString();
        }

        public void adjustJavaLines(final int n) {
            if (this.node != null) {
                GenBuffer.adjustJavaLine(this.node, n);
            }
            if (this.body != null) {
                try {
                    this.body.visit(new Node.Visitor(){

                        @Override
                        public void doVisit(Node node) {
                            GenBuffer.adjustJavaLine(node, n);
                        }

                        @Override
                        public void visit(Node.CustomTag customTag) throws JasperException {
                            Node.Nodes nodes = customTag.getBody();
                            if (nodes != null && !nodes.isGeneratedInBuffer()) {
                                nodes.visit(this);
                            }
                        }
                    });
                }
                catch (JasperException jasperException) {
                    // empty catch block
                }
            }
        }

        private static void adjustJavaLine(Node node, int n) {
            if (node.getBeginJavaLine() > 0) {
                node.setBeginJavaLine(node.getBeginJavaLine() + n);
                node.setEndJavaLine(node.getEndJavaLine() + n);
            }
        }
    }

    private static class TagHandlerInfo {
        private Map<String, Method> methodMaps;
        private Map<String, Class<?>> propertyEditorMaps;
        private Class<?> tagHandlerClass;

        TagHandlerInfo(Node node, Class<?> clazz, ErrorDispatcher errorDispatcher) throws JasperException {
            this.tagHandlerClass = clazz;
            this.methodMaps = new HashMap<String, Method>();
            this.propertyEditorMaps = new HashMap();
            try {
                PropertyDescriptor[] propertyDescriptorArray;
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                    if (propertyDescriptor.getWriteMethod() != null) {
                        this.methodMaps.put(propertyDescriptor.getName(), propertyDescriptor.getWriteMethod());
                    }
                    if (propertyDescriptor.getPropertyEditorClass() == null) continue;
                    this.propertyEditorMaps.put(propertyDescriptor.getName(), propertyDescriptor.getPropertyEditorClass());
                }
            }
            catch (IntrospectionException introspectionException) {
                errorDispatcher.jspError(node, (Exception)introspectionException, "jsp.error.introspect.taghandler", clazz.getName());
            }
        }

        public Method getSetterMethod(String string) {
            return this.methodMaps.get(string);
        }

        public Class<?> getPropertyEditorClass(String string) {
            return this.propertyEditorMaps.get(string);
        }

        public Class<?> getTagHandlerClass() {
            return this.tagHandlerClass;
        }
    }

    private class GenerateVisitor
    extends Node.Visitor {
        private final Map<String, Map<String, TagHandlerInfo>> handlerInfos;
        private final Map<String, Integer> tagVarNumbers;
        private String parent;
        private boolean isSimpleTagParent;
        private String pushBodyCountVar;
        private String simpleTagHandlerVar;
        private boolean isSimpleTagHandler;
        private boolean isFragment;
        private final boolean isTagFile;
        private ServletWriter out;
        private final ArrayList<GenBuffer> methodsBuffered;
        private final FragmentHelperClass fragmentHelperClass;
        private int methodNesting;
        private int charArrayCount;
        private HashMap<String, String> textMap;
        private final boolean useInstanceManagerForTags;
        private static final String DOUBLE_QUOTE = "\\\"";

        GenerateVisitor(boolean bl, ServletWriter servletWriter, ArrayList<GenBuffer> arrayList, FragmentHelperClass fragmentHelperClass, boolean bl2) {
            this.isTagFile = bl;
            this.out = servletWriter;
            this.methodsBuffered = arrayList;
            this.fragmentHelperClass = fragmentHelperClass;
            this.useInstanceManagerForTags = bl2;
            this.methodNesting = 0;
            this.handlerInfos = new HashMap<String, Map<String, TagHandlerInfo>>();
            this.tagVarNumbers = new HashMap<String, Integer>();
            this.textMap = new HashMap();
        }

        private String attributeValue(Node.JspAttribute jspAttribute, boolean bl, Class<?> clazz) {
            String string = jspAttribute.getValue();
            if (jspAttribute.isExpression()) {
                if (bl) {
                    return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(String.valueOf(" + string + "), request.getCharacterEncoding())";
                }
                return string;
            }
            if (jspAttribute.isELInterpreterInput()) {
                string = Generator.this.elInterpreter.interpreterCall(Generator.this.ctxt, this.isTagFile, string, clazz, jspAttribute.getEL().getMapName());
                if (bl) {
                    return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + string + ", request.getCharacterEncoding())";
                }
                return string;
            }
            if (jspAttribute.isNamedAttribute()) {
                return jspAttribute.getNamedAttributeNode().getTemporaryVariableName();
            }
            if (bl) {
                return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + Generator.quote(string) + ", request.getCharacterEncoding())";
            }
            return Generator.quote(string);
        }

        private void printParams(Node node, String string, boolean bl) throws JasperException {
            Object object = bl ? (string.indexOf(63) > 0 ? "\"&\"" : "\"?\"") : "((" + string + ").indexOf('?')>0? '&': '?')";
            if (node.getBody() != null) {
                class ParamVisitor
                extends Node.Visitor {
                    private String separator;

                    ParamVisitor(String string) {
                        this.separator = string;
                    }

                    @Override
                    public void visit(Node.ParamAction paramAction) throws JasperException {
                        GenerateVisitor.this.out.print(" + ");
                        GenerateVisitor.this.out.print(this.separator);
                        GenerateVisitor.this.out.print(" + ");
                        GenerateVisitor.this.out.print("org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + Generator.quote(paramAction.getTextAttribute("name")) + ", request.getCharacterEncoding())");
                        GenerateVisitor.this.out.print("+ \"=\" + ");
                        GenerateVisitor.this.out.print(GenerateVisitor.this.attributeValue(paramAction.getValue(), true, String.class));
                        this.separator = "\"&\"";
                    }
                }
                node.getBody().visit(new ParamVisitor((String)object));
            }
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            expression.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("out.print(");
            this.out.printMultiLn(expression.getText());
            this.out.println(");");
            expression.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            scriptlet.setBeginJavaLine(this.out.getJavaLine());
            this.out.printMultiLn(scriptlet.getText());
            this.out.println();
            scriptlet.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            eLExpression.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("out.write(" + Generator.this.elInterpreter.interpreterCall(Generator.this.ctxt, this.isTagFile, eLExpression.getType() + "{" + eLExpression.getText() + "}", String.class, eLExpression.getEL().getMapName()) + ");");
            eLExpression.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            String string = includeAction.getTextAttribute("flush");
            Node.JspAttribute jspAttribute = includeAction.getPage();
            boolean bl = "true".equals(string);
            includeAction.setBeginJavaLine(this.out.getJavaLine());
            String string2 = jspAttribute.isNamedAttribute() ? this.generateNamedAttributeValue(jspAttribute.getNamedAttributeNode()) : this.attributeValue(jspAttribute, false, String.class);
            Node.JspBody jspBody = this.findJspBody(includeAction);
            if (jspBody != null) {
                this.prepareParams(jspBody);
            } else {
                this.prepareParams(includeAction);
            }
            this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, " + string2);
            this.printParams(includeAction, string2, jspAttribute.isLiteral());
            this.out.println(", out, " + bl + ");");
            includeAction.setEndJavaLine(this.out.getJavaLine());
        }

        private void prepareParams(Node node) throws JasperException {
            Node.Nodes nodes = node.getBody();
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); ++i) {
                    Node node2 = nodes.getNode(i);
                    Node.Nodes nodes2 = node2.getBody();
                    for (int j = 0; nodes2 != null && j < nodes2.size(); ++j) {
                        Node node3 = nodes2.getNode(j);
                        if (!(node3 instanceof Node.NamedAttribute)) continue;
                        this.generateNamedAttributeValue((Node.NamedAttribute)node3);
                    }
                }
            }
        }

        private Node.JspBody findJspBody(Node node) {
            Node.JspBody jspBody = null;
            Node.Nodes nodes = node.getBody();
            for (int i = 0; nodes != null && i < nodes.size(); ++i) {
                Node node2 = nodes.getNode(i);
                if (!(node2 instanceof Node.JspBody)) continue;
                jspBody = (Node.JspBody)node2;
                break;
            }
            return jspBody;
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            Node.JspAttribute jspAttribute = forwardAction.getPage();
            forwardAction.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("if (true) {");
            this.out.pushIndent();
            String string = jspAttribute.isNamedAttribute() ? this.generateNamedAttributeValue(jspAttribute.getNamedAttributeNode()) : this.attributeValue(jspAttribute, false, String.class);
            Node.JspBody jspBody = this.findJspBody(forwardAction);
            if (jspBody != null) {
                this.prepareParams(jspBody);
            } else {
                this.prepareParams(forwardAction);
            }
            this.out.printin("_jspx_page_context.forward(");
            this.out.print(string);
            this.printParams(forwardAction, string, jspAttribute.isLiteral());
            this.out.println(");");
            if (this.isTagFile || this.isFragment) {
                this.out.printil("throw new jakarta.servlet.jsp.SkipPageException();");
            } else {
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            }
            this.out.popIndent();
            this.out.printil("}");
            forwardAction.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.GetProperty getProperty) throws JasperException {
            String string = getProperty.getTextAttribute("name");
            String string2 = getProperty.getTextAttribute("property");
            getProperty.setBeginJavaLine(this.out.getJavaLine());
            if (Generator.this.beanInfo.checkVariable(string)) {
                Class<?> clazz = Generator.this.beanInfo.getBeanType(string);
                String string3 = clazz.getCanonicalName();
                Method method = JspRuntimeLibrary.getReadMethod(clazz, string2);
                String string4 = method.getName();
                this.out.printil("out.write(org.apache.jasper.runtime.JspRuntimeLibrary.toString((((" + string3 + ")_jspx_page_context.findAttribute(\"" + string + "\"))." + string4 + "())));");
            } else if (!Generator.this.ctxt.getOptions().getStrictGetProperty() || Generator.this.varInfoNames.contains(string)) {
                this.out.printil("out.write(org.apache.jasper.runtime.JspRuntimeLibrary.toString(org.apache.jasper.runtime.JspRuntimeLibrary.handleGetProperty(_jspx_page_context.findAttribute(\"" + string + "\"), \"" + string2 + "\")));");
            } else {
                throw new JasperException(Localizer.getMessage("jsp.error.invalid.name", getProperty.getStart(), string));
            }
            getProperty.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            String string = setProperty.getTextAttribute("name");
            String string2 = setProperty.getTextAttribute("property");
            String string3 = setProperty.getTextAttribute("param");
            Node.JspAttribute jspAttribute = setProperty.getValue();
            setProperty.setBeginJavaLine(this.out.getJavaLine());
            if ("*".equals(string2)) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspect(_jspx_page_context.findAttribute(\"" + string + "\"), request);");
            } else if (jspAttribute == null) {
                if (string3 == null) {
                    string3 = string2;
                }
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(_jspx_page_context.findAttribute(\"" + string + "\"), \"" + string2 + "\", request.getParameter(\"" + string3 + "\"), request, \"" + string3 + "\", false);");
            } else if (jspAttribute.isExpression()) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.handleSetProperty(_jspx_page_context.findAttribute(\"" + string + "\"), \"" + string2 + "\",");
                this.out.print(this.attributeValue(jspAttribute, false, null));
                this.out.println(");");
            } else if (jspAttribute.isELInterpreterInput()) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.handleSetPropertyExpression(_jspx_page_context.findAttribute(\"" + string + "\"), \"" + string2 + "\", " + Generator.quote(jspAttribute.getValue()) + ", _jspx_page_context, " + jspAttribute.getEL().getMapName() + ");");
            } else if (jspAttribute.isNamedAttribute()) {
                String string4 = this.generateNamedAttributeValue(jspAttribute.getNamedAttributeNode());
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(_jspx_page_context.findAttribute(\"" + string + "\"), \"" + string2 + "\", " + string4 + ", null, null, false);");
            } else {
                this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(_jspx_page_context.findAttribute(\"" + string + "\"), \"" + string2 + "\", ");
                this.out.print(this.attributeValue(jspAttribute, false, null));
                this.out.println(", null, null, false);");
            }
            setProperty.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            Object object;
            Object object2;
            String string = useBean.getTextAttribute("id");
            String string2 = useBean.getTextAttribute("scope");
            String string3 = useBean.getTextAttribute("class");
            String string4 = useBean.getTextAttribute("type");
            Node.JspAttribute jspAttribute = useBean.getBeanName();
            boolean bl = false;
            String string5 = null;
            if (string3 != null) {
                block17: {
                    try {
                        object2 = Generator.this.ctxt.getClassLoader().loadClass(string3);
                        string5 = string3.indexOf(36) >= 0 ? ((Class)object2).getCanonicalName() : string3;
                        object = ((Class)object2).getConstructor(new Class[0]);
                        int n = ((Class)object2).getModifiers();
                        if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || !((AccessibleObject)object).canAccess(null)) {
                            throw new JasperException(Localizer.getMessage("jsp.error.invalid.bean", n));
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        if (Generator.this.ctxt.getOptions().getErrorOnUseBeanInvalidClassAttribute()) {
                            Generator.this.err.jspError((Node)useBean, "jsp.error.invalid.bean", string3);
                        }
                        if (string5 != null) break block17;
                        string5 = string3.replace('$', '.');
                    }
                }
                if (string4 == null) {
                    string4 = string5;
                }
            }
            object2 = "jakarta.servlet.jsp.PageContext.PAGE_SCOPE";
            object = null;
            if ("request".equals(string2)) {
                object2 = "jakarta.servlet.jsp.PageContext.REQUEST_SCOPE";
            } else if ("session".equals(string2)) {
                object2 = "jakarta.servlet.jsp.PageContext.SESSION_SCOPE";
                object = "session";
            } else if ("application".equals(string2)) {
                object2 = "jakarta.servlet.jsp.PageContext.APPLICATION_SCOPE";
                object = "application";
            }
            useBean.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin(string4);
            this.out.print(' ');
            this.out.print(string);
            this.out.println(" = null;");
            if (object != null) {
                this.out.printin("synchronized (");
                this.out.print((String)object);
                this.out.println(") {");
                this.out.pushIndent();
            }
            this.out.printin(string);
            this.out.print(" = (");
            this.out.print(string4);
            this.out.print(") _jspx_page_context.getAttribute(");
            this.out.print(Generator.quote(string));
            this.out.print(", ");
            this.out.print((String)object2);
            this.out.println(");");
            this.out.printin("if (");
            this.out.print(string);
            this.out.println(" == null){");
            this.out.pushIndent();
            if (string3 == null && jspAttribute == null) {
                this.out.printin("throw new java.lang.InstantiationException(\"bean ");
                this.out.print(string);
                this.out.println(" not found within scope\");");
            } else {
                if (!bl) {
                    String string6 = jspAttribute != null ? (jspAttribute.isNamedAttribute() ? this.generateNamedAttributeValue(jspAttribute.getNamedAttributeNode()) : this.attributeValue(jspAttribute, false, String.class)) : Generator.quote(string3);
                    this.out.printil("try {");
                    this.out.pushIndent();
                    this.out.printin(string);
                    this.out.print(" = (");
                    this.out.print(string4);
                    this.out.print(") java.beans.Beans.instantiate(");
                    this.out.print("this.getClass().getClassLoader(), ");
                    this.out.print(string6);
                    this.out.println(");");
                    this.out.popIndent();
                    this.out.printil("} catch (java.lang.ClassNotFoundException exc) {");
                    this.out.pushIndent();
                    this.out.printil("throw new InstantiationException(exc.getMessage());");
                    this.out.popIndent();
                    this.out.printil("} catch (java.lang.Exception exc) {");
                    this.out.pushIndent();
                    this.out.printin("throw new jakarta.servlet.ServletException(");
                    this.out.print("\"Cannot create bean of class \" + ");
                    this.out.print(string6);
                    this.out.println(", exc);");
                    this.out.popIndent();
                    this.out.printil("}");
                } else {
                    this.out.printin(string);
                    this.out.print(" = new ");
                    this.out.print(string5);
                    this.out.println("();");
                }
                this.out.printin("_jspx_page_context.setAttribute(");
                this.out.print(Generator.quote(string));
                this.out.print(", ");
                this.out.print(string);
                this.out.print(", ");
                this.out.print((String)object2);
                this.out.println(");");
                this.visitBody(useBean);
            }
            this.out.popIndent();
            this.out.printil("}");
            if (object != null) {
                this.out.popIndent();
                this.out.printil("}");
            }
            useBean.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            plugIn.setBeginJavaLine(this.out.getJavaLine());
            plugIn.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            int n;
            Object object;
            Object object2;
            if (customTag.useTagPlugin()) {
                this.generateTagPlugin(customTag);
                return;
            }
            TagHandlerInfo tagHandlerInfo = this.getTagHandlerInfo(customTag);
            String string = this.createTagVarName(customTag.getQName(), customTag.getPrefix(), customTag.getLocalName());
            String string2 = "_jspx_eval_" + string;
            String string3 = "_jspx_th_" + string;
            String string4 = "_jspx_push_body_count_" + string;
            ServletWriter servletWriter = null;
            Node.ChildInfo childInfo = customTag.getChildInfo();
            if (childInfo.isScriptless() && !childInfo.hasScriptingVars()) {
                object2 = "_jspx_meth_" + string;
                this.out.printin("if (");
                this.out.print((String)object2);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("_jspx_page_context");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println("))");
                this.out.pushIndent();
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
                this.out.popIndent();
                servletWriter = this.out;
                object = new GenBuffer(customTag, customTag.implementsSimpleTag() ? null : customTag.getBody());
                this.methodsBuffered.add((GenBuffer)object);
                this.out = ((GenBuffer)object).getOut();
                ++this.methodNesting;
                this.out.println();
                this.out.pushIndent();
                this.out.printin("private boolean ");
                this.out.print((String)object2);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print("jakarta.servlet.jsp.tagext.JspTag ");
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("jakarta.servlet.jsp.PageContext _jspx_page_context");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", int[] ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println(")");
                this.out.printil("        throws java.lang.Throwable {");
                this.out.pushIndent();
                if (!this.isTagFile) {
                    this.out.printil("jakarta.servlet.jsp.PageContext pageContext = _jspx_page_context;");
                }
                if (!customTag.hasEmptyBody() || customTag.implementsTryCatchFinally() || customTag.getNamedAttributeNodes().size() > 0) {
                    this.out.printil("jakarta.servlet.jsp.JspWriter out = _jspx_page_context.getOut();");
                }
                Generator.generateLocalVariables(this.out, customTag);
            }
            if (((VariableInfo[])(object2 = customTag.getVariableInfos())).length > 0) {
                object = object2;
                int n2 = ((VariableInfo[])object).length;
                for (n = 0; n < n2; ++n) {
                    VariableInfo variableInfo = object[n];
                    Generator.this.pageInfo.getVarInfoNames().add(variableInfo.getVarName());
                }
            }
            if (((VariableInfo[])(object = customTag.getTagVariableInfos())).length > 0) {
                for (VariableInfo variableInfo : object) {
                    String string5 = variableInfo.getNameGiven();
                    if (string5 == null) {
                        String string6 = variableInfo.getNameFromAttribute();
                        string5 = customTag.getAttributeValue(string6);
                    }
                    Generator.this.pageInfo.getVarInfoNames().add(string5);
                }
            }
            if (customTag.implementsSimpleTag()) {
                this.generateCustomDoTag(customTag, tagHandlerInfo, string3);
            } else {
                this.generateCustomStart(customTag, tagHandlerInfo, string3, string2, string4);
                String string7 = this.parent;
                this.parent = string3;
                n = this.isSimpleTagParent ? 1 : 0;
                this.isSimpleTagParent = false;
                String string8 = null;
                if (customTag.implementsTryCatchFinally()) {
                    string8 = this.pushBodyCountVar;
                    this.pushBodyCountVar = string4;
                }
                boolean bl = this.isSimpleTagHandler;
                this.isSimpleTagHandler = false;
                this.visitBody(customTag);
                this.parent = string7;
                this.isSimpleTagParent = n;
                if (customTag.implementsTryCatchFinally()) {
                    this.pushBodyCountVar = string8;
                }
                this.isSimpleTagHandler = bl;
                this.generateCustomEnd(customTag, string3, string2, string4);
            }
            if (childInfo.isScriptless() && !childInfo.hasScriptingVars()) {
                this.out.printil("return false;");
                this.out.popIndent();
                this.out.printil("}");
                this.out.popIndent();
                --this.methodNesting;
                this.out = servletWriter;
            }
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            uninterpretedTag.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("out.write(\"<");
            this.out.print(uninterpretedTag.getQName());
            Attributes attributes = uninterpretedTag.getNonTaglibXmlnsAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.out.print(" ");
                    this.out.print(attributes.getQName(i));
                    this.out.print("=");
                    this.out.print(DOUBLE_QUOTE);
                    this.out.print(Generator.escape(attributes.getValue(i).replace("\"", "&quot;")));
                    this.out.print(DOUBLE_QUOTE);
                }
            }
            if ((attributes = uninterpretedTag.getAttributes()) != null) {
                Node.JspAttribute[] jspAttributeArray = uninterpretedTag.getJspAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.out.print(" ");
                    this.out.print(attributes.getQName(i));
                    this.out.print("=");
                    if (jspAttributeArray[i].isELInterpreterInput()) {
                        this.out.print("\\\"\" + ");
                        String string = this.attributeValue(jspAttributeArray[i], false, String.class);
                        this.out.print(string);
                        this.out.print(" + \"\\\"");
                        continue;
                    }
                    this.out.print(DOUBLE_QUOTE);
                    this.out.print(Generator.escape(jspAttributeArray[i].getValue().replace("\"", "&quot;")));
                    this.out.print(DOUBLE_QUOTE);
                }
            }
            if (uninterpretedTag.getBody() != null) {
                this.out.println(">\");");
                this.visitBody(uninterpretedTag);
                this.out.printin("out.write(\"</");
                this.out.print(uninterpretedTag.getQName());
                this.out.println(">\");");
            } else {
                this.out.println("/>\");");
            }
            uninterpretedTag.setEndJavaLine(this.out.getJavaLine());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            Object object;
            jspElement.setBeginJavaLine(this.out.getJavaLine());
            HashMap<String, void> hashMap = new HashMap<String, void>();
            Node.JspAttribute[] jspAttributeArray = jspElement.getJspAttributes();
            for (int i = 0; i < jspAttributeArray.length; ++i) {
                void var6_14;
                Object object3 = null;
                Object var6_9 = null;
                if (jspAttributeArray[i].isNamedAttribute()) {
                    String string;
                    Node.NamedAttribute namedAttribute = jspAttributeArray[i].getNamedAttributeNode();
                    object = namedAttribute.getOmit();
                    if (object == null) {
                        string = "false";
                    } else {
                        string = this.attributeValue((Node.JspAttribute)object, false, Boolean.TYPE);
                        if ("\"true\"".equals(string)) continue;
                    }
                    object3 = this.generateNamedAttributeValue(jspAttributeArray[i].getNamedAttributeNode());
                    if ("\"false\"".equals(string)) {
                        String string2 = " + \" " + jspAttributeArray[i].getName() + "=\\\"\" + " + (String)object3 + " + \"\\\"\"";
                    } else {
                        String string3 = " + (java.lang.Boolean.valueOf(" + string + ")?\"\":\" " + jspAttributeArray[i].getName() + "=\\\"\" + " + (String)object3 + " + \"\\\"\")";
                    }
                } else {
                    object3 = this.attributeValue(jspAttributeArray[i], false, Object.class);
                    String string = " + \" " + jspAttributeArray[i].getName() + "=\\\"\" + " + (String)object3 + " + \"\\\"\"";
                }
                hashMap.put(jspAttributeArray[i].getName(), var6_14);
            }
            String string = this.attributeValue(jspElement.getNameAttribute(), false, String.class);
            this.out.printin("out.write(\"<\"");
            this.out.print(" + " + string);
            for (Map.Entry entry : hashMap.entrySet()) {
                this.out.print((String)entry.getValue());
            }
            boolean bl = false;
            Node.Nodes nodes = jspElement.getBody();
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); ++i) {
                    object = nodes.getNode(i);
                    if (object instanceof Node.NamedAttribute) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.out.println(" + \">\");");
                jspElement.setEndJavaLine(this.out.getJavaLine());
                this.visitBody(jspElement);
                this.out.printin("out.write(\"</\"");
                this.out.print(" + " + string);
                this.out.println(" + \">\");");
            } else {
                this.out.println(" + \"/>\");");
                jspElement.setEndJavaLine(this.out.getJavaLine());
            }
        }

        @Override
        public void visit(Node.TemplateText templateText) throws JasperException {
            int n;
            Object object;
            Matcher matcher;
            String string = templateText.getText();
            if (Generator.this.ctxt.getOptions().getTrimSpaces().equals((Object)TrimSpacesOption.EXTENDED) && string.contains("\n") && !(matcher = PRE_TAG_PATTERN.matcher(string)).matches()) {
                object = BLANK_LINE_PATTERN.matcher(string);
                String string2 = ((Matcher)object).replaceAll("\n");
                string = string2.trim();
            }
            if ((n = string.length()) == 0) {
                return;
            }
            if (n <= 3) {
                templateText.setBeginJavaLine(this.out.getJavaLine());
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    this.out.printil("out.write(" + Generator.quote(c) + ");");
                    if (i > 0) {
                        templateText.addSmap(n2);
                    }
                    if (c != '\n') continue;
                    ++n2;
                }
                templateText.setEndJavaLine(this.out.getJavaLine());
                return;
            }
            if (Generator.this.ctxt.getOptions().genStringAsCharArray()) {
                int n3;
                if (Generator.this.charArrayBuffer == null) {
                    Generator.this.charArrayBuffer = new GenBuffer();
                    object = Generator.this.charArrayBuffer.getOut();
                    ((ServletWriter)object).pushIndent();
                    this.textMap = new HashMap();
                } else {
                    object = Generator.this.charArrayBuffer.getOut();
                }
                int n4 = string.length();
                for (int i = 0; i < n4; i += n3) {
                    n3 = 0;
                    n3 = n4 - i > 16384 ? 16384 : n4 - i;
                    String string3 = string.substring(i, i + n3);
                    Object object2 = this.textMap.get(string3);
                    if (object2 == null) {
                        object2 = "_jspx_char_array_" + this.charArrayCount++;
                        this.textMap.put(string3, (String)object2);
                        ((ServletWriter)object).printin("static char[] ");
                        ((ServletWriter)object).print((String)object2);
                        ((ServletWriter)object).print(" = ");
                        ((ServletWriter)object).print(Generator.quote(string3));
                        ((ServletWriter)object).println(".toCharArray();");
                    }
                    templateText.setBeginJavaLine(this.out.getJavaLine());
                    this.out.printil("out.write(" + (String)object2 + ");");
                    templateText.setEndJavaLine(this.out.getJavaLine());
                }
                return;
            }
            templateText.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin();
            object = new StringBuilder("out.write(\"");
            int n5 = ((StringBuilder)object).length();
            int n6 = 1024;
            int n7 = 0;
            block8: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                --n6;
                switch (c) {
                    case '\"': {
                        ((StringBuilder)object).append('\\').append('\"');
                        continue block8;
                    }
                    case '\\': {
                        ((StringBuilder)object).append('\\').append('\\');
                        continue block8;
                    }
                    case '\r': {
                        ((StringBuilder)object).append('\\').append('r');
                        continue block8;
                    }
                    case '\n': {
                        ((StringBuilder)object).append('\\').append('n');
                        ++n7;
                        if (Generator.this.breakAtLF || n6 < 0) {
                            ((StringBuilder)object).append("\");");
                            this.out.println(((StringBuilder)object).toString());
                            if (i < string.length() - 1) {
                                this.out.printin();
                            }
                            ((StringBuilder)object).setLength(n5);
                            n6 = 1024;
                        }
                        templateText.addSmap(n7);
                        continue block8;
                    }
                    default: {
                        ((StringBuilder)object).append(c);
                    }
                }
            }
            if (((StringBuilder)object).length() > n5) {
                ((StringBuilder)object).append("\");");
                this.out.println(((StringBuilder)object).toString());
            }
            templateText.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            if (jspBody.getBody() != null) {
                if (this.isSimpleTagHandler) {
                    this.out.printin(this.simpleTagHandlerVar);
                    this.out.print(".setJspBody(");
                    this.generateJspFragment(jspBody, this.simpleTagHandlerVar);
                    this.out.println(");");
                } else {
                    this.visitBody(jspBody);
                }
            }
        }

        @Override
        public void visit(Node.InvokeAction invokeAction) throws JasperException {
            invokeAction.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) this.jspContext).syncBeforeInvoke();");
            String string = invokeAction.getTextAttribute("varReader");
            String string2 = invokeAction.getTextAttribute("var");
            if (string != null || string2 != null) {
                this.out.printil("_jspx_sout = new java.io.StringWriter();");
            } else {
                this.out.printil("_jspx_sout = null;");
            }
            this.out.printin("if (");
            this.out.print(Generator.this.toGetterMethod(invokeAction.getTextAttribute("fragment")));
            this.out.println(" != null) {");
            this.out.pushIndent();
            this.out.printin(Generator.this.toGetterMethod(invokeAction.getTextAttribute("fragment")));
            this.out.println(".invoke(_jspx_sout);");
            this.out.popIndent();
            this.out.printil("}");
            if (string != null || string2 != null) {
                String string3 = invokeAction.getTextAttribute("scope");
                this.out.printin("_jspx_page_context.setAttribute(");
                if (string != null) {
                    this.out.print(Generator.quote(string));
                    this.out.print(", new java.io.StringReader(_jspx_sout.toString())");
                } else {
                    this.out.print(Generator.quote(string2));
                    this.out.print(", _jspx_sout.toString()");
                }
                if (string3 != null) {
                    this.out.print(", ");
                    this.out.print(this.getScopeConstant(string3));
                }
                this.out.println(");");
            }
            invokeAction.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.DoBodyAction doBodyAction) throws JasperException {
            doBodyAction.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) this.jspContext).syncBeforeInvoke();");
            String string = doBodyAction.getTextAttribute("varReader");
            String string2 = doBodyAction.getTextAttribute("var");
            if (string != null || string2 != null) {
                this.out.printil("_jspx_sout = new java.io.StringWriter();");
            } else {
                this.out.printil("_jspx_sout = null;");
            }
            this.out.printil("if (getJspBody() != null)");
            this.out.pushIndent();
            this.out.printil("getJspBody().invoke(_jspx_sout);");
            this.out.popIndent();
            if (string != null || string2 != null) {
                String string3 = doBodyAction.getTextAttribute("scope");
                this.out.printin("_jspx_page_context.setAttribute(");
                if (string != null) {
                    this.out.print(Generator.quote(string));
                    this.out.print(", new java.io.StringReader(_jspx_sout.toString())");
                } else {
                    this.out.print(Generator.quote(string2));
                    this.out.print(", _jspx_sout.toString()");
                }
                if (string3 != null) {
                    this.out.print(", ");
                    this.out.print(this.getScopeConstant(string3));
                }
                this.out.println(");");
            }
            this.out.printil("jspContext.getELContext().putContext(jakarta.servlet.jsp.JspContext.class,getJspContext());");
            doBodyAction.setEndJavaLine(this.out.getJavaLine());
        }

        @Override
        public void visit(Node.AttributeGenerator attributeGenerator) throws JasperException {
            Node.CustomTag customTag = attributeGenerator.getTag();
            Node.JspAttribute[] jspAttributeArray = customTag.getJspAttributes();
            for (int i = 0; i < jspAttributeArray.length; ++i) {
                if (!jspAttributeArray[i].getName().equals(attributeGenerator.getName())) continue;
                this.out.print(this.evaluateAttribute(this.getTagHandlerInfo(customTag), jspAttributeArray[i], customTag, null));
                break;
            }
        }

        private TagHandlerInfo getTagHandlerInfo(Node.CustomTag customTag) throws JasperException {
            Map map = this.handlerInfos.computeIfAbsent(customTag.getPrefix(), string -> new HashMap());
            TagHandlerInfo tagHandlerInfo = (TagHandlerInfo)map.get(customTag.getLocalName());
            if (tagHandlerInfo == null) {
                tagHandlerInfo = new TagHandlerInfo(customTag, customTag.getTagHandlerClass(), Generator.this.err);
                map.put(customTag.getLocalName(), tagHandlerInfo);
            }
            return tagHandlerInfo;
        }

        private void generateTagPlugin(Node.CustomTag customTag) throws JasperException {
            customTag.getAtSTag().visit(this);
            this.visitBody(customTag);
            customTag.getAtETag().visit(this);
        }

        private void generateCustomStart(Node.CustomTag customTag, TagHandlerInfo tagHandlerInfo, String string, String string2, String string3) throws JasperException {
            Class<?> clazz = tagHandlerInfo.getTagHandlerClass();
            this.out.printin("//  ");
            this.out.println(customTag.getQName());
            customTag.setBeginJavaLine(this.out.getJavaLine());
            this.declareScriptingVars(customTag, 1);
            this.saveScriptingVars(customTag, 1);
            String string4 = clazz.getCanonicalName();
            if (Generator.this.isPoolingEnabled && !customTag.implementsJspIdConsumer()) {
                this.out.printin(string4);
                this.out.print(" ");
                this.out.print(string);
                this.out.print(" = ");
                this.out.print("(");
                this.out.print(string4);
                this.out.print(") ");
                this.out.print(customTag.getTagHandlerPoolName());
                this.out.print(".get(");
                this.out.print(string4);
                this.out.println(".class);");
                this.out.printin("boolean ");
                this.out.print(string);
                this.out.println("_reused = false;");
            } else {
                this.writeNewInstance(string, clazz);
            }
            this.out.printil("try {");
            this.out.pushIndent();
            this.generateSetters(customTag, string, tagHandlerInfo, false);
            if (customTag.implementsTryCatchFinally()) {
                this.out.printin("int[] ");
                this.out.print(string3);
                this.out.println(" = new int[] { 0 };");
                this.out.printil("try {");
                this.out.pushIndent();
            }
            this.out.printin("int ");
            this.out.print(string2);
            this.out.print(" = ");
            this.out.print(string);
            this.out.println(".doStartTag();");
            if (!customTag.implementsBodyTag()) {
                this.syncScriptingVars(customTag, 1);
            }
            if (!customTag.hasEmptyBody()) {
                this.out.printin("if (");
                this.out.print(string2);
                this.out.println(" != jakarta.servlet.jsp.tagext.Tag.SKIP_BODY) {");
                this.out.pushIndent();
                this.declareScriptingVars(customTag, 0);
                this.saveScriptingVars(customTag, 0);
                if (customTag.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(string2);
                    this.out.println(" != jakarta.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE) {");
                    this.out.pushIndent();
                    if (customTag.implementsTryCatchFinally()) {
                        this.out.printin(string3);
                        this.out.println("[0]++;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("[0]++;");
                    }
                    this.out.printin("out = org.apache.jasper.runtime.JspRuntimeLibrary.startBufferedBody(");
                    this.out.print("_jspx_page_context, ");
                    this.out.print(string);
                    this.out.println(");");
                    this.out.popIndent();
                    this.out.printil("}");
                    this.syncScriptingVars(customTag, 1);
                    this.syncScriptingVars(customTag, 0);
                } else {
                    this.syncScriptingVars(customTag, 0);
                }
                if (customTag.implementsIterationTag()) {
                    this.out.printil("do {");
                    this.out.pushIndent();
                }
            }
            customTag.setEndJavaLine(this.out.getJavaLine());
        }

        private void writeNewInstance(String string, Class<?> clazz) {
            String string2 = clazz.getCanonicalName();
            this.out.printin(string2);
            this.out.print(" ");
            this.out.print(string);
            this.out.print(" = ");
            if (this.useInstanceManagerForTags) {
                this.out.print("(");
                this.out.print(string2);
                this.out.print(")");
                this.out.print("_jsp_getInstanceManager().newInstance(\"");
                this.out.print(clazz.getName());
                this.out.println("\", this.getClass().getClassLoader());");
            } else {
                this.out.print("new ");
                this.out.print(string2);
                this.out.println("();");
                this.out.printin("_jsp_getInstanceManager().newInstance(");
                this.out.print(string);
                this.out.println(");");
            }
        }

        private void writeDestroyInstance(String string) {
            this.out.printin("_jsp_getInstanceManager().destroyInstance(");
            this.out.print(string);
            this.out.println(");");
        }

        private void generateCustomEnd(Node.CustomTag customTag, String string, String string2, String string3) {
            if (!customTag.hasEmptyBody()) {
                if (customTag.implementsIterationTag()) {
                    this.out.printin("int evalDoAfterBody = ");
                    this.out.print(string);
                    this.out.println(".doAfterBody();");
                    this.syncScriptingVars(customTag, 1);
                    this.syncScriptingVars(customTag, 0);
                    this.out.printil("if (evalDoAfterBody != jakarta.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN)");
                    this.out.pushIndent();
                    this.out.printil("break;");
                    this.out.popIndent();
                    this.out.popIndent();
                    this.out.printil("} while (true);");
                }
                this.restoreScriptingVars(customTag, 0);
                if (customTag.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(string2);
                    this.out.println(" != jakarta.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE) {");
                    this.out.pushIndent();
                    this.out.printil("out = _jspx_page_context.popBody();");
                    if (customTag.implementsTryCatchFinally()) {
                        this.out.printin(string3);
                        this.out.println("[0]--;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("[0]--;");
                    }
                    this.out.popIndent();
                    this.out.printil("}");
                }
                this.out.popIndent();
                this.out.printil("}");
            }
            this.out.printin("if (");
            this.out.print(string);
            this.out.println(".doEndTag() == jakarta.servlet.jsp.tagext.Tag.SKIP_PAGE) {");
            this.out.pushIndent();
            if (this.isTagFile || this.isFragment) {
                this.out.printil("throw new jakarta.servlet.jsp.SkipPageException();");
            } else {
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.syncScriptingVars(customTag, 1);
            if (customTag.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("} catch (java.lang.Throwable _jspx_exception) {");
                this.out.pushIndent();
                this.out.printin("while (");
                this.out.print(string3);
                this.out.println("[0]-- > 0)");
                this.out.pushIndent();
                this.out.printil("out = _jspx_page_context.popBody();");
                this.out.popIndent();
                this.out.printin(string);
                this.out.println(".doCatch(_jspx_exception);");
                this.out.popIndent();
                this.out.printil("} finally {");
                this.out.pushIndent();
                this.out.printin(string);
                this.out.println(".doFinally();");
            }
            if (customTag.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("}");
            }
            if (Generator.this.isPoolingEnabled && !customTag.implementsJspIdConsumer()) {
                this.out.printin(customTag.getTagHandlerPoolName());
                this.out.print(".reuse(");
                this.out.print(string);
                this.out.println(");");
                this.out.printin(string);
                this.out.println("_reused = true;");
            }
            this.out.popIndent();
            this.out.printil("} finally {");
            this.out.pushIndent();
            this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.releaseTag(");
            this.out.print(string);
            this.out.print(", _jsp_getInstanceManager(), ");
            if (Generator.this.isPoolingEnabled && !customTag.implementsJspIdConsumer()) {
                this.out.print(string);
                this.out.println("_reused);");
            } else {
                this.out.println("false);");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.declareScriptingVars(customTag, 2);
            this.syncScriptingVars(customTag, 2);
            this.restoreScriptingVars(customTag, 1);
        }

        private void generateCustomDoTag(Node.CustomTag customTag, TagHandlerInfo tagHandlerInfo, String string) throws JasperException {
            Class<?> clazz = tagHandlerInfo.getTagHandlerClass();
            customTag.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("//  ");
            this.out.println(customTag.getQName());
            this.declareScriptingVars(customTag, 1);
            this.saveScriptingVars(customTag, 1);
            this.declareScriptingVars(customTag, 2);
            this.writeNewInstance(string, clazz);
            this.out.printil("try {");
            this.out.pushIndent();
            this.generateSetters(customTag, string, tagHandlerInfo, true);
            if (this.findJspBody(customTag) == null) {
                if (!customTag.hasEmptyBody()) {
                    this.out.printin(string);
                    this.out.print(".setJspBody(");
                    this.generateJspFragment(customTag, string);
                    this.out.println(");");
                }
            } else {
                String string2 = this.simpleTagHandlerVar;
                this.simpleTagHandlerVar = string;
                boolean bl = this.isSimpleTagHandler;
                this.isSimpleTagHandler = true;
                this.visitBody(customTag);
                this.simpleTagHandlerVar = string2;
                this.isSimpleTagHandler = bl;
            }
            this.out.printin(string);
            this.out.println(".doTag();");
            this.restoreScriptingVars(customTag, 1);
            this.syncScriptingVars(customTag, 1);
            this.syncScriptingVars(customTag, 2);
            this.out.popIndent();
            this.out.printil("} finally {");
            this.out.pushIndent();
            this.writeDestroyInstance(string);
            this.out.popIndent();
            this.out.printil("}");
            customTag.setEndJavaLine(this.out.getJavaLine());
        }

        private void declareScriptingVars(Node.CustomTag customTag, int n) {
            if (this.isFragment) {
                return;
            }
            List<Object> list = customTag.getScriptingVars(n);
            if (list != null) {
                for (Object object : list) {
                    VariableInfo variableInfo;
                    if (object instanceof VariableInfo) {
                        variableInfo = (VariableInfo)object;
                        this.out.printin(variableInfo.getClassName());
                        this.out.print(" ");
                        this.out.print(variableInfo.getVarName());
                        this.out.println(" = null;");
                        continue;
                    }
                    variableInfo = (TagVariableInfo)object;
                    String string = variableInfo.getNameGiven();
                    if (string == null) {
                        string = customTag.getTagData().getAttributeString(variableInfo.getNameFromAttribute());
                    } else if (variableInfo.getNameFromAttribute() != null) continue;
                    this.out.printin(variableInfo.getClassName());
                    this.out.print(" ");
                    this.out.print(string);
                    this.out.println(" = null;");
                }
            }
        }

        private void saveScriptingVars(Node.CustomTag customTag, int n) {
            if (customTag.getCustomNestingLevel() == 0) {
                return;
            }
            if (this.isFragment) {
                return;
            }
            TagVariableInfo[] tagVariableInfoArray = customTag.getTagVariableInfos();
            VariableInfo[] variableInfoArray = customTag.getVariableInfos();
            if (variableInfoArray.length == 0 && tagVariableInfoArray.length == 0) {
                return;
            }
            List<Object> list = customTag.getScriptingVars(n);
            if (variableInfoArray.length > 0) {
                for (VariableInfo variableInfo : variableInfoArray) {
                    if (variableInfo.getScope() != n || list.contains(variableInfo)) continue;
                    String string = variableInfo.getVarName();
                    String string2 = "_jspx_" + string + "_" + customTag.getCustomNestingLevel();
                    this.out.printin(string2);
                    this.out.print(" = ");
                    this.out.print(string);
                    this.out.println(";");
                }
            } else {
                for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
                    if (tagVariableInfo.getScope() != n || list.contains(tagVariableInfo)) continue;
                    String string = tagVariableInfo.getNameGiven();
                    if (string == null) {
                        string = customTag.getTagData().getAttributeString(tagVariableInfo.getNameFromAttribute());
                    }
                    String string3 = "_jspx_" + string + "_" + customTag.getCustomNestingLevel();
                    this.out.printin(string3);
                    this.out.print(" = ");
                    this.out.print(string);
                    this.out.println(";");
                }
            }
        }

        private void restoreScriptingVars(Node.CustomTag customTag, int n) {
            if (customTag.getCustomNestingLevel() == 0) {
                return;
            }
            if (this.isFragment) {
                return;
            }
            TagVariableInfo[] tagVariableInfoArray = customTag.getTagVariableInfos();
            VariableInfo[] variableInfoArray = customTag.getVariableInfos();
            if (variableInfoArray.length == 0 && tagVariableInfoArray.length == 0) {
                return;
            }
            List<Object> list = customTag.getScriptingVars(n);
            if (variableInfoArray.length > 0) {
                for (VariableInfo variableInfo : variableInfoArray) {
                    if (variableInfo.getScope() != n || list.contains(variableInfo)) continue;
                    String string = variableInfo.getVarName();
                    String string2 = "_jspx_" + string + "_" + customTag.getCustomNestingLevel();
                    this.out.printin(string);
                    this.out.print(" = ");
                    this.out.print(string2);
                    this.out.println(";");
                }
            } else {
                for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
                    if (tagVariableInfo.getScope() != n || list.contains(tagVariableInfo)) continue;
                    String string = tagVariableInfo.getNameGiven();
                    if (string == null) {
                        string = customTag.getTagData().getAttributeString(tagVariableInfo.getNameFromAttribute());
                    }
                    String string3 = "_jspx_" + string + "_" + customTag.getCustomNestingLevel();
                    this.out.printin(string);
                    this.out.print(" = ");
                    this.out.print(string3);
                    this.out.println(";");
                }
            }
        }

        private void syncScriptingVars(Node.CustomTag customTag, int n) {
            if (this.isFragment) {
                return;
            }
            TagVariableInfo[] tagVariableInfoArray = customTag.getTagVariableInfos();
            VariableInfo[] variableInfoArray = customTag.getVariableInfos();
            if (variableInfoArray.length == 0 && tagVariableInfoArray.length == 0) {
                return;
            }
            if (variableInfoArray.length > 0) {
                for (VariableInfo variableInfo : variableInfoArray) {
                    if (variableInfo.getScope() != n) continue;
                    this.out.printin(variableInfo.getVarName());
                    this.out.print(" = (");
                    this.out.print(variableInfo.getClassName());
                    this.out.print(") _jspx_page_context.findAttribute(");
                    this.out.print(Generator.quote(variableInfo.getVarName()));
                    this.out.println(");");
                }
            } else {
                for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
                    if (tagVariableInfo.getScope() != n) continue;
                    String string = tagVariableInfo.getNameGiven();
                    if (string == null) {
                        string = customTag.getTagData().getAttributeString(tagVariableInfo.getNameFromAttribute());
                    } else if (tagVariableInfo.getNameFromAttribute() != null) continue;
                    this.out.printin(string);
                    this.out.print(" = (");
                    this.out.print(tagVariableInfo.getClassName());
                    this.out.print(") _jspx_page_context.findAttribute(");
                    this.out.print(Generator.quote(string));
                    this.out.println(");");
                }
            }
        }

        private String getJspContextVar() {
            if (this.isTagFile) {
                return "this.getJspContext()";
            }
            return "_jspx_page_context";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String createTagVarName(String string, String string2, String string3) {
            String string4;
            Map<String, Integer> map = this.tagVarNumbers;
            synchronized (map) {
                string4 = string2 + "_" + string3 + "_";
                if (this.tagVarNumbers.get(string) != null) {
                    Integer n = this.tagVarNumbers.get(string);
                    string4 = string4 + n;
                    this.tagVarNumbers.put(string, n + 1);
                } else {
                    this.tagVarNumbers.put(string, 1);
                    string4 = string4 + "0";
                }
            }
            return JspUtil.makeJavaIdentifier(string4);
        }

        private String evaluateAttribute(TagHandlerInfo tagHandlerInfo, Node.JspAttribute jspAttribute, Node.CustomTag customTag, String string) throws JasperException {
            String string2 = jspAttribute.getValue();
            if (string2 == null) {
                string2 = customTag.checkIfAttributeIsJspFragment(jspAttribute.getName()) ? this.generateNamedAttributeJspFragment(jspAttribute.getNamedAttributeNode(), string) : this.generateNamedAttributeValue(jspAttribute.getNamedAttributeNode());
            }
            String string3 = jspAttribute.getLocalName();
            Method method = null;
            Class<?>[] classArray = null;
            if (jspAttribute.isDynamic()) {
                classArray = OBJECT_CLASS;
            } else {
                method = tagHandlerInfo.getSetterMethod(string3);
                if (method == null) {
                    Generator.this.err.jspError((Node)customTag, "jsp.error.unable.to_find_method", jspAttribute.getName());
                }
                classArray = method.getParameterTypes();
            }
            if (!jspAttribute.isExpression()) {
                if (jspAttribute.isNamedAttribute()) {
                    if (!customTag.checkIfAttributeIsJspFragment(jspAttribute.getName()) && !jspAttribute.isDynamic()) {
                        string2 = Generator.this.stringInterpreter.convertString(classArray[0], string2, string3, tagHandlerInfo.getPropertyEditorClass(string3), true);
                    }
                } else if (jspAttribute.isELInterpreterInput()) {
                    StringBuilder stringBuilder = new StringBuilder(64);
                    TagAttributeInfo tagAttributeInfo = jspAttribute.getTagAttributeInfo();
                    stringBuilder.append(this.getJspContextVar());
                    stringBuilder.append(".getELContext()");
                    String string4 = stringBuilder.toString();
                    if (jspAttribute.getEL() != null && jspAttribute.getEL().getMapName() != null) {
                        stringBuilder.setLength(0);
                        stringBuilder.append("new org.apache.jasper.el.ELContextWrapper(");
                        stringBuilder.append(string4);
                        stringBuilder.append(',');
                        stringBuilder.append(jspAttribute.getEL().getMapName());
                        stringBuilder.append(')');
                        string4 = stringBuilder.toString();
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append(customTag.getStart().toString());
                    stringBuilder.append(" '");
                    stringBuilder.append(string2);
                    stringBuilder.append('\'');
                    String string5 = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    if (jspAttribute.isDeferredInput() || tagAttributeInfo != null && ValueExpression.class.getName().equals(tagAttributeInfo.getTypeName())) {
                        stringBuilder.append("new org.apache.jasper.el.JspValueExpression(");
                        stringBuilder.append(Generator.quote(string5));
                        stringBuilder.append(",_jsp_getExpressionFactory().createValueExpression(");
                        if (jspAttribute.getEL() != null) {
                            stringBuilder.append(string4);
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(Generator.quote(string2));
                        stringBuilder.append(',');
                        stringBuilder.append(JspUtil.toJavaSourceTypeFromTld(jspAttribute.getExpectedTypeName()));
                        stringBuilder.append("))");
                        boolean bl = false;
                        if (tagAttributeInfo.canBeRequestTime()) {
                            bl = true;
                        }
                        if (jspAttribute.isDeferredInput()) {
                            bl = false;
                        }
                        if (jspAttribute.isDeferredInput() && tagAttributeInfo.canBeRequestTime()) {
                            boolean bl2 = bl = !string2.contains("#{");
                        }
                        if (bl) {
                            stringBuilder.append(".getValue(");
                            stringBuilder.append(this.getJspContextVar());
                            stringBuilder.append(".getELContext()");
                            stringBuilder.append(')');
                        }
                        string2 = stringBuilder.toString();
                    } else if (jspAttribute.isDeferredMethodInput() || tagAttributeInfo != null && MethodExpression.class.getName().equals(tagAttributeInfo.getTypeName())) {
                        String[] stringArray;
                        stringBuilder.append("new org.apache.jasper.el.JspMethodExpression(");
                        stringBuilder.append(Generator.quote(string5));
                        stringBuilder.append(",_jsp_getExpressionFactory().createMethodExpression(");
                        stringBuilder.append(string4);
                        stringBuilder.append(',');
                        stringBuilder.append(Generator.quote(string2));
                        stringBuilder.append(',');
                        stringBuilder.append(JspUtil.toJavaSourceTypeFromTld(jspAttribute.getExpectedTypeName()));
                        stringBuilder.append(',');
                        stringBuilder.append("new java.lang.Class[] {");
                        for (String string6 : stringArray = jspAttribute.getParameterTypeNames()) {
                            stringBuilder.append(JspUtil.toJavaSourceTypeFromTld(string6));
                            stringBuilder.append(',');
                        }
                        if (stringArray.length > 0) {
                            stringBuilder.setLength(stringBuilder.length() - 1);
                        }
                        stringBuilder.append("}))");
                        string2 = stringBuilder.toString();
                    } else {
                        String string7 = jspAttribute.getEL().getMapName();
                        string2 = Generator.this.elInterpreter.interpreterCall(Generator.this.ctxt, this.isTagFile, string2, classArray[0], string7);
                    }
                } else {
                    string2 = Generator.this.stringInterpreter.convertString(classArray[0], string2, string3, tagHandlerInfo.getPropertyEditorClass(string3), false);
                }
            }
            return string2;
        }

        private String generateAliasMap(Node.CustomTag customTag, String string) {
            TagVariableInfo[] tagVariableInfoArray = customTag.getTagVariableInfos();
            String string2 = null;
            boolean bl = false;
            for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
                String string3 = tagVariableInfo.getNameFromAttribute();
                if (string3 == null) continue;
                String string4 = customTag.getAttributeValue(string3);
                if (!bl) {
                    this.out.printin("java.util.HashMap ");
                    string2 = string + "_aliasMap";
                    this.out.print(string2);
                    this.out.println(" = new java.util.HashMap();");
                    bl = true;
                }
                this.out.printin(string2);
                this.out.print(".put(");
                this.out.print(Generator.quote(tagVariableInfo.getNameGiven()));
                this.out.print(", ");
                this.out.print(Generator.quote(string4));
                this.out.println(");");
            }
            return string2;
        }

        private void generateSetters(Node.CustomTag customTag, String string, TagHandlerInfo tagHandlerInfo, boolean bl) throws JasperException {
            Node.JspAttribute[] jspAttributeArray;
            if (bl) {
                jspAttributeArray = null;
                if (customTag.isTagFile()) {
                    jspAttributeArray = this.generateAliasMap(customTag, string);
                }
                this.out.printin(string);
                if (jspAttributeArray == null) {
                    this.out.println(".setJspContext(_jspx_page_context);");
                } else {
                    this.out.print(".setJspContext(_jspx_page_context, ");
                    this.out.print((String)jspAttributeArray);
                    this.out.println(");");
                }
            } else {
                this.out.printin(string);
                this.out.println(".setPageContext(_jspx_page_context);");
            }
            if (this.isTagFile && this.parent == null) {
                this.out.printin(string);
                this.out.print(".setParent(");
                this.out.print("new jakarta.servlet.jsp.tagext.TagAdapter(");
                this.out.println("(jakarta.servlet.jsp.tagext.SimpleTag) this ));");
            } else if (!bl) {
                this.out.printin(string);
                this.out.print(".setParent(");
                if (this.parent != null) {
                    if (this.isSimpleTagParent) {
                        this.out.print("new jakarta.servlet.jsp.tagext.TagAdapter(");
                        this.out.print("(jakarta.servlet.jsp.tagext.SimpleTag) ");
                        this.out.print(this.parent);
                        this.out.println("));");
                    } else {
                        this.out.print("(jakarta.servlet.jsp.tagext.Tag) ");
                        this.out.print(this.parent);
                        this.out.println(");");
                    }
                } else {
                    this.out.println("null);");
                }
            } else if (this.parent != null) {
                this.out.printin(string);
                this.out.print(".setParent(");
                this.out.print(this.parent);
                this.out.println(");");
            }
            jspAttributeArray = customTag.getJspAttributes();
            for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                String string2 = this.evaluateAttribute(tagHandlerInfo, jspAttributeArray[i], customTag, string);
                Mark mark = customTag.getStart();
                this.out.printil("// " + mark.getFile() + "(" + mark.getLineNumber() + "," + mark.getColumnNumber() + ") " + jspAttributeArray[i].getTagAttributeInfo());
                if (jspAttributeArray[i].isDynamic()) {
                    this.out.printin(string);
                    this.out.print(".");
                    this.out.print("setDynamicAttribute(");
                    String string3 = jspAttributeArray[i].getURI();
                    if ("".equals(string3) || string3 == null) {
                        this.out.print("null");
                    } else {
                        this.out.print("\"" + jspAttributeArray[i].getURI() + "\"");
                    }
                    this.out.print(", \"");
                    this.out.print(jspAttributeArray[i].getLocalName());
                    this.out.print("\", ");
                    this.out.print(string2);
                    this.out.println(");");
                    continue;
                }
                this.out.printin(string);
                this.out.print(".");
                this.out.print(tagHandlerInfo.getSetterMethod(jspAttributeArray[i].getLocalName()).getName());
                this.out.print("(");
                this.out.print(string2);
                this.out.println(");");
            }
            if (customTag.implementsJspIdConsumer()) {
                this.out.printin(string);
                this.out.print(".setJspId(\"");
                this.out.print(Generator.this.createJspId());
                this.out.println("\");");
            }
        }

        private String getScopeConstant(String string) {
            String string2 = "jakarta.servlet.jsp.PageContext.PAGE_SCOPE";
            if ("request".equals(string)) {
                string2 = "jakarta.servlet.jsp.PageContext.REQUEST_SCOPE";
            } else if ("session".equals(string)) {
                string2 = "jakarta.servlet.jsp.PageContext.SESSION_SCOPE";
            } else if ("application".equals(string)) {
                string2 = "jakarta.servlet.jsp.PageContext.APPLICATION_SCOPE";
            }
            return string2;
        }

        private void generateJspFragment(Node.ChildInfoBase childInfoBase, String string) throws JasperException {
            FragmentHelperClass.Fragment fragment = this.fragmentHelperClass.openFragment(childInfoBase, this.methodNesting);
            ServletWriter servletWriter = this.out;
            this.out = fragment.getGenBuffer().getOut();
            String string2 = this.parent;
            this.parent = "_jspx_parent";
            boolean bl = this.isSimpleTagParent;
            this.isSimpleTagParent = true;
            boolean bl2 = this.isFragment;
            this.isFragment = true;
            String string3 = this.pushBodyCountVar;
            if (this.pushBodyCountVar != null) {
                this.pushBodyCountVar = "_jspx_push_body_count";
            }
            this.visitBody(childInfoBase);
            this.out = servletWriter;
            this.parent = string2;
            this.isSimpleTagParent = bl;
            this.isFragment = bl2;
            this.pushBodyCountVar = string3;
            this.fragmentHelperClass.closeFragment(fragment, this.methodNesting);
            this.out.print("new " + this.fragmentHelperClass.getClassName() + "( " + fragment.getId() + ", _jspx_page_context, " + string + ", " + this.pushBodyCountVar + ")");
        }

        public String generateNamedAttributeValue(Node.NamedAttribute namedAttribute) throws JasperException {
            String string = namedAttribute.getTemporaryVariableName();
            Node.Nodes nodes = namedAttribute.getBody();
            if (nodes != null) {
                Node node;
                boolean bl = false;
                if (nodes.size() == 1 && (node = nodes.getNode(0)) instanceof Node.TemplateText) {
                    bl = true;
                    this.out.printil("java.lang.String " + string + " = " + Generator.quote(node.getText()) + ";");
                }
                if (!bl) {
                    this.out.printil("out = _jspx_page_context.pushBody();");
                    this.visitBody(namedAttribute);
                    this.out.printil("java.lang.String " + string + " = ((jakarta.servlet.jsp.tagext.BodyContent)out).getString();");
                    this.out.printil("out = _jspx_page_context.popBody();");
                }
            } else {
                this.out.printil("java.lang.String " + string + " = \"\";");
            }
            return string;
        }

        public String generateNamedAttributeJspFragment(Node.NamedAttribute namedAttribute, String string) throws JasperException {
            String string2 = namedAttribute.getTemporaryVariableName();
            this.out.printin("jakarta.servlet.jsp.tagext.JspFragment " + string2 + " = ");
            this.generateJspFragment(namedAttribute, string);
            this.out.println(";");
            return string2;
        }
    }
}

