import * as vue from '@vue/language-core';
import type * as ts from 'typescript/lib/tsserverlibrary';
import type { MetaCheckerOptions, ComponentMeta } from './types';
export * from './types';
export type ComponentMetaChecker = ReturnType<typeof baseCreate>;
export declare function createComponentMetaCheckerByJsonConfig(root: string, json: any, checkerOptions?: MetaCheckerOptions, ts?: typeof import('typescript/lib/tsserverlibrary')): {
    updateFile(fileName: string, text: string): void;
    deleteFile(fileName: string): void;
    reload(): void;
    clearCache(): void;
    getExportNames: (componentPath: string) => string[];
    getComponentMeta: (componentPath: string, exportName?: string) => ComponentMeta;
    __internal__: {
        tsLs: ts.LanguageService;
    };
};
export declare function createComponentMetaChecker(tsconfigPath: string, checkerOptions?: MetaCheckerOptions, ts?: typeof import('typescript/lib/tsserverlibrary')): {
    updateFile(fileName: string, text: string): void;
    deleteFile(fileName: string): void;
    reload(): void;
    clearCache(): void;
    getExportNames: (componentPath: string) => string[];
    getComponentMeta: (componentPath: string, exportName?: string) => ComponentMeta;
    __internal__: {
        tsLs: ts.LanguageService;
    };
};
export declare function baseCreate(_host: vue.TypeScriptLanguageHost, vueCompilerOptions: vue.VueCompilerOptions, checkerOptions: MetaCheckerOptions, globalComponentName: string, ts: typeof import('typescript/lib/tsserverlibrary')): {
    getExportNames: (componentPath: string) => string[];
    getComponentMeta: (componentPath: string, exportName?: string) => ComponentMeta;
    __internal__: {
        tsLs: ts.LanguageService;
    };
};
