/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.DoubleExponentialSmoothingForLinearSeries;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.MovingAverage;
import eu.hansolo.tilesfx.tools.NiceScale;
import eu.hansolo.tilesfx.tools.TimeData;
import eu.hansolo.toolbox.Statistics;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class TimelineTileSkin
extends TileSkin {
    private static final int SEC_MONTH = 2592000;
    private static final int SEC_DAY = 86400;
    private static final int SEC_HOUR = 3600;
    private static final int SEC_MINUTE = 60;
    private static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("MM");
    private static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("dd");
    private static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter MINUTE_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter SECOND_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.YY HH:mm");
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Text averageText;
    private Text averageText2;
    private Text minText;
    private Text maxText;
    private Text highText;
    private Text lowText;
    private Text text;
    private Text timeSpanText;
    private Rectangle graphBounds;
    private Map<ChartData, Circle> dots;
    private Path path;
    private Group dotGroup;
    private Rectangle stdDeviationArea;
    private Line thresholdLine;
    private Line lowerThresholdLine;
    private Line averageLine;
    private Group sectionGroup;
    private Map<Section, Rectangle> sections;
    private Map<Section, Label> percentageInSections;
    private Group percentageInSectionGroup;
    private LinearGradient gradient;
    private double low;
    private double high;
    private double stdDeviation;
    private int noOfDatapoints;
    private int maxNoOfDatapoints;
    private List<ChartData> dataList;
    private List<ChartData> reducedDataList;
    private java.time.Duration timePeriod;
    private MovingAverage movingAverage;
    private InvalidationListener periodListener;
    private NiceScale niceScaleY;
    private List<Line> horizontalTickLines;
    private double horizontalLineOffset;
    private List<Line> verticalTickLines;
    private double tickLabelFontSize;
    private List<Text> tickLabelsX;
    private List<Text> tickLabelsY;
    private Color tickLineColor;
    private Color tickLabelColor;
    private Text trendText;
    private Instant lastUpdate;
    private double dotRadius;
    private EventHandler<MouseEvent> mouseListener;
    private Tooltip dotTooltip;

    public TimelineTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.dotTooltip = new Tooltip("");
        this.dotTooltip.setAutoHide(true);
        this.dotTooltip.setHideDelay(Duration.seconds((double)0.0));
        this.dotTooltip.setShowDuration(Duration.seconds((double)5.0));
        this.periodListener = o -> this.handleEvents("PERIOD");
        this.mouseListener = e -> this.handleMouseEvents((MouseEvent)e);
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm", this.tile.getLocale());
        this.timePeriod = this.tile.getTimePeriod();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.niceScaleY = new NiceScale(this.minValue, this.tile.getMaxValue());
        this.niceScaleY.setMaxTicks(5.0);
        this.tickLineColor = Color.color((double)this.tile.getChartGridColor().getRed(), (double)this.tile.getChartGridColor().getGreen(), (double)this.tile.getChartGridColor().getBlue(), (double)0.5);
        this.tickLabelColor = this.tile.getTickLabelColor();
        this.horizontalTickLines = new ArrayList<Line>(5);
        this.verticalTickLines = new ArrayList<Line>(16);
        this.tickLabelsX = new ArrayList<Text>(16);
        this.tickLabelsY = new ArrayList<Text>(5);
        int noOfVerticalLines = this.getNoOfVerticalLines(Instant.now(), this.timePeriod);
        for (long i = 0L; i < (long)noOfVerticalLines; ++i) {
            Line vLine = new Line(0.0, 0.0, 0.0, 0.0);
            vLine.getStrokeDashArray().addAll((Object[])new Double[]{1.0, 2.0});
            vLine.setStroke((Paint)Color.TRANSPARENT);
            vLine.setMouseTransparent(true);
            this.verticalTickLines.add(vLine);
            Text tickLabelX = new Text("");
            tickLabelX.setTextOrigin(VPos.BOTTOM);
            tickLabelX.setMouseTransparent(true);
            this.tickLabelsX.add(tickLabelX);
        }
        for (int i = 0; i < 5; ++i) {
            Line hLine = new Line(0.0, 0.0, 0.0, 0.0);
            hLine.getStrokeDashArray().addAll((Object[])new Double[]{1.0, 2.0});
            hLine.setStroke((Paint)Color.TRANSPARENT);
            hLine.setMouseTransparent(true);
            this.horizontalTickLines.add(hLine);
            Text tickLabelY = new Text("");
            tickLabelY.setFill((Paint)Color.TRANSPARENT);
            tickLabelY.setMouseTransparent(true);
            this.tickLabelsY.add(tickLabelY);
        }
        this.low = this.maxValue;
        this.high = this.minValue;
        this.stdDeviation = 0.0;
        this.movingAverage = this.tile.getMovingAverage();
        this.dataList = new ArrayList<ChartData>();
        this.reducedDataList = new ArrayList<ChartData>();
        this.dotRadius = 3.0;
        this.noOfDatapoints = this.calcNumberOfDatapointsForPeriod(this.timePeriod);
        this.maxNoOfDatapoints = this.calcNumberOfDatapointsForPeriod(this.tile.getMaxTimePeriod());
        this.graphBounds = new Rectangle(12.5, 125.0, 225.0, 112.5);
        this.tile.setAveragingPeriod(this.noOfDatapoints);
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_RIGHT);
        this.valueUnitFlow.setMouseTransparent(true);
        this.averageText = new Text(String.format(this.locale, "\u2300 " + this.formatString, this.tile.getAverage()));
        this.averageText.setFill((Paint)Tile.FOREGROUND);
        Helper.enableNode((Node)this.averageText, this.tile.isAverageVisible());
        this.averageText2 = new Text(String.format(this.locale, "\u2300 " + this.formatString, this.tile.getAverage()));
        this.averageText2.setFill((Paint)Tile.FOREGROUND);
        Helper.enableNode((Node)this.averageText2, this.tile.isAverageVisible());
        this.minText = new Text();
        this.minText.setTextOrigin(VPos.TOP);
        this.minText.setFill((Paint)this.tile.getValueColor());
        this.maxText = new Text();
        this.maxText.setTextOrigin(VPos.BOTTOM);
        this.maxText.setFill((Paint)this.tile.getValueColor());
        this.highText = new Text();
        this.highText.setTextOrigin(VPos.BOTTOM);
        this.highText.setFill((Paint)this.tile.getValueColor());
        this.lowText = new Text();
        this.lowText.setTextOrigin(VPos.TOP);
        this.lowText.setFill((Paint)this.tile.getValueColor());
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill((Paint)this.tile.getTextColor());
        this.timeSpanText = new Text("");
        this.timeSpanText.setTextOrigin(VPos.TOP);
        this.timeSpanText.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.timeSpanText, !this.tile.isTextVisible());
        this.stdDeviationArea = new Rectangle();
        Helper.enableNode((Node)this.stdDeviationArea, this.tile.isAverageVisible());
        this.thresholdLine = new Line();
        this.thresholdLine.setStroke((Paint)this.tile.getThresholdColor());
        this.thresholdLine.getStrokeDashArray().addAll((Object[])new Double[]{1.25, 1.25});
        Helper.enableNode((Node)this.thresholdLine, this.tile.isThresholdVisible());
        this.lowerThresholdLine = new Line();
        this.lowerThresholdLine.setStroke((Paint)this.tile.getLowerThresholdColor());
        this.lowerThresholdLine.getStrokeDashArray().addAll((Object[])new Double[]{1.25, 1.25});
        Helper.enableNode((Node)this.lowerThresholdLine, this.tile.isLowerThresholdVisible());
        this.averageLine = new Line();
        this.averageLine.setStroke((Paint)Tile.FOREGROUND);
        this.averageLine.getStrokeDashArray().addAll((Object[])new Double[]{1.25, 1.25});
        Helper.enableNode((Node)this.averageLine, this.tile.isAverageVisible());
        this.sections = new HashMap<Section, Rectangle>();
        this.tile.getSections().forEach(section -> {
            Rectangle sectionRect = new Rectangle();
            sectionRect.setMouseTransparent(true);
            this.sections.put((Section)section, sectionRect);
        });
        this.sectionGroup = new Group();
        this.sectionGroup.getChildren().addAll(this.sections.values());
        Helper.enableNode((Node)this.sectionGroup, this.tile.getSectionsVisible());
        this.percentageInSections = new HashMap<Section, Label>();
        this.tile.getSections().forEach(section -> {
            Label sectionLabel = new Label();
            sectionLabel.setAlignment(Pos.CENTER_RIGHT);
            sectionLabel.setTextFill((Paint)this.tile.getTextColor());
            this.percentageInSections.put((Section)section, sectionLabel);
        });
        this.percentageInSectionGroup = new Group();
        this.percentageInSectionGroup.getChildren().setAll(this.percentageInSections.values());
        Helper.enableNode((Node)this.percentageInSectionGroup, this.tile.getSectionsVisible());
        this.trendText = new Text("");
        this.trendText.setTextOrigin(VPos.TOP);
        this.trendText.setFill((Paint)this.tile.getTextColor());
        this.lastUpdate = Instant.now();
        this.path = new Path();
        this.path.setMouseTransparent(true);
        this.path.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.path.setStrokeLineCap(StrokeLineCap.ROUND);
        this.dots = new LinkedHashMap<ChartData, Circle>(this.noOfDatapoints);
        this.dotGroup = new Group();
        if (this.tile.getDataPointsVisible()) {
            this.dotGroup.getChildren().setAll(this.dots.values());
            this.dotGroup.getChildren().add((Object)this.path);
        } else {
            this.dotGroup.getChildren().setAll((Object[])new Node[]{this.path});
        }
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.valueUnitFlow, this.fractionLine, this.sectionGroup, this.stdDeviationArea, this.thresholdLine, this.lowerThresholdLine, this.dotGroup, this.percentageInSectionGroup, this.averageLine, this.averageText, this.averageText2, this.minText, this.maxText, this.highText, this.lowText, this.trendText, this.timeSpanText, this.text});
        this.getPane().getChildren().addAll(this.verticalTickLines);
        this.getPane().getChildren().addAll(this.horizontalTickLines);
        this.getPane().getChildren().addAll(this.tickLabelsX);
        this.getPane().getChildren().addAll(this.tickLabelsY);
        TimerTask timerTask2 = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> TimelineTileSkin.this.checkForOutdated());
            }
        };
        Timer timer = new Timer("Timer");
        timer.scheduleAtFixedRate(timerTask2, 1000L, 500L);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.timePeriodProperty().addListener(this.periodListener);
        this.tile.getChartData().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(chartData -> this.addData((ChartData)chartData));
            }
            Set dataSet = this.tile.getChartData().stream().filter(data -> !this.dataList.contains(data)).collect(Collectors.toSet());
            Platform.runLater(() -> this.tile.removeChartData(new ArrayList<ChartData>(dataSet)));
        });
        this.tile.getSections().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(section -> {
                        Rectangle sectionRect = new Rectangle();
                        sectionRect.setMouseTransparent(true);
                        this.sections.put((Section)section, sectionRect);
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(section -> this.sections.remove(section));
            }
            this.sectionGroup.getChildren().setAll(this.sections.values());
            this.resize();
        });
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (this.tile.isAnimated()) {
            this.tile.setAnimated(false);
        }
        if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.timeSpanText, !this.tile.isTextVisible());
            Helper.enableNode((Node)this.averageLine, this.tile.isAverageVisible());
            Helper.enableNode((Node)this.averageText, this.tile.isAverageVisible());
            Helper.enableNode((Node)this.averageText2, this.tile.isAverageVisible());
            Helper.enableNode((Node)this.stdDeviationArea, this.tile.isAverageVisible());
            Helper.enableNode((Node)this.thresholdLine, this.tile.isThresholdVisible());
            Helper.enableNode((Node)this.lowerThresholdLine, this.tile.isLowerThresholdVisible());
            Helper.enableNode((Node)this.sectionGroup, this.tile.getSectionsVisible());
            Helper.enableNode((Node)this.percentageInSectionGroup, this.tile.getSectionsVisible());
            Helper.enableNode((Node)this.trendText, this.tile.isTrendVisible());
            this.redraw();
        } else if (TileEvt.VALUE.getName().equals(EVENT_TYPE)) {
            double value = Helper.clamp(this.minValue, this.maxValue, this.tile.getValue());
            this.tile.getChartData().add((Object)new ChartData("", value, Instant.now()));
        } else if (TileEvt.SECTION.getName().equals(EVENT_TYPE)) {
            this.percentageInSections.clear();
            this.tile.getSections().forEach(section -> {
                Label sectionLabel = new Label();
                sectionLabel.setAlignment(Pos.CENTER_RIGHT);
                sectionLabel.setTextFill((Paint)this.tile.getTextColor());
                this.percentageInSections.put((Section)section, sectionLabel);
            });
            this.percentageInSectionGroup.getChildren().setAll(this.percentageInSections.values());
        } else if (TileEvt.TIME_PERIOD.getName().equals(EVENT_TYPE)) {
            this.timePeriod = this.tile.getTimePeriod();
            this.noOfDatapoints = this.calcNumberOfDatapointsForPeriod(this.timePeriod);
            this.maxNoOfDatapoints = this.calcNumberOfDatapointsForPeriod(this.tile.getMaxTimePeriod());
            this.timeSpanText.setText(this.createTimeSpanText());
            this.tile.setAveragingPeriod(this.noOfDatapoints);
            this.dots.values().forEach(dot -> {
                dot.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseListener);
                dot.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseListener);
            });
            this.dots.clear();
            this.reducedDataList.forEach(data -> {
                Circle dot = new Circle(this.dotRadius);
                dot.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseListener);
                dot.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseListener);
                this.dots.put((ChartData)data, dot);
            });
            if (this.tile.getDataPointsVisible()) {
                this.dotGroup.getChildren().setAll(this.dots.values());
                this.dotGroup.getChildren().add((Object)this.path);
            } else {
                this.dotGroup.getChildren().setAll((Object[])new Node[]{this.path});
            }
            this.redraw();
        } else if (TileEvt.REGIONS_ON_TOP.getName().equals(EVENT_TYPE)) {
            this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
            this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
            this.fractionLine.setStartX(this.width - 0.17 * this.size);
            this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
            this.fractionLine.setEndX(this.width - 0.05 * this.size);
            this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
            this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
            this.fractionLine.setStrokeWidth(this.size * 0.005);
        } else if (TileEvt.CLEAR_DATA.getName().equals(EVENT_TYPE)) {
            this.tile.clearChartData();
            this.dataList.clear();
            this.reducedDataList.clear();
            this.handleCurrentValue(this.minValue);
            Platform.runLater(() -> {
                this.path.getElements().clear();
                this.dots.clear();
                this.dotGroup.getChildren().clear();
            });
        } else if (TileEvt.THRESHOLD_EXCEEDED.equals(EVENT_TYPE) || TileEvt.THRESHOLD_UNDERRUN.equals(EVENT_TYPE) || TileEvt.LOWER_THRESHOLD_EXCEEDED.equals(EVENT_TYPE) || TileEvt.LOWER_THRESHOLD_UNDERRUN.equals(EVENT_TYPE)) {
            // empty if block
        }
    }

    private void handleMouseEvents(MouseEvent e) {
        EventType type = e.getEventType();
        Circle dot = (Circle)e.getSource();
        ChartData data = this.dots.entrySet().stream().filter(entry -> ((Circle)entry.getValue()).equals(dot)).map(entry -> (ChartData)entry.getKey()).findAny().orElse(null);
        if (MouseEvent.MOUSE_ENTERED.equals(type)) {
            if (null != data) {
                this.dotTooltip.setX(e.getScreenX());
                this.dotTooltip.setY(e.getScreenY());
                LocalDateTime localDateTime = LocalDateTime.ofInstant(data.getTimestamp(), this.tile.getZoneId());
                this.dotTooltip.setText(String.join((CharSequence)"\n", this.DTF.format(localDateTime), String.format(this.tile.getLocale(), String.join((CharSequence)" ", this.formatString, this.tile.getUnit()), data.getValue())));
                this.dotTooltip.show(this.tile.getScene().getWindow());
            }
        } else if (MouseEvent.MOUSE_EXITED.equals(type)) {
            this.dotTooltip.hide();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        Instant now;
        this.low = this.reducedDataList.stream().min(Comparator.comparingDouble(ChartData::getValue)).map(data -> data.getValue()).orElse(this.tile.getLowerThreshold());
        this.high = this.reducedDataList.stream().max(Comparator.comparingDouble(ChartData::getValue)).map(data -> data.getValue()).orElse(this.tile.getThreshold());
        this.range = this.maxValue - this.minValue;
        this.lastUpdate = now = Instant.now();
        long maxTime = now.getEpochSecond();
        long minTime = now.minus(this.timePeriod.toSeconds(), ChronoUnit.SECONDS).getEpochSecond();
        TimeUnit resolution = this.tile.getTimePeriodResolution();
        long resolutionStep = switch (resolution) {
            case TimeUnit.DAYS -> 86400L;
            case TimeUnit.HOURS -> 3600L;
            case TimeUnit.MINUTES -> 60L;
            default -> 1L;
        };
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)this.timePeriod.getSeconds();
        double stepY = this.graphBounds.getHeight() / this.range;
        this.niceScaleY.setMinMax(this.minValue, this.maxValue);
        int lineCountY = 1;
        int tickLabelOffsetY = 1;
        double tickSpacingY = this.niceScaleY.getTickSpacing();
        double tickStepY = tickSpacingY * stepY;
        double tickStartY = maxY - tickStepY;
        if (tickSpacingY < this.minValue) {
            tickLabelOffsetY = (int)(this.minValue / tickSpacingY) + 1;
            tickStartY = maxY - ((double)tickLabelOffsetY * tickSpacingY - this.minValue) * stepY;
        }
        this.verticalTickLines.forEach(line -> line.setStroke((Paint)Color.TRANSPARENT));
        this.horizontalTickLines.forEach(line -> line.setStroke((Paint)Color.TRANSPARENT));
        this.tickLabelsX.forEach(label -> label.setFill((Paint)Color.TRANSPARENT));
        this.tickLabelsY.forEach(label -> label.setFill((Paint)Color.TRANSPARENT));
        this.horizontalLineOffset = 0.0;
        double y = tickStartY;
        while ((double)Math.round(y) > minY) {
            Line line2 = this.horizontalTickLines.get(lineCountY);
            Text label2 = this.tickLabelsY.get(lineCountY);
            label2.setText(String.format(this.locale, "%.0f", this.minValue + (double)lineCountY * tickSpacingY));
            label2.setY(y + this.graphBounds.getHeight() * 0.03);
            label2.setFill((Paint)this.tickLabelColor);
            this.horizontalLineOffset = Math.max(label2.getLayoutBounds().getWidth(), this.horizontalLineOffset);
            line2.setStartX(minX);
            line2.setStartY(y);
            line2.setEndY(y);
            line2.setStroke((Paint)this.tickLineColor);
            ++lineCountY;
            lineCountY = Helper.clamp(0, 4, lineCountY);
            y -= tickStepY;
        }
        int lineCountX = 0;
        for (long t = minTime; t < maxTime; ++t) {
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(t), this.tile.getZoneId());
            double x = -1.0;
            String timeText = "";
            if (this.timePeriod.getSeconds() > 2592000L) {
                if (1 == dateTime.getDayOfMonth() && 0 == dateTime.getHour() && 0 == dateTime.getMinute() && 0 == dateTime.getSecond()) {
                    x = minX + (double)(t - minTime) * stepX;
                    timeText = MONTH_FORMATTER.format(dateTime);
                }
            } else if (this.timePeriod.getSeconds() > 86400L) {
                if (0 == dateTime.getHour() && 0 == dateTime.getMinute() && 0 == dateTime.getSecond()) {
                    x = minX + (double)(t - minTime) * stepX;
                    timeText = DAY_FORMATTER.format(dateTime);
                }
            } else if (this.timePeriod.getSeconds() > 43200L) {
                if (dateTime.getHour() % 2 == 0 && 0 == dateTime.getMinute() && 0 == dateTime.getSecond()) {
                    x = minX + (double)(t - minTime) * stepX;
                    timeText = HOUR_FORMATTER.format(dateTime);
                }
            } else if (this.timePeriod.getSeconds() > 21600L) {
                if (0 == dateTime.getMinute() && 0 == dateTime.getSecond()) {
                    x = minX + (double)(t - minTime) * stepX;
                    timeText = HOUR_FORMATTER.format(dateTime);
                }
            } else if (this.timePeriod.getSeconds() > 3600L) {
                if ((0 == dateTime.getMinute() || 30 == dateTime.getMinute()) && 0 == dateTime.getSecond()) {
                    x = minX + (double)(t - minTime) * stepX;
                    timeText = HOUR_FORMATTER.format(dateTime);
                }
            } else if (this.timePeriod.getSeconds() > 60L) {
                if (0 == dateTime.getSecond() && dateTime.getMinute() % 5 == 0) {
                    x = minX + (double)(t - minTime) * stepX;
                    timeText = MINUTE_FORMATTER.format(dateTime);
                }
            } else if (dateTime.getSecond() % 10 == 0) {
                x = minX + (double)(t - minTime) * stepX;
                timeText = SECOND_FORMATTER.format(dateTime);
            }
            if (!(x > -1.0)) continue;
            x = minX + (double)(t - minTime) * stepX;
            Line line3 = this.verticalTickLines.get(lineCountX);
            Text label3 = this.tickLabelsX.get(lineCountX);
            label3.setText(timeText);
            label3.setX(x - label3.getLayoutBounds().getWidth() * 0.5);
            label3.setY(this.graphBounds.getY());
            label3.setFill((Paint)this.tickLabelColor);
            line3.setStartX(x);
            line3.setEndX(x);
            line3.setStartY(minY);
            line3.setEndY(maxY);
            line3.setStroke((Paint)this.tickLineColor);
            ++lineCountX;
        }
        if (this.tickLabelFontSize < 6.0) {
            this.horizontalLineOffset = 0.0;
        }
        this.horizontalTickLines.forEach(line -> line.setEndX(maxX - this.horizontalLineOffset));
        this.tickLabelsY.forEach(label -> label.setX(maxX - label.getLayoutBounds().getWidth()));
        this.minText.setText(String.format(this.locale, this.formatString, this.minValue));
        this.maxText.setText(String.format(this.locale, this.formatString, this.maxValue));
        this.lowText.setText(String.format(this.locale, this.formatString, this.low));
        this.highText.setText(String.format(this.locale, this.formatString, this.high));
        this.minText.setX(maxX - this.minText.getLayoutBounds().getWidth());
        this.maxText.setX(maxX - this.maxText.getLayoutBounds().getWidth());
        if (!this.reducedDataList.isEmpty()) {
            if (this.tile.isStrokeWithGradient()) {
                this.setupGradient();
            }
            Iterator<Map.Entry<ChartData, Circle>> entries = this.dots.entrySet().iterator();
            Map.Entry<ChartData, Circle> entry = entries.next();
            ChartData data2 = entry.getKey();
            Circle dot = entry.getValue();
            this.path.getElements().clear();
            this.path.getElements().add((Object)new MoveTo(maxX - (double)(maxTime - data2.getTimestamp().getEpochSecond()) * stepX, maxY - Math.abs(this.minValue - Helper.clamp(this.minValue, this.maxValue, data2.getValue())) * stepY));
            for (long timeSlot = maxTime; timeSlot >= minTime; timeSlot -= resolutionStep) {
                if (data2.getTimestamp().getEpochSecond() <= timeSlot - resolutionStep) continue;
                dot.setCenterX(maxX - (double)(maxTime - data2.getTimestamp().getEpochSecond()) * stepX);
                dot.setCenterY(maxY - Math.abs(this.minValue - Helper.clamp(this.minValue, this.maxValue, data2.getValue())) * stepY);
                dot.setFill((Paint)(this.tile.isStrokeWithGradient() ? this.gradient : this.tile.getBarColor()));
                this.path.getElements().add((Object)new LineTo(dot.getCenterX(), dot.getCenterY()));
                if (!entries.hasNext()) continue;
                entry = entries.next();
                data2 = entry.getKey();
                dot = entry.getValue();
            }
            this.path.setStroke((Paint)(this.tile.isStrokeWithGradient() ? this.gradient : this.tile.getBarColor()));
            if (this.tile.isSmoothing()) {
                Helper.smoothPath(this.path, false);
            }
            this.sections.entrySet().forEach(e -> {
                Section section = (Section)e.getKey();
                Rectangle rectangle = (Rectangle)e.getValue();
                rectangle.setX(minX);
                rectangle.setY(Helper.clamp(minY, maxY, maxY - Math.abs(this.minValue - section.getStop()) * stepY));
                rectangle.setWidth(this.graphBounds.getWidth());
                rectangle.setHeight(Math.abs(section.getStop() - section.getStart()) * stepY);
                rectangle.setFill((Paint)section.getColor());
            });
            double average = Statistics.getAverage(this.reducedDataList.stream().map(ChartData::getValue).collect(Collectors.toList()));
            double averageY = Helper.clamp(minY, maxY, maxY - Math.abs(this.minValue - average) * stepY);
            this.averageLine.setStartX(minX);
            this.averageLine.setStartY(averageY);
            this.averageLine.setEndX(maxX);
            this.averageLine.setEndY(averageY);
            double threshold = this.tile.getThreshold();
            double thresholdY = Helper.clamp(minY, maxY, maxY - Math.abs(this.minValue - threshold) * stepY);
            this.thresholdLine.setStartX(minX);
            this.thresholdLine.setStartY(thresholdY);
            this.thresholdLine.setEndX(maxX);
            this.thresholdLine.setEndY(thresholdY);
            double lowerThreshold = this.tile.getLowerThreshold();
            double lowerThresholdY = Helper.clamp(minY, maxY, maxY - Math.abs(this.minValue - lowerThreshold) * stepY);
            this.lowerThresholdLine.setStartX(minX);
            this.lowerThresholdLine.setStartY(lowerThresholdY);
            this.lowerThresholdLine.setEndX(maxX);
            this.lowerThresholdLine.setEndY(lowerThresholdY);
            this.stdDeviationArea.setY(this.averageLine.getStartY() - this.stdDeviation * 0.5 * stepY);
            this.stdDeviationArea.setHeight(this.stdDeviation * stepY);
            this.averageText.setText(String.format(this.locale, "\u2300 " + this.formatString, average));
            this.averageText2.setText(String.format(this.locale, "\u2300 " + this.formatString, average));
        }
        if (this.tile.getShortenNumbers()) {
            this.valueText.setText(Helper.shortenNumber((long)VALUE));
        } else if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(HOUR_FORMATTER.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeDynamicText();
    }

    private void addData(ChartData DATA) {
        if (this.dataList.size() >= this.maxNoOfDatapoints) {
            Collections.rotate(this.dataList, -1);
            if (!this.dataList.isEmpty()) {
                this.dataList.set(this.noOfDatapoints - 1, DATA);
            }
        } else {
            this.dataList.add(DATA);
            if (this.tile.isAveragingEnabled()) {
                this.movingAverage.addData(new TimeData(DATA.getValue(), DATA.getTimestamp()));
            }
        }
        Predicate<ChartData> isNotInTimePeriod = chartData -> !chartData.isWithinTimePeriod(Instant.now(), this.timePeriod);
        this.reducedDataList.clear();
        this.reducedDataList.addAll(this.dataList);
        this.reducedDataList.removeIf(isNotInTimePeriod);
        if (this.reducedDataList.size() == 0x7FFFFFFE || this.reducedDataList.size() >= this.noOfDatapoints) {
            Collections.rotate(this.reducedDataList, -1);
            if (!this.reducedDataList.isEmpty()) {
                this.reducedDataList.set(this.noOfDatapoints - 1, DATA);
            }
        }
        Collections.sort(this.reducedDataList, Comparator.comparing(ChartData::getTimestamp).reversed());
        this.dots.values().forEach(dot -> {
            dot.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseListener);
            dot.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseListener);
        });
        this.dots.clear();
        this.reducedDataList.forEach(data -> {
            Circle dot = new Circle(this.dotRadius);
            dot.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseListener);
            dot.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseListener);
            this.dots.put((ChartData)data, dot);
        });
        if (this.tile.getDataPointsVisible()) {
            this.dotGroup.getChildren().setAll(this.dots.values());
            this.dotGroup.getChildren().add((Object)this.path);
        } else {
            this.dotGroup.getChildren().setAll((Object[])new Node[]{this.path});
        }
        int n = Helper.clamp(2, this.reducedDataList.size(), this.tile.getNumberOfValuesForTrendCalculation());
        if (this.reducedDataList.size() > n) {
            List firstNValues = this.reducedDataList.stream().map(ChartData::getValue).limit(n).collect(Collectors.toList());
            DoubleExponentialSmoothingForLinearSeries.Model model = DoubleExponentialSmoothingForLinearSeries.fit(firstNValues.stream().mapToDouble(Double::doubleValue).toArray(), 0.8, 0.2);
            String forecast = String.format(this.tile.getLocale(), "%.0f", model.forecast(1)[0]);
            double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
            double trendAngle = Helper.getAngleFromXY(0.0, DATA.getValue(), stepX, model.forecast(1)[0]) - 90.0;
            if (90.0 <= trendAngle && trendAngle < 112.5) {
                this.trendText.setText("\u2191");
            } else if (112.5 <= trendAngle && trendAngle < 147.5) {
                this.trendText.setText("\u2197");
            } else if (147.5 <= trendAngle && trendAngle < 202.5) {
                this.trendText.setText("\u2192");
            } else if (202.5 <= trendAngle && trendAngle < 247.5) {
                this.trendText.setText("\u2198");
            } else if (247.5 <= trendAngle && trendAngle < 270.0) {
                this.trendText.setText("\u2193");
            } else {
                this.trendText.setText("");
            }
        }
        this.stdDeviation = Statistics.getStdDev(this.reducedDataList.stream().map(ChartData::getValue).collect(Collectors.toList()));
        this.analyse(this.reducedDataList);
        this.handleCurrentValue(DATA.getValue());
    }

    private void setupGradient() {
        this.gradient = new LinearGradient(0.0, this.graphBounds.getY() + this.graphBounds.getHeight(), 0.0, this.graphBounds.getY(), false, CycleMethod.NO_CYCLE, this.tile.getGradientStops());
    }

    private int calcNumberOfDatapointsForPeriod(java.time.Duration TIME_PERIOD) {
        return Helper.calcNumberOfDatapointsForPeriod(TIME_PERIOD, this.tile.getTimePeriodResolution());
    }

    private String createTimeSpanText() {
        long timeSpan = this.timePeriod.getSeconds();
        StringBuilder timeSpanBuilder = new StringBuilder();
        if (timeSpan > 2592000L) {
            int months = (int)(timeSpan / 2592000L);
            double days = timeSpan % 2592000L;
            timeSpanBuilder.append(months).append("M");
            if (days > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", days)).append("d");
            }
        } else if (timeSpan > 86400L) {
            int days = (int)(timeSpan / 86400L);
            double hours = (timeSpan - (long)(days * 86400)) / 3600L;
            timeSpanBuilder.append(days).append("d");
            if (hours > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", hours)).append("h");
            }
        } else if (timeSpan > 3600L) {
            int hours = (int)(timeSpan / 3600L);
            double minutes = (timeSpan - (long)(hours * 3600)) / 60L;
            timeSpanBuilder.append(hours).append("h");
            if (minutes > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", minutes)).append("m");
            }
        } else if (timeSpan > 60L) {
            int minutes = (int)(timeSpan / 60L);
            double seconds = timeSpan - (long)(minutes * 60);
            timeSpanBuilder.append(minutes).append("m");
            if (seconds > 0.0) {
                timeSpanBuilder.append(String.format(Locale.US, "%.0f", seconds)).append("s");
            }
        } else {
            int seconds = (int)timeSpan;
            timeSpanBuilder.append(seconds).append("s");
        }
        return timeSpanBuilder.toString();
    }

    @Override
    public void dispose() {
        this.tile.timePeriodProperty().removeListener(this.periodListener);
        super.dispose();
    }

    private void checkForOutdated() {
        this.valueText.setOpacity(Instant.now().toEpochMilli() - this.lastUpdate.toEpochMilli() > this.tile.getTimeoutMs() ? 0.5 : 1.0);
    }

    private void analyse(List<ChartData> clampedDataList) {
        double noOfPointsInTimePeriod = clampedDataList.size();
        this.percentageInSections.entrySet().forEach(entry -> {
            double noOfPointsInSection = clampedDataList.stream().filter(chartData -> ((Section)entry.getKey()).contains(chartData.getValue())).mapToDouble(ChartData::getValue).count();
            ((Label)entry.getValue()).setText(String.format(this.tile.getLocale(), "%.0f%%", noOfPointsInSection / noOfPointsInTimePeriod * 100.0));
        });
    }

    private int getNoOfVerticalLines(Instant START, java.time.Duration TIME_PERIOD) {
        long maxTime = START.getEpochSecond();
        long minTime = START.minus(TIME_PERIOD.toSeconds(), ChronoUnit.SECONDS).getEpochSecond();
        int lineCountX = 0;
        for (long t = minTime; t < maxTime; ++t) {
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(t), this.tile.getZoneId());
            if (TIME_PERIOD.getSeconds() > 2592000L) {
                if (1 != dateTime.getDayOfMonth() || 0 != dateTime.getHour() || 0 != dateTime.getMinute() || 0 != dateTime.getSecond()) continue;
                ++lineCountX;
                continue;
            }
            if (TIME_PERIOD.getSeconds() > 86400L) {
                if (0 != dateTime.getHour() || 0 != dateTime.getMinute() || 0 != dateTime.getSecond()) continue;
                ++lineCountX;
                continue;
            }
            if (TIME_PERIOD.getSeconds() > 43200L) {
                if (dateTime.getHour() % 2 != 0 || 0 != dateTime.getMinute() || 0 != dateTime.getSecond()) continue;
                ++lineCountX;
                continue;
            }
            if (TIME_PERIOD.getSeconds() > 21600L) {
                if (0 != dateTime.getMinute() || 0 != dateTime.getSecond()) continue;
                ++lineCountX;
                continue;
            }
            if (TIME_PERIOD.getSeconds() > 3600L) {
                if (0 != dateTime.getMinute() && 30 != dateTime.getMinute() || 0 != dateTime.getSecond()) continue;
                ++lineCountX;
                continue;
            }
            if (TIME_PERIOD.getSeconds() > 60L) {
                if (0 != dateTime.getSecond() || dateTime.getMinute() % 5 != 0) continue;
                ++lineCountX;
                continue;
            }
            if (dateTime.getSecond() % 10 != 0) continue;
            ++lineCountX;
        }
        return lineCountX;
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.valueUnitFlow.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.7;
        fontSize = this.size * 0.03;
        this.averageText.setFont(Fonts.latoRegular(fontSize));
        if (this.averageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.averageText, maxWidth, fontSize);
        }
        if (this.averageLine.getStartY() < this.graphBounds.getY() + this.graphBounds.getHeight() * 0.5) {
            this.averageText.setY(this.averageLine.getStartY() + this.size * 0.0425);
        } else {
            this.averageText.setY(this.averageLine.getStartY() - this.size * 0.0075);
        }
        this.averageText.setVisible(fontSize > 6.0);
        fontSize = this.size * 0.06;
        this.minText.setFont(Fonts.latoRegular(fontSize));
        if (this.minText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minText, maxWidth, fontSize);
        }
        this.minText.setY(this.height - this.size * 0.1);
        this.maxText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxText, maxWidth, fontSize);
        }
        this.maxText.setY(this.graphBounds.getY() - this.size * 0.0175);
        this.lowText.setFont(Fonts.latoRegular(fontSize));
        if (this.lowText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.lowText, maxWidth, fontSize);
        }
        this.lowText.setY(this.height - this.size * 0.1);
        this.highText.setFont(Fonts.latoRegular(fontSize));
        if (this.highText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.highText, maxWidth, fontSize);
        }
        this.highText.setY(this.graphBounds.getY() - this.size * 0.0175);
        this.trendText.setFont(Fonts.latoRegular(fontSize));
        if (this.trendText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.trendText, maxWidth, fontSize);
        }
        this.trendText.relocate((this.width - this.trendText.getLayoutBounds().getWidth()) * 0.25, this.height - this.size * 0.1);
        this.averageText2.setFont(Fonts.latoRegular(fontSize));
        if (this.averageText2.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.averageText2, maxWidth, fontSize);
        }
        this.averageText2.relocate((this.width - this.averageText2.getLayoutBounds().getWidth()) * 0.75, this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.text.setFont(Fonts.latoRegular(fontSize));
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        this.text.relocate(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth(), this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.timeSpanText.setFont(Fonts.latoRegular(fontSize));
        if (this.timeSpanText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.timeSpanText, maxWidth, fontSize);
        }
        this.timeSpanText.relocate((this.width - this.timeSpanText.getLayoutBounds().getWidth()) * 0.5, this.height - this.size * 0.1);
        this.percentageInSections.entrySet().forEach(entry -> {
            ((Label)entry.getValue()).setFont(Fonts.latoRegular(this.size * 0.025));
            ((Label)entry.getValue()).setPrefWidth(this.size * 0.065);
            ((Label)entry.getValue()).relocate(this.size * 0.05, this.sections.get(entry.getKey()).getLayoutBounds().getCenterY() - ((Label)entry.getValue()).getLayoutBounds().getCenterY());
            ((Label)entry.getValue()).setVisible(this.size * 0.025 > 6.0);
        });
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.lowText.setX(this.size * 0.05);
        this.highText.setX(this.size * 0.05);
        this.averageText.setX(this.size * 0.15);
    }

    @Override
    protected void resize() {
        super.resize();
        this.graphBounds = new Rectangle(this.contentBounds.getX(), this.titleText.isVisible() ? this.size * 0.5 : this.size * 0.4, this.contentBounds.getWidth(), this.titleText.isVisible() ? this.height - this.size * 0.61 : this.height - this.size * 0.51);
        this.tickLabelFontSize = this.graphBounds.getHeight() * 0.1;
        Font tickLabelFont = Fonts.latoRegular(this.tickLabelFontSize);
        this.tickLabelsY.forEach(label -> {
            Helper.enableNode((Node)label, this.tickLabelFontSize >= 6.0);
            label.setFont(tickLabelFont);
        });
        this.horizontalTickLines.forEach(line -> line.setStrokeWidth(0.5));
        double miniLabelFontSize = this.size * 0.022;
        Font miniTickLabelFont = Fonts.latoRegular(miniLabelFontSize);
        this.tickLabelsX.forEach(label -> {
            Helper.enableNode((Node)label, miniLabelFontSize >= 6.0);
            label.setFont(miniTickLabelFont);
        });
        this.verticalTickLines.forEach(line -> line.setStrokeWidth(0.5));
        this.stdDeviationArea.setX(this.graphBounds.getX());
        this.stdDeviationArea.setWidth(this.graphBounds.getWidth());
        this.thresholdLine.getStrokeDashArray().setAll((Object[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
        this.lowerThresholdLine.getStrokeDashArray().setAll((Object[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
        this.averageLine.getStrokeDashArray().setAll((Object[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
        this.handleCurrentValue(Double.parseDouble(this.valueText.getText()));
        this.dotRadius = this.noOfDatapoints < 60 ? this.size * 0.01 : (this.noOfDatapoints < 3600 ? this.size * 0.0075 : this.size * 0.005);
        this.dots.values().forEach(dot -> dot.setRadius(this.dotRadius));
        this.path.setStrokeWidth(this.size * 0.01);
        if (this.tile.isStrokeWithGradient()) {
            this.setupGradient();
        }
        this.resizeStaticText();
        this.resizeDynamicText();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        if (!this.tile.getDescription().isEmpty()) {
            this.text.setText(this.tile.getDescription());
        }
        if (this.tile.isTextVisible()) {
            this.text.setText(this.tile.getText());
        } else if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.minText.setFill((Paint)this.tile.getValueColor());
        this.maxText.setFill((Paint)this.tile.getValueColor());
        this.lowText.setFill((Paint)this.tile.getValueColor());
        this.highText.setFill((Paint)this.tile.getValueColor());
        this.trendText.setFill((Paint)this.tile.getTextColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.averageText.setFill((Paint)this.tile.getForegroundColor());
        this.averageText2.setFill((Paint)this.tile.getForegroundColor());
        this.timeSpanText.setFill((Paint)this.tile.getTextColor());
        this.stdDeviationArea.setFill((Paint)Helper.getColorWithOpacity(Tile.FOREGROUND, 0.1));
    }
}

