/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten.writer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmListMetaData;
import mediathek.daten.ListeFilme;
import mediathek.gui.messages.FilmListWriteStartEvent;
import mediathek.gui.messages.FilmListWriteStopEvent;
import mediathek.tool.MessageBus;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilmListWriter {
    private static final Logger logger = LogManager.getLogger(FilmListWriter.class);
    private static final String TAG_JSON_LIST = "X";
    private String sender = "";
    private String thema = "";
    private final boolean readable;

    public FilmListWriter(boolean readable) {
        this.readable = readable;
    }

    private JsonGenerator getJsonGenerator(OutputStream os) throws IOException {
        JsonFactory jsonF = new JsonFactory();
        JsonGenerator jg = jsonF.createGenerator(os, JsonEncoding.UTF8);
        if (this.readable) {
            jg = jg.useDefaultPrettyPrinter();
        }
        return jg;
    }

    private void checkOsxCacheDirectory() {
        Path filePath = Paths.get(SystemUtils.USER_HOME + File.separator + "Library/Caches/MediathekView", new String[0]);
        if (Files.notExists(filePath, new LinkOption[0])) {
            try {
                Files.createDirectories(filePath, new FileAttribute[0]);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    private void writeFormatHeader(JsonGenerator jg, ListeFilme listeFilme) throws IOException {
        FilmListMetaData meta = listeFilme.metaData();
        jg.writeArrayFieldStart("Filmliste");
        jg.writeString("");
        jg.writeString(meta.getDatum());
        jg.writeString(meta.getVersion());
        jg.writeString("");
        jg.writeString(meta.getId());
        jg.writeEndArray();
    }

    public void writeFilmList(String datei, ListeFilme listeFilme, IProgressListener listener) {
        MessageBus.getMessageBus().publishAsync(new FilmListWriteStartEvent());
        try {
            logger.info("Filme schreiben ({} Filme) :", (Object)listeFilme.size());
            logger.info("   --> Start Schreiben nach: {}", (Object)datei);
            this.sender = "";
            this.thema = "";
            if (SystemUtils.IS_OS_MAC_OSX) {
                this.checkOsxCacheDirectory();
            }
            Path filePath = Paths.get(datei, new String[0]);
            try {
                Files.deleteIfExists(filePath);
            }
            catch (Exception e) {
                logger.warn("error trying to delete file", (Throwable)e);
                logger.trace("Waiting two seconds...");
                TimeUnit.SECONDS.sleep(2L);
            }
            long start = System.nanoTime();
            try (OutputStream fos = Files.newOutputStream(filePath, new OpenOption[0]);
                 BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
                 JsonGenerator jg = this.getJsonGenerator(bos);){
                jg.writeStartObject();
                this.writeFormatHeader(jg, listeFilme);
                this.writeFormatDescription(jg);
                long filmEntries = listeFilme.size();
                float curEntry = 0.0f;
                for (DatenFilm datenFilm : listeFilme) {
                    this.writeEntry(datenFilm, jg);
                    if (listener == null) continue;
                    listener.progress(curEntry / (float)filmEntries);
                    curEntry += 1.0f;
                }
                jg.writeEndObject();
                if (listener != null) {
                    listener.progress(1.0);
                }
                long end = System.nanoTime();
                logger.info("   --> geschrieben!");
                logger.trace("Write duration: {} ms", (Object)TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS));
            }
        }
        catch (Exception ex) {
            logger.error("nach: {}", (Object)datei, (Object)ex);
        }
        MessageBus.getMessageBus().publishAsync(new FilmListWriteStopEvent());
    }

    private void writeEntry(DatenFilm datenFilm, JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart(TAG_JSON_LIST);
        this.writeSender(jg, datenFilm);
        this.writeThema(jg, datenFilm);
        this.writeTitel(jg, datenFilm);
        jg.writeString(datenFilm.getSendeDatum());
        this.writeZeit(jg, datenFilm);
        jg.writeString(datenFilm.getDauer());
        jg.writeString(datenFilm.getSize());
        jg.writeString(datenFilm.getDescription());
        jg.writeString(datenFilm.getUrlNormalQuality());
        jg.writeString(datenFilm.getWebsiteLink());
        jg.writeString(datenFilm.getUrlSubtitle());
        this.skipEntry(jg);
        jg.writeString(datenFilm.getUrlLowQuality());
        this.skipEntry(jg);
        jg.writeString(datenFilm.getUrlHighQuality());
        this.skipEntry(jg);
        jg.writeString(datenFilm.getDatumLong());
        this.skipEntry(jg);
        jg.writeString(datenFilm.getGeo().orElse(""));
        jg.writeString(Boolean.toString(datenFilm.isNew()));
        jg.writeEndArray();
    }

    private void skipEntry(JsonGenerator jg) throws IOException {
        jg.writeString("");
    }

    private void writeTitel(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        jg.writeString(datenFilm.getTitle());
    }

    private void writeSender(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        String tempSender = datenFilm.getSender();
        if (tempSender.equals(this.sender)) {
            jg.writeString("");
        } else {
            this.sender = tempSender;
            jg.writeString(tempSender);
        }
    }

    private void writeThema(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        if (datenFilm.getThema().equals(this.thema)) {
            jg.writeString("");
        } else {
            this.thema = datenFilm.getThema();
            jg.writeString(datenFilm.getThema());
        }
    }

    private void writeZeit(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        String strZeit = datenFilm.getSendeZeit();
        int len = strZeit.length();
        if (strZeit.isEmpty() || len < 8) {
            jg.writeString("");
        } else {
            strZeit = strZeit.substring(0, len - 3);
            jg.writeString(strZeit);
        }
    }

    private void writeFormatDescription(JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart("Filmliste");
        jg.writeString("");
        jg.writeEndArray();
    }

    @FunctionalInterface
    public static interface IProgressListener {
        public void progress(double var1);
    }
}

