/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.quantum.QS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class GaussianReader
extends MOReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private String energyString = "";
    private String energyKey = "";
    protected int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    private int stepNumber;
    private int moModelSet = -1;
    protected BS namedSets = new BS();
    private boolean isHighPrecision;
    private boolean haveHighPrecision;
    private boolean allowHighPrecision;
    private boolean orientationInput;
    private String orientation;

    @Override
    protected void initializeReader() throws Exception {
        boolean bl = this.allowHighPrecision = !this.checkAndRemoveFilterKey("NOHP");
        this.orientation = this.checkFilterKey("ORIENTATION:INPUT") ? "Input" : (this.checkFilterKey("ORIENTATION:STANDARD") ? "Standard" : null);
        this.orientationInput = this.orientation == "Input";
        this.appendLoadNote("Orientation:" + (this.orientation == null ? "ALL" : this.orientation));
        if (this.orientation != null) {
            this.orientation = this.orientation + " orientation:";
        }
        super.initializeReader();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Step number")) {
            this.equivalentAtomSets = 0;
            ++this.stepNumber;
            int scanPointIndex = this.line.indexOf("scan point");
            this.scanPoint = scanPointIndex > 0 ? this.parseIntAt(this.line, scanPointIndex + 10) : -1;
            return true;
        }
        if (this.line.indexOf("-- Stationary point found") > 0) {
            if (this.scanPoint >= 0) {
                ++this.scanPoint;
            }
            return true;
        }
        if (this.orientation == null ? this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0 : this.line.indexOf(this.orientation) >= 0 || this.orientationInput && this.line.indexOf("Z-Matrix orientation:") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            Logger.info(this.asc.atomSetCount + " model " + this.modelNumber + " step " + this.stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
            this.readAtoms();
            return false;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" Energy=")) {
            this.setEnergy();
            return true;
        }
        if (this.line.startsWith(" SCF Done:")) {
            this.readSCFDone();
            return true;
        }
        if (this.line.startsWith(" Calculating GIAO")) {
            this.readCSATensors();
            return false;
        }
        if (this.line.startsWith(" Total nuclear spin-spin coupling")) {
            this.readCouplings();
            return false;
        }
        if (!this.orientationInput && this.line.startsWith(" Harmonic frequencies")) {
            this.readFrequencies(":", true);
            return true;
        }
        if (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" Dipole moment")) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.startsWith(" Standard basis:") || this.line.startsWith(" General basis read from")) {
            this.energyUnits = "";
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" Basis read from chk")) {
            this.energyUnits = "";
            this.calculationType = this.line.substring(this.line.lastIndexOf("\"") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" AO basis set")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0 || this.line.indexOf("Natural Orbital Coefficients") >= 0 || this.line.indexOf("Natural Transition Orbitals") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals();
            Logger.info(this.orbitals.size() + " molecular orbitals read");
            return true;
        }
        if (this.line.startsWith(" Normal termination of Gaussian")) {
            ++this.calculationNumber;
            this.equivalentAtomSets = 0;
            return true;
        }
        if (this.line.startsWith(" Mulliken atomic spin densities:")) {
            this.getSpinDensities(11);
            return true;
        }
        if (this.line.startsWith(" Mulliken charges and spin densities:")) {
            this.getSpinDensities(21);
            return true;
        }
        return this.checkNboLine();
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        if (this.orientation == null) {
            this.appendLoadNote("\nUse filter 'orientation:xxx' where 'xxx' is one of: input (includes z-matrix), standard, or ALL");
        } else {
            this.appendLoadNote("\nfilter: " + this.filter);
        }
    }

    private void getSpinDensities(int pt) throws Exception {
        this.rd();
        float[] data = new float[this.asc.getLastAtomSetAtomCount()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.parseFloatStr(this.rd().substring(pt, pt + 10));
        }
        this.asc.setAtomProperties("spin", data, -1, false);
        this.appendLoadNote(data.length + " spin densities loaded into model " + (this.asc.iSet + 1));
    }

    private void readSCFDone() throws Exception {
        String[] tokens = PT.getTokensAt(this.line, 11);
        if (tokens.length < 4) {
            return;
        }
        this.energyKey = tokens[0];
        this.asc.setAtomSetEnergy(tokens[2], this.parseFloatStr(tokens[2]));
        this.energyString = tokens[2] + " " + tokens[3];
        this.setNames(this.energyKey + " = " + this.energyString, this.namedSets, this.equivalentAtomSets);
        this.setProps(this.energyKey, this.energyString, this.equivalentAtomSets);
        tokens = PT.getTokens(this.rd());
        if (tokens.length > 2) {
            this.setProps(tokens[0], tokens[2], this.equivalentAtomSets);
            if (tokens.length > 5) {
                this.setProps(tokens[3], tokens[5], this.equivalentAtomSets);
            }
            tokens = PT.getTokens(this.rd());
        }
        if (tokens.length > 2) {
            this.setProps(tokens[0], tokens[2], this.equivalentAtomSets);
        }
    }

    private void setProps(String key, String value, int n) {
        for (int i = this.asc.iSet; --n >= 0 && i >= 0; --i) {
            this.asc.setAtomSetModelPropertyForSet(key, value, i);
        }
    }

    private void setNames(String atomSetName, BS namedSets, int n) {
        for (int i = this.asc.iSet; --n >= 0 && i >= 0; --i) {
            if (namedSets != null && namedSets.get(i)) continue;
            this.asc.setModelInfoForSet("name", atomSetName, i);
        }
    }

    private void setEnergy() {
        String[] tokens = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = tokens[1];
        this.setNames("Energy = " + tokens[1], this.namedSets, this.equivalentAtomSets);
        this.asc.setAtomSetEnergy(this.energyString, this.parseFloatStr(this.energyString));
    }

    protected void readAtoms() throws Exception {
        this.asc.newAtomSet();
        this.haveHighPrecision = false;
        if (this.energyKey.length() != 0) {
            this.asc.setAtomSetName(this.energyKey + " = " + this.energyString);
        }
        this.asc.setAtomSetEnergy(this.energyString, this.parseFloatStr(this.energyString));
        String path = this.getTokens()[0];
        this.readLines(4);
        while (this.rd() != null && !this.line.startsWith(" --")) {
            String[] tokens = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)this.parseIntStr(tokens[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordTokens(atom, tokens, tokens.length - 3);
        }
        this.asc.setAtomSetModelProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + path);
    }

    protected void readBasis() throws Exception {
        int i;
        int nGaussians;
        String oType;
        int[] slater;
        String[] tokens;
        boolean isGeneral;
        this.shells = new Lst();
        Lst<String[]> gdata = new Lst<String[]>();
        int ac = 0;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String lastAtom = "";
        boolean doSphericalD = this.calculationType != null && this.calculationType.indexOf("5D") > 0;
        boolean doSphericalF = this.calculationType != null && this.calculationType.indexOf("7F") > 0;
        boolean doSphericalG = this.calculationType != null && this.calculationType.indexOf("9G") > 0;
        boolean doSphericalH = this.calculationType != null && this.calculationType.indexOf("11H") > 0;
        boolean doSphericalI = this.calculationType != null && this.calculationType.indexOf("13I") > 0;
        boolean doSphericalHighL = doSphericalG || doSphericalH || doSphericalI;
        boolean doSpherical = doSphericalD || doSphericalF || doSphericalHighL;
        boolean bl = isGeneral = this.line.indexOf("general basis input") >= 0;
        if (isGeneral) {
            while (this.rd() != null && this.line.length() > 0) {
                ++this.shellCount;
                tokens = this.getTokens();
                ++ac;
                while (this.rd().indexOf("****") < 0) {
                    slater = new int[4];
                    slater[0] = ac;
                    tokens = this.getTokens();
                    oType = tokens[0];
                    slater[1] = doSphericalF && oType.indexOf("F") >= 0 || doSphericalD && oType.indexOf("D") >= 0 ? BasisFunctionReader.getQuantumShellTagIDSpherical(oType) : BasisFunctionReader.getQuantumShellTagID(oType);
                    nGaussians = this.parseIntStr(tokens[1]);
                    slater[2] = this.gaussianCount + 1;
                    slater[3] = nGaussians;
                    if (this.debugging) {
                        Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(slater));
                    }
                    this.shells.addLast(slater);
                    this.gaussianCount += nGaussians;
                    for (i = 0; i < nGaussians; ++i) {
                        this.rd();
                        this.line = PT.rep(this.line, "D ", "D+");
                        tokens = this.getTokens();
                        if (this.debugging) {
                            Logger.debug("Gaussians " + (i + 1) + " " + Escape.eAS(tokens, true));
                        }
                        gdata.addLast(tokens);
                    }
                }
            }
        } else {
            while (this.rd() != null && this.line.startsWith(" Atom")) {
                ++this.shellCount;
                tokens = this.getTokens();
                slater = new int[4];
                if (!tokens[1].equals(lastAtom)) {
                    // empty if block
                }
                lastAtom = tokens[1];
                slater[0] = ++ac;
                oType = tokens[4];
                slater[1] = doSpherical && (doSphericalF && oType.indexOf("F") >= 0 || doSphericalD && oType.indexOf("D") >= 0 || doSphericalHighL && (doSphericalG && oType.indexOf("G") >= 0 || doSphericalH && oType.indexOf("H") >= 0 || doSphericalI && oType.indexOf("I") >= 0)) ? BasisFunctionReader.getQuantumShellTagIDSpherical(oType) : BasisFunctionReader.getQuantumShellTagID(oType);
                this.enableShell(slater[1]);
                nGaussians = this.parseIntStr(tokens[5]);
                slater[2] = this.gaussianCount + 1;
                slater[3] = nGaussians;
                this.shells.addLast(slater);
                this.gaussianCount += nGaussians;
                for (i = 0; i < nGaussians; ++i) {
                    gdata.addLast(PT.getTokens(this.rd()));
                }
            }
        }
        if (ac == 0) {
            ac = 1;
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        for (int i2 = 0; i2 < this.gaussianCount; ++i2) {
            tokens = (String[])gdata.get(i2);
            this.gaussians[i2] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                this.gaussians[i2][j] = this.parseFloatStr(tokens[j]);
            }
        }
        Logger.info(this.shellCount + " slater shells read");
        Logger.info(this.gaussianCount + " gaussian primitives read");
    }

    protected void readMolecularOrbitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        Map<K, V>[] mos = AU.createArrayOfHashtable(5);
        Lst<type>[] data = AU.createArrayOfArrayList(5);
        int nThisLine = 0;
        boolean isNOtype = this.line.contains("Natural Orbital");
        while (this.rd() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            String[] tokens;
            if (this.line.indexOf("eta Molecular Orbital Coefficients") >= 0) {
                this.addMOData(nThisLine, data, mos);
                nThisLine = 0;
                if (!this.filterMO()) break;
            }
            if (this.line.indexOf("                    ") == 0) {
                int i;
                this.addMOData(nThisLine, data, mos);
                if (isNOtype) {
                    tokens = this.getTokens();
                    nThisLine = tokens.length;
                    tokens = PT.getTokens(this.rd());
                } else {
                    tokens = PT.getTokens(this.rd());
                    nThisLine = tokens.length;
                }
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Lst();
                    if (isNOtype) {
                        mos[i].put("occupancy", Float.valueOf(PT.parseFloat(tokens[i + 2])));
                        continue;
                    }
                    String sym = tokens[i];
                    mos[i].put("symmetry", sym);
                    if (sym.indexOf("O") >= 0) {
                        mos[i].put("occupancy", Float.valueOf(2.0f));
                        continue;
                    }
                    if (sym.indexOf("V") < 0) continue;
                    mos[i].put("occupancy", Float.valueOf(0.0f));
                }
                if (isNOtype) continue;
                this.line = this.rd().substring(21);
                tokens = this.getTokens();
                if (tokens.length != nThisLine) {
                    tokens = GaussianReader.getStrings(this.line, nThisLine, 10);
                }
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", Float.valueOf(tokens[i]));
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(5) != ' ' && !PT.isDigit(this.line.charAt(5))) continue;
            try {
                this.line = PT.rep(this.line, " 0 ", "0  ");
                tokens = this.getTokens();
                String type = tokens[tokens.length - nThisLine - 1].substring(1);
                if (PT.isDigit(type.charAt(0))) {
                    type = type.substring(1);
                }
                if (!QS.isQuantumBasisSupported(type.charAt(0)) && "XYZ".indexOf(type.charAt(0)) >= 0) {
                    type = (type.length() == 2 ? "D" : "F") + type;
                }
                if (!QS.isQuantumBasisSupported(type.charAt(0))) continue;
                tokens = GaussianReader.getStrings(this.line.substring(this.line.length() - 10 * nThisLine), nThisLine, 10);
                for (int i = 0; i < nThisLine; ++i) {
                    data[i].addLast(tokens[i]);
                }
            }
            catch (Exception e) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(nThisLine, data, mos);
        this.setMOData(this.moModelSet != this.asc.atomSetCount);
        this.moModelSet = this.asc.atomSetCount;
    }

    protected void readFrequencies(String key, boolean mustHave) throws Exception {
        this.discardLinesUntilContains2(key, ":");
        if (this.line == null && mustHave) {
            throw new Exception("No frequencies encountered");
        }
        this.line = this.rd();
        int ac = this.asc.getLastAtomSetAtomCount();
        String[][] data = new String[ac][];
        String[][] temp = null;
        int[] atomIndices = new int[ac];
        while (this.line != null && this.line.length() > 20 && this.line.indexOf("Temperature") < 0) {
            String[] symmetries = PT.getTokens(this.rd());
            this.discardLinesUntilContains(" Frequencies");
            if (this.line == null) {
                return;
            }
            boolean bl = this.isHighPrecision = this.line.indexOf("---") > 0;
            if (this.isHighPrecision ? !this.allowHighPrecision : this.haveHighPrecision) {
                return;
            }
            if (this.isHighPrecision && !this.haveHighPrecision) {
                this.appendLoadNote("high precision vibrational modes enabled. Use filter 'NOHP' to disable.");
                this.haveHighPrecision = true;
            }
            if (temp == null) {
                temp = new String[this.isHighPrecision ? 3 : 1][0];
            }
            int width = this.isHighPrecision ? 22 : 15;
            String[] frequencies = PT.getTokensAt(this.line, width);
            String[] red_masses = PT.getTokensAt(this.discardLinesUntilContains(this.isHighPrecision ? "Reduced masses" : "Red. masses"), width);
            String[] frc_consts = PT.getTokensAt(this.discardLinesUntilContains(this.isHighPrecision ? "Force constants" : "Frc consts"), width);
            String[] intensities = PT.getTokensAt(this.discardLinesUntilContains(this.isHighPrecision ? "IR Intensities" : "IR Inten"), width);
            int iAtom0 = this.asc.ac;
            int frequencyCount = frequencies.length;
            boolean[] ignore = new boolean[frequencyCount];
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl2 = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                this.asc.cloneAtomSetWithBonds(true);
                String name = this.asc.setAtomSetFrequency(this.vibrationNumber, "Calculation " + this.calculationNumber, symmetries[i], frequencies[i], null);
                this.appendLoadNote("model " + this.asc.atomSetCount + ": " + name);
                this.namedSets.set(this.asc.iSet);
                this.asc.setAtomSetModelProperty("ReducedMass", red_masses[i] + " AMU");
                this.asc.setAtomSetModelProperty("ForceConstant", frc_consts[i] + " mDyne/A");
                this.asc.setAtomSetModelProperty("IRIntensity", intensities[i] + " KM/Mole");
            }
            this.discardLinesUntilContains(" Atom ");
            if (this.isHighPrecision) {
                do {
                    this.fillFrequencyData(iAtom0, 1, ac, ignore, false, 23, 10, null, 9, temp);
                } while (temp[0] != null);
                continue;
            }
            int nLines = 0;
            int nMin = frequencyCount * 3 + 1;
            while (true) {
                this.fillDataBlockFixed(temp, 0, 0, 0);
                if (temp[0].length < nMin) break;
                atomIndices[nLines] = Integer.valueOf(temp[0][0]) - 1;
                data[nLines++] = temp[0];
            }
            this.fillFrequencyData(iAtom0, nLines, ac, ignore, true, 0, 0, atomIndices, 0, data);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] tokens = PT.getTokens(this.rd());
        if (tokens.length != 8) {
            return;
        }
        V3 dipole = V3.new3(this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[5]));
        Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + dipole);
        this.asc.setCurrentModelInfo("dipole", dipole);
    }

    void readPartialCharges() throws Exception {
        this.rd();
        int ac = this.asc.ac;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atoms = this.asc.atoms;
        for (int i = i0; i < ac; ++i) {
            float charge;
            while (atoms[i].elementNumber == 0) {
                ++i;
            }
            atoms[i].partialCharge = charge = this.parseFloatStr(PT.getTokens(this.rd())[2]);
        }
        Logger.info("Mulliken charges found for Model " + this.asc.atomSetCount);
    }

    private void readCSATensors() throws Exception {
        this.rd();
        this.rd();
        while (this.line != null && this.line.indexOf("Isotropic") >= 0) {
            int iatom = this.parseIntAt(this.line, 0);
            String[] data = (this.rd() + this.rd() + this.rd()).split("=");
            this.addTensor(iatom, data);
            if (this.rd() == null || this.line.indexOf("Eigen") < 0) continue;
            this.rd();
        }
        this.appendLoadNote("NMR shift tensors are available for model=" + (this.asc.iSet + 1) + "\n using \"ellipsoids set 'csa'.");
    }

    private void addTensor(int iatom, String[] data) {
        int i0 = this.asc.getLastAtomSetAtomIndex();
        double[][] a = new double[3][3];
        int p = 1;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                a[i][j] = this.parseFloatStr(data[p]);
                ++j;
                ++p;
            }
        }
        Tensor t = new Tensor().setFromAsymmetricTensor(a, "csa", "csa" + iatom);
        this.asc.atoms[i0 + iatom - 1].addTensor(t, "csa", false);
        System.out.println("calc Tensor " + t + "calc isotropy=" + t.getInfo("isotropy") + " anisotropy=" + t.getInfo("anisotropy") + "\n");
    }

    private void readCouplings() throws Exception {
        String type = this.line.indexOf(" K ") >= 0 ? "K" : "J";
        int n = this.asc.getLastAtomSetAtomCount();
        float[][] data = new float[n][n];
        int k0 = 0;
        do {
            this.rd();
            for (int i = k0; i < n; ++i) {
                this.rd();
                String[] tokens = this.getTokens();
                int nj = tokens.length;
                for (int j = 1; j < nj; ++j) {
                    float v;
                    float f = v = this.parseFloatStr(tokens[j]);
                    data[k0 + j - 1][i] = f;
                    data[i][k0 + j - 1] = f;
                }
            }
        } while ((k0 += 5) < n);
        System.out.println(data);
        this.asc.setModelInfoForSet("NMR_" + type + "_couplings", data, this.asc.iSet);
        if (type == "J") {
            this.asc.setAtomProperties("J", data, this.asc.iSet, false);
            this.appendLoadNote("NMR J Couplings saved for model=" + (this.asc.iSet + 1) + " as property_J;\n use set measurementUnits \"+hz\" to measure them.");
        }
    }
}

