/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.ad.constant.CommonValue;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.feature.Features;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.EntityAnomalyResult;
import org.opensearch.ad.model.Feature;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.ad.util.MultiResponsesDelegateActionListener;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;

public final class AnomalyDetectorRunner {
    private final Logger logger = LogManager.getLogger(AnomalyDetectorRunner.class);
    private final ModelManager modelManager;
    private final FeatureManager featureManager;
    private final int maxPreviewResults;

    public AnomalyDetectorRunner(ModelManager modelManager, FeatureManager featureManager, int maxPreviewResults) {
        this.modelManager = modelManager;
        this.featureManager = featureManager;
        this.maxPreviewResults = maxPreviewResults;
    }

    public void executeDetector(AnomalyDetector detector, Instant startTime, Instant endTime, ThreadContext.StoredContext context, ActionListener<List<AnomalyResult>> listener) throws IOException {
        context.restore();
        List<String> categoryField = detector.getCategoryField();
        if (categoryField != null && !categoryField.isEmpty()) {
            this.featureManager.getPreviewEntities(detector, startTime.toEpochMilli(), endTime.toEpochMilli(), (ActionListener<List<Entity>>)ActionListener.wrap(entities -> {
                if (entities == null || entities.isEmpty()) {
                    listener.onResponse(Collections.emptyList());
                    return;
                }
                ActionListener entityAnomalyResultListener = ActionListener.wrap(entityAnomalyResult -> listener.onResponse(entityAnomalyResult.getAnomalyResults()), e -> this.onFailure((Exception)e, listener, detector.getDetectorId()));
                MultiResponsesDelegateActionListener multiEntitiesResponseListener = new MultiResponsesDelegateActionListener(entityAnomalyResultListener, entities.size(), String.format(Locale.ROOT, "Fail to get preview result for multi entity detector %s", detector.getDetectorId()), true);
                for (Entity entity : entities) {
                    this.featureManager.getPreviewFeaturesForEntity(detector, entity, startTime.toEpochMilli(), endTime.toEpochMilli(), (ActionListener<Features>)ActionListener.wrap(features -> {
                        List<ThresholdingResult> entityResults = this.modelManager.getPreviewResults(features.getProcessedFeatures(), detector.getShingleSize());
                        List<AnomalyResult> sampledEntityResults = this.sample(this.parsePreviewResult(detector, (Features)features, entityResults, entity), this.maxPreviewResults);
                        multiEntitiesResponseListener.onResponse(new EntityAnomalyResult(sampledEntityResults));
                    }, e -> multiEntitiesResponseListener.onFailure((Exception)e)));
                }
            }, e -> this.onFailure((Exception)e, listener, detector.getDetectorId())));
        } else {
            this.featureManager.getPreviewFeatures(detector, startTime.toEpochMilli(), endTime.toEpochMilli(), (ActionListener<Features>)ActionListener.wrap(features -> {
                try {
                    List<ThresholdingResult> results = this.modelManager.getPreviewResults(features.getProcessedFeatures(), detector.getShingleSize());
                    listener.onResponse(this.sample(this.parsePreviewResult(detector, (Features)features, results, null), this.maxPreviewResults));
                }
                catch (Exception e) {
                    this.onFailure(e, listener, detector.getDetectorId());
                }
            }, e -> this.onFailure((Exception)e, listener, detector.getDetectorId())));
        }
    }

    private void onFailure(Exception e, ActionListener<List<AnomalyResult>> listener, String detectorId) {
        this.logger.info("Fail to preview anomaly detector " + detectorId, (Throwable)e);
        if (e instanceof OpenSearchSecurityException) {
            listener.onFailure(e);
            return;
        }
        listener.onResponse(Collections.emptyList());
    }

    private List<AnomalyResult> parsePreviewResult(AnomalyDetector detector, Features features, List<ThresholdingResult> results, Entity entity) {
        double[][] unprocessedFeatures = features.getUnprocessedFeatures();
        List<Map.Entry<Long, Long>> timeRanges = features.getTimeRanges();
        List featureAttributes = detector.getFeatureAttributes().stream().filter(Feature::getEnabled).collect(Collectors.toList());
        ArrayList<AnomalyResult> anomalyResults = new ArrayList<AnomalyResult>();
        if (timeRanges != null && timeRanges.size() > 0) {
            for (int i = 0; i < timeRanges.size(); ++i) {
                AnomalyResult result;
                Map.Entry<Long, Long> timeRange = timeRanges.get(i);
                ArrayList<FeatureData> featureDatas = new ArrayList<FeatureData>();
                int featureSize = featureAttributes.size();
                for (int j = 0; j < featureSize; ++j) {
                    double value = unprocessedFeatures[i][j];
                    Feature feature = (Feature)featureAttributes.get(j);
                    FeatureData data = new FeatureData(feature.getId(), feature.getName(), value);
                    featureDatas.add(data);
                }
                if (results != null && results.size() > i) {
                    ThresholdingResult thresholdingResult = results.get(i);
                    result = thresholdingResult.toAnomalyResult(detector, Instant.ofEpochMilli(timeRange.getKey()), Instant.ofEpochMilli(timeRange.getValue()), null, null, featureDatas, entity, CommonValue.NO_SCHEMA_VERSION, null, null, null);
                } else {
                    result = new AnomalyResult(detector.getDetectorId(), null, featureDatas, Instant.ofEpochMilli(timeRange.getKey()), Instant.ofEpochMilli(timeRange.getValue()), null, null, null, entity, detector.getUser(), CommonValue.NO_SCHEMA_VERSION, null);
                }
                anomalyResults.add(result);
            }
        }
        return anomalyResults;
    }

    private List<AnomalyResult> sample(List<AnomalyResult> results, int sampleSize) {
        if (results.size() <= sampleSize) {
            return results;
        }
        double stepSize = ((double)results.size() - 1.0) / ((double)sampleSize - 1.0);
        ArrayList<AnomalyResult> samples = new ArrayList<AnomalyResult>(sampleSize);
        for (int i = 0; i < sampleSize; ++i) {
            int index = Math.min((int)(stepSize * (double)i), results.size() - 1);
            samples.add(results.get(index));
        }
        return samples;
    }
}

