# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

AdditionalProperties: typing_extensions.TypeAlias = schemas.NotAnyTypeSchema

from nethsm.client.components.schema import passphrase
from nethsm.client.paths.system_restore.post.parameters.parameter_1 import schema
Properties = typing.TypedDict(
    'Properties',
    {
        "backupPassphrase": typing.Type[passphrase.Passphrase],
        "systemTime": typing.Type[schema.Schema],
    }
)
QueryParametersRequiredDictInput = typing.TypedDict(
    'QueryParametersRequiredDictInput',
    {
        "backupPassphrase": str,
    }
)
QueryParametersOptionalDictInput = typing.TypedDict(
    'QueryParametersOptionalDictInput',
    {
        "systemTime": typing.Union[
            str,
            datetime.datetime
        ],
    },
    total=False
)


class QueryParametersDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "backupPassphrase",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "systemTime",
    })
    
    def __new__(
        cls,
        *,
        backupPassphrase: str,
        systemTime: typing.Union[
            str,
            datetime.datetime,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "backupPassphrase": backupPassphrase,
        }
        for key_, val in (
            ("systemTime", systemTime),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        used_arg_ = typing.cast(QueryParametersDictInput, arg_)
        return QueryParameters.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            QueryParametersDictInput,
            QueryParametersDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> QueryParametersDict:
        return QueryParameters.validate(arg, configuration=configuration)
    
    @property
    def backupPassphrase(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("backupPassphrase")
        )
    
    @property
    def systemTime(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("systemTime", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )


class QueryParametersDictInput(QueryParametersRequiredDictInput, QueryParametersOptionalDictInput):
    pass


@dataclasses.dataclass(frozen=True)
class QueryParameters(
    schemas.Schema[QueryParametersDict, tuple]
):
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "backupPassphrase",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    additional_properties: typing.Type[AdditionalProperties] = dataclasses.field(default_factory=lambda: AdditionalProperties) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: QueryParametersDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            QueryParametersDictInput,
            QueryParametersDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> QueryParametersDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

