/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ModifyQueueCapacityAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.QueueActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.ThresholdConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.DeciderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.WorkLoadTypeConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelTwoActionBuilderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.store.collector.NodeConfigCache;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import org.opensearch.performanceanalyzer.rca.store.rca.util.NodeConfigCacheReaderUtil;

public class LevelTwoActionBuilder {
    private final AppContext appContext;
    private final RcaConf rcaConf;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final LevelTwoActionBuilderConfig actionBuilderConfig;
    private final WorkLoadTypeConfig workLoadTypeConfig;
    private final CacheActionConfig cacheActionConfig;
    private final QueueActionConfig queueActionConfig;
    private final NodeKey nodeKey;
    private final Map<ResourceEnum, ModifyCacheMaxSizeAction> cacheActionMap;
    private final Map<ResourceEnum, ModifyQueueCapacityAction> queueActionMap;
    private final Map<ResourceEnum, Boolean> actionFilter;

    private LevelTwoActionBuilder(NodeKey nodeKey, AppContext appContext, RcaConf rcaConf) {
        this.appContext = appContext;
        this.rcaConf = rcaConf;
        DeciderConfig deciderConfig = rcaConf.getDeciderConfig();
        this.oldGenDecisionPolicyConfig = rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        this.actionBuilderConfig = deciderConfig.getOldGenDecisionPolicyConfig().levelTwoActionBuilderConfig();
        this.workLoadTypeConfig = deciderConfig.getWorkLoadTypeConfig();
        this.cacheActionConfig = rcaConf.getCacheActionConfig();
        this.queueActionConfig = rcaConf.getQueueActionConfig();
        this.nodeKey = nodeKey;
        this.cacheActionMap = new HashMap<ResourceEnum, ModifyCacheMaxSizeAction>();
        this.queueActionMap = new HashMap<ResourceEnum, ModifyQueueCapacityAction>();
        this.actionFilter = new HashMap<ResourceEnum, Boolean>();
        this.registerActions();
        this.actionPriorityFilter();
    }

    public static LevelTwoActionBuilder newBuilder(NodeKey nodeKey, AppContext appContext, RcaConf rcaConf) {
        return new LevelTwoActionBuilder(nodeKey, appContext, rcaConf);
    }

    private void addFieldDataCacheAction() {
        double stepSizeInPercent = this.cacheActionConfig.getStepSize(ResourceEnum.FIELD_DATA_CACHE);
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.nodeKey, ResourceEnum.FIELD_DATA_CACHE, this.appContext, this.rcaConf).increase(false).stepSizeInPercent(stepSizeInPercent * (double)this.actionBuilderConfig.fieldDataCacheStepSize()).build();
        if (action.isActionable()) {
            this.cacheActionMap.put(ResourceEnum.FIELD_DATA_CACHE, action);
        }
    }

    private void addShardRequestCacheAction() {
        double stepSizeInPercent = this.cacheActionConfig.getStepSize(ResourceEnum.SHARD_REQUEST_CACHE);
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.nodeKey, ResourceEnum.SHARD_REQUEST_CACHE, this.appContext, this.rcaConf).increase(false).stepSizeInPercent(stepSizeInPercent * (double)this.actionBuilderConfig.shardRequestCacheStepSize()).build();
        if (action.isActionable()) {
            this.cacheActionMap.put(ResourceEnum.SHARD_REQUEST_CACHE, action);
        }
    }

    private void addWriteQueueAction() {
        int stepSize = this.queueActionConfig.getStepSize(ResourceEnum.WRITE_THREADPOOL);
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(this.nodeKey, ResourceEnum.WRITE_THREADPOOL, this.appContext, this.rcaConf).increase(false).stepSize(stepSize * this.actionBuilderConfig.writeQueueStepSize()).build();
        if (action.isActionable()) {
            this.queueActionMap.put(ResourceEnum.WRITE_THREADPOOL, action);
        }
    }

    private void addSearchQueueAction() {
        int stepSize = this.queueActionConfig.getStepSize(ResourceEnum.SEARCH_THREADPOOL);
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(this.nodeKey, ResourceEnum.SEARCH_THREADPOOL, this.appContext, this.rcaConf).increase(false).stepSize(stepSize * this.actionBuilderConfig.searchQueueStepSize()).build();
        if (action.isActionable()) {
            this.queueActionMap.put(ResourceEnum.SEARCH_THREADPOOL, action);
        }
    }

    private void actionPriorityForCache() {
        this.actionFilter.put(ResourceEnum.FIELD_DATA_CACHE, true);
        this.actionFilter.put(ResourceEnum.SHARD_REQUEST_CACHE, true);
    }

    private int bucketization(int lowerBound, int upperBound, int val, int bucketSize) {
        double step = (double)(upperBound - lowerBound) / (double)bucketSize;
        return (int)((double)(val - lowerBound) / step);
    }

    private void tieBreaker() {
        boolean preferIngest = this.workLoadTypeConfig.preferIngest();
        boolean preferSearch = this.workLoadTypeConfig.preferSearch();
        if (preferIngest && preferSearch || !preferIngest && !preferSearch) {
            this.actionFilter.put(ResourceEnum.WRITE_THREADPOOL, true);
            this.actionFilter.put(ResourceEnum.SEARCH_THREADPOOL, true);
        } else if (preferIngest) {
            this.actionFilter.put(ResourceEnum.SEARCH_THREADPOOL, true);
        } else if (preferSearch) {
            this.actionFilter.put(ResourceEnum.WRITE_THREADPOOL, true);
        }
    }

    private void actionPriorityForQueue() {
        NodeConfigCache nodeConfigCache = this.appContext.getNodeConfigCache();
        Integer writeQueueCapacity = NodeConfigCacheReaderUtil.readQueueCapacity(nodeConfigCache, this.nodeKey, ResourceEnum.WRITE_THREADPOOL);
        Integer searchQueueCapacity = NodeConfigCacheReaderUtil.readQueueCapacity(nodeConfigCache, this.nodeKey, ResourceEnum.SEARCH_THREADPOOL);
        if (writeQueueCapacity == null || searchQueueCapacity == null) {
            return;
        }
        ModifyQueueCapacityAction writeQueueAction = this.queueActionMap.get((Object)ResourceEnum.WRITE_THREADPOOL);
        ModifyQueueCapacityAction searchQueueAction = this.queueActionMap.get((Object)ResourceEnum.SEARCH_THREADPOOL);
        ThresholdConfig<Integer> writeQueueConfig = this.queueActionConfig.getThresholdConfig(ResourceEnum.WRITE_THREADPOOL);
        ThresholdConfig<Integer> searchQueueConfig = this.queueActionConfig.getThresholdConfig(ResourceEnum.SEARCH_THREADPOOL);
        if (writeQueueAction != null && searchQueueAction != null) {
            int searchQueueSizeBucket;
            int writeQueueSizeBucket = this.bucketization(writeQueueConfig.lowerBound(), writeQueueConfig.upperBound(), writeQueueCapacity, this.oldGenDecisionPolicyConfig.queueBucketSize());
            if (writeQueueSizeBucket > (searchQueueSizeBucket = this.bucketization(searchQueueConfig.lowerBound(), searchQueueConfig.upperBound(), searchQueueCapacity, this.oldGenDecisionPolicyConfig.queueBucketSize()))) {
                this.actionFilter.put(ResourceEnum.WRITE_THREADPOOL, true);
            } else if (writeQueueSizeBucket < searchQueueSizeBucket) {
                this.actionFilter.put(ResourceEnum.SEARCH_THREADPOOL, true);
            } else {
                this.tieBreaker();
            }
        } else if (writeQueueAction != null) {
            this.actionFilter.put(ResourceEnum.WRITE_THREADPOOL, true);
        } else if (searchQueueAction != null) {
            this.actionFilter.put(ResourceEnum.SEARCH_THREADPOOL, true);
        }
    }

    private void registerActions() {
        this.addFieldDataCacheAction();
        this.addShardRequestCacheAction();
        this.addSearchQueueAction();
        this.addWriteQueueAction();
    }

    private void actionPriorityFilter() {
        this.actionPriorityForCache();
        this.actionPriorityForQueue();
    }

    public List<Action> build() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.cacheActionMap.forEach((cache, action) -> {
            if (this.actionFilter.getOrDefault(cache, false).booleanValue()) {
                actions.add((Action)action);
            }
        });
        this.queueActionMap.forEach((queue, action) -> {
            if (this.actionFilter.getOrDefault(queue, false).booleanValue()) {
                actions.add((Action)action);
            }
        });
        return actions;
    }
}

