/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.food;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.food.Food;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import java.util.Calendar;

public class Pasty
extends Food {
    private static Holiday holiday = Holiday.NONE;

    public Pasty() {
        this.reset();
        this.energy = 450.0f;
        this.bones = true;
    }

    @Override
    public void reset() {
        super.reset();
        switch (holiday) {
            case NONE: {
                this.image = ItemSpriteSheet.PASTY;
                break;
            }
            case HWEEN: {
                this.image = ItemSpriteSheet.PUMPKIN_PIE;
                break;
            }
            case XMAS: {
                this.image = ItemSpriteSheet.CANDY_CANE;
            }
        }
    }

    @Override
    protected void satisfy(Hero hero) {
        super.satisfy(hero);
        switch (holiday) {
            case NONE: {
                break;
            }
            case HWEEN: {
                hero.HP = Math.min(hero.HP + hero.HT / 10, hero.HT);
                hero.sprite.emitter().burst(Speck.factory(0), 1);
                break;
            }
            case XMAS: {
                Buff.affect(hero, Recharging.class, 2.0f);
                ScrollOfRecharging.charge(hero);
            }
        }
    }

    @Override
    public String name() {
        switch (holiday) {
            default: {
                return Messages.get(this, "pasty", new Object[0]);
            }
            case HWEEN: {
                return Messages.get(this, "pie", new Object[0]);
            }
            case XMAS: 
        }
        return Messages.get(this, "cane", new Object[0]);
    }

    @Override
    public String info() {
        switch (holiday) {
            default: {
                return Messages.get(this, "pasty_desc", new Object[0]);
            }
            case HWEEN: {
                return Messages.get(this, "pie_desc", new Object[0]);
            }
            case XMAS: 
        }
        return Messages.get(this, "cane_desc", new Object[0]);
    }

    @Override
    public int value() {
        return 20 * this.quantity;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        switch (calendar.get(2)) {
            case 0: {
                if (calendar.get(4) != 1) break;
                holiday = Holiday.XMAS;
                break;
            }
            case 9: {
                if (calendar.get(4) < 2) break;
                holiday = Holiday.HWEEN;
                break;
            }
            case 10: {
                if (calendar.get(5) != 1) break;
                holiday = Holiday.HWEEN;
                break;
            }
            case 11: {
                if (calendar.get(4) < 3) break;
                holiday = Holiday.XMAS;
            }
        }
    }

    private static enum Holiday {
        NONE,
        EASTER,
        HWEEN,
        XMAS;

    }
}

