/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.cmd.MediaLinkType;
import tim.prune.cmd.PointAndMedia;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class ConnectMultipleMediaCmd
extends Command {
    private final MediaLinkType _linkType;
    private final ArrayList<PointAndMedia> _data = new ArrayList();

    public ConnectMultipleMediaCmd(MediaLinkType mediaLinkType, List<PointAndMedia> list) {
        this(null, mediaLinkType, list);
    }

    private ConnectMultipleMediaCmd(ConnectMultipleMediaCmd connectMultipleMediaCmd, MediaLinkType mediaLinkType, List<PointAndMedia> list) {
        super(connectMultipleMediaCmd);
        this._linkType = mediaLinkType;
        this._data.addAll(list);
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this._data.isEmpty()) {
            return false;
        }
        for (PointAndMedia pointAndMedia : this._data) {
            MediaObject mediaObject;
            DataPoint dataPoint = pointAndMedia.getPoint();
            if (dataPoint == null) continue;
            if (this._linkType.handlePhotos()) {
                mediaObject = pointAndMedia.getPhoto();
                if (dataPoint.getPhoto() != null) {
                    dataPoint.getPhoto().setDataPoint(null);
                }
                dataPoint.setPhoto((Photo)mediaObject);
                if (mediaObject != null) {
                    mediaObject.setDataPoint(dataPoint);
                }
            }
            if (!this._linkType.handleAudios()) continue;
            mediaObject = pointAndMedia.getAudio();
            if (dataPoint.getAudio() != null) {
                dataPoint.getAudio().setDataPoint(null);
            }
            dataPoint.setAudio((AudioClip)mediaObject);
            if (mediaObject == null) continue;
            mediaObject.setDataPoint(dataPoint);
        }
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        ArrayList<PointAndMedia> arrayList = new ArrayList<PointAndMedia>();
        for (PointAndMedia pointAndMedia : this._data) {
            DataPoint dataPoint = pointAndMedia.getPoint();
            if (dataPoint == null) continue;
            arrayList.add(new PointAndMedia(dataPoint, dataPoint.getPhoto(), dataPoint.getAudio()));
        }
        return new ConnectMultipleMediaCmd(this, this._linkType, arrayList);
    }
}

