/// <reference types="node" />
import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosPromise, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace orgpolicy_v2 {
    export interface Options extends GlobalOptions {
        version: 'v2';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Organization Policy API
     *
     * The Org Policy API allows users to configure governance rules on their GCP resources across the Cloud Resource Hierarchy.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const orgpolicy = google.orgpolicy('v2');
     * ```
     */
    export class Orgpolicy {
        context: APIRequestContext;
        folders: Resource$Folders;
        organizations: Resource$Organizations;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * Similar to PolicySpec but with an extra 'launch' field for launch reference. The PolicySpec here is specific for dry-run/darklaunch.
     */
    export interface Schema$GoogleCloudOrgpolicyV2AlternatePolicySpec {
        /**
         * Reference to the launch that will be used while audit logging and to control the launch. Should be set only in the alternate policy.
         */
        launch?: string | null;
        /**
         * Specify `Constraint` for configurations of Cloud Platform resources.
         */
        spec?: Schema$GoogleCloudOrgpolicyV2PolicySpec;
    }
    /**
     * A `constraint` describes a way to restrict resource's configuration. For example, you could enforce a constraint that controls which cloud services can be activated across an organization, or whether a Compute Engine instance can have serial port connections established. `Constraints` can be configured by the organization's policy administrator to fit the needs of the organization by setting a `policy` that includes `constraints` at different locations in the organization's resource hierarchy. Policies are inherited down the resource hierarchy from higher levels, but can also be overridden. For details about the inheritance rules please read about `policies`. `Constraints` have a default behavior determined by the `constraint_default` field, which is the enforcement behavior that is used in the absence of a `policy` being defined or inherited for the resource in question.
     */
    export interface Schema$GoogleCloudOrgpolicyV2Constraint {
        /**
         * Defines this constraint as being a BooleanConstraint.
         */
        booleanConstraint?: Schema$GoogleCloudOrgpolicyV2ConstraintBooleanConstraint;
        /**
         * The evaluation behavior of this constraint in the absence of 'Policy'.
         */
        constraintDefault?: string | null;
        /**
         * Detailed description of what this `Constraint` controls as well as how and where it is enforced. Mutable.
         */
        description?: string | null;
        /**
         * The human readable name. Mutable.
         */
        displayName?: string | null;
        /**
         * Defines this constraint as being a ListConstraint.
         */
        listConstraint?: Schema$GoogleCloudOrgpolicyV2ConstraintListConstraint;
        /**
         * Immutable. The resource name of the Constraint. Must be in one of the following forms: * `projects/{project_number\}/constraints/{constraint_name\}` * `folders/{folder_id\}/constraints/{constraint_name\}` * `organizations/{organization_id\}/constraints/{constraint_name\}` For example, "/projects/123/constraints/compute.disableSerialPortAccess".
         */
        name?: string | null;
    }
    /**
     * A `Constraint` that is either enforced or not. For example a constraint `constraints/compute.disableSerialPortAccess`. If it is enforced on a VM instance, serial port connections will not be opened to that instance.
     */
    export interface Schema$GoogleCloudOrgpolicyV2ConstraintBooleanConstraint {
    }
    /**
     * A `Constraint` that allows or disallows a list of string values, which are configured by an Organization's policy administrator with a `Policy`.
     */
    export interface Schema$GoogleCloudOrgpolicyV2ConstraintListConstraint {
        /**
         * Indicates whether values grouped into categories can be used in `Policy.allowed_values` and `Policy.denied_values`. For example, `"in:Python"` would match any value in the 'Python' group.
         */
        supportsIn?: boolean | null;
        /**
         * Indicates whether subtrees of Cloud Resource Manager resource hierarchy can be used in `Policy.allowed_values` and `Policy.denied_values`. For example, `"under:folders/123"` would match any resource under the 'folders/123' folder.
         */
        supportsUnder?: boolean | null;
    }
    /**
     * The response returned from the ListConstraints method.
     */
    export interface Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse {
        /**
         * The collection of constraints that are available on the targeted resource.
         */
        constraints?: Schema$GoogleCloudOrgpolicyV2Constraint[];
        /**
         * Page token used to retrieve the next page. This is currently not used.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response returned from the ListPolicies method. It will be empty if no `Policies` are set on the resource.
     */
    export interface Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse {
        /**
         * Page token used to retrieve the next page. This is currently not used, but the server may at any point start supplying a valid token.
         */
        nextPageToken?: string | null;
        /**
         * All `Policies` that exist on the resource. It will be empty if no `Policies` are set.
         */
        policies?: Schema$GoogleCloudOrgpolicyV2Policy[];
    }
    /**
     * Defines a Cloud Organization `Policy` which is used to specify `Constraints` for configurations of Cloud Platform resources.
     */
    export interface Schema$GoogleCloudOrgpolicyV2Policy {
        /**
         * Deprecated.
         */
        alternate?: Schema$GoogleCloudOrgpolicyV2AlternatePolicySpec;
        /**
         * Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         */
        name?: string | null;
        /**
         * Basic information about the Organization Policy.
         */
        spec?: Schema$GoogleCloudOrgpolicyV2PolicySpec;
    }
    /**
     * Defines a Cloud Organization `PolicySpec` which is used to specify `Constraints` for configurations of Cloud Platform resources.
     */
    export interface Schema$GoogleCloudOrgpolicyV2PolicySpec {
        /**
         * An opaque tag indicating the current version of the `Policy`, used for concurrency control. This field is ignored if used in a `CreatePolicy` request. When the `Policy` is returned from either a `GetPolicy` or a `ListPolicies` request, this `etag` indicates the version of the current `Policy` to use when executing a read-modify-write loop. When the `Policy` is returned from a `GetEffectivePolicy` request, the `etag` will be unset.
         */
        etag?: string | null;
        /**
         * Determines the inheritance behavior for this `Policy`. If `inherit_from_parent` is true, PolicyRules set higher up in the hierarchy (up to the closest root) are inherited and present in the effective policy. If it is false, then no rules are inherited, and this Policy becomes the new root for evaluation. This field can be set only for Policies which configure list constraints.
         */
        inheritFromParent?: boolean | null;
        /**
         * Ignores policies set above this resource and restores the `constraint_default` enforcement behavior of the specific `Constraint` at this resource. This field can be set in policies for either list or boolean constraints. If set, `rules` must be empty and `inherit_from_parent` must be set to false.
         */
        reset?: boolean | null;
        /**
         * Up to 10 PolicyRules are allowed. In Policies for boolean constraints, the following requirements apply: - There must be one and only one PolicyRule where condition is unset. - BooleanPolicyRules with conditions must set `enforced` to the opposite of the PolicyRule without a condition. - During policy evaluation, PolicyRules with conditions that are true for a target resource take precedence.
         */
        rules?: Schema$GoogleCloudOrgpolicyV2PolicySpecPolicyRule[];
        /**
         * Output only. The time stamp this was previously updated. This represents the last time a call to `CreatePolicy` or `UpdatePolicy` was made for that `Policy`.
         */
        updateTime?: string | null;
    }
    /**
     * A rule used to express this policy.
     */
    export interface Schema$GoogleCloudOrgpolicyV2PolicySpecPolicyRule {
        /**
         * Setting this to true means that all values are allowed. This field can be set only in Policies for list constraints.
         */
        allowAll?: boolean | null;
        /**
         * A condition which determines whether this rule is used in the evaluation of the policy. When set, the `expression` field in the `Expr' must include from 1 to 10 subexpressions, joined by the "||" or "&&" operators. Each subexpression must be of the form "resource.matchTag('/tag_key_short_name, 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id', 'tagValues/value_id')". where key_name and value_name are the resource names for Label Keys and Values. These names are available from the Tag Manager Service. An example expression is: "resource.matchTag('123456789/environment, 'prod')". or "resource.matchTagId('tagKeys/123', 'tagValues/456')".
         */
        condition?: Schema$GoogleTypeExpr;
        /**
         * Setting this to true means that all values are denied. This field can be set only in Policies for list constraints.
         */
        denyAll?: boolean | null;
        /**
         * If `true`, then the `Policy` is enforced. If `false`, then any configuration is acceptable. This field can be set only in Policies for boolean constraints.
         */
        enforce?: boolean | null;
        /**
         * List of values to be used for this PolicyRule. This field can be set only in Policies for list constraints.
         */
        values?: Schema$GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues;
    }
    /**
     * A message that holds specific allowed and denied values. This message can define specific values and subtrees of Cloud Resource Manager resource hierarchy (`Organizations`, `Folders`, `Projects`) that are allowed or denied. This is achieved by using the `under:` and optional `is:` prefixes. The `under:` prefix is used to denote resource subtree values. The `is:` prefix is used to denote specific values, and is required only if the value contains a ":". Values prefixed with "is:" are treated the same as values with no prefix. Ancestry subtrees must be in one of the following formats: - "projects/", e.g. "projects/tokyo-rain-123" - "folders/", e.g. "folders/1234" - "organizations/", e.g. "organizations/1234" The `supports_under` field of the associated `Constraint` defines whether ancestry prefixes can be used.
     */
    export interface Schema$GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues {
        /**
         * List of values allowed at this resource.
         */
        allowedValues?: string[] | null;
        /**
         * List of values denied at this resource.
         */
        deniedValues?: string[] | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \}
     */
    export interface Schema$GoogleProtobufEmpty {
    }
    /**
     * Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
     */
    export interface Schema$GoogleTypeExpr {
        /**
         * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string | null;
        /**
         * Textual representation of an expression in Common Expression Language syntax.
         */
        expression?: string | null;
        /**
         * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string | null;
        /**
         * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string | null;
    }
    export class Resource$Folders {
        context: APIRequestContext;
        constraints: Resource$Folders$Constraints;
        policies: Resource$Folders$Policies;
        constructor(context: APIRequestContext);
    }
    export class Resource$Folders$Constraints {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Lists `Constraints` that could be applied on the specified resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.constraints.list({
         *     // Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         *     pageSize: 'placeholder-value',
         *     // Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         *     pageToken: 'placeholder-value',
         *     // Required. The Cloud resource that parents the constraint. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'folders/my-folder',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "constraints": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Folders$Constraints$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Folders$Constraints$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>;
        list(params: Params$Resource$Folders$Constraints$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Folders$Constraints$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
        list(params: Params$Resource$Folders$Constraints$List, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
    }
    export interface Params$Resource$Folders$Constraints$List extends StandardParameters {
        /**
         * Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         */
        pageSize?: number;
        /**
         * Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         */
        pageToken?: string;
        /**
         * Required. The Cloud resource that parents the constraint. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
    }
    export class Resource$Folders$Policies {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy already exists on the given Cloud resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.policies.create({
         *     // Required. The Cloud resource that will parent the new Policy. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'folders/my-folder',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "alternate": {},
         *       //   "name": "my_name",
         *       //   "spec": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Folders$Policies$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Folders$Policies$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        create(params: Params$Resource$Folders$Policies$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Folders$Policies$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        create(params: Params$Resource$Folders$Policies$Create, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Deletes a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or Org Policy does not exist.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.policies.delete({
         *     // Required. Name of the policy to delete. See `Policy` for naming rules.
         *     name: 'folders/my-folder/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Folders$Policies$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Folders$Policies$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Folders$Policies$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Folders$Policies$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Folders$Policies$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets a `Policy` on a resource. If no `Policy` is set on the resource, NOT_FOUND is returned. The `etag` value can be used with `UpdatePolicy()` to update a `Policy` during read-modify-write.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.policies.get({
         *     // Required. Resource name of the policy. See `Policy` for naming requirements.
         *     name: 'folders/my-folder/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Folders$Policies$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Folders$Policies$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        get(params: Params$Resource$Folders$Policies$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Folders$Policies$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        get(params: Params$Resource$Folders$Policies$Get, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy and evaluating conditions. The returned `Policy` will not have an `etag` or `condition` set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.policies.getEffectivePolicy({
         *     // Required. The effective policy to compute. See `Policy` for naming rules.
         *     name: 'folders/my-folder/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getEffectivePolicy(params: Params$Resource$Folders$Policies$Geteffectivepolicy, options: StreamMethodOptions): GaxiosPromise<Readable>;
        getEffectivePolicy(params?: Params$Resource$Folders$Policies$Geteffectivepolicy, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        getEffectivePolicy(params: Params$Resource$Folders$Policies$Geteffectivepolicy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getEffectivePolicy(params: Params$Resource$Folders$Policies$Geteffectivepolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        getEffectivePolicy(params: Params$Resource$Folders$Policies$Geteffectivepolicy, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        getEffectivePolicy(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Retrieves all of the `Policies` that exist on a particular resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.policies.list({
         *     // Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         *     pageSize: 'placeholder-value',
         *     // Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         *     pageToken: 'placeholder-value',
         *     // Required. The target Cloud resource that parents the set of constraints and policies that will be returned from this call. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'folders/my-folder',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "policies": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Folders$Policies$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Folders$Policies$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>;
        list(params: Params$Resource$Folders$Policies$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Folders$Policies$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        list(params: Params$Resource$Folders$Policies$List, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        /**
         * Updates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the policy Note: the supplied policy will perform a full overwrite of all fields.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.folders.policies.patch({
         *     // Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         *     name: 'folders/my-folder/policies/my-policie',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "alternate": {},
         *       //   "name": "my_name",
         *       //   "spec": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Folders$Policies$Patch, options: StreamMethodOptions): GaxiosPromise<Readable>;
        patch(params?: Params$Resource$Folders$Policies$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        patch(params: Params$Resource$Folders$Policies$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Folders$Policies$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        patch(params: Params$Resource$Folders$Policies$Patch, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
    }
    export interface Params$Resource$Folders$Policies$Create extends StandardParameters {
        /**
         * Required. The Cloud resource that will parent the new Policy. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudOrgpolicyV2Policy;
    }
    export interface Params$Resource$Folders$Policies$Delete extends StandardParameters {
        /**
         * Required. Name of the policy to delete. See `Policy` for naming rules.
         */
        name?: string;
    }
    export interface Params$Resource$Folders$Policies$Get extends StandardParameters {
        /**
         * Required. Resource name of the policy. See `Policy` for naming requirements.
         */
        name?: string;
    }
    export interface Params$Resource$Folders$Policies$Geteffectivepolicy extends StandardParameters {
        /**
         * Required. The effective policy to compute. See `Policy` for naming rules.
         */
        name?: string;
    }
    export interface Params$Resource$Folders$Policies$List extends StandardParameters {
        /**
         * Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         */
        pageSize?: number;
        /**
         * Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         */
        pageToken?: string;
        /**
         * Required. The target Cloud resource that parents the set of constraints and policies that will be returned from this call. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Folders$Policies$Patch extends StandardParameters {
        /**
         * Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudOrgpolicyV2Policy;
    }
    export class Resource$Organizations {
        context: APIRequestContext;
        constraints: Resource$Organizations$Constraints;
        policies: Resource$Organizations$Policies;
        constructor(context: APIRequestContext);
    }
    export class Resource$Organizations$Constraints {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Lists `Constraints` that could be applied on the specified resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.constraints.list({
         *     // Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         *     pageSize: 'placeholder-value',
         *     // Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         *     pageToken: 'placeholder-value',
         *     // Required. The Cloud resource that parents the constraint. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'organizations/my-organization',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "constraints": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Organizations$Constraints$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Organizations$Constraints$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>;
        list(params: Params$Resource$Organizations$Constraints$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Organizations$Constraints$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
        list(params: Params$Resource$Organizations$Constraints$List, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
    }
    export interface Params$Resource$Organizations$Constraints$List extends StandardParameters {
        /**
         * Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         */
        pageSize?: number;
        /**
         * Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         */
        pageToken?: string;
        /**
         * Required. The Cloud resource that parents the constraint. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
    }
    export class Resource$Organizations$Policies {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy already exists on the given Cloud resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.policies.create({
         *     // Required. The Cloud resource that will parent the new Policy. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'organizations/my-organization',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "alternate": {},
         *       //   "name": "my_name",
         *       //   "spec": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Organizations$Policies$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Organizations$Policies$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        create(params: Params$Resource$Organizations$Policies$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Organizations$Policies$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        create(params: Params$Resource$Organizations$Policies$Create, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Deletes a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or Org Policy does not exist.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.policies.delete({
         *     // Required. Name of the policy to delete. See `Policy` for naming rules.
         *     name: 'organizations/my-organization/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Organizations$Policies$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Organizations$Policies$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Organizations$Policies$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Organizations$Policies$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Organizations$Policies$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets a `Policy` on a resource. If no `Policy` is set on the resource, NOT_FOUND is returned. The `etag` value can be used with `UpdatePolicy()` to update a `Policy` during read-modify-write.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.policies.get({
         *     // Required. Resource name of the policy. See `Policy` for naming requirements.
         *     name: 'organizations/my-organization/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Organizations$Policies$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Organizations$Policies$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        get(params: Params$Resource$Organizations$Policies$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Organizations$Policies$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        get(params: Params$Resource$Organizations$Policies$Get, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy and evaluating conditions. The returned `Policy` will not have an `etag` or `condition` set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.policies.getEffectivePolicy({
         *     // Required. The effective policy to compute. See `Policy` for naming rules.
         *     name: 'organizations/my-organization/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getEffectivePolicy(params: Params$Resource$Organizations$Policies$Geteffectivepolicy, options: StreamMethodOptions): GaxiosPromise<Readable>;
        getEffectivePolicy(params?: Params$Resource$Organizations$Policies$Geteffectivepolicy, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        getEffectivePolicy(params: Params$Resource$Organizations$Policies$Geteffectivepolicy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getEffectivePolicy(params: Params$Resource$Organizations$Policies$Geteffectivepolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        getEffectivePolicy(params: Params$Resource$Organizations$Policies$Geteffectivepolicy, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        getEffectivePolicy(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Retrieves all of the `Policies` that exist on a particular resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.policies.list({
         *     // Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         *     pageSize: 'placeholder-value',
         *     // Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         *     pageToken: 'placeholder-value',
         *     // Required. The target Cloud resource that parents the set of constraints and policies that will be returned from this call. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'organizations/my-organization',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "policies": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Organizations$Policies$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Organizations$Policies$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>;
        list(params: Params$Resource$Organizations$Policies$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Organizations$Policies$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        list(params: Params$Resource$Organizations$Policies$List, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        /**
         * Updates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the policy Note: the supplied policy will perform a full overwrite of all fields.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.organizations.policies.patch({
         *     // Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         *     name: 'organizations/my-organization/policies/my-policie',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "alternate": {},
         *       //   "name": "my_name",
         *       //   "spec": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Organizations$Policies$Patch, options: StreamMethodOptions): GaxiosPromise<Readable>;
        patch(params?: Params$Resource$Organizations$Policies$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        patch(params: Params$Resource$Organizations$Policies$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Organizations$Policies$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        patch(params: Params$Resource$Organizations$Policies$Patch, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
    }
    export interface Params$Resource$Organizations$Policies$Create extends StandardParameters {
        /**
         * Required. The Cloud resource that will parent the new Policy. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudOrgpolicyV2Policy;
    }
    export interface Params$Resource$Organizations$Policies$Delete extends StandardParameters {
        /**
         * Required. Name of the policy to delete. See `Policy` for naming rules.
         */
        name?: string;
    }
    export interface Params$Resource$Organizations$Policies$Get extends StandardParameters {
        /**
         * Required. Resource name of the policy. See `Policy` for naming requirements.
         */
        name?: string;
    }
    export interface Params$Resource$Organizations$Policies$Geteffectivepolicy extends StandardParameters {
        /**
         * Required. The effective policy to compute. See `Policy` for naming rules.
         */
        name?: string;
    }
    export interface Params$Resource$Organizations$Policies$List extends StandardParameters {
        /**
         * Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         */
        pageSize?: number;
        /**
         * Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         */
        pageToken?: string;
        /**
         * Required. The target Cloud resource that parents the set of constraints and policies that will be returned from this call. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Organizations$Policies$Patch extends StandardParameters {
        /**
         * Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudOrgpolicyV2Policy;
    }
    export class Resource$Projects {
        context: APIRequestContext;
        constraints: Resource$Projects$Constraints;
        policies: Resource$Projects$Policies;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Constraints {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Lists `Constraints` that could be applied on the specified resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.constraints.list({
         *     // Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         *     pageSize: 'placeholder-value',
         *     // Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         *     pageToken: 'placeholder-value',
         *     // Required. The Cloud resource that parents the constraint. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "constraints": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Constraints$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Projects$Constraints$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>;
        list(params: Params$Resource$Projects$Constraints$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Constraints$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
        list(params: Params$Resource$Projects$Constraints$List, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListConstraintsResponse>): void;
    }
    export interface Params$Resource$Projects$Constraints$List extends StandardParameters {
        /**
         * Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         */
        pageSize?: number;
        /**
         * Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         */
        pageToken?: string;
        /**
         * Required. The Cloud resource that parents the constraint. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
    }
    export class Resource$Projects$Policies {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy already exists on the given Cloud resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.policies.create({
         *     // Required. The Cloud resource that will parent the new Policy. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "alternate": {},
         *       //   "name": "my_name",
         *       //   "spec": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Policies$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Projects$Policies$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        create(params: Params$Resource$Projects$Policies$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Policies$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        create(params: Params$Resource$Projects$Policies$Create, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Deletes a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or Org Policy does not exist.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.policies.delete({
         *     // Required. Name of the policy to delete. See `Policy` for naming rules.
         *     name: 'projects/my-project/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Policies$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Projects$Policies$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleProtobufEmpty>;
        delete(params: Params$Resource$Projects$Policies$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Policies$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Policies$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets a `Policy` on a resource. If no `Policy` is set on the resource, NOT_FOUND is returned. The `etag` value can be used with `UpdatePolicy()` to update a `Policy` during read-modify-write.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.policies.get({
         *     // Required. Resource name of the policy. See `Policy` for naming requirements.
         *     name: 'projects/my-project/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Policies$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Projects$Policies$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        get(params: Params$Resource$Projects$Policies$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Policies$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        get(params: Params$Resource$Projects$Policies$Get, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy and evaluating conditions. The returned `Policy` will not have an `etag` or `condition` set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.policies.getEffectivePolicy({
         *     // Required. The effective policy to compute. See `Policy` for naming rules.
         *     name: 'projects/my-project/policies/my-policie',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getEffectivePolicy(params: Params$Resource$Projects$Policies$Geteffectivepolicy, options: StreamMethodOptions): GaxiosPromise<Readable>;
        getEffectivePolicy(params?: Params$Resource$Projects$Policies$Geteffectivepolicy, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        getEffectivePolicy(params: Params$Resource$Projects$Policies$Geteffectivepolicy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getEffectivePolicy(params: Params$Resource$Projects$Policies$Geteffectivepolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        getEffectivePolicy(params: Params$Resource$Projects$Policies$Geteffectivepolicy, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        getEffectivePolicy(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        /**
         * Retrieves all of the `Policies` that exist on a particular resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.policies.list({
         *     // Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         *     pageSize: 'placeholder-value',
         *     // Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         *     pageToken: 'placeholder-value',
         *     // Required. The target Cloud resource that parents the set of constraints and policies that will be returned from this call. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "policies": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Policies$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Projects$Policies$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>;
        list(params: Params$Resource$Projects$Policies$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Policies$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        list(params: Params$Resource$Projects$Policies$List, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2ListPoliciesResponse>): void;
        /**
         * Updates a Policy. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the policy Note: the supplied policy will perform a full overwrite of all fields.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/orgpolicy.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const orgpolicy = google.orgpolicy('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await orgpolicy.projects.policies.patch({
         *     // Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         *     name: 'projects/my-project/policies/my-policie',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "alternate": {},
         *       //   "name": "my_name",
         *       //   "spec": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternate": {},
         *   //   "name": "my_name",
         *   //   "spec": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Policies$Patch, options: StreamMethodOptions): GaxiosPromise<Readable>;
        patch(params?: Params$Resource$Projects$Policies$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudOrgpolicyV2Policy>;
        patch(params: Params$Resource$Projects$Policies$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Policies$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        patch(params: Params$Resource$Projects$Policies$Patch, callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudOrgpolicyV2Policy>): void;
    }
    export interface Params$Resource$Projects$Policies$Create extends StandardParameters {
        /**
         * Required. The Cloud resource that will parent the new Policy. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudOrgpolicyV2Policy;
    }
    export interface Params$Resource$Projects$Policies$Delete extends StandardParameters {
        /**
         * Required. Name of the policy to delete. See `Policy` for naming rules.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Policies$Get extends StandardParameters {
        /**
         * Required. Resource name of the policy. See `Policy` for naming requirements.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Policies$Geteffectivepolicy extends StandardParameters {
        /**
         * Required. The effective policy to compute. See `Policy` for naming rules.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Policies$List extends StandardParameters {
        /**
         * Size of the pages to be returned. This is currently unsupported and will be ignored. The server may at any point start using this field to limit page size.
         */
        pageSize?: number;
        /**
         * Page token used to retrieve the next page. This is currently unsupported and will be ignored. The server may at any point start using this field.
         */
        pageToken?: string;
        /**
         * Required. The target Cloud resource that parents the set of constraints and policies that will be returned from this call. Must be in one of the following forms: * `projects/{project_number\}` * `projects/{project_id\}` * `folders/{folder_id\}` * `organizations/{organization_id\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Policies$Patch extends StandardParameters {
        /**
         * Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number\}/policies/{constraint_name\}` * `folders/{folder_id\}/policies/{constraint_name\}` * `organizations/{organization_id\}/policies/{constraint_name\}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id\}/policies/{constraint_name\}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudOrgpolicyV2Policy;
    }
    export {};
}
