"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWriteStream = exports.createReadStream = void 0;
var stream_1 = __importDefault(require("stream"));
var url_1 = require("../tools/url");
var path_1 = require("../tools/path");
var request_1 = require("../request");
var response_1 = require("../response");
var NOOP = function () { };
function createReadStream(context, filePath, options) {
    if (options === void 0) { options = {}; }
    var PassThroughStream = stream_1.default.PassThrough;
    var outStream = new PassThroughStream();
    getFileStream(context, filePath, options)
        .then(function (stream) {
        stream.pipe(outStream);
    })
        .catch(function (err) {
        outStream.emit("error", err);
    });
    return outStream;
}
exports.createReadStream = createReadStream;
function createWriteStream(context, filePath, options, callback) {
    if (options === void 0) { options = {}; }
    if (callback === void 0) { callback = NOOP; }
    var PassThroughStream = stream_1.default.PassThrough;
    var writeStream = new PassThroughStream();
    var headers = {};
    if (options.overwrite === false) {
        headers["If-None-Match"] = "*";
    }
    var requestOptions = (0, request_1.prepareRequestOptions)({
        url: (0, url_1.joinURL)(context.remoteURL, (0, path_1.encodePath)(filePath)),
        method: "PUT",
        headers: headers,
        data: writeStream,
        maxRedirects: 0
    }, context, options);
    (0, request_1.request)(requestOptions)
        .then(function (response) { return (0, response_1.handleResponseCode)(context, response); })
        .then(function (response) {
        // Fire callback asynchronously to avoid errors
        setTimeout(function () {
            callback(response);
        }, 0);
    })
        .catch(function (err) {
        writeStream.emit("error", err);
    });
    return writeStream;
}
exports.createWriteStream = createWriteStream;
function getFileStream(context, filePath, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var headers, rangeHeader, requestOptions, response, responseError;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    headers = {};
                    if (typeof options.range === "object" && typeof options.range.start === "number") {
                        rangeHeader = "bytes=".concat(options.range.start, "-");
                        if (typeof options.range.end === "number") {
                            rangeHeader = "".concat(rangeHeader).concat(options.range.end);
                        }
                        headers.Range = rangeHeader;
                    }
                    requestOptions = (0, request_1.prepareRequestOptions)({
                        url: (0, url_1.joinURL)(context.remoteURL, (0, path_1.encodePath)(filePath)),
                        method: "GET",
                        headers: headers,
                        responseType: "stream"
                    }, context, options);
                    return [4 /*yield*/, (0, request_1.request)(requestOptions)];
                case 1:
                    response = _a.sent();
                    (0, response_1.handleResponseCode)(context, response);
                    if (headers.Range && response.status !== 206) {
                        responseError = new Error("Invalid response code for partial request: ".concat(response.status));
                        responseError.status = response.status;
                        throw responseError;
                    }
                    if (options.callback) {
                        setTimeout(function () {
                            options.callback(response);
                        }, 0);
                    }
                    return [2 /*return*/, response.data];
            }
        });
    });
}
