"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalisePath = exports.getAllDirectories = exports.encodePath = void 0;
var path_posix_1 = require("path-posix");
var SEP_PATH_POSIX = "__PATH_SEPARATOR_POSIX__";
var SEP_PATH_WINDOWS = "__PATH_SEPARATOR_WINDOWS__";
function encodePath(path) {
    var replaced = path.replace(/\//g, SEP_PATH_POSIX).replace(/\\\\/g, SEP_PATH_WINDOWS);
    var formatted = encodeURIComponent(replaced);
    return formatted
        .split(SEP_PATH_WINDOWS)
        .join("\\\\")
        .split(SEP_PATH_POSIX)
        .join("/");
}
exports.encodePath = encodePath;
function getAllDirectories(path) {
    if (!path || path === "/")
        return [];
    var currentPath = path;
    var output = [];
    do {
        output.push(currentPath);
        currentPath = (0, path_posix_1.dirname)(currentPath);
    } while (currentPath && currentPath !== "/");
    return output;
}
exports.getAllDirectories = getAllDirectories;
function normalisePath(pathStr) {
    var normalisedPath = pathStr;
    if (normalisedPath[0] !== "/") {
        normalisedPath = "/" + normalisedPath;
    }
    if (/^.+\/$/.test(normalisedPath)) {
        normalisedPath = normalisedPath.substr(0, normalisedPath.length - 1);
    }
    return normalisedPath;
}
exports.normalisePath = normalisePath;
