/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.repository.internal.MavenMetadata;
import org.apache.maven.repository.internal.MavenSnapshotMetadata;
import org.eclipse.aether.artifact.Artifact;

final class RemoteSnapshotMetadata
extends MavenSnapshotMetadata {
    public static final String DEFAULT_SNAPSHOT_TIMESTAMP_FORMAT = "yyyyMMdd.HHmmss";
    public static final TimeZone DEFAULT_SNAPSHOT_TIME_ZONE = TimeZone.getTimeZone("Etc/UTC");
    private final Map<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();

    RemoteSnapshotMetadata(Artifact artifact, boolean legacyFormat, Date timestamp) {
        super(RemoteSnapshotMetadata.createRepositoryMetadata(artifact, legacyFormat), null, legacyFormat, timestamp);
    }

    private RemoteSnapshotMetadata(Metadata metadata, File file2, boolean legacyFormat, Date timestamp) {
        super(metadata, file2, legacyFormat, timestamp);
    }

    @Override
    public MavenMetadata setFile(File file2) {
        return new RemoteSnapshotMetadata(this.metadata, file2, this.legacyFormat, this.timestamp);
    }

    public String getExpandedVersion(Artifact artifact) {
        String key2 = this.getKey(artifact.getClassifier(), artifact.getExtension());
        return this.versions.get(key2).getVersion();
    }

    @Override
    protected void merge(Metadata recessive) {
        String lastUpdated;
        Snapshot snapshot2;
        if (this.metadata.getVersioning() == null) {
            SimpleDateFormat utcDateFormatter = new SimpleDateFormat(DEFAULT_SNAPSHOT_TIMESTAMP_FORMAT);
            utcDateFormatter.setCalendar(new GregorianCalendar());
            utcDateFormatter.setTimeZone(DEFAULT_SNAPSHOT_TIME_ZONE);
            snapshot2 = new Snapshot();
            snapshot2.setBuildNumber(RemoteSnapshotMetadata.getBuildNumber(recessive) + 1);
            snapshot2.setTimestamp(utcDateFormatter.format(this.timestamp));
            Versioning versioning = new Versioning();
            versioning.setSnapshot(snapshot2);
            versioning.setLastUpdatedTimestamp(this.timestamp);
            lastUpdated = versioning.getLastUpdated();
            this.metadata.setVersioning(versioning);
        } else {
            snapshot2 = this.metadata.getVersioning().getSnapshot();
            lastUpdated = this.metadata.getVersioning().getLastUpdated();
        }
        for (Artifact artifact : this.artifacts) {
            String version = artifact.getVersion();
            if (version.endsWith("SNAPSHOT")) {
                String qualifier = snapshot2.getTimestamp() + '-' + snapshot2.getBuildNumber();
                version = version.substring(0, version.length() - "SNAPSHOT".length()) + qualifier;
            }
            SnapshotVersion sv = new SnapshotVersion();
            sv.setClassifier(artifact.getClassifier());
            sv.setExtension(artifact.getExtension());
            sv.setVersion(version);
            sv.setUpdated(lastUpdated);
            this.versions.put(this.getKey(sv.getClassifier(), sv.getExtension()), sv);
        }
        this.artifacts.clear();
        Versioning versioning = recessive.getVersioning();
        if (versioning != null) {
            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                String key2 = this.getKey(sv.getClassifier(), sv.getExtension());
                if (this.versions.containsKey(key2)) continue;
                this.versions.put(key2, sv);
            }
        }
        if (!this.legacyFormat) {
            this.metadata.getVersioning().setSnapshotVersions(new ArrayList<SnapshotVersion>(this.versions.values()));
        }
    }

    private static int getBuildNumber(Metadata metadata) {
        Snapshot snapshot2;
        int number = 0;
        Versioning versioning = metadata.getVersioning();
        if (versioning != null && (snapshot2 = versioning.getSnapshot()) != null && snapshot2.getBuildNumber() > 0) {
            number = snapshot2.getBuildNumber();
        }
        return number;
    }
}

