/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.factory;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Order;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.spring.beans.ImportedBy;
import io.micronaut.spring.context.factory.MicronautBeanFactory;
import io.micronaut.spring.core.type.BeanDefinitionSpringMetadata;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.springframework.aop.framework.autoproxy.InfrastructureAdvisorAutoProxyCreator;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

@Context
@Order(value=-2147483648)
@Introspected(classes={InfrastructureAdvisorAutoProxyCreator.class})
@Internal
final class ImportBeanRegistrarProcessor {
    private final List<BeanRegistration<ImportBeanDefinitionRegistrar>> registrars;
    private final MicronautBeanFactory beanFactory;

    public ImportBeanRegistrarProcessor(List<BeanRegistration<ImportBeanDefinitionRegistrar>> registrars, MicronautBeanFactory beanFactory) {
        this.registrars = registrars;
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    void runRegistrars() {
        for (BeanRegistration<ImportBeanDefinitionRegistrar> registrar : this.registrars) {
            BeanDefinition beanDefinition = registrar.getBeanDefinition();
            Class importingType = beanDefinition.classValue(ImportedBy.class).orElse(null);
            BeanDefinitionSpringMetadata springMetadata = importingType != null ? new BeanDefinitionSpringMetadata(this.beanFactory.getBeanContext().getBeanDefinition(importingType)) : new BeanDefinitionSpringMetadata(beanDefinition);
            ((ImportBeanDefinitionRegistrar)registrar.bean()).registerBeanDefinitions((AnnotationMetadata)springMetadata, (BeanDefinitionRegistry)this.beanFactory, (BeanNameGenerator)AnnotationBeanNameGenerator.INSTANCE);
        }
    }
}

