/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharSequenceBackedByArray;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.ImmutableText;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharArrayUtil {
    public static void getChars(@NotNull CharSequence src, char @NotNull [] dst, int dstOffset) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(0);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(1);
        }
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, char @NotNull [] dst, int dstOffset, int len) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(2);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(3);
        }
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, char @NotNull [] dst, int srcOffset, int dstOffset, int len) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(4);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(5);
        }
        if (src instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i = buffer.position();
                buffer.position(i + srcOffset);
                buffer.get(dst, dstOffset, len);
                buffer.position(i);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(srcOffset, srcOffset + len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
        }
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = src.charAt(j);
        }
    }

    public static char @Nullable [] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    public static char @NotNull [] fromSequence(@NotNull CharSequence seq) {
        char[] underlying;
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(6);
        }
        return (underlying = CharArrayUtil.fromSequenceWithoutCopying(seq)) != null ? (char[])underlying.clone() : CharArrayUtil.fromSequence(seq, 0, seq.length());
    }

    public static char @NotNull [] fromSequence(@NotNull CharSequence seq, int start, int end) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(7);
        }
        char[] result2 = new char[end - start];
        CharArrayUtil.getChars(seq, result2, start, 0, end - start);
        if (result2 == null) {
            CharArrayUtil.$$$reportNull$$$0(8);
        }
        return result2;
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset2, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(9);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(10);
        }
        return CharArrayUtil.shiftForward(buffer, offset2, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(11);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(12);
        }
        int limit = Math.min(endOffset, buffer.length());
        for (int offset2 = startOffset; offset2 < limit; ++offset2) {
            int i;
            char c = buffer.charAt(offset2);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset2;
        }
        return endOffset;
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset2, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(18);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(19);
        }
        return CharArrayUtil.shiftBackward(buffer, 0, offset2, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset2;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(20);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(21);
        }
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset2 = maxOffset; offset2 >= minOffset; --offset2) {
            int i;
            char c = buffer.charAt(offset2);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset2;
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset2, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(26);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(27);
        }
        if (offset2 >= buffer.length()) {
            return offset2;
        }
        while (offset2 >= 0) {
            int i;
            char c = buffer.charAt(offset2);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset2;
        }
        return offset2;
    }

    public static boolean regionMatches(char @NotNull [] buffer, int start, int end, @NotNull CharSequence s) {
        int len;
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(28);
        }
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(29);
        }
        if (start + (len = s.length()) > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[start + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int start, int end, @NotNull CharSequence s) {
        int len;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(30);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(31);
        }
        if (start + (len = s.length()) > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(start + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static void assertRegionIndicesInRange(int s1Length, int start1, int end1, int s2Length, int start2, int end2) {
        if (start1 < 0 || start1 > end1 || end1 > s1Length || start2 < 0 || start2 > end2 || end2 > s2Length) {
            throw new IllegalArgumentException("Indices out of bounds: (" + start1 + ", " + end1 + ") of CharSequence length " + s1Length + " vs (" + start2 + ", " + end2 + ") of CharSequence length " + s2Length);
        }
    }

    public static boolean regionMatches(@NotNull CharSequence s1, int start1, int end1, @NotNull CharSequence s2, int start2, int end2) {
        if (s1 == null) {
            CharArrayUtil.$$$reportNull$$$0(32);
        }
        if (s2 == null) {
            CharArrayUtil.$$$reportNull$$$0(33);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        CharArrayUtil.assertRegionIndicesInRange(s1.length(), start1, end1, s2.length(), start2, end2);
        int i = start1;
        int j = start2;
        while (i < end1) {
            if (s1.charAt(i) != s2.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int offset2, @NotNull CharSequence s) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(36);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(37);
        }
        if (offset2 + s.length() > buffer.length()) {
            return false;
        }
        if (offset2 < 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (buffer.charAt(offset2 + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(char @NotNull [] buffer, char symbol2, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(46);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer[i] != symbol2) continue;
            return i;
        }
        return -1;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(54);
        }
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ImmutableCharSequence createImmutableCharSequence(@NotNull CharSequence sequence2) {
        if (sequence2 == null) {
            CharArrayUtil.$$$reportNull$$$0(57);
        }
        ImmutableText immutableText = ImmutableText.valueOf((Object)sequence2);
        if (immutableText == null) {
            CharArrayUtil.$$$reportNull$$$0(58);
        }
        return immutableText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 53: 
            case 58: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 53: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 6: 
            case 7: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 8: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/CharArrayUtil";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 28: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer1";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer2";
                break;
            }
            case 40: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsSequence";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/CharArrayUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSequence";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndents";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createImmutableCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromSequence";
                break;
            }
            case 8: 
            case 53: 
            case 58: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shiftForward";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shiftForwardCarefully";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shiftBackward";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shiftForwardUntil";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shiftBackwardUntil";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "regionMatches";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getIndents";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "containLineBreaks";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyOrSpaces";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "readerFromCharSequence";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createImmutableCharSequence";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 53: 
            case 58: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

