/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.wagon.shared;

import org.apache.maven.wagon.providers.http.httpclient.HttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Contract;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadingBehavior;
import org.apache.maven.wagon.providers.http.httpclient.client.ServiceUnavailableRetryStrategy;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StandardServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public StandardServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        int statusCode = response.getStatusLine().getStatusCode();
        boolean retryableStatusCode = statusCode == 408 || statusCode == 429 || statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
        return executionCount <= this.maxRetries && retryableStatusCode;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

