/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.cluster.HashRing;
import org.opensearch.ad.model.ADTaskProfile;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADTaskProfileAction;
import org.opensearch.ad.transport.ADTaskProfileNodeRequest;
import org.opensearch.ad.transport.ADTaskProfileNodeResponse;
import org.opensearch.ad.transport.ADTaskProfileRequest;
import org.opensearch.ad.transport.ADTaskProfileResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class ADTaskProfileTransportAction
extends TransportNodesAction<ADTaskProfileRequest, ADTaskProfileResponse, ADTaskProfileNodeRequest, ADTaskProfileNodeResponse> {
    private ADTaskManager adTaskManager;
    private HashRing hashRing;

    @Inject
    public ADTaskProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ADTaskManager adTaskManager, HashRing hashRing) {
        super(ADTaskProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, ADTaskProfileRequest::new, ADTaskProfileNodeRequest::new, "management", ADTaskProfileNodeResponse.class);
        this.adTaskManager = adTaskManager;
        this.hashRing = hashRing;
    }

    protected ADTaskProfileResponse newResponse(ADTaskProfileRequest request, List<ADTaskProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new ADTaskProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ADTaskProfileNodeRequest newNodeRequest(ADTaskProfileRequest request) {
        return new ADTaskProfileNodeRequest(request);
    }

    protected ADTaskProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ADTaskProfileNodeResponse(in);
    }

    protected ADTaskProfileNodeResponse nodeOperation(ADTaskProfileNodeRequest request) {
        String remoteNodeId = request.getParentTask().getNodeId();
        Version remoteAdVersion = this.hashRing.getAdVersion(remoteNodeId);
        ADTaskProfile adTaskProfile = this.adTaskManager.getLocalADTaskProfilesByDetectorId(request.getDetectorId());
        return new ADTaskProfileNodeResponse(this.clusterService.localNode(), adTaskProfile, remoteAdVersion);
    }
}

