/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.internal.JceKeyCipher;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.lang3.ArrayUtils;

class RsaJceKeyCipher
extends JceKeyCipher {
    private static final Logger LOGGER = Logger.getLogger(RsaJceKeyCipher.class.getName());
    private static final Pattern SUPPORTED_TRANSFORMATIONS = Pattern.compile("RSA/ECB/(?:PKCS1Padding|OAEPWith(SHA-(?:1|224|256|384|512))AndMGF1Padding)", 2);
    private final AlgorithmParameterSpec parameterSpec_;
    private final String transformation_;

    RsaJceKeyCipher(PublicKey wrappingKey, PrivateKey unwrappingKey, String transformation) {
        super(wrappingKey, unwrappingKey);
        Matcher matcher = SUPPORTED_TRANSFORMATIONS.matcher(transformation);
        if (matcher.matches()) {
            String hashUnknownCase = matcher.group(1);
            if (hashUnknownCase != null) {
                MGF1ParameterSpec mgf1Spec;
                String hash = hashUnknownCase.toUpperCase();
                this.transformation_ = "RSA/ECB/OAEPPadding";
                switch (hash) {
                    case "SHA-1": {
                        mgf1Spec = MGF1ParameterSpec.SHA1;
                        break;
                    }
                    case "SHA-224": {
                        LOGGER.warning(transformation + " is not officially supported by the JceMasterKey");
                        mgf1Spec = MGF1ParameterSpec.SHA224;
                        break;
                    }
                    case "SHA-256": {
                        mgf1Spec = MGF1ParameterSpec.SHA256;
                        break;
                    }
                    case "SHA-384": {
                        mgf1Spec = MGF1ParameterSpec.SHA384;
                        break;
                    }
                    case "SHA-512": {
                        mgf1Spec = MGF1ParameterSpec.SHA512;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported algorithm: " + transformation);
                    }
                }
                this.parameterSpec_ = new OAEPParameterSpec(hash, "MGF1", mgf1Spec, PSource.PSpecified.DEFAULT);
            } else {
                this.transformation_ = transformation;
                this.parameterSpec_ = null;
            }
        } else {
            LOGGER.warning(transformation + " is not officially supported by the JceMasterKey");
            this.transformation_ = transformation;
            this.parameterSpec_ = null;
        }
    }

    @Override
    JceKeyCipher.WrappingData buildWrappingCipher(Key key, Map<String, String> encryptionContext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation_);
        cipher.init(1, key, this.parameterSpec_);
        return new JceKeyCipher.WrappingData(cipher, ArrayUtils.EMPTY_BYTE_ARRAY);
    }

    @Override
    Cipher buildUnwrappingCipher(Key key, byte[] extraInfo, int offset, Map<String, String> encryptionContext) throws GeneralSecurityException {
        if (extraInfo.length != offset) {
            throw new IllegalArgumentException("Extra info must be empty for RSA keys");
        }
        Cipher cipher = Cipher.getInstance(this.transformation_);
        cipher.init(2, key, this.parameterSpec_);
        return cipher;
    }
}

