import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  ImportStacksToStackSetInput,
  ImportStacksToStackSetOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface ImportStacksToStackSetCommandInput
  extends ImportStacksToStackSetInput {}
export interface ImportStacksToStackSetCommandOutput
  extends ImportStacksToStackSetOutput,
    __MetadataBearer {}
export declare class ImportStacksToStackSetCommand extends $Command<
  ImportStacksToStackSetCommandInput,
  ImportStacksToStackSetCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: ImportStacksToStackSetCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ImportStacksToStackSetCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ImportStacksToStackSetCommandInput,
    ImportStacksToStackSetCommandOutput
  >;
  private serialize;
  private deserialize;
}
