"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const fs_1 = require("fs");
const path_1 = require("path");
const typescript_1 = __importDefault(require("typescript"));
const documents_1 = require("../../../../../src/lib/documents");
const ls_config_1 = require("../../../../../src/ls-config");
const plugins_1 = require("../../../../../src/plugins");
const InlayHintProvider_1 = require("../../../../../src/plugins/typescript/features/InlayHintProvider");
const utils_1 = require("../../../../../src/utils");
const test_utils_1 = require("../../test-utils");
function setup(workspaceDir, filePath) {
    const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
    const configManager = new ls_config_1.LSConfigManager();
    const allEnable = {
        enumMemberValues: { enabled: true },
        functionLikeReturnTypes: { enabled: true },
        parameterNames: { enabled: 'all', suppressWhenArgumentMatchesName: false },
        parameterTypes: { enabled: true },
        propertyDeclarationTypes: { enabled: true },
        variableTypes: { enabled: true }
    };
    configManager.updateTsJsUserPreferences({
        typescript: {
            inlayHints: allEnable
        },
        javascript: {
            inlayHints: allEnable
        }
    });
    const lsAndTsDocResolver = new plugins_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(workspaceDir)], configManager);
    const plugin = new InlayHintProvider_1.InlayHintProviderImpl(lsAndTsDocResolver);
    const document = docManager.openDocument({
        uri: (0, utils_1.pathToUrl)(filePath),
        text: typescript_1.default.sys.readFile(filePath) || ''
    });
    return { plugin, document, docManager, lsAndTsDocResolver };
}
async function executeTest(inputFile, { workspaceDir, dir }) {
    const expected = 'expectedv2.json';
    const { plugin, document } = setup(workspaceDir, inputFile);
    const inlayHints = await plugin.getInlayHints(document, {
        start: { line: 0, character: 0 },
        end: document.positionAt(document.getTextLength())
    });
    const expectedFile = (0, path_1.join)(dir, expected);
    if (process.argv.includes('--debug')) {
        (0, fs_1.writeFileSync)((0, path_1.join)(dir, 'debug.svelte'), appendInlayHintAsComment());
    }
    const snapshotFormatter = await (0, test_utils_1.createJsonSnapshotFormatter)(dir);
    await (0, test_utils_1.updateSnapshotIfFailedOrEmpty)({
        assertion() {
            assert.deepStrictEqual(JSON.parse(JSON.stringify(inlayHints)), JSON.parse((0, fs_1.readFileSync)(expectedFile, 'utf-8')));
        },
        expectedFile,
        getFileContent() {
            return snapshotFormatter(inlayHints);
        },
        rootDir: __dirname
    });
    function appendInlayHintAsComment() {
        if (!inlayHints) {
            return document.getText();
        }
        const offsetMap = new Map();
        for (const inlayHint of inlayHints) {
            const offset = document.offsetAt(inlayHint.position);
            const text = Array.isArray(inlayHint.label)
                ? inlayHint.label.map((l) => l.value).join('')
                : inlayHint.label;
            const comment = `/*${inlayHint.paddingLeft ? ' ' : ''}${text}${inlayHint.paddingRight ? ' ' : ''}*/`;
            offsetMap.set(offset, (offsetMap.get(offset) ?? []).concat(comment));
        }
        const offsets = Array.from(offsetMap.keys()).sort((a, b) => a - b);
        const parts = [];
        for (let index = 0; index < offsets.length; index++) {
            const offset = offsets[index];
            parts.push(document.getText().slice(offsets[index - 1], offset), ...(offsetMap.get(offset) ?? []));
        }
        parts.push(document.getText().slice(offsets[offsets.length - 1]));
        return parts.join('');
    }
}
const executeTests = (0, test_utils_1.createSnapshotTester)(executeTest);
describe('InlayHintProvider', function () {
    executeTests({
        dir: (0, path_1.join)(__dirname, 'fixtures'),
        workspaceDir: (0, path_1.join)(__dirname, 'fixtures'),
        context: this
    });
});
//# sourceMappingURL=index.test.js.map