/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.TomcatPrincipal;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationMapping;
import org.apache.catalina.core.ApplicationMappingImpl;
import org.apache.catalina.core.ApplicationPart;
import org.apache.catalina.core.ApplicationPushBuilder;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.TLSUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.ContextBind;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.impl.InvalidContentTypeException;
import org.apache.tomcat.util.http.fileupload.impl.SizeException;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.fileupload.servlet.ServletRequestContext;
import org.apache.tomcat.util.http.parser.AcceptLanguage;
import org.apache.tomcat.util.http.parser.Upgrade;
import org.apache.tomcat.util.res.StringManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class Request
implements HttpServletRequest {
    private static final String HTTP_UPGRADE_HEADER_NAME = "upgrade";
    private static final Log log = LogFactory.getLog(Request.class);
    protected org.apache.coyote.Request coyoteRequest;
    @Deprecated
    protected static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    protected static final StringManager sm = StringManager.getManager(Request.class);
    protected Cookie[] cookies = null;
    @Deprecated
    protected final SimpleDateFormat[] formats;
    @Deprecated
    private static final SimpleDateFormat[] formatsTemplate = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final Locale defaultLocale = Locale.getDefault();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected boolean sslAttributesParsed = false;
    protected final ArrayList<Locale> locales = new ArrayList();
    private final transient HashMap<String, Object> notes = new HashMap();
    protected String authType = null;
    protected DispatcherType internalDispatcherType = null;
    protected final InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean parametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean cookiesConverted = false;
    protected boolean secure = false;
    protected transient Subject subject = null;
    protected static final int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap<String, String[]> parameterMap = new ParameterMap();
    protected Collection<Part> parts = null;
    protected Exception partsParseException = null;
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected boolean requestedSessionSSL = false;
    protected boolean localesParsed = false;
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String peerAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected String localName = null;
    private volatile AsyncContextImpl asyncContext = null;
    protected Boolean asyncSupported = null;
    private HttpServletRequest applicationRequest = null;
    protected Connector connector;
    protected FilterChain filterChain = null;
    protected final MappingData mappingData = new MappingData();
    private final ApplicationMapping applicationMapping = new ApplicationMapping(this.mappingData);
    protected RequestFacade facade = null;
    protected Response response = null;
    protected B2CConverter URIConverter = null;
    private static final Map<String, SpecialAttributeAdapter> specialAttributes = new HashMap<String, SpecialAttributeAdapter>();

    public Request() {
        this.formats = new SimpleDateFormat[formatsTemplate.length];
        for (int i = 0; i < this.formats.length; ++i) {
            this.formats[i] = (SimpleDateFormat)formatsTemplate[i].clone();
        }
    }

    public void setCoyoteRequest(org.apache.coyote.Request request) {
        this.coyoteRequest = request;
        this.inputBuffer.setRequest(request);
    }

    public org.apache.coyote.Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    protected void addPathParameter(String string, String string2) {
        this.coyoteRequest.addPathParameter(string, string2);
    }

    protected String getPathParameter(String string) {
        return this.coyoteRequest.getPathParameter(string);
    }

    public void setAsyncSupported(boolean bl) {
        this.asyncSupported = bl;
    }

    public void recycle() {
        this.internalDispatcherType = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.parametersParsed = false;
        if (this.parts != null) {
            for (Part part : this.parts) {
                try {
                    part.delete();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.warn((Object)sm.getString("coyoteRequest.deletePartFailed", new Object[]{part.getName()}), throwable);
                }
            }
            this.parts = null;
        }
        this.partsParseException = null;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.peerAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.attributes.clear();
        this.sslAttributesParsed = false;
        this.notes.clear();
        this.recycleSessionInfo();
        this.recycleCookieInfo(false);
        if (this.getDiscardFacades()) {
            this.parameterMap = new ParameterMap();
        } else {
            this.parameterMap.setLocked(false);
            this.parameterMap.clear();
        }
        this.mappingData.recycle();
        this.applicationMapping.recycle();
        this.applicationRequest = null;
        if (this.getDiscardFacades()) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
        this.asyncSupported = null;
        if (this.asyncContext != null) {
            this.asyncContext.recycle();
            this.asyncContext = null;
        }
    }

    protected void recycleSessionInfo() {
        if (this.session != null) {
            try {
                this.session.endAccess();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.warn((Object)sm.getString("coyoteRequest.sessionEndAccessFail"), throwable);
            }
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        this.requestedSessionSSL = false;
    }

    protected void recycleCookieInfo(boolean bl) {
        this.cookiesParsed = false;
        this.cookiesConverted = false;
        this.cookies = null;
        if (bl) {
            this.getCoyoteRequest().getCookies().recycle();
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Context getContext() {
        return this.mappingData.context;
    }

    public boolean getDiscardFacades() {
        return this.connector == null ? true : this.connector.getDiscardFacades();
    }

    @Deprecated
    public void setContext(Context context) {
        this.mappingData.context = context;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public Host getHost() {
        return this.mappingData.host;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public HttpServletRequest getRequest() {
        if (this.facade == null) {
            this.facade = new RequestFacade(this);
        }
        if (this.applicationRequest == null) {
            this.applicationRequest = this.facade;
        }
        return this.applicationRequest;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        while (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            httpServletRequest2 = ((HttpServletRequestWrapper)httpServletRequest2).getRequest();
        }
        if (httpServletRequest2 != this.facade) {
            throw new IllegalArgumentException(sm.getString("request.illegalWrap"));
        }
        this.applicationRequest = httpServletRequest;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter b2CConverter) {
        this.URIConverter = b2CConverter;
    }

    public Wrapper getWrapper() {
        return this.mappingData.wrapper;
    }

    @Deprecated
    public void setWrapper(Wrapper wrapper) {
        this.mappingData.wrapper = wrapper;
    }

    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
        if (this.response.getStatus() == 413) {
            this.checkSwallowInput();
        }
    }

    public Object getNote(String string) {
        return this.notes.get(string);
    }

    public void removeNote(String string) {
        this.notes.remove(string);
    }

    public void setLocalPort(int n) {
        this.localPort = n;
    }

    public void setNote(String string, Object object) {
        this.notes.put(string, object);
    }

    public void setRemoteAddr(String string) {
        this.remoteAddr = string;
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setServerPort(int n) {
        this.coyoteRequest.setServerPort(n);
    }

    public Object getAttribute(String string) {
        SpecialAttributeAdapter specialAttributeAdapter = specialAttributes.get(string);
        if (specialAttributeAdapter != null) {
            return specialAttributeAdapter.get(this, string);
        }
        Object object = this.attributes.get(string);
        if (object != null) {
            return object;
        }
        object = this.coyoteRequest.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (!this.sslAttributesParsed && TLSUtil.isTLSRequestAttribute(string)) {
            this.coyoteRequest.action(ActionCode.REQ_SSL_ATTRIBUTE, (Object)this.coyoteRequest);
            object = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (object != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", object);
            }
            if ((object = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
                this.attributes.put("javax.servlet.request.cipher_suite", object);
            }
            if ((object = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
                this.attributes.put("javax.servlet.request.key_size", object);
            }
            if ((object = this.coyoteRequest.getAttribute("javax.servlet.request.ssl_session_id")) != null) {
                this.attributes.put("javax.servlet.request.ssl_session_id", object);
            }
            if ((object = this.coyoteRequest.getAttribute("javax.servlet.request.ssl_session_mgr")) != null) {
                this.attributes.put("javax.servlet.request.ssl_session_mgr", object);
            }
            if ((object = this.coyoteRequest.getAttribute("org.apache.tomcat.util.net.secure_protocol_version")) != null) {
                this.attributes.put("org.apache.tomcat.util.net.secure_protocol_version", object);
            }
            if ((object = this.coyoteRequest.getAttribute("org.apache.tomcat.util.net.secure_requested_protocol_versions")) != null) {
                this.attributes.put("org.apache.tomcat.util.net.secure_requested_protocol_versions", object);
            }
            if ((object = this.coyoteRequest.getAttribute("org.apache.tomcat.util.net.secure_requested_ciphers")) != null) {
                this.attributes.put("org.apache.tomcat.util.net.secure_requested_ciphers", object);
            }
            object = this.attributes.get(string);
            this.sslAttributesParsed = true;
        }
        return object;
    }

    public long getContentLengthLong() {
        return this.coyoteRequest.getContentLengthLong();
    }

    public Enumeration<String> getAttributeNames() {
        if (this.isSecure() && !this.sslAttributesParsed) {
            this.getAttribute("javax.servlet.request.X509Certificate");
        }
        HashSet<String> hashSet = new HashSet<String>(this.attributes.keySet());
        return Collections.enumeration(hashSet);
    }

    public String getCharacterEncoding() {
        String string = this.coyoteRequest.getCharacterEncoding();
        if (string != null) {
            return string;
        }
        Context context = this.getContext();
        if (context != null) {
            return context.getRequestCharacterEncoding();
        }
        return null;
    }

    private Charset getCharset() {
        String string;
        Charset charset = null;
        try {
            charset = this.coyoteRequest.getCharset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (charset != null) {
            return charset;
        }
        Context context = this.getContext();
        if (context != null && (string = context.getRequestCharacterEncoding()) != null) {
            try {
                return B2CConverter.getCharset((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return Constants.DEFAULT_BODY_CHARSET;
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public void setContentType(String string) {
        this.coyoteRequest.setContentType(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration<Locale> getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return Collections.enumeration(this.locales);
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.add(defaultLocale);
        return Collections.enumeration(arrayList);
    }

    public String getParameter(String string) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(string);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String[] stringArray = this.getParameterValues(string);
            this.parameterMap.put(string, stringArray);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String string) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(string);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    @Deprecated
    public String getRealPath(String string) {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        ServletContext servletContext = context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_HOST_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
            this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
        }
        return this.remoteAddr;
    }

    public String getPeerAddr() {
        if (this.peerAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_PEER_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
            this.peerAddr = this.coyoteRequest.peerAddr().toString();
        }
        return this.peerAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else {
                this.coyoteRequest.action(ActionCode.REQ_HOST_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.coyoteRequest.action(ActionCode.REQ_REMOTEPORT_ATTRIBUTE, (Object)this.coyoteRequest);
            this.remotePort = this.coyoteRequest.getRemotePort();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            this.coyoteRequest.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, (Object)this.coyoteRequest);
            this.localName = this.coyoteRequest.localName().toString();
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
            this.localAddr = this.coyoteRequest.localAddr().toString();
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.coyoteRequest.action(ActionCode.REQ_LOCALPORT_ATTRIBUTE, (Object)this.coyoteRequest);
            this.localPort = this.coyoteRequest.getLocalPort();
        }
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(35);
        if (n > -1) {
            log.warn((Object)sm.getString("request.fragmentInDispatchPath", new Object[]{string}));
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            return context.getServletContext().getRequestDispatcher(string);
        }
        String string2 = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (string2 == null) {
            string2 = this.getServletPath();
        }
        String string3 = this.getPathInfo();
        String string4 = null;
        string4 = string3 == null ? string2 : string2 + string3;
        int n2 = string4.lastIndexOf(47);
        String string5 = null;
        string5 = context.getDispatchersUseEncodedPaths() ? (n2 >= 0 ? URLEncoder.DEFAULT.encode(string4.substring(0, n2 + 1), StandardCharsets.UTF_8) + string : URLEncoder.DEFAULT.encode(string4, StandardCharsets.UTF_8) + string) : (n2 >= 0 ? string4.substring(0, n2 + 1) + string : string4 + string);
        return context.getServletContext().getRequestDispatcher(string5);
    }

    public String getScheme() {
        return this.coyoteRequest.scheme().toString();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String string) {
        boolean bl;
        if (string.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.getAttributes().remove(string);
        }
        if (bl = this.attributes.containsKey(string)) {
            Object object = this.attributes.get(string);
            this.attributes.remove(string);
            this.notifyAttributeRemoved(string, object);
        }
    }

    public void setAttribute(String string, Object object) {
        Object object2;
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        SpecialAttributeAdapter specialAttributeAdapter = specialAttributes.get(string);
        if (specialAttributeAdapter != null) {
            specialAttributeAdapter.set(this, string, object);
            return;
        }
        if (Globals.IS_SECURITY_ENABLED && string.equals("org.apache.tomcat.sendfile.filename")) {
            try {
                object2 = new File(object.toString()).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new SecurityException(sm.getString("coyoteRequest.sendfileNotCanonical", new Object[]{object}), iOException);
            }
            System.getSecurityManager().checkRead((String)object2);
            object = object2;
        }
        object2 = this.attributes.put(string, object);
        if (string.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.setAttribute(string, object);
        }
        this.notifyAttributeAssigned(string, object, object2);
    }

    private void notifyAttributeAssigned(String string, Object object, Object object2) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Object[] objectArray = context.getApplicationEventListeners();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        boolean bl = object2 != null;
        ServletRequestAttributeEvent servletRequestAttributeEvent = null;
        servletRequestAttributeEvent = bl ? new ServletRequestAttributeEvent(context.getServletContext(), (ServletRequest)this.getRequest(), string, object2) : new ServletRequestAttributeEvent(context.getServletContext(), (ServletRequest)this.getRequest(), string, object);
        for (Object object3 : objectArray) {
            if (!(object3 instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)object3;
            try {
                if (bl) {
                    servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
                    continue;
                }
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.attributes.put("javax.servlet.error.exception", throwable);
                context.getLogger().error((Object)sm.getString("coyoteRequest.attributeEvent"), throwable);
            }
        }
    }

    private void notifyAttributeRemoved(String string, Object object) {
        Context context = this.getContext();
        Object[] objectArray = context.getApplicationEventListeners();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(context.getServletContext(), (ServletRequest)this.getRequest(), string, object);
        for (Object object2 : objectArray) {
            if (!(object2 instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)object2;
            try {
                servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.attributes.put("javax.servlet.error.exception", throwable);
                context.getLogger().error((Object)sm.getString("coyoteRequest.attributeEvent"), throwable);
            }
        }
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this.usingReader) {
            return;
        }
        Charset charset = B2CConverter.getCharset((String)string);
        this.coyoteRequest.setCharset(charset);
    }

    public ServletContext getServletContext() {
        return this.getContext().getServletContext();
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this.getRequest(), (ServletResponse)this.response.getResponse());
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!this.isAsyncSupported()) {
            IllegalStateException illegalStateException = new IllegalStateException(sm.getString("request.asyncNotSupported"));
            log.warn((Object)sm.getString("coyoteRequest.noAsync", new Object[]{StringUtils.join(this.getNonAsyncClassNames())}), (Throwable)illegalStateException);
            throw illegalStateException;
        }
        if (this.asyncContext == null) {
            this.asyncContext = new AsyncContextImpl(this);
        }
        this.asyncContext.setStarted(this.getContext(), servletRequest, servletResponse, servletRequest == this.getRequest() && servletResponse == this.getResponse().getResponse());
        this.asyncContext.setTimeout(this.getConnector().getAsyncTimeout());
        return this.asyncContext;
    }

    private Set<String> getNonAsyncClassNames() {
        FilterChain filterChain;
        HashSet<String> hashSet = new HashSet<String>();
        Wrapper wrapper = this.getWrapper();
        if (!wrapper.isAsyncSupported()) {
            hashSet.add(wrapper.getServletClass());
        }
        if ((filterChain = this.getFilterChain()) instanceof ApplicationFilterChain) {
            ((ApplicationFilterChain)filterChain).findNonAsyncFilters(hashSet);
        } else {
            hashSet.add(sm.getString("coyoteRequest.filterAsyncSupportUnknown"));
        }
        for (Container container = wrapper; container != null; container = container.getParent()) {
            container.getPipeline().findNonAsyncValves(hashSet);
        }
        return hashSet;
    }

    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return this.asyncContext.isStarted();
    }

    public boolean isAsyncDispatching() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_DISPATCHING, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public boolean isAsyncCompleting() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_COMPLETING, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public boolean isAsync() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_ASYNC, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public boolean isAsyncSupported() {
        if (this.asyncSupported == null) {
            return true;
        }
        return this.asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException(sm.getString("request.notAsync"));
        }
        return this.asyncContext;
    }

    public AsyncContextImpl getAsyncContextInternal() {
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        if (this.internalDispatcherType == null) {
            return DispatcherType.REQUEST;
        }
        return this.internalDispatcherType;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesConverted) {
            this.convertCookies();
        }
        int n = 0;
        if (this.cookies != null) {
            n = this.cookies.length;
        }
        Cookie[] cookieArray = new Cookie[n + 1];
        if (this.cookies != null) {
            System.arraycopy(this.cookies, 0, cookieArray, 0, n);
        }
        cookieArray[n] = cookie;
        this.cookies = cookieArray;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookiesConverted = true;
        this.cookies = null;
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void setAuthType(String string) {
        this.authType = string;
    }

    public void setPathInfo(String string) {
        this.mappingData.pathInfo.setString(string);
    }

    public void setRequestedSessionCookie(boolean bl) {
        this.requestedSessionCookie = bl;
    }

    public void setRequestedSessionId(String string) {
        this.requestedSessionId = string;
    }

    public void setRequestedSessionURL(boolean bl) {
        this.requestedSessionURL = bl;
    }

    public void setRequestedSessionSSL(boolean bl) {
        this.requestedSessionSSL = bl;
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.coyoteRequest.decodedURI();
    }

    public void setUserPrincipal(Principal principal) {
        if (Globals.IS_SECURITY_ENABLED && principal != null) {
            if (this.subject == null) {
                HttpSession httpSession = this.getSession(false);
                if (httpSession == null) {
                    this.subject = this.newSubject(principal);
                } else {
                    this.subject = (Subject)httpSession.getAttribute("javax.security.auth.subject");
                    if (this.subject == null) {
                        this.subject = this.newSubject(principal);
                        httpSession.setAttribute("javax.security.auth.subject", (Object)this.subject);
                    } else {
                        this.subject.getPrincipals().add(principal);
                    }
                }
            } else {
                this.subject.getPrincipals().add(principal);
            }
        }
        this.userPrincipal = principal;
    }

    private Subject newSubject(Principal principal) {
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        return subject;
    }

    public ApplicationPushBuilder newPushBuilder() {
        return this.newPushBuilder(this);
    }

    public ApplicationPushBuilder newPushBuilder(HttpServletRequest httpServletRequest) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.coyoteRequest.action(ActionCode.IS_PUSH_SUPPORTED, (Object)atomicBoolean);
        if (atomicBoolean.get()) {
            return new ApplicationPushBuilder(this, httpServletRequest);
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) throws IOException, ServletException {
        HttpUpgradeHandler httpUpgradeHandler;
        InstanceManager instanceManager = null;
        try {
            if (InternalHttpUpgradeHandler.class.isAssignableFrom(clazz)) {
                httpUpgradeHandler = (HttpUpgradeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                instanceManager = this.getContext().getInstanceManager();
                httpUpgradeHandler = (HttpUpgradeHandler)instanceManager.newInstance(clazz);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | NamingException exception) {
            throw new ServletException((Throwable)exception);
        }
        UpgradeToken upgradeToken = new UpgradeToken(httpUpgradeHandler, (ContextBind)this.getContext(), instanceManager, this.getUpgradeProtocolName(clazz));
        this.coyoteRequest.action(ActionCode.UPGRADE, (Object)upgradeToken);
        this.response.setStatus(101);
        return (T)httpUpgradeHandler;
    }

    private String getUpgradeProtocolName(Class<? extends HttpUpgradeHandler> clazz) {
        List list;
        String string = this.response.getHeader(HTTP_UPGRADE_HEADER_NAME);
        if (string == null && (list = Upgrade.parse(this.getHeaders(HTTP_UPGRADE_HEADER_NAME))) != null && list.size() == 1) {
            string = ((Upgrade)list.get(0)).toString();
        }
        if (string == null) {
            string = clazz.getName();
        }
        return string;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        int n = this.mappingData.contextSlashCount;
        if (n == 0) {
            return "";
        }
        String string = this.getServletContext().getContextPath();
        String string2 = this.getRequestURI();
        int n2 = 0;
        if (!this.getContext().getAllowMultipleLeadingForwardSlashInPath()) {
            while (++n2 < string2.length() && string2.charAt(n2) == '/') {
            }
            string2 = string2.substring(--n2);
        }
        char[] cArray = string2.toCharArray();
        while (n > 0 && (n2 = this.nextSlash(cArray, n2 + 1)) != -1) {
            --n;
        }
        String string3 = n2 == -1 ? string2 : string2.substring(0, n2);
        string3 = this.removePathParameters(string3);
        string3 = UDecoder.URLDecode((String)string3, (Charset)this.connector.getURICharset());
        string3 = org.apache.tomcat.util.http.RequestUtil.normalize((String)string3);
        boolean bl = string.equals(string3);
        while (!bl && n2 != -1) {
            string3 = (n2 = this.nextSlash(cArray, n2 + 1)) == -1 ? string2 : string2.substring(0, n2);
            string3 = this.removePathParameters(string3);
            string3 = UDecoder.URLDecode((String)string3, (Charset)this.connector.getURICharset());
            string3 = org.apache.tomcat.util.http.RequestUtil.normalize((String)string3);
            bl = string.equals(string3);
        }
        if (bl) {
            if (n2 == -1) {
                return string2;
            }
            return string2.substring(0, n2);
        }
        throw new IllegalStateException(sm.getString("coyoteRequest.getContextPath.ise", new Object[]{string, string2}));
    }

    private String removePathParameters(String string) {
        int n;
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string.substring(0, n2));
        while ((n = string.indexOf(47, n2)) != -1) {
            n2 = string.indexOf(59, n);
            if (n2 == -1) {
                stringBuilder.append(string.substring(n));
                break;
            }
            stringBuilder.append(string.substring(n, n2));
        }
        return stringBuilder.toString();
    }

    private int nextSlash(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == '/') {
                return i;
            }
            if (this.connector.getEncodedSolidusHandlingInternal() != EncodedSolidusHandling.DECODE || cArray[i] != '%' || i + 2 >= n2 || cArray[i + 1] != '2' || cArray[i + 2] != 'f' && cArray[i + 2] != 'F') continue;
            return i;
        }
        return -1;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesConverted) {
            this.convertCookies();
        }
        return this.cookies;
    }

    public ServerCookies getServerCookies() {
        this.parseCookies();
        return this.coyoteRequest.getCookies();
    }

    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1L;
        }
        long l = FastHttpDateFormat.parseDate((String)string2);
        if (l != -1L) {
            return l;
        }
        throw new IllegalArgumentException(string2);
    }

    public String getHeader(String string) {
        return this.coyoteRequest.getHeader(string);
    }

    public Enumeration<String> getHeaders(String string) {
        return this.coyoteRequest.getMimeHeaders().values(string);
    }

    public Enumeration<String> getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public ApplicationMappingImpl getHttpServletMapping() {
        return this.applicationMapping.getHttpServletMapping();
    }

    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    public String getPathInfo() {
        return this.mappingData.pathInfo.toString();
    }

    public String getPathTranslated() {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return context.getServletContext().getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        return this.coyoteRequest.queryString().toString();
    }

    public String getRemoteUser() {
        if (this.userPrincipal == null) {
            return null;
        }
        return this.userPrincipal.getName();
    }

    public MessageBytes getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        return RequestUtil.getRequestURL(this);
    }

    public String getServletPath() {
        return this.mappingData.wrapperPath.toString();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        Session session = this.doGetSession(bl);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionURL;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        ClassLoader classLoader = context.bind(Globals.IS_SECURITY_ENABLED, null);
        try {
            Manager manager = context.getManager();
            if (manager == null) {
                boolean bl = false;
                return bl;
            }
            Session session = null;
            try {
                session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (session == null || !session.isValid()) {
                int n;
                if (this.getMappingData().contexts == null) {
                    boolean bl = false;
                    return bl;
                }
                for (n = this.getMappingData().contexts.length; n > 0; --n) {
                    Context context2 = this.getMappingData().contexts[n - 1];
                    try {
                        if (context2.getManager().findSession(this.requestedSessionId) == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                n = 0;
                return n != 0;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
        }
    }

    public boolean isUserInRole(String string) {
        if (this.userPrincipal == null) {
            return false;
        }
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if ("*".equals(string)) {
            return false;
        }
        if ("**".equals(string) && !context.findSecurityRole("**")) {
            return this.userPrincipal != null;
        }
        Realm realm = context.getRealm();
        if (realm == null) {
            return false;
        }
        return realm.hasRole(this.getWrapper(), this.userPrincipal, string);
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal instanceof TomcatPrincipal) {
            GSSCredential gSSCredential = ((TomcatPrincipal)this.userPrincipal).getGssCredential();
            if (gSSCredential != null) {
                int n = -1;
                try {
                    n = gSSCredential.getRemainingLifetime();
                }
                catch (IllegalStateException | GSSException exception) {
                    log.warn((Object)sm.getString("coyoteRequest.gssLifetimeFail", new Object[]{this.userPrincipal.getName()}), (Throwable)exception);
                }
                if (n <= 0) {
                    try {
                        this.logout();
                    }
                    catch (ServletException servletException) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return ((TomcatPrincipal)this.userPrincipal).getUserPrincipal();
        }
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    public void changeSessionId(String string) {
        Context context;
        if (this.requestedSessionId != null && this.requestedSessionId.length() > 0) {
            this.requestedSessionId = string;
        }
        if ((context = this.getContext()) != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        if (this.response != null) {
            Cookie cookie = ApplicationSessionCookieConfig.createSessionCookie(context, string, this.isSecure());
            this.response.addSessionCookieInternal(cookie);
        }
    }

    public String changeSessionId() {
        Session session = this.getSessionInternal(false);
        if (session == null) {
            throw new IllegalStateException(sm.getString("coyoteRequest.changeSessionId"));
        }
        Manager manager = this.getContext().getManager();
        String string = this.rotateSessionId(manager, session);
        this.changeSessionId(string);
        return string;
    }

    private String rotateSessionId(Manager manager, Session session) {
        if (manager instanceof ManagerBase) {
            return ((ManagerBase)manager).rotateSessionId(session);
        }
        String string = null;
        boolean bl = true;
        do {
            string = manager.getSessionIdGenerator().generateSessionId();
            try {
                if (manager.findSession(string) != null) continue;
                bl = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (bl);
        manager.changeSessionId(session, string);
        return string;
    }

    public Session getSessionInternal(boolean bl) {
        return this.doGetSession(bl);
    }

    public boolean isParametersParsed() {
        return this.parametersParsed;
    }

    public boolean isFinished() {
        return this.coyoteRequest.isFinished();
    }

    protected void checkSwallowInput() {
        Context context = this.getContext();
        if (context != null && !context.getSwallowAbortedUploads()) {
            this.coyoteRequest.action(ActionCode.DISABLE_SWALLOW_INPUT, null);
        }
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (httpServletResponse.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.authenticate.ise"));
        }
        return this.getContext().getAuthenticator().authenticate(this, httpServletResponse);
    }

    public void login(String string, String string2) throws ServletException {
        if (this.getAuthType() != null || this.getRemoteUser() != null || this.getUserPrincipal() != null) {
            throw new ServletException(sm.getString("coyoteRequest.alreadyAuthenticated"));
        }
        this.getContext().getAuthenticator().login(string, string2, this);
    }

    public void logout() throws ServletException {
        this.getContext().getAuthenticator().logout(this);
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        this.parseParts(true);
        if (this.partsParseException != null) {
            if (this.partsParseException instanceof IOException) {
                throw (IOException)this.partsParseException;
            }
            if (this.partsParseException instanceof IllegalStateException) {
                throw (IllegalStateException)this.partsParseException;
            }
            if (this.partsParseException instanceof ServletException) {
                throw (ServletException)((Object)this.partsParseException);
            }
        }
        return this.parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseParts(boolean bl) {
        if (this.parts != null || this.partsParseException != null) {
            return;
        }
        Context context = this.getContext();
        MultipartConfigElement multipartConfigElement = this.getWrapper().getMultipartConfigElement();
        if (multipartConfigElement == null) {
            if (context.getAllowCasualMultipartParsing()) {
                multipartConfigElement = new MultipartConfigElement(null, (long)this.connector.getMaxPostSize(), (long)this.connector.getMaxPostSize(), this.connector.getMaxPostSize());
            } else {
                if (bl) {
                    this.partsParseException = new IllegalStateException(sm.getString("coyoteRequest.noMultipartConfig"));
                    return;
                }
                this.parts = Collections.emptyList();
                return;
            }
        }
        int n = this.getConnector().getMaxParameterCount();
        Parameters parameters = this.coyoteRequest.getParameters();
        parameters.setLimit(n);
        boolean bl2 = false;
        try {
            File file;
            String string = multipartConfigElement.getLocation();
            if (string == null || string.length() == 0) {
                file = (File)context.getServletContext().getAttribute("javax.servlet.context.tempdir");
            } else {
                file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File((File)context.getServletContext().getAttribute("javax.servlet.context.tempdir"), string).getAbsoluteFile();
                }
            }
            if (!file.exists() && context.getCreateUploadTargets()) {
                log.warn((Object)sm.getString("coyoteRequest.uploadCreate", new Object[]{file.getAbsolutePath(), this.getMappingData().wrapper.getName()}));
                if (!file.mkdirs()) {
                    log.warn((Object)sm.getString("coyoteRequest.uploadCreateFail", new Object[]{file.getAbsolutePath()}));
                }
            }
            if (!file.isDirectory()) {
                parameters.setParseFailedReason(Parameters.FailReason.MULTIPART_CONFIG_INVALID);
                this.partsParseException = new IOException(sm.getString("coyoteRequest.uploadLocationInvalid", new Object[]{file}));
                return;
            }
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            try {
                diskFileItemFactory.setRepository(file.getCanonicalFile());
            }
            catch (IOException iOException) {
                parameters.setParseFailedReason(Parameters.FailReason.IO_ERROR);
                this.partsParseException = iOException;
                if (this.partsParseException != null || !bl2) {
                    parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                }
                return;
            }
            diskFileItemFactory.setSizeThreshold(multipartConfigElement.getFileSizeThreshold());
            ServletFileUpload servletFileUpload = new ServletFileUpload();
            servletFileUpload.setFileItemFactory((FileItemFactory)diskFileItemFactory);
            servletFileUpload.setFileSizeMax(multipartConfigElement.getMaxFileSize());
            servletFileUpload.setSizeMax(multipartConfigElement.getMaxRequestSize());
            if (n > -1) {
                servletFileUpload.setFileCountMax((long)(n - parameters.size()));
            }
            this.parts = new ArrayList<Part>();
            try {
                List list = servletFileUpload.parseRequest((RequestContext)new ServletRequestContext((HttpServletRequest)this));
                int n2 = this.getConnector().getMaxPostSize();
                int n3 = 0;
                Charset charset = this.getCharset();
                for (FileItem fileItem : list) {
                    ApplicationPart applicationPart = new ApplicationPart(fileItem, file);
                    this.parts.add(applicationPart);
                    if (applicationPart.getSubmittedFileName() != null) continue;
                    String string2 = applicationPart.getName();
                    if (n2 >= 0) {
                        n3 += string2.getBytes(charset).length;
                        ++n3;
                        n3 = (int)((long)n3 + applicationPart.getSize());
                        if (++n3 > n2) {
                            parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                            throw new IllegalStateException(sm.getString("coyoteRequest.maxPostSizeExceeded"));
                        }
                    }
                    String string3 = null;
                    try {
                        string3 = applicationPart.getString(charset.name());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    parameters.addParameter(string2, string3);
                }
                bl2 = true;
            }
            catch (InvalidContentTypeException invalidContentTypeException) {
                parameters.setParseFailedReason(Parameters.FailReason.INVALID_CONTENT_TYPE);
                this.partsParseException = new ServletException((Throwable)invalidContentTypeException);
            }
            catch (SizeException sizeException) {
                parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                this.checkSwallowInput();
                this.partsParseException = new IllegalStateException(sizeException);
            }
            catch (IOException iOException) {
                parameters.setParseFailedReason(Parameters.FailReason.IO_ERROR);
                this.partsParseException = iOException;
            }
            catch (IllegalStateException illegalStateException) {
                this.checkSwallowInput();
                this.partsParseException = illegalStateException;
            }
        }
        finally {
            if (this.partsParseException != null || !bl2) {
                parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
            }
        }
    }

    public Part getPart(String string) throws IOException, IllegalStateException, ServletException {
        for (Part part : this.getParts()) {
            if (!string.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    protected Session doGetSession(boolean bl) {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = context.getManager();
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("request.session.failed", new Object[]{this.requestedSessionId, iOException.getMessage()}), (Throwable)iOException);
                } else {
                    log.info((Object)sm.getString("request.session.failed", new Object[]{this.requestedSessionId, iOException.getMessage()}));
                }
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!bl) {
            return null;
        }
        boolean bl2 = context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE);
        if (bl2 && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        String string = this.getRequestedSessionId();
        if (!this.requestedSessionSSL) {
            if ("/".equals(context.getSessionCookiePath()) && this.isRequestedSessionIdFromCookie()) {
                if (context.getValidateClientProvidedNewSessionId()) {
                    boolean bl3 = false;
                    for (Container container : this.getHost().findChildren()) {
                        Manager manager2 = ((Context)container).getManager();
                        if (manager2 == null) continue;
                        try {
                            if (manager2.findSession(string) == null) continue;
                            bl3 = true;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl3) {
                        string = null;
                    }
                }
            } else {
                string = null;
            }
        }
        this.session = manager.createSession(string);
        if (this.session != null && bl2) {
            Cookie cookie = ApplicationSessionCookieConfig.createSessionCookie(context, this.session.getIdInternal(), this.isSecure());
            this.response.addSessionCookieInternal(cookie);
        }
        if (this.session == null) {
            return null;
        }
        this.session.access();
        return this.session;
    }

    protected String unescape(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (++i >= string.length()) {
                throw new IllegalArgumentException();
            }
            c = string.charAt(i);
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private CookieProcessor getCookieProcessor() {
        Context context = this.getContext();
        if (context == null) {
            return new Rfc6265CookieProcessor();
        }
        return context.getCookieProcessor();
    }

    protected void parseCookies() {
        if (this.cookiesParsed) {
            return;
        }
        this.cookiesParsed = true;
        ServerCookies serverCookies = this.coyoteRequest.getCookies();
        serverCookies.setLimit(this.connector.getMaxCookieCount());
        this.getCookieProcessor().parseCookieHeader(this.coyoteRequest.getMimeHeaders(), serverCookies);
    }

    protected void convertCookies() {
        if (this.cookiesConverted) {
            return;
        }
        this.cookiesConverted = true;
        this.parseCookies();
        ServerCookies serverCookies = this.coyoteRequest.getCookies();
        int n = serverCookies.getCookieCount();
        if (n <= 0) {
            return;
        }
        this.cookies = new Cookie[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ServerCookie serverCookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(serverCookie.getName().toString(), null);
                int n3 = serverCookie.getVersion();
                cookie.setVersion(n3);
                serverCookie.getValue().getByteChunk().setCharset(this.getCookieProcessor().getCharset());
                cookie.setValue(this.unescape(serverCookie.getValue().toString()));
                cookie.setPath(this.unescape(serverCookie.getPath().toString()));
                String string = serverCookie.getDomain().toString();
                if (string != null) {
                    cookie.setDomain(this.unescape(string));
                }
                String string2 = serverCookie.getComment().toString();
                cookie.setComment(n3 == 1 ? this.unescape(string2) : null);
                this.cookies[n2++] = cookie;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (n2 < n) {
            Cookie[] cookieArray = new Cookie[n2];
            System.arraycopy(this.cookies, 0, cookieArray, 0, n2);
            this.cookies = cookieArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void parseParameters() {
        block39: {
            this.parametersParsed = true;
            Parameters parameters = this.coyoteRequest.getParameters();
            boolean bl = false;
            try {
                int n;
                int n2 = this.getConnector().getMaxParameterCount();
                if (this.parts != null && n2 > 0) {
                    n2 -= this.parts.size();
                }
                parameters.setLimit(n2);
                Charset charset = this.getCharset();
                boolean bl2 = this.connector.getUseBodyEncodingForURI();
                parameters.setCharset(charset);
                if (bl2) {
                    parameters.setQueryStringCharset(charset);
                }
                parameters.handleQueryParameters();
                if (this.usingInputStream || this.usingReader) {
                    bl = true;
                    return;
                }
                String string = this.getContentType();
                if (string == null) {
                    string = "";
                }
                if ("multipart/form-data".equals(string = (n = string.indexOf(59)) >= 0 ? string.substring(0, n).trim() : string.trim())) {
                    this.parseParts(false);
                    bl = true;
                    return;
                }
                if (!this.getConnector().isParseBodyMethod(this.getMethod())) {
                    bl = true;
                    return;
                }
                if (!"application/x-www-form-urlencoded".equals(string)) {
                    bl = true;
                    return;
                }
                int n3 = this.getContentLength();
                if (n3 > 0) {
                    int n4 = this.connector.getMaxPostSize();
                    if (n4 >= 0 && n3 > n4) {
                        Context context = this.getContext();
                        if (context != null && context.getLogger().isDebugEnabled()) {
                            context.getLogger().debug((Object)sm.getString("coyoteRequest.postTooLarge"));
                        }
                        this.checkSwallowInput();
                        parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                        return;
                    }
                    byte[] byArray = null;
                    if (n3 < 8192) {
                        if (this.postData == null) {
                            this.postData = new byte[8192];
                        }
                        byArray = this.postData;
                    } else {
                        byArray = new byte[n3];
                    }
                    try {
                        this.readPostBodyFully(byArray, n3);
                    }
                    catch (IOException iOException) {
                        Context context = this.getContext();
                        if (context != null && context.getLogger().isDebugEnabled()) {
                            context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)iOException);
                        }
                        parameters.setParseFailedReason(Parameters.FailReason.CLIENT_DISCONNECT);
                        if (!bl) {
                            parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                        }
                        return;
                    }
                    parameters.processParameters(byArray, 0, n3);
                } else if ("chunked".equalsIgnoreCase(this.coyoteRequest.getHeader("transfer-encoding"))) {
                    byte[] byArray = null;
                    try {
                        byArray = this.readChunkedPostBody();
                    }
                    catch (IllegalStateException illegalStateException) {
                        parameters.setParseFailedReason(Parameters.FailReason.POST_TOO_LARGE);
                        Context context = this.getContext();
                        if (context != null && context.getLogger().isDebugEnabled()) {
                            context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)illegalStateException);
                        }
                        if (!bl) {
                            parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                        }
                        return;
                    }
                    catch (IOException iOException) {
                        block38: {
                            parameters.setParseFailedReason(Parameters.FailReason.CLIENT_DISCONNECT);
                            Context context = this.getContext();
                            if (context != null && context.getLogger().isDebugEnabled()) {
                                context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)iOException);
                            }
                            if (bl) break block38;
                            parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                        }
                        return;
                    }
                    if (byArray != null) {
                        parameters.processParameters(byArray, 0, byArray.length);
                    }
                }
                bl = true;
                break block39;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!bl) {
                    parameters.setParseFailedReason(Parameters.FailReason.UNKNOWN);
                }
            }
        }
    }

    @Deprecated
    protected int readPostBody(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = this.getStream().read(byArray, n3, n - n3)) > 0) continue;
            return n3;
        } while (n - (n3 += n2) > 0);
        return n;
    }

    protected void readPostBodyFully(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = this.getStream().read(byArray, n3, n - n3)) > 0) continue;
            throw new EOFException();
        } while (n - (n3 += n2) > 0);
    }

    protected byte[] readChunkedPostBody() throws IOException {
        ByteChunk byteChunk = new ByteChunk();
        byte[] byArray = new byte[8192];
        int n = 0;
        while (n > -1) {
            n = this.getStream().read(byArray, 0, 8192);
            if (this.connector.getMaxPostSize() >= 0 && byteChunk.getLength() + n > this.connector.getMaxPostSize()) {
                this.checkSwallowInput();
                throw new IllegalStateException(sm.getString("coyoteRequest.chunkedPostTooLarge"));
            }
            if (n <= 0) continue;
            byteChunk.append(byArray, 0, n);
        }
        if (byteChunk.getLength() == 0) {
            return null;
        }
        if (byteChunk.getLength() < byteChunk.getBuffer().length) {
            int n2 = byteChunk.getLength();
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byteChunk.getBuffer(), 0, byArray2, 0, n2);
            return byArray2;
        }
        return byteChunk.getBuffer();
    }

    protected void parseLocales() {
        this.localesParsed = true;
        TreeMap<Double, ArrayList<Locale>> treeMap = new TreeMap<Double, ArrayList<Locale>>();
        Enumeration<String> enumeration = this.getHeaders("accept-language");
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.parseLocalesHeader(string, treeMap);
        }
        for (ArrayList arrayList : treeMap.values()) {
            for (Locale locale : arrayList) {
                this.addLocale(locale);
            }
        }
    }

    protected void parseLocalesHeader(String string, TreeMap<Double, ArrayList<Locale>> treeMap) {
        List list;
        try {
            list = AcceptLanguage.parse((StringReader)new StringReader(string));
        }
        catch (IOException iOException) {
            return;
        }
        for (AcceptLanguage acceptLanguage : list) {
            Double d = -acceptLanguage.getQuality();
            ArrayList<Locale> arrayList = treeMap.get(d);
            if (arrayList == null) {
                arrayList = new ArrayList();
                treeMap.put(d, arrayList);
            }
            arrayList.add(acceptLanguage.getLocale());
        }
    }

    static {
        specialAttributes.put("org.apache.catalina.core.DISPATCHER_TYPE", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.internalDispatcherType == null ? DispatcherType.REQUEST : request.internalDispatcherType;
            }

            @Override
            public void set(Request request, String string, Object object) {
                request.internalDispatcherType = (DispatcherType)object;
            }
        });
        specialAttributes.put("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.requestDispatcherPath == null ? request.getRequestPathMB().toString() : request.requestDispatcherPath.toString();
            }

            @Override
            public void set(Request request, String string, Object object) {
                request.requestDispatcherPath = object;
            }
        });
        specialAttributes.put("org.apache.catalina.ASYNC_SUPPORTED", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.asyncSupported;
            }

            @Override
            public void set(Request request, String string, Object object) {
                Boolean bl = request.asyncSupported;
                request.asyncSupported = (Boolean)object;
                request.notifyAttributeAssigned(string, object, bl);
            }
        });
        specialAttributes.put("org.apache.catalina.realm.GSS_CREDENTIAL", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                if (request.userPrincipal instanceof TomcatPrincipal) {
                    return ((TomcatPrincipal)request.userPrincipal).getGssCredential();
                }
                return null;
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.catalina.parameter_parse_failed", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                if (request.getCoyoteRequest().getParameters().isParseFailed()) {
                    return Boolean.TRUE;
                }
                return null;
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.catalina.parameter_parse_failed_reason", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.getCoyoteRequest().getParameters().getParseFailedReason();
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.tomcat.sendfile.support", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.getConnector().getProtocolHandler().isSendfileSupported() && request.getCoyoteRequest().getSendfile();
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.coyote.connectionID", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                AtomicReference atomicReference = new AtomicReference();
                request.getCoyoteRequest().action(ActionCode.CONNECTION_ID, atomicReference);
                return atomicReference.get();
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        specialAttributes.put("org.apache.catalina.filters.RemoteIpFilter.secure", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                return request.isSecure();
            }

            @Override
            public void set(Request request, String string, Object object) {
                if (object instanceof Boolean) {
                    request.setSecure((Boolean)object);
                }
            }
        });
        specialAttributes.put("org.apache.coyote.streamID", new SpecialAttributeAdapter(){

            @Override
            public Object get(Request request, String string) {
                AtomicReference atomicReference = new AtomicReference();
                request.getCoyoteRequest().action(ActionCode.STREAM_ID, atomicReference);
                return atomicReference.get();
            }

            @Override
            public void set(Request request, String string, Object object) {
            }
        });
        for (SimpleDateFormat simpleDateFormat : formatsTemplate) {
            simpleDateFormat.setTimeZone(GMT_ZONE);
        }
    }

    private static interface SpecialAttributeAdapter {
        public Object get(Request var1, String var2);

        public void set(Request var1, String var2, Object var3);
    }
}

